/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_dupecheckdialog.c - creation and destruction of the dupecheck dialog
 *
 * a dialog is created where you can select which logs to dupecheck and if
 * you want to ignore bands and/or modes used. Either a list of dupes is
 * displayed or a dialog which tells you there are no dupes. When you select
 * a QSO in the dupelist, the corresponding QSO in the log is selected.
 */
 
#include <gtk/gtk.h>
#include <stdlib.h>

#include "gui_dupecheckdialog.h"
#include "support.h"
#include "types.h"
#include "log.h"
#include "utils.h"

extern statetype state;
extern GtkWidget *mainnotebook;
extern GtkWidget *mainwindow;
extern GList *logwindowlist;

static void
on_dupelisttreeview_select_row (GtkTreeSelection * selection, gpointer user_data)
{
	gchar *nr, *lognr, *logn;
	guint i = 0;
	logtype *logwindow = NULL;
	gboolean qsofound = FALSE, valid = FALSE;
	GtkTreeModel *model, *logmodel = NULL;
	GtkTreeIter iter, logiter;
	GtkTreeSelection *logselection;
	GtkTreePath *logpath;

	if (gtk_tree_selection_get_selected (selection, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, 0, &logn, -1);
		gtk_tree_model_get (model, &iter, NR + 1, &nr, -1);
		for (i = 0; i < g_list_length (logwindowlist); i++)
		{
			logwindow = g_list_nth_data (logwindowlist, i);
			logmodel = gtk_tree_view_get_model (GTK_TREE_VIEW(logwindow->treeview));
			valid = gtk_tree_model_get_iter_first (logmodel, &logiter);
			while (valid)
			{
				gtk_tree_model_get (logmodel, &logiter, NR, &lognr, -1);
				if ((g_ascii_strcasecmp (nr, lognr) == 0) && (g_ascii_strcasecmp (logn, logwindow->logname) == 0))
				{
					qsofound = TRUE;
					break;
				}
				valid = gtk_tree_model_iter_next (logmodel, &logiter);
			}
			if (qsofound)	break;
		}
		if (qsofound)
		{
			gtk_notebook_set_current_page (GTK_NOTEBOOK(mainnotebook), i);
			logselection = gtk_tree_view_get_selection (GTK_TREE_VIEW(logwindow->treeview));
			gtk_tree_selection_select_iter (logselection,	&logiter);
			logpath =	gtk_tree_model_get_path (logmodel, &logiter);
			gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW(logwindow->treeview), logpath, NULL, TRUE, 0.5, 0.0);
			gtk_tree_path_free (logpath);
		}
	}
}

void
on_menu_dupecheck_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *dupecheckdialog, *dupecheckthisradiobutton,
		*dupecheckallradiobutton, *dupecheckbuttonmode, *dupecheckbuttonband,
		*dupecheckdialog_vbox, *dupecheckmain_vbox, *dupechecklabel,
		*dupecheckframe, *dupechecklogs_vbox, *dupecheckitems_vbox,
		*dupecheckitems_label, *dupecheckinclude_frame, *dupecheckinclude_hbox,
		*dupecheckstatusbar_hbox, *dupecheckstatusbar, *dupecheckprogressbar,
		*dupecheckdialog_action_area, *dupecheckcancelbutton, *dupecheckokbutton,
		*dupelistdialog, *dupelistdialogvbox, *dupelistlabel, *dupelisthseparator,
		*dupelistscrolledwindow, *dupelisttreeview,
		*duperesultdialog, *duperesultdialog_vbox, *duperesultlabel, 
		*duperesultdialog_action_area, *duperesultdialogokbutton;
	GdkPixbuf *dupecheckdialog_icon_pixbuf, *duperesultdialog_icon_pixbuf, 
		*dupelistdialog_icon_pixbuf;
	GList *dupelist = NULL;
	GSList *dupecheckthisradiobutton_group = NULL;
	logtype *logwindow;
	gint i, page, savedpage, pages, row = 0, step, dupecheckresponse, count;
	gchar *nr, *date, *gmt, *callsign, *band,
		*mode, *temp = NULL, *str, *dupestr;
	gchar **dupe = NULL;
	gboolean dupefound = FALSE, valid = FALSE;
	GtkTreeIter dupeiter, iter;
	GtkTreeModel *logmodel, *dupemodel;
	GtkTreeStore *dupestore;
	GtkCellRenderer *duperenderer;
	GtkTreeViewColumn *dupecolumn;
	GObject *selection;

	page = gtk_notebook_get_current_page (GTK_NOTEBOOK(mainnotebook));
	if (page >= 0)
	{
		dupecheckdialog = gtk_dialog_new ();
		gtk_window_set_title (GTK_WINDOW (dupecheckdialog), _("xlog - dupecheck"));
		gtk_window_set_position (GTK_WINDOW (dupecheckdialog), GTK_WIN_POS_MOUSE);
		dupecheckdialog_icon_pixbuf = create_pixbuf ("xlog.png");
		if (dupecheckdialog_icon_pixbuf)
			{
				gtk_window_set_icon (GTK_WINDOW (dupecheckdialog), dupecheckdialog_icon_pixbuf);
				g_object_unref (dupecheckdialog_icon_pixbuf);
			}

		dupecheckdialog_vbox = GTK_DIALOG (dupecheckdialog)->vbox;
		gtk_widget_show (dupecheckdialog_vbox);
	
		dupecheckmain_vbox = gtk_vbox_new (FALSE, 0);
		gtk_widget_show (dupecheckmain_vbox);
		gtk_box_pack_start (GTK_BOX (dupecheckdialog_vbox), dupecheckmain_vbox, TRUE, TRUE, 0);

		dupechecklabel = gtk_label_new (_("Select logs for dupe checking"));
		gtk_widget_show (dupechecklabel);
		gtk_box_pack_start (GTK_BOX (dupecheckmain_vbox), dupechecklabel, FALSE, FALSE, 10);
		gtk_label_set_justify (GTK_LABEL (dupechecklabel), GTK_JUSTIFY_CENTER);
		gtk_label_set_line_wrap (GTK_LABEL (dupechecklabel), TRUE);

		dupecheckframe = gtk_frame_new (NULL);
		gtk_widget_show (dupecheckframe);
		gtk_box_pack_start (GTK_BOX (dupecheckmain_vbox), dupecheckframe, FALSE, FALSE, 0);
		gtk_container_set_border_width (GTK_CONTAINER (dupecheckframe), 10);

		dupechecklogs_vbox = gtk_vbox_new (FALSE, 0);
		gtk_widget_show (dupechecklogs_vbox);
		gtk_container_add (GTK_CONTAINER (dupecheckframe), dupechecklogs_vbox);

		dupecheckthisradiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Check this log"));
		gtk_widget_show (dupecheckthisradiobutton);
		gtk_box_pack_start (GTK_BOX (dupechecklogs_vbox), dupecheckthisradiobutton, TRUE, TRUE, 0);
		gtk_radio_button_set_group (GTK_RADIO_BUTTON (dupecheckthisradiobutton), dupecheckthisradiobutton_group);
		dupecheckthisradiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (dupecheckthisradiobutton));

		dupecheckallradiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Check all logs"));
		gtk_widget_show (dupecheckallradiobutton);
		gtk_box_pack_start (GTK_BOX (dupechecklogs_vbox), dupecheckallradiobutton, TRUE, TRUE, 0);
		gtk_radio_button_set_group (GTK_RADIO_BUTTON (dupecheckallradiobutton), dupecheckthisradiobutton_group);
		dupecheckthisradiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (dupecheckallradiobutton));

		dupecheckitems_vbox = gtk_vbox_new (FALSE, 0);
		gtk_widget_show (dupecheckitems_vbox);
		gtk_box_pack_start (GTK_BOX (dupecheckdialog_vbox), dupecheckitems_vbox, TRUE, TRUE, 0);

		dupecheckitems_label = gtk_label_new (_("Items to exclude"));
		gtk_widget_show (dupecheckitems_label);
		gtk_box_pack_start (GTK_BOX (dupecheckitems_vbox), dupecheckitems_label, FALSE, FALSE, 10);
		gtk_label_set_justify (GTK_LABEL (dupecheckitems_label), GTK_JUSTIFY_CENTER);
		gtk_label_set_line_wrap (GTK_LABEL (dupecheckitems_label), TRUE);

		dupecheckinclude_frame = gtk_frame_new (NULL);
		gtk_widget_show (dupecheckinclude_frame);
		gtk_box_pack_start (GTK_BOX (dupecheckitems_vbox), dupecheckinclude_frame, FALSE, FALSE, 0);
		gtk_container_set_border_width (GTK_CONTAINER (dupecheckinclude_frame), 10);

		dupecheckinclude_hbox = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (dupecheckinclude_hbox);
		gtk_container_add (GTK_CONTAINER (dupecheckinclude_frame), dupecheckinclude_hbox);

		dupecheckbuttonmode = gtk_check_button_new_with_mnemonic (_("Mode"));
		gtk_widget_show (dupecheckbuttonmode);
		gtk_box_pack_start (GTK_BOX (dupecheckinclude_hbox), dupecheckbuttonmode, TRUE, TRUE, 0);

		dupecheckbuttonband = gtk_check_button_new_with_mnemonic (_("Band"));
		gtk_widget_show (dupecheckbuttonband);
		gtk_box_pack_start (GTK_BOX (dupecheckinclude_hbox), dupecheckbuttonband, TRUE, TRUE, 0);

		dupecheckstatusbar_hbox = gtk_hbox_new (TRUE, 0);
		gtk_widget_show (dupecheckstatusbar_hbox);
		gtk_box_pack_start (GTK_BOX (dupecheckdialog_vbox), dupecheckstatusbar_hbox, TRUE, FALSE, 10);

		dupecheckstatusbar = gtk_statusbar_new ();
		gtk_widget_show (dupecheckstatusbar);
		gtk_box_pack_start (GTK_BOX (dupecheckstatusbar_hbox), dupecheckstatusbar, TRUE, TRUE, 0);
		gtk_statusbar_set_has_resize_grip (GTK_STATUSBAR (dupecheckstatusbar), FALSE);
	
		dupecheckprogressbar = gtk_progress_bar_new ();
		gtk_widget_show (dupecheckprogressbar);
		gtk_box_pack_start (GTK_BOX (dupecheckstatusbar_hbox), dupecheckprogressbar, FALSE, FALSE, 0);

		dupecheckdialog_action_area = GTK_DIALOG (dupecheckdialog)->action_area;
		gtk_widget_show (dupecheckdialog_action_area);
		gtk_button_box_set_layout (GTK_BUTTON_BOX (dupecheckdialog_action_area), GTK_BUTTONBOX_SPREAD);

		dupecheckcancelbutton = gtk_button_new_from_stock ("gtk-cancel");
		gtk_widget_show (dupecheckcancelbutton);
		gtk_dialog_add_action_widget (GTK_DIALOG (dupecheckdialog), dupecheckcancelbutton, GTK_RESPONSE_CANCEL);
		GTK_WIDGET_SET_FLAGS (dupecheckcancelbutton, GTK_CAN_DEFAULT);

		dupecheckokbutton = gtk_button_new_from_stock ("gtk-ok");
		gtk_widget_show (dupecheckokbutton);
		gtk_dialog_add_action_widget (GTK_DIALOG (dupecheckdialog), dupecheckokbutton, GTK_RESPONSE_OK);
		GTK_WIDGET_SET_FLAGS (dupecheckokbutton, GTK_CAN_DEFAULT);

		if (state.dupecheck == 0)
		{
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (dupecheckthisradiobutton), TRUE);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (dupecheckallradiobutton), FALSE);
		}
		else
		{
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (dupecheckthisradiobutton), FALSE);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (dupecheckallradiobutton), TRUE);
		}

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (dupecheckbuttonmode), state.notdupecheckmode);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON (dupecheckbuttonband), state.notdupecheckband);

		dupecheckresponse = gtk_dialog_run (GTK_DIALOG(dupecheckdialog));
		if (dupecheckresponse == GTK_RESPONSE_OK)
		{
			dupe = g_new0 (gchar *, 7);
			for (i = 0; i < 7; i++)
				dupe[i] = g_new0 (gchar, 100);

			gtk_statusbar_pop (GTK_STATUSBAR (dupecheckstatusbar), 1);
			gtk_statusbar_push (GTK_STATUSBAR (dupecheckstatusbar), 1, _("Searching ..."));

			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (dupecheckthisradiobutton)))
				state.dupecheck = 0;
			else
				state.dupecheck = 1;
			state.notdupecheckmode = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(dupecheckbuttonmode));
			state.notdupecheckband = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(dupecheckbuttonband));

			/* all or this page */
			if (state.dupecheck == 0)
			{
				page = gtk_notebook_get_current_page (GTK_NOTEBOOK(mainnotebook));
				pages = page + 1;
			}
			else
			{
				page = 0;
				pages = g_list_length (logwindowlist);
			}

			savedpage = page;
			while (page < pages)
			{			/* make a string consisting of pagecallbandmode and store in a list */
				logwindow = g_list_nth_data (logwindowlist, page);
				logmodel = gtk_tree_view_get_model (GTK_TREE_VIEW(logwindow->treeview));
				valid = gtk_tree_model_get_iter_first (logmodel, &iter);
				while (valid)
				{
					gtk_tree_model_get (logmodel, &iter, CALL, &callsign, -1);
					temp = g_strdup (callsign);
					if (!state.notdupecheckband)
					{
						gtk_tree_model_get (logmodel, &iter, BAND, &band, -1);
						str = findband (g_strdup (band));
						temp = g_strconcat (temp, str, NULL);
						g_free (str);
					}
					if (!state.notdupecheckmode)
					{
						gtk_tree_model_get (logmodel, &iter, MODE, &mode, -1);
						temp = g_strconcat (temp, mode, NULL);
					}
					dupelist = g_list_append (dupelist, temp);
					valid = gtk_tree_model_iter_next (logmodel, &iter);
				}
				page++;
			}

			/* create the dupelist window, don't make this a dialog because we want
				to be able to switch focus to the main window */
			dupelistdialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
			gtk_window_set_title (GTK_WINDOW (dupelistdialog), _("xlog - dupe results"));
			gtk_window_set_position (GTK_WINDOW (dupelistdialog), GTK_WIN_POS_MOUSE);
			gtk_window_set_default_size (GTK_WINDOW (dupelistdialog), 500, 300);
			dupelistdialog_icon_pixbuf = create_pixbuf ("xlog.png");
			if (dupelistdialog_icon_pixbuf)
				{
					gtk_window_set_icon (GTK_WINDOW (dupelistdialog), dupelistdialog_icon_pixbuf);
					g_object_unref (dupelistdialog_icon_pixbuf);
				}

			dupelistdialogvbox = gtk_vbox_new (FALSE, 0);
			gtk_widget_show (dupelistdialogvbox);
			gtk_container_add (GTK_CONTAINER (dupelistdialog), dupelistdialogvbox);
	
			/* create a treeview */
			dupelistscrolledwindow = gtk_scrolled_window_new (NULL, NULL);
			gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (dupelistscrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
			gtk_widget_show (dupelistscrolledwindow);
			gtk_box_pack_start (GTK_BOX (dupelistdialogvbox), dupelistscrolledwindow, TRUE, TRUE, 0);
			gtk_box_reorder_child (GTK_BOX (dupelistdialogvbox), dupelistscrolledwindow, 0);
			dupestore = gtk_tree_store_new (7, G_TYPE_STRING, G_TYPE_STRING,
				G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
			dupelisttreeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (dupestore));
			gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE (dupestore), 4, GTK_SORT_ASCENDING);
			g_object_unref (G_OBJECT (dupestore));
			gtk_widget_show (dupelisttreeview);
			gtk_container_add (GTK_CONTAINER (dupelistscrolledwindow), dupelisttreeview);

			/* add callback for selecting a row */
			selection = G_OBJECT (gtk_tree_view_get_selection(GTK_TREE_VIEW (dupelisttreeview)));
			gtk_tree_selection_set_mode (GTK_TREE_SELECTION (selection), GTK_SELECTION_SINGLE);
			g_signal_connect (selection, "changed", G_CALLBACK (on_dupelisttreeview_select_row), NULL);

			/* add columns */
			duperenderer = gtk_cell_renderer_text_new ();
			dupecolumn = gtk_tree_view_column_new_with_attributes ("LOG", duperenderer, "text", 0, NULL);
			gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (dupecolumn), GTK_TREE_VIEW_COLUMN_GROW_ONLY);
			gtk_tree_view_append_column (GTK_TREE_VIEW (dupelisttreeview), dupecolumn);

			duperenderer = gtk_cell_renderer_text_new ();
			dupecolumn = gtk_tree_view_column_new_with_attributes ("NR", duperenderer, "text", 1, NULL);
			gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (dupecolumn), GTK_TREE_VIEW_COLUMN_GROW_ONLY);
			gtk_tree_view_append_column (GTK_TREE_VIEW (dupelisttreeview), dupecolumn);

			duperenderer = gtk_cell_renderer_text_new ();
			dupecolumn = gtk_tree_view_column_new_with_attributes ("DATE", duperenderer, "text", 2, NULL);
			gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (dupecolumn), GTK_TREE_VIEW_COLUMN_GROW_ONLY);
			gtk_tree_view_append_column (GTK_TREE_VIEW (dupelisttreeview), dupecolumn);

			duperenderer = gtk_cell_renderer_text_new ();
			dupecolumn = gtk_tree_view_column_new_with_attributes ("GMT", duperenderer, "text", 3, NULL);
			gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (dupecolumn),	GTK_TREE_VIEW_COLUMN_GROW_ONLY);
			gtk_tree_view_append_column (GTK_TREE_VIEW (dupelisttreeview), dupecolumn);

			duperenderer = gtk_cell_renderer_text_new ();
			dupecolumn = gtk_tree_view_column_new_with_attributes("CALL", duperenderer, "text", 4, NULL);
			gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (dupecolumn), GTK_TREE_VIEW_COLUMN_GROW_ONLY);
			gtk_tree_view_column_set_sort_column_id (dupecolumn, 4);
			gtk_tree_view_append_column (GTK_TREE_VIEW (dupelisttreeview), dupecolumn);
	
			duperenderer = gtk_cell_renderer_text_new ();
			dupecolumn = gtk_tree_view_column_new_with_attributes("BAND", duperenderer, "text", 5, NULL);
			gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (dupecolumn), GTK_TREE_VIEW_COLUMN_GROW_ONLY);
			gtk_tree_view_append_column (GTK_TREE_VIEW (dupelisttreeview), dupecolumn);

			duperenderer = gtk_cell_renderer_text_new ();
			dupecolumn = gtk_tree_view_column_new_with_attributes("MODE", duperenderer, "text", 6, NULL);
			gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (dupecolumn), GTK_TREE_VIEW_COLUMN_GROW_ONLY);
			gtk_tree_view_append_column (GTK_TREE_VIEW (dupelisttreeview), dupecolumn);

			dupelisthseparator = gtk_hseparator_new ();
			gtk_widget_show (dupelisthseparator);
			gtk_box_pack_start (GTK_BOX (dupelistdialogvbox), dupelisthseparator, FALSE, FALSE, 0);

			dupelistlabel = gtk_label_new (_("Select an entry to highlight the corresponding entry in the main window"));
			gtk_widget_show (dupelistlabel);
			gtk_box_pack_start (GTK_BOX (dupelistdialogvbox), dupelistlabel, FALSE, FALSE, 0);
			gtk_label_set_justify (GTK_LABEL (dupelistlabel), GTK_JUSTIFY_CENTER);
			gtk_label_set_line_wrap (GTK_LABEL (dupelistlabel), TRUE);
			gtk_misc_set_padding (GTK_MISC (dupelistlabel), 0, 5);

			dupemodel = gtk_tree_view_get_model (GTK_TREE_VIEW(dupelisttreeview));
			page = savedpage;
			while (page < pages)
			{	/* check the list against the logs */
				logwindow = g_list_nth_data (logwindowlist, page);
				logmodel = gtk_tree_view_get_model (GTK_TREE_VIEW (logwindow->treeview));
				valid = gtk_tree_model_get_iter_first (logmodel, &iter);
				while (valid)
				{
					if (row++ % 50 == 0)
					{
						gtk_progress_bar_pulse (GTK_PROGRESS_BAR (dupecheckprogressbar));
						while (gtk_events_pending ()) gtk_main_iteration ();
					}
					gtk_tree_model_get (logmodel, &iter, CALL, &callsign, -1);
					temp = g_strdup (callsign);
					if (!state.notdupecheckband)
					{
						gtk_tree_model_get (logmodel, &iter, BAND, &band, -1);
						str = findband (g_strdup (band));
						temp = g_strconcat (temp, str, NULL);
						g_free (str);
					}
					if (!state.notdupecheckmode)
					{
						gtk_tree_model_get (logmodel, &iter, MODE, &mode, -1);
						temp = g_strconcat (temp, mode, NULL);
					}
					dupestr = g_strdup (temp);
					/* check every callsign against the dupelist */
					count = 0;
					for (step = 0; step < g_list_length(dupelist); step++)
					{
						if (g_ascii_strcasecmp (dupestr, g_list_nth_data (dupelist, step)) == 0)
						{	/* dupe found */
							count++;
							if (count > 1)
							{
								dupe[0] = g_strdup (logwindow->logname);
								gtk_tree_model_get (logmodel, &iter, NR, &nr, -1);
								dupe[1] = g_strdup (nr);
								gtk_tree_model_get (logmodel, &iter, DATE, &date, -1);
								dupe[2] = g_strdup (date);
								gtk_tree_model_get (logmodel, &iter, GMT, &gmt, -1);
								dupe[3] = g_strdup (gmt);
								gtk_tree_model_get (logmodel, &iter, CALL, &callsign, -1);
								dupe[4] = g_strdup (callsign);
								gtk_tree_model_get (logmodel, &iter, BAND, &band, -1);
								dupe[5] = g_strdup (band);
								gtk_tree_model_get (logmodel, &iter, MODE, &mode, -1);
								dupe[6] = g_strdup (mode);
								gtk_tree_store_prepend(GTK_TREE_STORE(dupemodel), &dupeiter, NULL);
								gtk_tree_store_set(GTK_TREE_STORE(dupemodel), &dupeiter, 
									0, dupe[0], 1, dupe[1], 2, dupe[2], 3, dupe[3], 4, dupe[4], 5, dupe[5], 6, dupe[6], -1);
								dupefound = TRUE;
							}
						}
					}
					valid = gtk_tree_model_iter_next (logmodel, &iter);
				}
				page++;
			}

			g_list_free (dupelist);
			if (temp) g_free (temp);
			for (i = 0; i < 7; i++)	g_free (dupe[i]);
			g_free (dupe);

			gtk_widget_destroy (dupecheckdialog);
			if (dupefound)
				gtk_widget_show (dupelistdialog);
			else
			{ /* no dupe found, show a message */
				duperesultdialog = gtk_dialog_new ();
				gtk_widget_set_size_request (duperesultdialog, 350, 150);
				gtk_window_set_title (GTK_WINDOW (duperesultdialog), _("xlog - dupe results"));
				gtk_window_set_position (GTK_WINDOW (duperesultdialog), GTK_WIN_POS_MOUSE);
				duperesultdialog_icon_pixbuf = create_pixbuf ("xlog.png");
				if (duperesultdialog_icon_pixbuf)
					{
						gtk_window_set_icon (GTK_WINDOW (duperesultdialog), duperesultdialog_icon_pixbuf);
						g_object_unref (duperesultdialog_icon_pixbuf);
					}
			
				duperesultdialog_vbox = GTK_DIALOG (duperesultdialog)->vbox;
				gtk_widget_show (duperesultdialog_vbox);
			
				duperesultlabel = gtk_label_new (_("No dupes found!"));
				gtk_widget_show (duperesultlabel);
				gtk_box_pack_end (GTK_BOX (duperesultdialog_vbox), duperesultlabel, TRUE, TRUE, 0);
				gtk_label_set_justify (GTK_LABEL (duperesultlabel), GTK_JUSTIFY_CENTER);
				gtk_label_set_line_wrap (GTK_LABEL (duperesultlabel), TRUE);
				gtk_misc_set_padding (GTK_MISC (duperesultlabel), 30, 40);

				duperesultdialog_action_area = GTK_DIALOG (duperesultdialog)->action_area;
				gtk_widget_show (duperesultdialog_action_area);
				gtk_button_box_set_layout (GTK_BUTTON_BOX (duperesultdialog_action_area), GTK_BUTTONBOX_SPREAD);

				duperesultdialogokbutton = gtk_button_new_from_stock ("gtk-ok");
				gtk_widget_show (duperesultdialogokbutton);
				gtk_dialog_add_action_widget (GTK_DIALOG (duperesultdialog), duperesultdialogokbutton, GTK_RESPONSE_OK);
				GTK_WIDGET_SET_FLAGS (duperesultdialogokbutton, GTK_CAN_DEFAULT);

				gtk_widget_destroy (dupelistdialog);
				gtk_dialog_run (GTK_DIALOG(duperesultdialog));
				gtk_widget_destroy (duperesultdialog);
			}
		} /* GTK_RESPONSE_OK */
		else if (dupecheckresponse == GTK_RESPONSE_CANCEL)
		{
			gtk_widget_destroy (dupecheckdialog);
		}
	} /* page >= 0 */
}
