/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>


#if WANT_HAMLIB
#			 include <hamlib/rig.h>
#endif

#include "gui_utils.h"
#include "gui_colorselectiondialog.h"
#include "gui_fontselectiondialog.h"
#include "gui_pathselectiondialog.h"
#include "support.h"
#include "types.h"
#include "callbacks_preferencesdialog.h"
#include "gui_preferencesdialog.h"

GtkWidget *preferencesdialog;
extern preferencestype preferences;
extern GtkWidget *mainwindow;

#if WANT_HAMLIB
	extern GList *riglist;
#endif

static GtkWidget*
create_preferencesdialog (void)
{
	GtkWidget *preferencesdialog;
	GdkPixbuf *preferencesdialog_icon_pixbuf;
	GtkWidget *dialog_vbox4;
	GtkWidget *preferencesnotebook;
	GtkWidget *vbox18;
	GtkWidget *frame8;
	GtkWidget *clockcheckbutton;
	GtkWidget *alignment1;
	GtkWidget *hbox151;
	GtkWidget *image181;
	GtkWidget *label187;
	GtkWidget *label9;
	GtkWidget *frame10;
	GtkWidget *vbox23;
	GtkWidget *hbox35;
	GtkWidget *label37;
	GtkWidget *exampleframe;
	GtkWidget *examplelabel;
	GtkWidget *label38;
	GtkWidget *vbox19;
	GtkWidget *themebutton;
	GtkWidget *image185;
	GtkWidget *hseparator4;
	GtkWidget *hbox101;
	GtkWidget *label106;
	GtkWidget *hbox100;
	GtkWidget *fontentry;
	GtkWidget *fontbutton;
	GtkWidget *image186;
	GtkWidget *hseparator5;
	GtkWidget *themecheckbutton;
	GtkWidget *label10;
	GtkWidget *preferenceslabel1;
	GtkWidget *vbox17;
	GtkWidget *modesloggingframe;
	GtkWidget *vbox3;
	GtkWidget *modesradiobutton1;
	GSList *modesradiobutton1_group = NULL;
	GtkWidget *modesradiobutton2;
	GtkWidget *modesframe;
	GtkWidget *vbox4;
	GtkWidget *modeslabel;
	GtkWidget *modesentry;
	GtkWidget *label107;
	GtkWidget *vbox14;
	GtkWidget *bandsloggingframe;
	GtkWidget *vbox2;
	GtkWidget *bandsradiobutton1;
	GSList *bandsradiobutton1_group = NULL;
	GtkWidget *bandsradiobutton2;
	GtkWidget *bandsframe;
	GtkWidget *vbox5;
	GtkWidget *bandslabel;
	GtkWidget *bandsentry;
	GtkWidget *label108;
	GtkWidget *preferenceslabel2;
	GtkWidget *vbox20;
	GtkWidget *frame17;
	GtkWidget *hbox95;
	GtkWidget *label104;
	GtkWidget *callsignentry;
	GtkWidget *label109;
	GtkWidget *frame11;
	GtkWidget *vbox1;
	GtkWidget *labelloc;
	GtkWidget *hbox148;
	GtkWidget *latentry;
	GtkWidget *NScombo;
	GtkWidget *longentry;
	GtkWidget *EWcombo;
	GtkWidget *hbox154;
	GtkWidget *label103;
	GtkWidget *qthlocatorentry;
	GtkWidget *label110;
	GtkWidget *frame12;
	GtkWidget *hbox10;
	GtkWidget *labeldist;
	GtkWidget *unitscombo;
	GtkWidget *label111;
	GtkWidget *preferenceslabel3;
	GtkWidget *vbox12;
	GtkWidget *hamlibcheckbutton;
	GtkWidget *hamlibframe;
	GtkWidget *vbox13;
	GtkWidget *hbox25;
	GtkWidget *radiolabel;
	GtkWidget *radiocombo;
	GtkWidget *hbox26;
	GtkWidget *devicelabel;
	GtkWidget *devicecombo;
	GtkWidget *hseparator10;
	GtkWidget *label202;
	GtkWidget *rigsetconfentry;
	GtkWidget *hseparator9;
	GtkWidget *pollingcheckbutton;
	GtkWidget *pollingframe;
	GtkWidget *hbox161;
	GtkWidget *label197;
	GtkWidget *pollcombo;
	GtkWidget *label198;
	GtkWidget *label200;
	GtkWidget *smetercheckbutton;
	GtkWidget *alignment2;
	GtkWidget *hbox152;
	GtkWidget *image182;
	GtkWidget *label188;
	GtkWidget *frequencycheckbutton;
	GtkWidget *alignment3;
	GtkWidget *hbox153;
	GtkWidget *image183;
	GtkWidget *label189;
	GtkWidget *frequencyframe;
	GtkWidget *hbox36;
	GtkWidget *label39;
	GtkWidget *digitscombo;
	GtkWidget *label40;
	GtkWidget *label201;
	GtkWidget *label112;
	GtkWidget *preferenceslabel4;
	GtkWidget *vbox26;
	GtkWidget *frame16;
	GtkWidget *vbox28;
	GtkWidget *pathlabel;
	GtkWidget *hbox71;
	GtkWidget *pathentry;
	GtkWidget *pathbutton;
	GtkWidget *alignment4;
	GtkWidget *hbox155;
	GtkWidget *image184;
	GtkWidget *label190;
	GtkWidget *hseparator3;
	GtkWidget *label91;
	GtkWidget *hbox72;
	GtkWidget *logsentry;
	GtkWidget *label113;
	GtkWidget *frame9;
	GtkWidget *vbox39;
	GtkWidget *savecheckbutton;
	GtkWidget *autosavecheckbutton;
	GtkWidget *autosaveframe;
	GtkWidget *hbox37;
	GtkWidget *label41;
	GtkWidget *autosavecombo;
	GtkWidget *label42;
	GtkWidget *label114;
	GtkWidget *label92;
	GtkWidget *vbox40;
	GtkWidget *typeaheadfindcheckbutton;
	GtkWidget *frame21;
	GtkWidget *vbox41;
	GtkWidget *label176;
	GtkWidget *hseparator6;
	GtkWidget *remoteradiobutton1;
	GSList *remoteradiobutton1_group = NULL;
	GtkWidget *remoteradiobutton2;
	GtkWidget *label115;
	GtkWidget *label175;
	GtkWidget *dialog_action_area4;
	GtkWidget *preferencescancelbutton;
	GtkWidget *preferencesokbutton;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new ();

	preferencesdialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (preferencesdialog), _("xlog - preferences"));
	gtk_window_set_position (GTK_WINDOW (preferencesdialog), GTK_WIN_POS_MOUSE);
	preferencesdialog_icon_pixbuf = create_pixbuf ("xlog.png");
	if (preferencesdialog_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (preferencesdialog), preferencesdialog_icon_pixbuf);
			g_object_unref (preferencesdialog_icon_pixbuf);
		}

	dialog_vbox4 = GTK_DIALOG (preferencesdialog)->vbox;
	gtk_widget_show (dialog_vbox4);

	preferencesnotebook = gtk_notebook_new ();
	gtk_widget_show (preferencesnotebook);
	gtk_box_pack_start (GTK_BOX (dialog_vbox4), preferencesnotebook, FALSE, FALSE, 0);

	vbox18 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox18);
	gtk_container_add (GTK_CONTAINER (preferencesnotebook), vbox18);
	gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (preferencesnotebook), vbox18, FALSE, FALSE, GTK_PACK_START);

	frame8 = gtk_frame_new (NULL);
	gtk_widget_show (frame8);
	gtk_box_pack_start (GTK_BOX (vbox18), frame8, FALSE, FALSE, 5);

	clockcheckbutton = gtk_check_button_new ();
	gtk_widget_show (clockcheckbutton);
	gtk_container_add (GTK_CONTAINER (frame8), clockcheckbutton);
	gtk_container_set_border_width (GTK_CONTAINER (clockcheckbutton), 5);

	alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_widget_show (alignment1);
	gtk_container_add (GTK_CONTAINER (clockcheckbutton), alignment1);

	hbox151 = gtk_hbox_new (FALSE, 2);
	gtk_widget_show (hbox151);
	gtk_container_add (GTK_CONTAINER (alignment1), hbox151);

	image181 = create_pixmap (preferencesdialog, "mini-clock.xpm");
	gtk_widget_show (image181);
	gtk_box_pack_start (GTK_BOX (hbox151), image181, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (image181), 5, 0);

	label187 = gtk_label_new_with_mnemonic (_("Enable clock on statusbar"));
	gtk_widget_show (label187);
	gtk_box_pack_start (GTK_BOX (hbox151), label187, FALSE, FALSE, 0);
	gtk_label_set_line_wrap (GTK_LABEL (label187), TRUE);

	label9 = gtk_label_new (_("Clock"));
	gtk_widget_show (label9);
	gtk_frame_set_label_widget (GTK_FRAME (frame8), label9);

	frame10 = gtk_frame_new (NULL);
	gtk_widget_show (frame10);
	gtk_box_pack_start (GTK_BOX (vbox18), frame10, FALSE, FALSE, 5);

	vbox23 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox23);
	gtk_container_add (GTK_CONTAINER (frame10), vbox23);

	hbox35 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox35);
	gtk_box_pack_start (GTK_BOX (vbox23), hbox35, TRUE, TRUE, 0);

	label37 = gtk_label_new (_("Theme color"));
	gtk_widget_show (label37);
	gtk_box_pack_start (GTK_BOX (hbox35), label37, FALSE, FALSE, 5);
	gtk_label_set_justify (GTK_LABEL (label37), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label37), TRUE);
	gtk_misc_set_padding (GTK_MISC (label37), 5, 0);

	exampleframe = gtk_frame_new (NULL);
	gtk_widget_show (exampleframe);
	gtk_box_pack_start (GTK_BOX (hbox35), exampleframe, TRUE, TRUE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (exampleframe), 5);

	examplelabel = gtk_label_new (_("Colored label"));
	gtk_widget_show (examplelabel);
	gtk_container_add (GTK_CONTAINER (exampleframe), examplelabel);
	gtk_label_set_justify (GTK_LABEL (examplelabel), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (examplelabel), TRUE);
	gtk_misc_set_padding (GTK_MISC (examplelabel), 30, 0);

	label38 = gtk_label_new (_("Example"));
	gtk_widget_show (label38);
	gtk_frame_set_label_widget (GTK_FRAME (exampleframe), label38);

	vbox19 = gtk_vbox_new (TRUE, 0);
	gtk_widget_show (vbox19);
	gtk_box_pack_start (GTK_BOX (hbox35), vbox19, FALSE, FALSE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox19), 5);

	themebutton = gtk_button_new ();
	gtk_widget_show (themebutton);
	gtk_box_pack_start (GTK_BOX (vbox19), themebutton, FALSE, FALSE, 0);
	gtk_tooltips_set_tip (tooltips, themebutton, _("Click here to change the theme color"), NULL);

	image185 = gtk_image_new_from_stock ("gtk-select-color", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show (image185);
	gtk_container_add (GTK_CONTAINER (themebutton), image185);

	hseparator4 = gtk_hseparator_new ();
	gtk_widget_show (hseparator4);
	gtk_box_pack_start (GTK_BOX (vbox23), hseparator4, FALSE, FALSE, 5);

	hbox101 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox101);
	gtk_box_pack_start (GTK_BOX (vbox23), hbox101, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox101), 5);

	label106 = gtk_label_new (_("Theme font"));
	gtk_widget_show (label106);
	gtk_box_pack_start (GTK_BOX (hbox101), label106, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label106), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label106), TRUE);
	gtk_misc_set_padding (GTK_MISC (label106), 5, 0);

	hbox100 = gtk_hbox_new (FALSE, 5);
	gtk_widget_show (hbox100);
	gtk_box_pack_start (GTK_BOX (vbox23), hbox100, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox100), 5);

	fontentry = gtk_entry_new ();
	gtk_widget_show (fontentry);
	gtk_box_pack_start (GTK_BOX (hbox100), fontentry, TRUE, TRUE, 5);
	gtk_widget_set_size_request (fontentry, 150, 23);
	gtk_editable_set_editable (GTK_EDITABLE (fontentry), FALSE);

	fontbutton = gtk_button_new ();
	gtk_widget_show (fontbutton);
	gtk_box_pack_start (GTK_BOX (hbox100), fontbutton, FALSE, FALSE, 5);
	gtk_tooltips_set_tip (tooltips, fontbutton, _("Click here to change the path"), NULL);

	image186 = gtk_image_new_from_stock ("gtk-select-font", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show (image186);
	gtk_container_add (GTK_CONTAINER (fontbutton), image186);

	hseparator5 = gtk_hseparator_new ();
	gtk_widget_show (hseparator5);
	gtk_box_pack_start (GTK_BOX (vbox23), hseparator5, FALSE, FALSE, 0);

	themecheckbutton = gtk_check_button_new_with_mnemonic (_("Apply theme to the log (restart xlog if you change this)"));
	gtk_widget_show (themecheckbutton);
	gtk_box_pack_start (GTK_BOX (vbox23), themecheckbutton, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (themecheckbutton), 5);

	label10 = gtk_label_new (_("Theme"));
	gtk_widget_show (label10);
	gtk_frame_set_label_widget (GTK_FRAME (frame10), label10);

	preferenceslabel1 = gtk_label_new (_("General"));
	gtk_widget_show (preferenceslabel1);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (preferencesnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (preferencesnotebook), 0), preferenceslabel1);
	gtk_label_set_justify (GTK_LABEL (preferenceslabel1), GTK_JUSTIFY_CENTER);

	vbox17 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox17);
	gtk_container_add (GTK_CONTAINER (preferencesnotebook), vbox17);
	gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (preferencesnotebook), vbox17, FALSE, FALSE, GTK_PACK_START);

	modesloggingframe = gtk_frame_new (NULL);
	gtk_widget_show (modesloggingframe);
	gtk_box_pack_start (GTK_BOX (vbox17), modesloggingframe, FALSE, FALSE, 5);

	vbox3 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox3);
	gtk_container_add (GTK_CONTAINER (modesloggingframe), vbox3);
	gtk_container_set_border_width (GTK_CONTAINER (vbox3), 5);

	modesradiobutton1 = gtk_radio_button_new_with_mnemonic (NULL, _("Use Editbox"));
	gtk_widget_show (modesradiobutton1);
	gtk_box_pack_start (GTK_BOX (vbox3), modesradiobutton1, FALSE, FALSE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (modesradiobutton1), modesradiobutton1_group);
	modesradiobutton1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (modesradiobutton1));

	modesradiobutton2 = gtk_radio_button_new_with_mnemonic (NULL, _("Use Optionmenu"));
	gtk_widget_show (modesradiobutton2);
	gtk_box_pack_start (GTK_BOX (vbox3), modesradiobutton2, FALSE, FALSE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (modesradiobutton2), modesradiobutton1_group);
	modesradiobutton1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (modesradiobutton2));

	modesframe = gtk_frame_new (NULL);
	gtk_widget_show (modesframe);
	gtk_box_pack_start (GTK_BOX (vbox3), modesframe, FALSE, FALSE, 0);

	vbox4 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox4);
	gtk_container_add (GTK_CONTAINER (modesframe), vbox4);

	modeslabel = gtk_label_new (_("Comma separated list of modes"));
	gtk_widget_show (modeslabel);
	gtk_box_pack_start (GTK_BOX (vbox4), modeslabel, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (modeslabel), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (modeslabel), TRUE);

	modesentry = gtk_entry_new ();
	gtk_widget_show (modesentry);
	gtk_box_pack_start (GTK_BOX (vbox4), modesentry, FALSE, FALSE, 0);
	gtk_entry_set_max_length (GTK_ENTRY (modesentry), 90);

	label107 = gtk_label_new (_("Modes"));
	gtk_widget_show (label107);
	gtk_frame_set_label_widget (GTK_FRAME (modesloggingframe), label107);

	vbox14 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox14);
	gtk_box_pack_start (GTK_BOX (vbox17), vbox14, TRUE, TRUE, 0);

	bandsloggingframe = gtk_frame_new (NULL);
	gtk_widget_show (bandsloggingframe);
	gtk_box_pack_start (GTK_BOX (vbox14), bandsloggingframe, FALSE, FALSE, 5);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox2);
	gtk_container_add (GTK_CONTAINER (bandsloggingframe), vbox2);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);

	bandsradiobutton1 = gtk_radio_button_new_with_mnemonic (NULL, _("Use Editbox"));
	gtk_widget_show (bandsradiobutton1);
	gtk_box_pack_start (GTK_BOX (vbox2), bandsradiobutton1, FALSE, FALSE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (bandsradiobutton1), bandsradiobutton1_group);
	bandsradiobutton1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (bandsradiobutton1));

	bandsradiobutton2 = gtk_radio_button_new_with_mnemonic (NULL, _("Use Optionmenu"));
	gtk_widget_show (bandsradiobutton2);
	gtk_box_pack_start (GTK_BOX (vbox2), bandsradiobutton2, FALSE, FALSE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (bandsradiobutton2), bandsradiobutton1_group);
	bandsradiobutton1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (bandsradiobutton2));

	bandsframe = gtk_frame_new (NULL);
	gtk_widget_show (bandsframe);
	gtk_box_pack_start (GTK_BOX (vbox2), bandsframe, FALSE, FALSE, 0);

	vbox5 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox5);
	gtk_container_add (GTK_CONTAINER (bandsframe), vbox5);

	bandslabel = gtk_label_new (_("Comma separated list of bands"));
	gtk_widget_show (bandslabel);
	gtk_box_pack_start (GTK_BOX (vbox5), bandslabel, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (bandslabel), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (bandslabel), TRUE);

	bandsentry = gtk_entry_new ();
	gtk_widget_show (bandsentry);
	gtk_box_pack_start (GTK_BOX (vbox5), bandsentry, FALSE, FALSE, 0);
	gtk_entry_set_max_length (GTK_ENTRY (bandsentry), 90);

	label108 = gtk_label_new (_("Bands"));
	gtk_widget_show (label108);
	gtk_frame_set_label_widget (GTK_FRAME (bandsloggingframe), label108);

	preferenceslabel2 = gtk_label_new (_("Modes/Bands"));
	gtk_widget_show (preferenceslabel2);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (preferencesnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (preferencesnotebook), 1), preferenceslabel2);
	gtk_label_set_justify (GTK_LABEL (preferenceslabel2), GTK_JUSTIFY_CENTER);

	vbox20 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox20);
	gtk_container_add (GTK_CONTAINER (preferencesnotebook), vbox20);
	gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (preferencesnotebook), vbox20, FALSE, FALSE, GTK_PACK_START);

	frame17 = gtk_frame_new (NULL);
	gtk_widget_show (frame17);
	gtk_box_pack_start (GTK_BOX (vbox20), frame17, FALSE, FALSE, 5);

	hbox95 = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox95);
	gtk_container_add (GTK_CONTAINER (frame17), hbox95);
	gtk_container_set_border_width (GTK_CONTAINER (hbox95), 5);

	label104 = gtk_label_new (_("Your Callsign"));
	gtk_widget_show (label104);
	gtk_box_pack_start (GTK_BOX (hbox95), label104, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label104), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label104), TRUE);

	callsignentry = gtk_entry_new ();
	gtk_widget_show (callsignentry);
	gtk_box_pack_start (GTK_BOX (hbox95), callsignentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (callsignentry, 50, 23);
	gtk_entry_set_max_length (GTK_ENTRY (callsignentry), 15);

	label109 = gtk_label_new (_("Callsign"));
	gtk_widget_show (label109);
	gtk_frame_set_label_widget (GTK_FRAME (frame17), label109);

	frame11 = gtk_frame_new (NULL);
	gtk_widget_show (frame11);
	gtk_box_pack_start (GTK_BOX (vbox20), frame11, FALSE, FALSE, 5);

	vbox1 = gtk_vbox_new (TRUE, 5);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (frame11), vbox1);
	gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);

	labelloc = gtk_label_new (_("Your location (ddd.mm)"));
	gtk_widget_show (labelloc);
	gtk_box_pack_start (GTK_BOX (vbox1), labelloc, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (labelloc), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (labelloc), TRUE);
	gtk_misc_set_padding (GTK_MISC (labelloc), 5, 5);

	hbox148 = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox148);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox148, FALSE, FALSE, 0);

	latentry = gtk_entry_new ();
	gtk_widget_show (latentry);
	gtk_box_pack_start (GTK_BOX (hbox148), latentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (latentry, 50, 23);
	gtk_entry_set_max_length (GTK_ENTRY (latentry), 8);

	NScombo = gtk_combo_box_new_text ();
	gtk_widget_show (NScombo);
	gtk_box_pack_start (GTK_BOX (hbox148), NScombo, TRUE, TRUE, 0);
	gtk_combo_box_append_text (GTK_COMBO_BOX (NScombo), _("N"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (NScombo), _("S"));

	longentry = gtk_entry_new ();
	gtk_widget_show (longentry);
	gtk_box_pack_start (GTK_BOX (hbox148), longentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (longentry, 50, 23);
	gtk_entry_set_max_length (GTK_ENTRY (longentry), 8);

	EWcombo = gtk_combo_box_new_text ();
	gtk_widget_show (EWcombo);
	gtk_box_pack_start (GTK_BOX (hbox148), EWcombo, TRUE, TRUE, 0);
	gtk_combo_box_append_text (GTK_COMBO_BOX (EWcombo), _("E"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (EWcombo), _("W"));

	hbox154 = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox154);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox154, FALSE, FALSE, 0);

	label103 = gtk_label_new (_("QTH locator"));
	gtk_widget_show (label103);
	gtk_box_pack_start (GTK_BOX (hbox154), label103, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label103), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label103), TRUE);

	qthlocatorentry = gtk_entry_new ();
	gtk_widget_show (qthlocatorentry);
	gtk_box_pack_start (GTK_BOX (hbox154), qthlocatorentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (qthlocatorentry, 100, 23);
	gtk_entry_set_max_length (GTK_ENTRY (qthlocatorentry), 8);

	label110 = gtk_label_new (_("Location"));
	gtk_widget_show (label110);
	gtk_frame_set_label_widget (GTK_FRAME (frame11), label110);

	frame12 = gtk_frame_new (NULL);
	gtk_widget_show (frame12);
	gtk_box_pack_start (GTK_BOX (vbox20), frame12, FALSE, FALSE, 0);

	hbox10 = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox10);
	gtk_container_add (GTK_CONTAINER (frame12), hbox10);
	gtk_container_set_border_width (GTK_CONTAINER (hbox10), 5);

	labeldist = gtk_label_new (_("Display distance in"));
	gtk_widget_show (labeldist);
	gtk_box_pack_start (GTK_BOX (hbox10), labeldist, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (labeldist), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (labeldist), TRUE);

	unitscombo = gtk_combo_box_new_text ();
	gtk_widget_show (unitscombo);
	gtk_box_pack_start (GTK_BOX (hbox10), unitscombo, TRUE, TRUE, 0);
	gtk_combo_box_append_text (GTK_COMBO_BOX (unitscombo), _("Kilometers"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (unitscombo), _("Miles"));

	label111 = gtk_label_new (_("Units"));
	gtk_widget_show (label111);
	gtk_frame_set_label_widget (GTK_FRAME (frame12), label111);

	preferenceslabel3 = gtk_label_new (_("Info"));
	gtk_widget_show (preferenceslabel3);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (preferencesnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (preferencesnotebook), 2), preferenceslabel3);
	gtk_label_set_justify (GTK_LABEL (preferenceslabel3), GTK_JUSTIFY_CENTER);

	vbox12 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox12);
	gtk_container_add (GTK_CONTAINER (preferencesnotebook), vbox12);
	gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (preferencesnotebook), vbox12, FALSE, FALSE, GTK_PACK_START);

	hamlibcheckbutton = gtk_check_button_new_with_mnemonic (_("Enable hamlib support"));
	gtk_widget_show (hamlibcheckbutton);
	gtk_box_pack_start (GTK_BOX (vbox12), hamlibcheckbutton, FALSE, FALSE, 5);

	hamlibframe = gtk_frame_new (NULL);
	gtk_widget_show (hamlibframe);
	gtk_box_pack_start (GTK_BOX (vbox12), hamlibframe, FALSE, FALSE, 5);

	vbox13 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox13);
	gtk_container_add (GTK_CONTAINER (hamlibframe), vbox13);

	hbox25 = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox25);
	gtk_box_pack_start (GTK_BOX (vbox13), hbox25, TRUE, TRUE, 5);

	radiolabel = gtk_label_new (_("Select a Radio"));
	gtk_widget_show (radiolabel);
	gtk_box_pack_start (GTK_BOX (hbox25), radiolabel, FALSE, FALSE, 5);
	gtk_label_set_line_wrap (GTK_LABEL (radiolabel), TRUE);
	gtk_misc_set_padding (GTK_MISC (radiolabel), 5, 0);

	radiocombo = gtk_combo_box_entry_new_text ();
	gtk_widget_show (radiocombo);
	gtk_box_pack_start (GTK_BOX (hbox25), radiocombo, TRUE, TRUE, 0);
	gtk_editable_set_editable (GTK_EDITABLE (GTK_BIN(radiocombo)->child), FALSE);

	hbox26 = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox26);
	gtk_box_pack_start (GTK_BOX (vbox13), hbox26, TRUE, TRUE, 5);

	devicelabel = gtk_label_new (_("Attach to Device"));
	gtk_widget_show (devicelabel);
	gtk_box_pack_start (GTK_BOX (hbox26), devicelabel, FALSE, FALSE, 5);
	gtk_label_set_justify (GTK_LABEL (devicelabel), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (devicelabel), TRUE);
	gtk_misc_set_padding (GTK_MISC (devicelabel), 5, 0);

	devicecombo = gtk_combo_box_entry_new_text ();
	gtk_widget_show (devicecombo);
	gtk_box_pack_start (GTK_BOX (hbox26), devicecombo, TRUE, TRUE, 0);
	gtk_combo_box_append_text (GTK_COMBO_BOX (devicecombo), "/dev/ttyS0");
	gtk_combo_box_append_text (GTK_COMBO_BOX (devicecombo), "/dev/ttyS1");
	gtk_combo_box_append_text (GTK_COMBO_BOX (devicecombo), "/dev/ttyS2");
	gtk_combo_box_append_text (GTK_COMBO_BOX (devicecombo), "/dev/ttyS3");
	gtk_combo_box_append_text (GTK_COMBO_BOX (devicecombo), "localhost");
	gtk_entry_set_max_length (GTK_ENTRY (GTK_BIN(devicecombo)->child), 30);

	hseparator10 = gtk_hseparator_new ();
	gtk_widget_show (hseparator10);
	gtk_box_pack_start (GTK_BOX (vbox13), hseparator10, FALSE, FALSE, 5);

	label202 = gtk_label_new (_("Comma separated list of commands for configuring your hamlib port"));
	gtk_widget_show (label202);
	gtk_box_pack_start (GTK_BOX (vbox13), label202, FALSE, FALSE, 0);
	gtk_label_set_line_wrap (GTK_LABEL (label202), TRUE);
	gtk_misc_set_padding (GTK_MISC (label202), 5, 0);

	rigsetconfentry = gtk_entry_new ();
	gtk_widget_show (rigsetconfentry);
	gtk_box_pack_start (GTK_BOX (vbox13), rigsetconfentry, FALSE, FALSE, 5);
	gtk_entry_set_max_length (GTK_ENTRY (rigsetconfentry), 80);
	gtk_tooltips_set_tip (tooltips, rigsetconfentry, 
		_("example: rts_state=ON,timeout=600,serial_speed=19200"), NULL);

	hseparator9 = gtk_hseparator_new ();
	gtk_widget_show (hseparator9);
	gtk_box_pack_start (GTK_BOX (vbox13), hseparator9, FALSE, FALSE, 0);

	pollingcheckbutton = gtk_check_button_new_with_mnemonic (_("Enable polling"));
	gtk_widget_show (pollingcheckbutton);
	gtk_box_pack_start (GTK_BOX (vbox13), pollingcheckbutton, FALSE, FALSE, 0);

	pollingframe = gtk_frame_new (NULL);
	gtk_widget_show (pollingframe);
	gtk_box_pack_start (GTK_BOX (vbox13), pollingframe, FALSE, FALSE, 0);

	hbox161 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox161);
	gtk_container_add (GTK_CONTAINER (pollingframe), hbox161);
	gtk_container_set_border_width (GTK_CONTAINER (hbox161), 5);

	label197 = gtk_label_new (_("Poll rig every"));
	gtk_widget_show (label197);
	gtk_box_pack_start (GTK_BOX (hbox161), label197, FALSE, FALSE, 5);
	gtk_label_set_justify (GTK_LABEL (label197), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label197), TRUE);
	gtk_misc_set_padding (GTK_MISC (label197), 5, 0);

	pollcombo = gtk_combo_box_entry_new_text ();
	gtk_widget_show (pollcombo);
	gtk_box_pack_start (GTK_BOX (hbox161), pollcombo, FALSE, FALSE, 5);
	gtk_combo_box_append_text (GTK_COMBO_BOX (pollcombo), "300");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pollcombo), "400");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pollcombo), "500");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pollcombo), "700");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pollcombo), "1000");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pollcombo), "2000");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pollcombo), "3000");
	gtk_editable_set_editable (GTK_EDITABLE (GTK_BIN(pollcombo)->child), FALSE);

	label198 = gtk_label_new (_("milliseconds"));
	gtk_widget_show (label198);
	gtk_box_pack_start (GTK_BOX (hbox161), label198, FALSE, FALSE, 5);
	gtk_label_set_line_wrap (GTK_LABEL (label198), TRUE);
	gtk_misc_set_padding (GTK_MISC (label198), 5, 0);

	label200 = gtk_label_new ("");
	gtk_widget_show (label200);
	gtk_frame_set_label_widget (GTK_FRAME (pollingframe), label200);

	smetercheckbutton = gtk_check_button_new ();
	gtk_widget_show (smetercheckbutton);
	gtk_box_pack_start (GTK_BOX (vbox13), smetercheckbutton, FALSE, FALSE, 0);

	alignment2 = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_widget_show (alignment2);
	gtk_container_add (GTK_CONTAINER (smetercheckbutton), alignment2);

	hbox152 = gtk_hbox_new (FALSE, 2);
	gtk_widget_show (hbox152);
	gtk_container_add (GTK_CONTAINER (alignment2), hbox152);

	image182 = create_pixmap (preferencesdialog, "s-meter.xpm");
	gtk_widget_show (image182);
	gtk_box_pack_start (GTK_BOX (hbox152), image182, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (image182), 5, 0);

	label188 = gtk_label_new_with_mnemonic (_("Show S-meter on statusbar"));
	gtk_widget_show (label188);
	gtk_box_pack_start (GTK_BOX (hbox152), label188, FALSE, FALSE, 0);
	gtk_label_set_line_wrap (GTK_LABEL (label188), TRUE);
	gtk_misc_set_padding (GTK_MISC (label188), 5, 0);

	frequencycheckbutton = gtk_check_button_new ();
	gtk_widget_show (frequencycheckbutton);
	gtk_box_pack_start (GTK_BOX (vbox13), frequencycheckbutton, FALSE, FALSE, 0);

	alignment3 = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_widget_show (alignment3);
	gtk_container_add (GTK_CONTAINER (frequencycheckbutton), alignment3);

	hbox153 = gtk_hbox_new (FALSE, 2);
	gtk_widget_show (hbox153);
	gtk_container_add (GTK_CONTAINER (alignment3), hbox153);

	image183 = create_pixmap (preferencesdialog, "mini-trx.xpm");
	gtk_widget_show (image183);
	gtk_box_pack_start (GTK_BOX (hbox153), image183, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (image183), 5, 0);

	label189 = gtk_label_new_with_mnemonic (_("Show frequency on statusbar"));
	gtk_widget_show (label189);
	gtk_box_pack_start (GTK_BOX (hbox153), label189, FALSE, FALSE, 0);
	gtk_label_set_line_wrap (GTK_LABEL (label189), TRUE);
	gtk_misc_set_padding (GTK_MISC (label189), 5, 0);

	frequencyframe = gtk_frame_new (NULL);
	gtk_widget_show (frequencyframe);
	gtk_box_pack_start (GTK_BOX (vbox13), frequencyframe, TRUE, TRUE, 0);

	hbox36 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox36);
	gtk_container_add (GTK_CONTAINER (frequencyframe), hbox36);
	gtk_container_set_border_width (GTK_CONTAINER (hbox36), 5);

	label39 = gtk_label_new (_("Round digits to"));
	gtk_widget_show (label39);
	gtk_box_pack_start (GTK_BOX (hbox36), label39, FALSE, FALSE, 5);
	gtk_label_set_justify (GTK_LABEL (label39), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label39), TRUE);
	gtk_misc_set_padding (GTK_MISC (label39), 5, 0);

	digitscombo = gtk_combo_box_entry_new_text ();
	gtk_widget_show (digitscombo);
	gtk_box_pack_start (GTK_BOX (hbox36), digitscombo, FALSE, FALSE, 5);
	gtk_combo_box_append_text (GTK_COMBO_BOX (digitscombo), "0");
	gtk_combo_box_append_text (GTK_COMBO_BOX (digitscombo), "1");
	gtk_combo_box_append_text (GTK_COMBO_BOX (digitscombo), "2");
	gtk_combo_box_append_text (GTK_COMBO_BOX (digitscombo), "3");
	gtk_combo_box_append_text (GTK_COMBO_BOX (digitscombo), "4");
	gtk_combo_box_append_text (GTK_COMBO_BOX (digitscombo), "5");
	gtk_editable_set_editable (GTK_EDITABLE (GTK_BIN(digitscombo)->child), FALSE);

	label40 = gtk_label_new (_("characters"));
	gtk_widget_show (label40);
	gtk_box_pack_start (GTK_BOX (hbox36), label40, FALSE, FALSE, 5);
	gtk_label_set_justify (GTK_LABEL (label40), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label40), TRUE);
	gtk_misc_set_padding (GTK_MISC (label40), 5, 0);

	label201 = gtk_label_new ("");
	gtk_widget_show (label201);
	gtk_frame_set_label_widget (GTK_FRAME (frequencyframe), label201);

	label112 = gtk_label_new (_("Settings"));
	gtk_widget_show (label112);
	gtk_frame_set_label_widget (GTK_FRAME (hamlibframe), label112);

	preferenceslabel4 = gtk_label_new ("Hamlib");
	gtk_widget_show (preferenceslabel4);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (preferencesnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (preferencesnotebook), 3), preferenceslabel4);
	gtk_label_set_justify (GTK_LABEL (preferenceslabel4), GTK_JUSTIFY_CENTER);

	vbox26 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox26);
	gtk_container_add (GTK_CONTAINER (preferencesnotebook), vbox26);
	gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (preferencesnotebook), vbox26, FALSE, FALSE, GTK_PACK_START);

	frame16 = gtk_frame_new (NULL);
	gtk_widget_show (frame16);
	gtk_box_pack_start (GTK_BOX (vbox26), frame16, FALSE, FALSE, 5);

	vbox28 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox28);
	gtk_container_add (GTK_CONTAINER (frame16), vbox28);

	pathlabel = gtk_label_new (_("Directory where the logs will be saved"));
	gtk_widget_show (pathlabel);
	gtk_box_pack_start (GTK_BOX (vbox28), pathlabel, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (pathlabel), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (pathlabel), TRUE);
	gtk_misc_set_padding (GTK_MISC (pathlabel), 2, 5);

	hbox71 = gtk_hbox_new (FALSE, 5);
	gtk_widget_show (hbox71);
	gtk_box_pack_start (GTK_BOX (vbox28), hbox71, TRUE, TRUE, 0);

	pathentry = gtk_entry_new ();
	gtk_widget_show (pathentry);
	gtk_box_pack_start (GTK_BOX (hbox71), pathentry, TRUE, TRUE, 5);
	gtk_editable_set_editable (GTK_EDITABLE (pathentry), FALSE);

	pathbutton = gtk_button_new ();
	gtk_widget_show (pathbutton);
	gtk_box_pack_start (GTK_BOX (hbox71), pathbutton, FALSE, FALSE, 5);
	gtk_tooltips_set_tip (tooltips, pathbutton, _("Click here to change the path"), NULL);

	alignment4 = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_widget_show (alignment4);
	gtk_container_add (GTK_CONTAINER (pathbutton), alignment4);

	hbox155 = gtk_hbox_new (FALSE, 2);
	gtk_widget_show (hbox155);
	gtk_container_add (GTK_CONTAINER (alignment4), hbox155);

	image184 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show (image184);
	gtk_box_pack_start (GTK_BOX (hbox155), image184, FALSE, FALSE, 0);

	label190 = gtk_label_new_with_mnemonic ("");
	gtk_widget_show (label190);
	gtk_box_pack_start (GTK_BOX (hbox155), label190, FALSE, FALSE, 0);

	hseparator3 = gtk_hseparator_new ();
	gtk_widget_show (hseparator3);
	gtk_box_pack_start (GTK_BOX (vbox28), hseparator3, TRUE, TRUE, 8);

	label91 = gtk_label_new (_("Comma separated list of logs to load at startup"));
	gtk_widget_show (label91);
	gtk_box_pack_start (GTK_BOX (vbox28), label91, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label91), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label91), TRUE);
	gtk_misc_set_padding (GTK_MISC (label91), 2, 5);

	hbox72 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox72);
	gtk_box_pack_start (GTK_BOX (vbox28), hbox72, TRUE, TRUE, 7);

	logsentry = gtk_entry_new ();
	gtk_widget_show (logsentry);
	gtk_box_pack_start (GTK_BOX (hbox72), logsentry, TRUE, TRUE, 5);
	gtk_entry_set_max_length (GTK_ENTRY (logsentry), 90);

	label113 = gtk_label_new ("Logs");
	gtk_widget_show (label113);
	gtk_frame_set_label_widget (GTK_FRAME (frame16), label113);

	frame9 = gtk_frame_new (NULL);
	gtk_widget_show (frame9);
	gtk_box_pack_start (GTK_BOX (vbox26), frame9, FALSE, FALSE, 5);

	vbox39 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox39);
	gtk_container_add (GTK_CONTAINER (frame9), vbox39);
	gtk_container_set_border_width (GTK_CONTAINER (vbox39), 3);

	savecheckbutton = gtk_check_button_new_with_mnemonic (_("Save with every log change"));
	gtk_widget_show (savecheckbutton);
	gtk_box_pack_start (GTK_BOX (vbox39), savecheckbutton, FALSE, FALSE, 0);

	autosavecheckbutton = gtk_check_button_new_with_mnemonic (_("Enable autosave"));
	gtk_widget_show (autosavecheckbutton);
	gtk_box_pack_start (GTK_BOX (vbox39), autosavecheckbutton, FALSE, FALSE, 0);

	autosaveframe = gtk_frame_new (NULL);
	gtk_widget_show (autosaveframe);
	gtk_box_pack_start (GTK_BOX (vbox39), autosaveframe, FALSE, FALSE, 0);

	hbox37 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox37);
	gtk_container_add (GTK_CONTAINER (autosaveframe), hbox37);

	label41 = gtk_label_new (_("Autosave logs every"));
	gtk_widget_show (label41);
	gtk_box_pack_start (GTK_BOX (hbox37), label41, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label41), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label41), TRUE);
	gtk_misc_set_padding (GTK_MISC (label41), 5, 0);

	autosavecombo = gtk_combo_box_entry_new_text ();
	gtk_widget_show (autosavecombo);
	gtk_box_pack_start (GTK_BOX (hbox37), autosavecombo, FALSE, FALSE, 5);
	gtk_widget_set_size_request (autosavecombo, 100, 23);
	gtk_combo_box_append_text (GTK_COMBO_BOX (autosavecombo), "5");
	gtk_combo_box_append_text (GTK_COMBO_BOX (autosavecombo), "10");
	gtk_combo_box_append_text (GTK_COMBO_BOX (autosavecombo), "20");
	gtk_combo_box_append_text (GTK_COMBO_BOX (autosavecombo), "30");
	gtk_combo_box_append_text (GTK_COMBO_BOX (autosavecombo), "40");
	gtk_combo_box_append_text (GTK_COMBO_BOX (autosavecombo), "50");
	gtk_combo_box_append_text (GTK_COMBO_BOX (autosavecombo), "60");
	gtk_combo_box_append_text (GTK_COMBO_BOX (autosavecombo), "90");
	gtk_combo_box_append_text (GTK_COMBO_BOX (autosavecombo), "120");
	gtk_editable_set_editable (GTK_EDITABLE (GTK_BIN(autosavecombo)->child), FALSE);

	label42 = gtk_label_new (_("minutes"));
	gtk_widget_show (label42);
	gtk_box_pack_start (GTK_BOX (hbox37), label42, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label42), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label42), TRUE);
	gtk_misc_set_padding (GTK_MISC (label42), 5, 0);

	label114 = gtk_label_new (_("Saving"));
	gtk_widget_show (label114);
	gtk_frame_set_label_widget (GTK_FRAME (frame9), label114);

	label92 = gtk_label_new ("Logs");
	gtk_widget_show (label92);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (preferencesnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (preferencesnotebook), 4), label92);
	gtk_label_set_justify (GTK_LABEL (label92), GTK_JUSTIFY_CENTER);

	vbox40 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox40);
	gtk_container_add (GTK_CONTAINER (preferencesnotebook), vbox40);
	gtk_notebook_set_tab_label_packing (GTK_NOTEBOOK (preferencesnotebook), vbox40, FALSE, FALSE, GTK_PACK_START);

	typeaheadfindcheckbutton = gtk_check_button_new_with_mnemonic (_("Enable type and find"));
	gtk_widget_show (typeaheadfindcheckbutton);
	gtk_box_pack_start (GTK_BOX (vbox40), typeaheadfindcheckbutton, FALSE, FALSE, 5);
	gtk_tooltips_set_tip (tooltips, typeaheadfindcheckbutton, _("Search all the logs for a callsign match and when found, fill in name, QTH, locator and remarks like in the previous QSO when these fields are empty"), NULL);

	frame21 = gtk_frame_new (NULL);
	gtk_widget_show (frame21);
	gtk_box_pack_start (GTK_BOX (vbox40), frame21, FALSE, FALSE, 5);

	vbox41 = gtk_vbox_new (FALSE, 5);
	gtk_widget_show (vbox41);
	gtk_container_add (GTK_CONTAINER (frame21), vbox41);

	label176 = gtk_label_new (_("When receiving data from another application (gmfsk, ktrack):"));
	gtk_widget_show (label176);
	gtk_box_pack_start (GTK_BOX (vbox41), label176, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label176), GTK_JUSTIFY_CENTER);
	gtk_label_set_line_wrap (GTK_LABEL (label176), TRUE);

	hseparator6 = gtk_hseparator_new ();
	gtk_widget_show (hseparator6);
	gtk_box_pack_start (GTK_BOX (vbox41), hseparator6, FALSE, FALSE, 0);

	remoteradiobutton1 = gtk_radio_button_new_with_mnemonic (NULL, _("Add data directly to the log"));
	gtk_widget_show (remoteradiobutton1);
	gtk_box_pack_start (GTK_BOX (vbox41), remoteradiobutton1, FALSE, FALSE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (remoteradiobutton1), remoteradiobutton1_group);
	remoteradiobutton1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (remoteradiobutton1));

	remoteradiobutton2 = gtk_radio_button_new_with_mnemonic (NULL, _("Add data to the QSO frame"));
	gtk_widget_show (remoteradiobutton2);
	gtk_box_pack_start (GTK_BOX (vbox41), remoteradiobutton2, FALSE, FALSE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (remoteradiobutton2), remoteradiobutton1_group);
	remoteradiobutton1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (remoteradiobutton2));

	label115 = gtk_label_new (_("Remote data"));
	gtk_widget_show (label115);
	gtk_frame_set_label_widget (GTK_FRAME (frame21), label115);

	label175 = gtk_label_new (_("Other"));
	gtk_widget_show (label175);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (preferencesnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (preferencesnotebook), 5), label175);
	gtk_label_set_justify (GTK_LABEL (label175), GTK_JUSTIFY_CENTER);

	dialog_action_area4 = GTK_DIALOG (preferencesdialog)->action_area;
	gtk_widget_show (dialog_action_area4);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area4), GTK_BUTTONBOX_SPREAD);

	preferencescancelbutton = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (preferencescancelbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (preferencesdialog), preferencescancelbutton, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (preferencescancelbutton, GTK_CAN_DEFAULT);

	preferencesokbutton = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (preferencesokbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (preferencesdialog), preferencesokbutton, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (preferencesokbutton, GTK_CAN_DEFAULT);

	g_signal_connect ((gpointer) preferencesdialog, "delete_event", G_CALLBACK (on_preferencesdialog_delete_event), NULL);
	g_signal_connect ((gpointer) themebutton, "clicked", G_CALLBACK (on_themebutton_clicked), NULL);
	g_signal_connect ((gpointer) fontbutton, "clicked", G_CALLBACK (on_fontbutton_clicked), NULL);
	g_signal_connect ((gpointer) hamlibcheckbutton, "toggled", G_CALLBACK (on_hamlibcheckbutton_toggled), NULL);
	g_signal_connect ((gpointer) pollingcheckbutton, "toggled", G_CALLBACK (on_pollingcheckbutton_toggled), NULL);
	g_signal_connect ((gpointer) frequencycheckbutton, "toggled", G_CALLBACK (on_frequencycheckbutton_toggled), NULL);
	g_signal_connect ((gpointer) pathbutton, "clicked", G_CALLBACK (on_pathbutton_clicked), NULL);
	g_signal_connect ((gpointer) savecheckbutton, "toggled", G_CALLBACK (on_savecheckbutton_toggled), NULL);
	g_signal_connect ((gpointer) autosavecheckbutton, "toggled", G_CALLBACK (on_autosavecheckbutton_toggled), NULL);
	g_signal_connect ((gpointer) preferencescancelbutton, "clicked", G_CALLBACK (on_preferencescancelbutton_clicked), NULL);
	g_signal_connect ((gpointer) preferencesokbutton, "clicked", G_CALLBACK (on_preferencesokbutton_clicked), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (preferencesdialog, preferencesdialog, "preferencesdialog");
	GLADE_HOOKUP_OBJECT (preferencesdialog, preferencesnotebook, "preferencesnotebook");
	GLADE_HOOKUP_OBJECT (preferencesdialog, clockcheckbutton, "clockcheckbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, exampleframe, "exampleframe");
	GLADE_HOOKUP_OBJECT (preferencesdialog, examplelabel, "examplelabel");
	GLADE_HOOKUP_OBJECT (preferencesdialog, fontentry, "fontentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, themecheckbutton, "themecheckbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, modesradiobutton1, "modesradiobutton1");
	GLADE_HOOKUP_OBJECT (preferencesdialog, modesradiobutton2, "modesradiobutton2");
	GLADE_HOOKUP_OBJECT (preferencesdialog, modeslabel, "modeslabel");
	GLADE_HOOKUP_OBJECT (preferencesdialog, modesentry, "modesentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, bandsradiobutton1, "bandsradiobutton1");
	GLADE_HOOKUP_OBJECT (preferencesdialog, bandsradiobutton2, "bandsradiobutton2");
	GLADE_HOOKUP_OBJECT (preferencesdialog, bandslabel, "bandslabel");
	GLADE_HOOKUP_OBJECT (preferencesdialog, bandsentry, "bandsentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, callsignentry, "callsignentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, latentry, "latentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, NScombo, "NScombo");
	GLADE_HOOKUP_OBJECT (preferencesdialog, longentry, "longentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, EWcombo, "EWcombo");
	GLADE_HOOKUP_OBJECT (preferencesdialog, qthlocatorentry, "qthlocatorentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, unitscombo, "unitscombo");
	GLADE_HOOKUP_OBJECT (preferencesdialog, hamlibcheckbutton, "hamlibcheckbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, radiocombo, "radiocombo");
	GLADE_HOOKUP_OBJECT (preferencesdialog, devicecombo, "devicecombo");
	GLADE_HOOKUP_OBJECT (preferencesdialog, rigsetconfentry, "rigsetconfentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, pollingcheckbutton, "pollingcheckbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, pollcombo, "pollcombo");
	GLADE_HOOKUP_OBJECT (preferencesdialog, smetercheckbutton, "smetercheckbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, frequencycheckbutton, "frequencycheckbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, digitscombo, "digitscombo");
	GLADE_HOOKUP_OBJECT (preferencesdialog, pathentry, "pathentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, pathbutton, "pathbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, logsentry, "logsentry");
	GLADE_HOOKUP_OBJECT (preferencesdialog, savecheckbutton, "savecheckbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, autosavecheckbutton, "autosavecheckbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, autosavecombo, "autosavecombo");
	GLADE_HOOKUP_OBJECT (preferencesdialog, typeaheadfindcheckbutton, "typeaheadfindcheckbutton");
	GLADE_HOOKUP_OBJECT (preferencesdialog, remoteradiobutton1, "remoteradiobutton1");
	GLADE_HOOKUP_OBJECT (preferencesdialog, remoteradiobutton2, "remoteradiobutton2");

	GLADE_HOOKUP_OBJECT (preferencesdialog, autosaveframe, "autosaveframe");
	GLADE_HOOKUP_OBJECT (preferencesdialog, hamlibframe, "hamlibframe");
	GLADE_HOOKUP_OBJECT (preferencesdialog, frequencyframe, "frequencyframe");
	GLADE_HOOKUP_OBJECT (preferencesdialog, pollingframe, "pollingframe");

	return preferencesdialog;
}

void
on_menu_preferences_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *latentry, *longentry, *NScombo,
		*EWcombo, *unitscombo, *modesentry, *bandsentry,
		*modesradiobutton1, *modesradiobutton2, *bandsradiobutton1,
		*bandsradiobutton2, *modeslabel, *bandslabel, *clockcheckbutton,
		*exampleframe, *examplelabel, *autosavecombo, 
		*themecheckbutton, *pathentry, *logsentry, *qthlocatorentry,
		*callsignentry, *fontentry, *savecheckbutton, *autosavecheckbutton,
		*autosaveframe, *typeaheadfindcheckbutton, *remoteradiobutton1,
		*remoteradiobutton2;
	gchar *temp;
#if WANT_HAMLIB
	GtkWidget *hamlibcheckbutton, *radiocombo, *hamlibframe,
		*devicecombo, *frequencycheckbutton, *digitscombo,
		*smetercheckbutton, *pollingcheckbutton, *rigsetconfentry, *pollcombo;
	gint i, indexradio = -1, numrigs;
	struct rig_caps *rcaps;
#else
	GtkWidget *notebook;
#endif

	preferencesdialog = create_preferencesdialog ();

	/* remote logging */
	remoteradiobutton1 = lookup_widget (preferencesdialog, "remoteradiobutton1");
	remoteradiobutton2 = lookup_widget (preferencesdialog, "remoteradiobutton2");
	if (preferences.remoteadding == 1)
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remoteradiobutton1), TRUE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remoteradiobutton2), FALSE);
	}
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remoteradiobutton1), FALSE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remoteradiobutton2), TRUE);
	}

	/* type ahead find */
	typeaheadfindcheckbutton = lookup_widget 
		(preferencesdialog, "typeaheadfindcheckbutton");
	if (preferences.typeaheadfind == 1)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON 
			(typeaheadfindcheckbutton), TRUE);
	else
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON 
			(typeaheadfindcheckbutton), FALSE);

	/* path for the logs */
	pathentry = lookup_widget (preferencesdialog, "pathentry");
	gtk_entry_set_text (GTK_ENTRY (pathentry), preferences.savedir);

	/* logs to load at startup */
	logsentry = lookup_widget (preferencesdialog, "logsentry");
	gtk_entry_set_text (GTK_ENTRY (logsentry), preferences.logstoload);

	/* callsign */
	callsignentry = lookup_widget (preferencesdialog, "callsignentry");
	gtk_entry_set_text (GTK_ENTRY (callsignentry), preferences.callsign);

	/* saving */
	temp = g_strdup_printf ("%d", preferences.autosave);
	autosavecombo =	lookup_widget (preferencesdialog, "autosavecombo");
	gtk_entry_set_text (GTK_ENTRY (GTK_BIN(autosavecombo)->child), temp);
	autosavecheckbutton = lookup_widget (preferencesdialog, "autosavecheckbutton");
	autosaveframe = lookup_widget (preferencesdialog, "autosaveframe");
	savecheckbutton = lookup_widget (preferencesdialog, "savecheckbutton");
	if (preferences.saving == 1)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(autosavecheckbutton), TRUE);
	}
	else if (preferences.saving == 2)
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(savecheckbutton), TRUE);
		gtk_widget_set_sensitive(autosaveframe, FALSE);
	}

	/* theme */
	fontentry = lookup_widget (preferencesdialog, "fontentry");
	gtk_entry_set_text (GTK_ENTRY (fontentry), preferences.themefont);
	exampleframe = lookup_widget (preferencesdialog, "exampleframe");
	setframestyle (exampleframe, preferences.themecolor, preferences.themefont);
	examplelabel = lookup_widget (preferencesdialog, "examplelabel");
	setlabelstyle (examplelabel, preferences.themecolor, preferences.themefont);
	themecheckbutton = lookup_widget (preferencesdialog, "themecheckbutton");
	if (preferences.logcolor == 0)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (themecheckbutton),
					FALSE);
	else
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (themecheckbutton), TRUE);

	/* clock */
	clockcheckbutton = lookup_widget (preferencesdialog, "clockcheckbutton");
	if (preferences.clock == 0)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (clockcheckbutton),
					FALSE);
	else
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (clockcheckbutton), TRUE);

#if WANT_HAMLIB
	hamlibcheckbutton = lookup_widget (preferencesdialog, "hamlibcheckbutton");
	hamlibframe = lookup_widget (preferencesdialog, "hamlibframe");
	frequencycheckbutton =
		lookup_widget (preferencesdialog, "frequencycheckbutton");
	smetercheckbutton = lookup_widget (preferencesdialog, "smetercheckbutton");
	if (preferences.hamlib == 0)
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hamlibcheckbutton),
					FALSE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (frequencycheckbutton),
					FALSE);
		gtk_widget_set_sensitive (hamlibframe, 0);
	}
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hamlibcheckbutton),
						TRUE);
		if (preferences.hamlib == 2)
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(frequencycheckbutton), TRUE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (smetercheckbutton),
					FALSE);
		}
		else if (preferences.hamlib == 3)
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(frequencycheckbutton), FALSE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (smetercheckbutton),
					TRUE);
		}
		else if (preferences.hamlib == 4)
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(frequencycheckbutton), TRUE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (smetercheckbutton),
					TRUE);
		}
		gtk_widget_set_sensitive (hamlibframe, 1);
	}

	numrigs = g_list_length (riglist);
	radiocombo = lookup_widget (preferencesdialog, "radiocombo");
	if (numrigs > 0)
	{
		for (i = 0; i < numrigs; i++)
		{
			rcaps = (struct rig_caps *) g_list_nth_data (riglist, i);
			gtk_combo_box_append_text (GTK_COMBO_BOX (radiocombo), 
				(gchar *) rcaps->model_name);
			if (g_ascii_strcasecmp (rcaps->model_name, preferences.radio) == 0)
				indexradio = i;
		}
		if (indexradio != -1)
			gtk_combo_box_set_active (GTK_COMBO_BOX (radiocombo), indexradio);
	}

	devicecombo = lookup_widget (preferencesdialog, "devicecombo");
	gtk_entry_set_text (GTK_ENTRY (GTK_BIN(devicecombo)->child), 
		preferences.device);

	temp = g_strdup_printf ("%d", preferences.round);
	digitscombo = lookup_widget (preferencesdialog, "digitscombo");
	gtk_entry_set_text (GTK_ENTRY (GTK_BIN(digitscombo)->child), temp);
	rigsetconfentry = lookup_widget (preferencesdialog, "rigsetconfentry");
	if (g_ascii_strcasecmp (preferences.rigconf, "?"))
		gtk_entry_set_text (GTK_ENTRY (rigsetconfentry), preferences.rigconf);

	/* polling */
	pollingcheckbutton =
		lookup_widget (preferencesdialog, "pollingcheckbutton");
	pollcombo = lookup_widget (preferencesdialog, "pollcombo");

	if (preferences.polltime == 0)
	{
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pollcombo)->child), "300");
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pollingcheckbutton), 
			FALSE);
	}
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pollingcheckbutton), 
			TRUE);
		temp = g_strdup_printf ("%d", preferences.polltime);
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pollcombo)->child), temp);
	}

#else /* hide hamlib page in notebook if no hamlib support */
	notebook = lookup_widget (preferencesdialog, "preferencesnotebook");
	gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), 3);
#endif

	/* location */
	temp = g_strdup_printf ("%3.2f", preferences.latitude);
	latentry = lookup_widget (preferencesdialog, "latentry");
	gtk_entry_set_text (GTK_ENTRY (latentry), temp);
	NScombo = lookup_widget (preferencesdialog, "NScombo");
	if (preferences.NS == 1)
		gtk_combo_box_set_active (GTK_COMBO_BOX (NScombo), 0);
	else
		gtk_combo_box_set_active (GTK_COMBO_BOX (NScombo), 1);
	temp = g_strdup_printf ("%3.2f", preferences.longitude);
	longentry = lookup_widget (preferencesdialog, "longentry");
	gtk_entry_set_text (GTK_ENTRY (longentry), temp);
	EWcombo = lookup_widget (preferencesdialog, "EWcombo");
	if (preferences.EW == 1)
		gtk_combo_box_set_active (GTK_COMBO_BOX (EWcombo), 0);
	else
		gtk_combo_box_set_active (GTK_COMBO_BOX (EWcombo), 1);
	unitscombo = lookup_widget (preferencesdialog, "unitscombo");
	if (preferences.units == 1)
		gtk_combo_box_set_active (GTK_COMBO_BOX (unitscombo), 0);
	else
		gtk_combo_box_set_active (GTK_COMBO_BOX (unitscombo), 1);
	g_free (temp);

	/* locator */
	qthlocatorentry = lookup_widget (preferencesdialog, "qthlocatorentry");
	gtk_entry_set_text (GTK_ENTRY (qthlocatorentry), preferences.locator);

	/* modes and bands */
	modesentry = lookup_widget (preferencesdialog, "modesentry");
	gtk_entry_set_text (GTK_ENTRY (modesentry), preferences.modes);
	bandsentry = lookup_widget (preferencesdialog, "bandsentry");
	gtk_entry_set_text (GTK_ENTRY (bandsentry), preferences.bands);
	/* set state of radio buttons and sensitivity of associated widgets */
	modesradiobutton1 = lookup_widget (preferencesdialog, "modesradiobutton1");
	modesradiobutton2 = lookup_widget (preferencesdialog, "modesradiobutton2");
	modeslabel = lookup_widget (preferencesdialog, "modeslabel");

	if (preferences.modeseditbox == 0)
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (modesradiobutton1),
						FALSE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (modesradiobutton2),
						TRUE);
			gtk_widget_set_sensitive (modeslabel, 1);
			gtk_widget_set_sensitive (modesentry, 1);
		}
	else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (modesradiobutton1),
						TRUE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (modesradiobutton2),
						FALSE);
			gtk_widget_set_sensitive (modeslabel, 0);
			gtk_widget_set_sensitive (modesentry, 0);
		}
	g_signal_connect ((gpointer) modesradiobutton1, "toggled", G_CALLBACK (on_modesradiobutton_toggled), "1");
	g_signal_connect ((gpointer) modesradiobutton2, "toggled", G_CALLBACK (on_modesradiobutton_toggled), "2");

	bandsradiobutton1 = lookup_widget (preferencesdialog, "bandsradiobutton1");
	bandsradiobutton2 = lookup_widget (preferencesdialog, "bandsradiobutton2");
	bandslabel = lookup_widget (preferencesdialog, "bandslabel");
	if (preferences.bandseditbox == 0)
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bandsradiobutton1),
						FALSE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bandsradiobutton2),
						TRUE);
			gtk_widget_set_sensitive (bandslabel, 1);
			gtk_widget_set_sensitive (bandsentry, 1);
		}
	else
		{
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bandsradiobutton1),
						TRUE);
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bandsradiobutton2),
						FALSE);
			gtk_widget_set_sensitive (bandslabel, 0);
			gtk_widget_set_sensitive (bandsentry, 0);
		}
	g_signal_connect ((gpointer) bandsradiobutton1, "toggled", G_CALLBACK (on_bandsradiobutton_toggled), "1");
	g_signal_connect ((gpointer) bandsradiobutton2, "toggled", G_CALLBACK (on_bandsradiobutton_toggled), "2");

	gtk_widget_set_sensitive (mainwindow, 0);
	gtk_widget_show (preferencesdialog);
}
