/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2006 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * preferences.h
 */

/* preferences saved to ~/.xlog/preferences.xml */
typedef struct
{
	gint version;         /* revision number of the preferences file */
	gint x;
	gint y;
	gint width;
	gint height;
	gdouble latitude;
	gint NS;
	gdouble longitude;
	gint EW;
	gint units;           /* kilometers or nautical miles */
	gchar *modes;
	gchar *bands;
	gint bandseditbox;    /* optionmenu or entry for bands? */
	gint modeseditbox;    /* optionmenu or entry modes? */
	gint bandoptionmenu;  /* position of optionmenu */
	gint modeoptionmenu;  /* position of optionmenu */
	gint printall;        /* 0 = all, 1 = range */
	gint printsize;       /* A4 or letter */
	gint printpoint;      /* pointsize (10, 11, 12) */
	gint printorientation;  /* 0 = portrait, 1 = landscape */
	gint printdestination;  /* 0 = printer, 1 = file */
	gint hamlib;  /* hamlib enabled? 0=no, 1=yes, 2=display freq on statusbar */
	gint rigid;      /* what type of radio do you use? */
	gchar *device;   /* which serial port does it use? */
	gchar *rigconf;  /* string for rig_set_conf */
	gint round;      /* how many digits to round to */
	gint polltime;   /* poll every 'polltime' milliseconds, 0 = no polling */
	gint clock;      /* clock on the statusbar? */
	gchar *logfont;
	gint autosave;
	gchar *savedir;
	gchar *backupdir;
	gint saving;    /* 1= autosave, 2=save with click on toolbar */
	gint backup;    /* 1= standard, 2=safe */
	gchar *logstoload;
	gchar *locator;
	gchar *freefield1;
	gchar *freefield2;
	gchar *callsign;
	gchar *defaultmhz;
	gchar *defaultmode;
	gchar *defaulttxrst;
	gchar *defaultrxrst;
	gchar *defaultawards;
	gchar *defaultpower;
	gchar *defaultfreefield1;
	gchar *defaultfreefield2;
	gchar *defaultremarks;
	gchar *b4columns2;
	gchar *logcwidths2;
	gint typeaheadfind;  /* do we want type ahead find */
	gint remoteadding;   /* add remote data to log or qso frame */
	gint viewtoolbar;    /* do we want to see the toolbar button */
	gint viewb4;         /* do we want to see the worked before dialog */
	gint b4x;
	gint b4y;
	gint b4width;
	gint b4height;
	gint saveasadif;
	gchar *saveastsv2;
	gint tsvcalc;
	gint handlebarpos;
	gchar *cwf1;
	gchar *cwf2;
	gchar *cwf3;
	gchar *cwf4;
	gchar *cwf5;
	gchar *cwf6;
	gchar *cwf7;
	gchar *cwf8;
	gchar *cwf9;
	gchar *cwf10;
	gchar *cwf11;
	gchar *cwf12;
	gchar *cwcq;
	gchar *cwsp;
	gint cwspeed;
	gint fcc;
	gint viewscoring;
	gint scorex;
	gint scorey;
	gint scorewidth;
	gint scoreheight;
	gchar *scoringbands;
}
preferencestype;

void loadpreferences (void);
void savepreferences (void);
