/*

   xlog - GTK+ logging program for amateur radio operators
   Copyright (C) 2001 - 2007 Joop Stakenborg <pg4i@amsat.org>

   This file is part of xlog.

   Xlog is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Xlog is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with xlog.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * wwl.c - see description below by IK0ZSN, adopted for xlog April 2002
 * fixes by Pieter-Tjerk de Boer, PA3FWM and Hamish Mofatt, VK3SB
 * from the wwl debian package.
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <gtk/gtk.h>

#include "wwl.h"
#include "support.h"
#include "utils.h"
#include "preferences.h"

extern preferencestype preferences;
extern GtkWidget *scorewindow;


/* calculate distance between 2 locators, distance in kilometers */
gint
wwl (gchar * my, gchar * dx, gint *p, gint *l)
{
	gint strlen_dx;
	gdouble z, y, n, h, x, w, t, s, v, u, c, d, e, lx;
	gchar my_wwl[7], dx_wwl[7] = "AA55MM";
	gchar *msg;

	if (strlen (my) != 6)
		{
			msg = g_strdup_printf (_("%s: not a valid locator"), my);
			update_statusbar (msg);
			g_free (msg);
			return 1;
		}

	strlen_dx = strlen (dx);
	if (strlen_dx < 2 || strlen_dx > 6)
		{
			msg = g_strdup_printf (_("%s: not a valid locator"), dx);
			update_statusbar (msg);
			g_free (msg);
			return 1;
		}

	strcpy (my_wwl, my);
	memcpy (dx_wwl, dx, strlen_dx);

	my_wwl[0] = toupper (my_wwl[0]);
	z = my_wwl[0] - 65;
	my_wwl[1] = toupper (my_wwl[1]);
	y = my_wwl[1] - 65;
	n = my_wwl[2] - 48;
	h = my_wwl[3] - 48;
	my_wwl[4] = toupper (my_wwl[4]);
	x = my_wwl[4] - 65;
	my_wwl[5] = toupper (my_wwl[5]);
	w = my_wwl[5] - 65;

	if (my_wwl[0] < 65 || my_wwl[0] > 88 || my_wwl[1] < 65 || my_wwl[1] > 88 ||
			my_wwl[2] < 48 || my_wwl[2] > 57 || my_wwl[3] < 48 || my_wwl[3] > 57 ||
			my_wwl[4] < 65 || my_wwl[4] > 88 || my_wwl[5] < 65 || my_wwl[5] > 88)
		{
			msg = g_strdup_printf (_("%s: not a valid locator"), my_wwl);
			update_statusbar (msg);
			g_free (msg);
			return 1;
		}

	t = z * 20 - 180 + n * 2 + x / 12 + 1.0 / 24;
	t = t * 3.1415926 / 180;
	s = y * 10 - 90 + h + w / 24 + 1.0 / 48;
	s = s * 3.1415926 / 180;

	dx_wwl[0] = toupper (dx_wwl[0]);
	z = dx_wwl[0] - 65;
	dx_wwl[1] = toupper (dx_wwl[1]);
	y = dx_wwl[1] - 65;
	n = dx_wwl[2] - 48;
	h = dx_wwl[3] - 48;
	dx_wwl[4] = toupper (dx_wwl[4]);
	x = dx_wwl[4] - 65;
	dx_wwl[5] = toupper (dx_wwl[5]);
	w = dx_wwl[5] - 65;

	if (dx_wwl[0] < 65 || dx_wwl[0] > 88 || dx_wwl[1] < 65 || dx_wwl[1] > 88 ||
			dx_wwl[2] < 48 || dx_wwl[2] > 57 || dx_wwl[3] < 48 || dx_wwl[3] > 57 ||
			dx_wwl[4] < 65 || dx_wwl[4] > 88 || dx_wwl[5] < 65 || dx_wwl[5] > 88)
		{
			msg = g_strdup_printf (_("%s: not a valid locator"), dx_wwl);
			update_statusbar (msg);
			g_free (msg);
			return 1;
		}

	v = z * 20 - 180 + n * 2 + x / 12 + 1.0 / 24;
	v = v * 3.1415926 / 180;
	u = y * 10 - 90 + h + w / 24 + 1.0 / 48;
	u = u * 3.1415926 / 180;

	c = cos (s) * cos (u) * cos (v - t) + sin (s) * sin (u);
	d = 1 - c * c;
	if (sqrt (d) != 0)
		{
			e = (sin (u) - sin (s) * c) / (cos (s) * sqrt (d));
			if (e > 1.0) e = 1.0;
			if (e < -1.0) e = -1.0;
			lx = acos (e) * 180 / 3.1415926;
			*l = (int) (lx + 0.5);
		}
	else
		{
			*l = 0;
		}

	if (sin (v - t) < 0)
		{
			*l = 360 - *l;
		}

	*p = (gint) (atan (sqrt (d) / c) * 6371.33) + .5;
	if (*p < 0) *p = 20002 + *p;
	if (*p < 1) *p = 0;
	return 0;
}

void
updatelocatorframe (gchar * locator)
{
	gchar *locatorlabeltext, *framelabeltext;
	GtkWidget *locatorframe, *framelabel, *locatorlabel;
	gint p, m, result, l;

	/* initialize */
	locatorframe = lookup_widget (scorewindow, "locatorframe");
	locatorlabel = lookup_widget (scorewindow, "locatorlabel");
	framelabel = gtk_frame_get_label_widget (GTK_FRAME(locatorframe));
	locatorlabeltext = g_strdup ("");
	framelabeltext = g_strdup ("");

	if (strlen (locator) >= 2)
	{
		result = wwl (preferences.locator, locator, &p, &l);
		if (result == 0)
		{
			if (preferences.units == 1)
				locatorlabeltext = g_strdup_printf
					(_("Distance: %d km, azimuth: %d deg"), p, l);
			else
			{
				m = (gint) (p / 1.609);
				locatorlabeltext = g_strdup_printf
					(_("Distance: %d m, azimuth: %d deg"), m, l);
			}
		}
		framelabeltext = g_strdup_printf ("<b>%s</b>", g_ascii_strup (locator, -1));
	}
	gtk_label_set_markup (GTK_LABEL (framelabel), framelabeltext);
	gtk_label_set_text (GTK_LABEL (locatorlabel), locatorlabeltext);
	g_free (framelabeltext);
	g_free (locatorlabeltext);
}
