/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import java.util.Comparator;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.AttrOverNodeInfo;
import net.sf.saxon.dom.DOMAttributeMap;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.ElementOverNodeInfo;
import net.sf.saxon.dom.PIOverNodeInfo;
import net.sf.saxon.dom.TextOverNodeInfo;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class NodeOverNodeInfo
implements Node {
    protected NodeInfo node;

    public NodeInfo getUnderlyingNodeInfo() {
        return this.node;
    }

    public static NodeOverNodeInfo wrap(NodeInfo nodeInfo) {
        NodeOverNodeInfo nodeOverNodeInfo = null;
        if (nodeInfo == null) {
            return null;
        }
        switch (nodeInfo.getNodeKind()) {
            case 9: {
                nodeOverNodeInfo = new DocumentOverNodeInfo();
                break;
            }
            case 1: {
                nodeOverNodeInfo = new ElementOverNodeInfo();
                break;
            }
            case 2: {
                nodeOverNodeInfo = new AttrOverNodeInfo();
                break;
            }
            case 3: 
            case 8: {
                nodeOverNodeInfo = new TextOverNodeInfo();
                break;
            }
            case 7: {
                nodeOverNodeInfo = new PIOverNodeInfo();
                break;
            }
            case 13: {
                nodeOverNodeInfo = new AttrOverNodeInfo();
            }
        }
        nodeOverNodeInfo.node = nodeInfo;
        return nodeOverNodeInfo;
    }

    public final boolean isSameNode(Node node) {
        if (node instanceof NodeOverNodeInfo) {
            return this.node.isSameNodeInfo(((NodeOverNodeInfo)node).node);
        }
        return false;
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public String getNodeName() {
        switch (this.node.getNodeKind()) {
            case 9: {
                return "#document";
            }
            case 1: {
                return this.node.getDisplayName();
            }
            case 2: {
                return this.node.getDisplayName();
            }
            case 3: {
                return "#text";
            }
            case 8: {
                return "#comment";
            }
            case 7: {
                return this.node.getLocalPart();
            }
            case 13: {
                if (this.node.getLocalPart().equals("")) {
                    return "xmlns";
                }
                return "xmlns:" + this.node.getLocalPart();
            }
        }
        return "#unknown";
    }

    public String getLocalName() {
        switch (this.node.getNodeKind()) {
            case 1: 
            case 2: {
                return this.node.getLocalPart();
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
            case 13: {
                if (this.node.getLocalPart().equals("")) {
                    return "xmlns";
                }
                return this.node.getLocalPart();
            }
        }
        return null;
    }

    public boolean hasChildNodes() {
        return this.node.iterateAxis((byte)3).next() != null;
    }

    public boolean hasAttributes() {
        return true;
    }

    public short getNodeType() {
        short s = (short)this.node.getNodeKind();
        if (s == 13) {
            return 2;
        }
        return s;
    }

    public Node getParentNode() {
        return NodeOverNodeInfo.wrap(this.node.getParent());
    }

    public Node getPreviousSibling() {
        return NodeOverNodeInfo.wrap((NodeInfo)this.node.iterateAxis((byte)11).next());
    }

    public Node getNextSibling() {
        return NodeOverNodeInfo.wrap((NodeInfo)this.node.iterateAxis((byte)7).next());
    }

    public Node getFirstChild() {
        return NodeOverNodeInfo.wrap((NodeInfo)this.node.iterateAxis((byte)3).next());
    }

    public Node getLastChild() {
        AxisIterator axisIterator = this.node.iterateAxis((byte)3);
        NodeInfo nodeInfo = null;
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            nodeInfo = nodeInfo2;
        }
        return NodeOverNodeInfo.wrap(nodeInfo);
    }

    public String getNodeValue() {
        switch (this.node.getNodeKind()) {
            case 1: 
            case 9: {
                return null;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return this.node.getStringValue();
            }
        }
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
    }

    public NodeList getChildNodes() {
        try {
            NodeInfo nodeInfo;
            ArrayList<NodeOverNodeInfo> arrayList = new ArrayList<NodeOverNodeInfo>(10);
            AxisIterator axisIterator = this.node.iterateAxis((byte)3);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                arrayList.add(NodeOverNodeInfo.wrap(nodeInfo));
            }
            return new DOMNodeList(arrayList);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public NamedNodeMap getAttributes() {
        if (this.node.getNodeKind() == 1) {
            return new DOMAttributeMap(this.node);
        }
        return null;
    }

    public Document getOwnerDocument() {
        return (Document)((Object)NodeOverNodeInfo.wrap((NodeInfo)this.node.getDocumentRoot()));
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Node cloneNode(boolean bl) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return string.equalsIgnoreCase("xml");
    }

    public String getNamespaceURI() {
        if (this.node.getNodeKind() == 13) {
            if (this.node.getLocalPart().equals("")) {
                return null;
            }
            return "http://www.w3.org/2000/xmlns/";
        }
        String string = this.node.getURI();
        return "".equals(string) ? null : string;
    }

    public String getPrefix() {
        if (this.node.getNodeKind() == 13) {
            if (this.node.getLocalPart().equals("")) {
                return null;
            }
            return "xmlns";
        }
        String string = this.node.getNamePool().getPrefix(this.node.getNameCode());
        return "".equals(string) ? null : string;
    }

    public void setPrefix(String string) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        if (!(node instanceof NodeOverNodeInfo)) {
            return 1;
        }
        int n = this.node.compareOrder(((NodeOverNodeInfo)node).node);
        if (n == 0) {
            return 0;
        }
        if (n == -1) {
            short s = this.compareDocumentPosition(node.getParentNode());
            short s2 = 4;
            if (s == 0 || (s & 0x10) != 0) {
                s = (short)(s | 0x10);
            }
            return s2;
        }
        if (n == 1) {
            short s = ((NodeOverNodeInfo)this.getParentNode()).compareDocumentPosition(node);
            short s3 = 2;
            if (s == 0 || (s & 8) != 0) {
                s = (short)(s | 8);
            }
            return s3;
        }
        throw new AssertionError();
    }

    public String getTextContent() throws DOMException {
        if (this.node.getNodeKind() == 9) {
            return null;
        }
        return this.node.getStringValue();
    }

    public void setTextContent(String string) throws DOMException {
        NodeOverNodeInfo.disallowUpdate();
    }

    public String lookupPrefix(String string) {
        if (this.node.getNodeKind() == 9) {
            return null;
        }
        if (this.node.getNodeKind() == 1) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = this.node.iterateAxis((byte)8);
            do {
                if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
                return null;
            } while (!nodeInfo.getStringValue().equals(string));
            return nodeInfo.getLocalPart();
        }
        return ((NodeOverNodeInfo)this.getParentNode()).lookupPrefix(string);
    }

    public boolean isDefaultNamespace(String string) {
        return string.equals(this.lookupNamespaceURI(""));
    }

    public String lookupNamespaceURI(String string) {
        if (this.node.getNodeKind() == 9) {
            return null;
        }
        if (this.node.getNodeKind() == 1) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = this.node.iterateAxis((byte)8);
            do {
                if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
                return null;
            } while (!nodeInfo.getLocalPart().equals(string));
            return nodeInfo.getStringValue();
        }
        return ((NodeOverNodeInfo)this.getParentNode()).lookupNamespaceURI(string);
    }

    public boolean isEqualNode(Node node) {
        if (!(node instanceof NodeOverNodeInfo)) {
            throw new IllegalArgumentException("Other Node must wrap a Saxon NodeInfo");
        }
        return DeepEqual.deepEquals((SequenceIterator)SingletonIterator.makeIterator((Item)this.node), (SequenceIterator)SingletonIterator.makeIterator((Item)((NodeOverNodeInfo)node).node), (GenericAtomicComparer)new GenericAtomicComparer((Comparator)CodepointCollator.getInstance(), this.node.getConfiguration()), (Configuration)this.node.getConfiguration(), (int)46);
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        NodeOverNodeInfo.disallowUpdate();
        return null;
    }

    public Object getUserData(String string) {
        return null;
    }

    protected static void disallowUpdate() throws DOMException {
        throw new UnsupportedOperationException("The Saxon DOM cannot be updated");
    }
}

