#### Header variables
%define name xmms-crossfade
%define version 0.3.10
%define release 1
%define serial 1

# Override standard libdir with xmms config
%define _libdir /usr/lib/xmms/Output

#### Useful macros
# Attempt to avoid disaster
%define clean_build_root if test -O "%{buildroot}" -a "%{buildroot}" != "/" -a "%{buildroot}" != "$HOME"; then %{__rm} -rf %{buildroot}; fi
# To delete directory where compilation takes place
%define clean_build_dir %{__rm} -rf %{buildsubdir}

#### Header
Summary: XMMS - Plugin for Crossfading and Continuous Output
Name: %{name}
Version: %{version}
Release: %{release}
Serial: %{serial}
Copyright: GPL
Group: Applications/Multimedia
Vendor: Peter Eisenlohr <peter@eisenlohr.org>
Packager: %packager
Url: http://www.eisenlohr.org/xmms-crossfade
Source: %{name}-%{version}.tar.gz
Prefix: %{_prefix}
Requires: xmms
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

#### Description
%description
This XMMS plugin provides crossfading, continuous output and gap-killing between tracks.

#### Prep
%prep
%setup -q

#### Build
%build
%configure
# Build user might have his/her own special "make" hooks
%__make

#### Install
%install
%clean_build_root
# makeinstall is rpm >= 3.0.5 only, so define it manually if necessary
%{!?makeinstall: %define makeinstall make DESTDIR="$RPM_BUILD_ROOT" install}
%makeinstall

#### Clean
%clean
%clean_build_root
%clean_build_dir

#### Post
# Nothing to do

#### Files
%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog README INSTALL TODO
%{_libdir}/* 

#### Changelog
%changelog

* Wed Jan 03 2001 Sourav K. Mandal <Sourav.Mandal@ikaran.com>
- First spec file incorporated in tarball package

