/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  FM Radio plug-in v1.5
 *  Copyright (C) 1999 Julien Viard <Julien.Viard@enst.fr>
 *
 *  Radio acces routines from Keith Wesolowski (wesolows@cs.unr.edu)
 *  GRadio 1.0.0
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "radio.h"
#ifndef __FreeBSD__

static GtkWidget *window = NULL, *vbox, *frame, *table;
static GtkWidget *radio_label, *radio_entry;
static GtkWidget *freq_label, *freq_scale, *freq_spin, *freq_label2;
static GtkObject *freq_adj;
static GtkWidget *scan_label, *scan_hbox, *scan_down, *scan_up, *scan_down2, *scan_up2;
static GtkWidget *bbox, *save, *save_as, *cancel;

static gchar *current_filename = NULL;

static void show_dialog(gchar * title, gchar * text)
{
	GtkWidget *dialog, *label, *button;

	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
	gtk_container_border_width(GTK_CONTAINER(dialog), 5);
	label = gtk_label_new(text);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);

	button = gtk_button_new_with_label("Close");
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_set_usize(button, 75, -1);
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 0);
	gtk_widget_show(button);
	gtk_widget_grab_default(button);

	gtk_widget_show(dialog);
}


static void save_cb(GtkWidget * w, gpointer data)
{
  FILE *file;
  gint fr;
  gchar *tmp,*radioname;

  radioname=g_strdup(gtk_entry_get_text( GTK_ENTRY(radio_entry) ));
  if ((tmp = strrchr(radioname, '\n')) != NULL)
    *tmp = '\0';
  fr=1000*gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(freq_spin));
  file=fopen(current_filename,"w");
  if(file!=NULL){
    fprintf(file,"%s\nFreq:%d\n",radioname,fr);
    fclose(file);
  }else{
    show_dialog("File Info", "\n    Couldn't write file!    \n");
  }
  free(radioname);
  gtk_widget_destroy(window);
}

/* Get the selected filename and print it to the console */
void file_ok_sel (GtkWidget *w, GtkFileSelection *fs)
{
  FILE *file;
  gint fr;
  gchar *tmp,*radioname;

  g_free(current_filename);
  current_filename=g_strdup(gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
  radioname=g_strdup(gtk_entry_get_text( GTK_ENTRY(radio_entry) ));
  if ((tmp = strrchr(radioname, '\n')) != NULL)
    *tmp = '\0';
  fr=1000*gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(freq_spin));
  file=fopen(current_filename,"w");
  if(file!=NULL){
    fprintf(file,"%s\nFreq:%d\n",radioname,fr);
    fclose(file);
  }else{
    show_dialog("File Info", "\n    Couldn't write file!    \n");
  }
  free(radioname);
  gtk_widget_destroy(window);
  gtk_widget_destroy(GTK_WIDGET(fs));
}


static void save_as_cb(GtkWidget * w, gpointer data)
{
  GtkWidget *filew;
  /* Create a new file selection widget */
  filew = gtk_file_selection_new ("File selection");
  
  gtk_signal_connect(GTK_OBJECT(filew), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &filew);
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked", (GtkSignalFunc) file_ok_sel, filew );
  
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
					 (filew)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filew));
  
  /* Lets set the filename, as if this were a save dialog, and we are giving
            a default filename */
  gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), 
				   current_filename);
  
  gtk_widget_show(filew);
}

static void freq_changed(GtkAdjustment *adj, gpointer data)
{
#ifdef linux
  struct video_tuner v;
  struct video_audio va;
  unsigned long xl_freq;

  if (radio_fd == -2) {
    radio_fd = open (radio_cfg.device, O_RDONLY);
  }
  if (radio_fd == -1)
    return;
#endif /* linux */

  freq=1000*adj->value;

    if (freq > FMR_FREQ_MAX)
      freq = FMR_FREQ_MAX;
    if (freq < FMR_FREQ_MIN)
      freq = FMR_FREQ_MIN;

#ifdef linux
    xl_freq = (unsigned long)(freq*fmradio_get_freq_fact () + 0.5);
    va.volume = volume * (65535/(FMR_VOL_MAX-FMR_VOL_MIN));
    va.audio = 0;
    va.flags = VIDEO_AUDIO_VOLUME|(is_paused ? VIDEO_AUDIO_MUTE : 0);
    
    v.tuner = 0;
    ioctl (radio_fd, VIDIOCSFREQ, &xl_freq);
    ioctl (radio_fd, VIDIOCGTUNER, &v);
    ioctl (radio_fd, VIDIOCSAUDIO, &va);
    tuned = ((v.signal != 0) ? TRUE : FALSE);
  close(radio_fd);
  radio_fd = -2;
#elif defined BSD_RADIO
  ri.freq = freq;
  ri.volume = volume * (255 / (FMR_VOL_MAX - FMR_VOL_MIN));
  ri.mute = is_paused ? 1 : 0;
  SetGetRadioInfo(RIOCSINFO);
  usleep(50000);
  SetGetRadioInfo(RIOCGINFO);
  tuned = ri.info ? TRUE : FALSE;
#endif /* linux || BSD_RADIO */
}

static void scan_cb(GtkWidget * sb, gpointer data){
  gint tries,step,fr,i;
#ifdef linux
  struct video_tuner v;
  struct video_audio va;
  unsigned long xl_freq;

  if (radio_fd == -2) {
    radio_fd = open (radio_cfg.device, O_RDONLY);
  }
#endif /* linux */
  sscanf((char*)data,"%d",&tries);
  if (tries!=0){
    if(tries>0)
      step=50;
    else {
      step=-50;
      tries=-tries;
    }
    fr=step * ( freq / step);
    while((tuned)&&(freq+step <= FMR_FREQ_MAX)&&(freq+step >= FMR_FREQ_MIN)){
      fr+=step;
      gtk_adjustment_set_value(GTK_ADJUSTMENT(freq_adj),(gfloat)fr/1000.0);
     
#ifdef linux
      xl_freq = (unsigned long)(fr*fmradio_get_freq_fact () + 0.5);
      va.volume = volume * (65535/(FMR_VOL_MAX-FMR_VOL_MIN));
      va.audio = 0;
      va.flags = VIDEO_AUDIO_VOLUME|(is_paused ? VIDEO_AUDIO_MUTE : 0);
      ioctl (radio_fd, VIDIOCSFREQ, &xl_freq);
      ioctl (radio_fd, VIDIOCSAUDIO, &va);
#elif defined BSD_RADIO
      ri.freq = fr;
      ri.volume = volume * (255/(FMR_VOL_MAX-FMR_VOL_MIN));
      ri.mute = is_paused ? 1 : 0;
      SetGetRadioInfo(RIOCSINFO);
#endif /* linux || BSD_RADIO */
	
      for(i=0;(i<tries)&&(tuned);i++){
	usleep (10000); 
#ifdef linux
	v.tuner = 0;
	ioctl (radio_fd, VIDIOCGTUNER, &v);
	tuned = ((v.signal != 0) ? TRUE : FALSE);
#elif defined BSD_RADIO
      	SetGetRadioInfo(RIOCGINFO);
	tuned = ri.info & (RADIO_INFO_SIGNAL | RADIO_INFO_STEREO) ? 1 : 0;
#endif /* linux || BSD_RADIO */
      }
    }

    while((!tuned)&&(freq+step <= FMR_FREQ_MAX)&&(freq+step >= FMR_FREQ_MIN)){
      fr+=step;
      gtk_adjustment_set_value(GTK_ADJUSTMENT(freq_adj),(gfloat)fr/1000.0);

#ifdef linux
      xl_freq = (unsigned long)(fr*fmradio_get_freq_fact () + 0.5);
      va.volume = volume * (65535/(FMR_VOL_MAX-FMR_VOL_MIN));
      va.audio = 0;
      va.flags = VIDEO_AUDIO_VOLUME|(is_paused ? VIDEO_AUDIO_MUTE : 0);
      ioctl (radio_fd, VIDIOCSFREQ, &xl_freq);
      ioctl (radio_fd, VIDIOCSAUDIO, &va);
#elif defined BSD_RADIO
      ri.freq = fr;
      ri.volume = volume * (255/(FMR_VOL_MAX-FMR_VOL_MIN));
      ri.mute = is_paused ? 1 : 0;
      SetGetRadioInfo(RIOCSINFO);
#endif /* linux || BSD_RADIO */
	
      for(i=0;(i<tries)&&(!tuned);i++){
	usleep (10000); 
#ifdef linux
	v.tuner = 0;
	ioctl (radio_fd, VIDIOCGTUNER, &v);
	tuned = ((v.signal != 0) ? TRUE : FALSE);
#elif defined BSD_RADIO
      	SetGetRadioInfo(RIOCGINFO);
	tuned = ri.info & (RADIO_INFO_SIGNAL | RADIO_INFO_STEREO) ? 1 : 0;
#endif /* linux || BSD_RADIO */
      }
     }
  }
#ifdef linux
  close(radio_fd);
  radio_fd = -2;
#endif /* linux */
}

void radio_file_info_box(char *filename)
{
  gint fr;
  gchar *tmp, *name, *title, *radioname;
  FILE *file;

  if (!window)
    {
      /* create the windows with all the widgets */
      window = gtk_window_new(GTK_WINDOW_DIALOG);
      gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
      gtk_container_set_border_width(GTK_CONTAINER(window), 10);

      vbox = gtk_vbox_new(FALSE, 10);
      gtk_container_add(GTK_CONTAINER(window), vbox);

      frame = gtk_frame_new("FM Radio:");
      gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);

      table = gtk_table_new(4, 5, FALSE);
      gtk_container_set_border_width(GTK_CONTAINER(table), 5);
      gtk_container_add(GTK_CONTAINER(frame), table);

      radio_label = gtk_label_new("Name:");
      gtk_misc_set_alignment(GTK_MISC(radio_label), 1, 0.5);
      gtk_table_attach(GTK_TABLE(table), radio_label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 5, 5);
      gtk_widget_show(radio_label);

      radio_entry = gtk_entry_new_with_max_length(30);
      gtk_table_attach(GTK_TABLE(table), radio_entry, 1, 4, 0, 1, GTK_FILL | GTK_EXPAND | GTK_SHRINK, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 5);
      gtk_widget_show(radio_entry);

      freq_label = gtk_label_new("Frequency:");
      gtk_misc_set_alignment(GTK_MISC(freq_label), 1, 0.5);
      gtk_table_attach(GTK_TABLE(table), freq_label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 5);
      gtk_widget_show(freq_label);

      freq_adj=gtk_adjustment_new(FMR_FREQ_DEFAULT/1000.0,FMR_FREQ_MIN/1000.0,FMR_FREQ_MAX/1000.0,0.05,0.05,0.05);
      if(radio_fd!=-1){
	gtk_signal_connect (GTK_OBJECT (freq_adj), "value_changed",
                           GTK_SIGNAL_FUNC (freq_changed),NULL);
      }


      freq_scale=gtk_hscale_new(GTK_ADJUSTMENT(freq_adj));
      gtk_misc_set_alignment(GTK_MISC(freq_scale), 1, 0.5);
      gtk_scale_set_draw_value(GTK_SCALE(freq_scale), FALSE);
      gtk_table_attach(GTK_TABLE(table), freq_scale, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND | GTK_SHRINK, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 5);
      gtk_widget_show(freq_scale);

      freq_spin=gtk_spin_button_new(GTK_ADJUSTMENT(freq_adj),0.2,2);
      gtk_misc_set_alignment(GTK_MISC(freq_spin), 1, 0.5);
      gtk_table_attach(GTK_TABLE(table), freq_spin, 2, 3, 1, 2, GTK_FILL | GTK_EXPAND | GTK_SHRINK, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 5, 5);
      gtk_widget_show(freq_spin);

      freq_label2 = gtk_label_new("MHz");
      gtk_misc_set_alignment(GTK_MISC(freq_label2), 0, 0.5);
      gtk_table_attach(GTK_TABLE(table), freq_label2, 3, 4, 1, 2, GTK_FILL, GTK_FILL, 0, 5);
      gtk_widget_show(freq_label2);

      if(radio_fd!=-1){
	scan_label = gtk_label_new("Scan ");
	gtk_misc_set_alignment(GTK_MISC(scan_label), 1, 0.5);
	gtk_table_attach(GTK_TABLE(table), scan_label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 5);
	gtk_widget_show(scan_label);

	scan_hbox=gtk_hbox_new(FALSE,0);
	gtk_table_attach(GTK_TABLE(table), scan_hbox, 1, 2, 2, 3, GTK_FILL | GTK_EXPAND | GTK_SHRINK, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 5, 5);

	scan_down2=gtk_button_new_with_label ("<<");
	gtk_signal_connect (GTK_OBJECT (scan_down2), "clicked",
			    GTK_SIGNAL_FUNC (scan_cb), (gpointer) "-5");
	gtk_box_pack_start(GTK_BOX(scan_hbox), scan_down2, FALSE, FALSE, 0);
	gtk_widget_show(scan_down2);

	scan_down=gtk_button_new_with_label ("<");
	gtk_signal_connect (GTK_OBJECT (scan_down), "clicked",
			    GTK_SIGNAL_FUNC (scan_cb), (gpointer) "-25");
	gtk_box_pack_start(GTK_BOX(scan_hbox), scan_down, FALSE, FALSE, 0);
	gtk_widget_show(scan_down);

	scan_up2=gtk_button_new_with_label (">>");
	gtk_signal_connect (GTK_OBJECT (scan_up2), "clicked",
			    GTK_SIGNAL_FUNC (scan_cb), (gpointer) "5");
	gtk_box_pack_end(GTK_BOX(scan_hbox), scan_up2, FALSE, FALSE, 0);
	gtk_widget_show(scan_up2);

	scan_up=gtk_button_new_with_label (">");
	gtk_signal_connect (GTK_OBJECT (scan_up), "clicked",
			    GTK_SIGNAL_FUNC (scan_cb), (gpointer) "25");
	gtk_box_pack_end(GTK_BOX(scan_hbox), scan_up, FALSE, FALSE, 0);
	gtk_widget_show(scan_up);

	gtk_widget_show(scan_hbox);
      }


      gtk_widget_show(frame);
      gtk_widget_show(table);

      bbox = gtk_hbutton_box_new();
      gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
      gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
      gtk_box_pack_end(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

      save = gtk_button_new_with_label("Save");
      gtk_signal_connect(GTK_OBJECT(save), "clicked", GTK_SIGNAL_FUNC(save_cb), NULL);

      GTK_WIDGET_SET_FLAGS(save, GTK_CAN_DEFAULT);
      gtk_box_pack_start(GTK_BOX(bbox), save, TRUE, TRUE, 0);
      gtk_widget_show(save);
      gtk_widget_grab_default(save);

      save_as = gtk_button_new_with_label("Save as");
      gtk_signal_connect(GTK_OBJECT(save_as), "clicked", GTK_SIGNAL_FUNC(save_as_cb), NULL);
/*      gtk_signal_connect_object(GTK_OBJECT(save_as), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));*/

      GTK_WIDGET_SET_FLAGS(save_as, GTK_CAN_DEFAULT);
      gtk_box_pack_start(GTK_BOX(bbox), save_as, TRUE, TRUE, 0);
      gtk_widget_show(save_as);

      cancel = gtk_button_new_with_label("Cancel");
      gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
      GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
      gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
      gtk_widget_show(cancel);

      gtk_widget_show(bbox);
      gtk_widget_show(vbox);
      gtk_widget_show(window);
    }

  if (current_filename)
    g_free(current_filename);
  current_filename = g_strdup(filename);
  
  name = strrchr(filename, '/');
  if (name)
    name++;
  else
    name = filename;

  title = g_strdup_printf("File Info - %s", name);
  gtk_window_set_title(GTK_WINDOW(window), title);
  g_free(title);
  
  title = g_strdup(name);
  if ((tmp = strrchr(title, '.')) != NULL)
    *tmp = '\0';
  gtk_entry_set_text(GTK_ENTRY(radio_entry), title);
  g_free(title);

  fr=0;
  file=fopen(current_filename,"r");
  if(file!=NULL){
    radioname=(gchar*)malloc(STR_LEN_MAX*sizeof(gchar));
    fgets(radioname,STR_LEN_MAX,file);
    radioname[STR_LEN_MAX-1] = '\0';
    if ((tmp = strrchr(radioname, '\n')) != NULL)
      *tmp = '\0';
    if(!fscanf(file,"Freq:%d", &fr)) fr=0;
    fclose(file);
    gtk_entry_set_text(GTK_ENTRY(radio_entry), radioname);
  }else{
    radioname=NULL;
  }
  if(fr==0){
    tmp = strrchr(current_filename, '/');
    if (tmp)
      tmp++;
    else
      tmp = current_filename;
    if (!sscanf(tmp, "Radio %d.fmr", &fr))
      fr=FMR_FREQ_DEFAULT;
  }
  gtk_adjustment_set_value(GTK_ADJUSTMENT(freq_adj),(gfloat)fr/1000.0);
}

#endif
