/*  
   XMMS-SID - SIDPlay input plugin for X MultiMedia System (XMMS)

   Miscellaneous support functions
   
   Written by Matti "ccr" Hamalainen <ccr@tnsp.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "xs_support.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/*
 * Utility routines
 */
gint xs_strcalloc(gchar **ppcResult, const gchar *pcStr)
{
 assert(ppcResult);
 assert(pcStr);
 
 /* Allocate memory for destination */
 *ppcResult = (gchar *) g_realloc(*ppcResult, strlen(pcStr) + 1);
 if (*ppcResult == NULL) return -1;

 /* Copy to the destination */
 strcpy(*ppcResult, pcStr);

 return 0;
}


int xs_strcat(gchar **ppcResult, const gchar *pcStr)
{
 assert(ppcResult);
 assert(pcStr);
 
 /* Re-allocate memory for destination */
 *ppcResult = (gchar *) g_realloc(*ppcResult, strlen(*ppcResult) + strlen(pcStr) + 1);
 if (*ppcResult == NULL) return -1;

 /* Cat to the destination */
 strcat(*ppcResult, pcStr);

 return 0;
}


gchar *xs_strrchr(gchar *pcStr, gchar ch)
{
 gchar *lastPos = NULL;

 while (*pcStr)
 	{
 	if (*pcStr == ch) lastPos = pcStr;
 	pcStr++;
 	}

 return lastPos;
}


inline void xs_findnext(gchar *pcStr, guint *piPos)
{
 while (pcStr[*piPos] && isspace(pcStr[*piPos])) (*piPos)++;
}


inline void xs_findeol(gchar *pcStr, guint *piPos)
{
 while (pcStr[*piPos] && (pcStr[*piPos] != '\n') && (pcStr[*piPos] != '\r')) (*piPos)++;
}


inline void xs_findnum(gchar *pcStr, guint *piPos)
{
 while (pcStr[*piPos] && isdigit(pcStr[*piPos])) (*piPos)++;
}


