#!/bin/sh
#

function usage()
{
	echo
	echo "Usage: jmg.sh [options]"
	echo "Options:"
	echo "  -g    Disable OpenGL displayer"
	echo "  -h    Disable home install"
	echo "  -o    Enable optimizations"
	echo "  -t    Omit test plugins"
	echo "  -w    Normal warnings"
	echo
}

function evl_echo()
{
	if test "$1" != ""
	then
		echo "        $1"
	fi
}

OPENGL=" --enable-opengl"
HOMEINST=" --enable-install-home"
OPTIMI=" --disable-optimizations"
TESTDIS=" --enable-test-plugins"
WARNS=" --enable-more-warnings"

# Parse command line options
while getopts ghotw? opt ; do
	case "$opt" in
		g) OPENGL="" ;;
		h) HOMEINST="" ;;
		o) OPTIMI="" ;;
		t) TESTDIS="" ;;
		w) WARNS="" ;;
		?) usage; exit ;;
	esac
done

CONFIG="--enable-opengl ${TESTDIS} ${OPTIMI} ${WARNS} ${HOMEINST}"

echo
echo "This script runs configure with the following settings"
echo " ./configure"
evl_echo "$OPENGL"
evl_echo "$TESTDIS"
evl_echo "$OPTIMI"
evl_echo "$WARNS"
evl_echo "$HOMEINST"
echo
echo "<CTRL + C> to abort - <Return> to continue"

read TMP

./configure ${CONFIG}

echo
echo "Press <Return> to compile"
echo
read TMP

make

echo
echo "Press <Return> to install"
echo
read TMP

make install

exit 0
