/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <string.h>
#include <gtk/gtk.h>

#include "singit_debug.h"

#include "dlg_input_number.h"


enum {
	NEW_NUMBER,
	LAST_SIGNAL
};

static guint enter_number_dialog_signals[LAST_SIGNAL] = { 0 };
static GtkWidgetClass *parent_class = NULL;

static void enter_number_dialog_destroy (GtkObject *object);

void enter_number_dialog_set_number (EnterNumberDialog *dialog, gint nbr)
{
	if (!dialog) { return; }

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_input_number.c [enter_number_dialog_set_number]\n"));
#endif
	dialog->number = nbr;
}

gint enter_number_dialog_get_number (EnterNumberDialog *dialog)
{
	if (!dialog) { return 0; }

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_input_number.c [enter_number_dialog_get_number]\n"));
#endif

	return dialog->number;
}

static void enter_number_ok_button_event(GtkButton *button, gpointer data)
{
	EnterNumberDialog* mld;

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_input_number.c [enter_number_ok_button_event]\n"));
#endif

	g_return_if_fail (IS_ENTER_NUMBER_DIALOG(button));
	mld = ENTER_NUMBER_DIALOG (button);

	mld->number =
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(mld->spinbutton));

	gtk_signal_emit(GTK_OBJECT(mld), enter_number_dialog_signals[NEW_NUMBER], mld->number);
}

static void enter_number_cancel_button_event(GtkButton *button, gpointer data)
{
#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_input_number.c [enter_number_cancel_button_event]\n"));
#endif

	g_return_if_fail (IS_ENTER_NUMBER_DIALOG(data));
	
	enter_number_dialog_hide(ENTER_NUMBER_DIALOG(data));
}

static void enter_number_dialog_class_init (EnterNumberDialogClass *class)
{
	GtkObjectClass *object_class;

	object_class = (GtkObjectClass*) class;

	parent_class = gtk_type_class (gtk_widget_get_type ());

	enter_number_dialog_signals[NEW_NUMBER] =
		gtk_signal_new ("new_number",
		GTK_RUN_FIRST,
		object_class->type,
		GTK_SIGNAL_OFFSET (EnterNumberDialogClass, new_number),
		gtk_marshal_NONE__INT,
		GTK_TYPE_NONE,
		1,
		GTK_TYPE_INT);

	gtk_object_class_add_signals (object_class, enter_number_dialog_signals, LAST_SIGNAL);
  	class->new_number = NULL;

	object_class->destroy = enter_number_dialog_destroy;
}

static gint enter_number_dialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_input_number.c [enter_number_dialog_delete_event]\n"));
#endif

	gtk_widget_hide(widget);
	return (TRUE);
}

static void enter_number_dialog_init (EnterNumberDialog *dialog)
{
	GtkObject *enter_number_spinbutton_adj;
	GtkWidget
		*enter_number_vbox,
			*enter_number_button_hbox,
				*enter_number_ok_button,
				*enter_number_cancel_button;

	dialog->number = 0;

	gtk_window_set_policy(GTK_WINDOW(dialog), TRUE, TRUE, TRUE);
	gtk_container_border_width(GTK_CONTAINER(dialog), 2);
	gtk_widget_realize(GTK_WIDGET(dialog));
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

	enter_number_vbox = gtk_vbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(dialog), enter_number_vbox);
	gtk_widget_show(enter_number_vbox);

	enter_number_spinbutton_adj = gtk_adjustment_new
		(0.0, -999999.0, 999999.0, 1.0, 100.0, 100.0);
	dialog->spinbutton = GTK_SPIN_BUTTON
		(gtk_spin_button_new (GTK_ADJUSTMENT (enter_number_spinbutton_adj), 1.0, 0));
	gtk_box_pack_start(GTK_BOX(enter_number_vbox), GTK_WIDGET(dialog->spinbutton), TRUE, TRUE, 2);
	gtk_widget_show (GTK_WIDGET(dialog->spinbutton));

	enter_number_button_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(enter_number_button_hbox), 5);
	gtk_box_pack_start(GTK_BOX(enter_number_vbox), enter_number_button_hbox, FALSE, FALSE, 0);
	gtk_widget_show(enter_number_button_hbox);

	enter_number_ok_button = gtk_button_new_with_label(_("Ok"));
	GTK_WIDGET_SET_FLAGS(enter_number_ok_button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(enter_number_button_hbox), enter_number_ok_button, TRUE, TRUE, 0);
	gtk_widget_show(enter_number_ok_button);

	enter_number_cancel_button = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(enter_number_cancel_button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(enter_number_button_hbox), enter_number_cancel_button, TRUE, TRUE, 0);
	gtk_widget_grab_default(enter_number_cancel_button);
	gtk_widget_show(enter_number_cancel_button);

	gtk_signal_connect_object(GTK_OBJECT(enter_number_ok_button), "clicked",
		GTK_SIGNAL_FUNC(enter_number_ok_button_event), (gpointer) dialog);
	gtk_signal_connect_object(GTK_OBJECT(enter_number_cancel_button), "clicked",
		GTK_SIGNAL_FUNC(enter_number_cancel_button_event), (gpointer) dialog);
	gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
		GTK_SIGNAL_FUNC(enter_number_dialog_delete_event), NULL);

}

GtkType enter_number_dialog_get_type (void)
{
	static GtkType enter_number_dialog_type = 0;

	if (!enter_number_dialog_type) {

		static const GtkTypeInfo enter_number_dialog_info =
		{
			(gchar*) "EnterNumberDialog",
			sizeof (EnterNumberDialog),
			sizeof (EnterNumberDialogClass),
			(GtkClassInitFunc) enter_number_dialog_class_init,
			(GtkObjectInitFunc) enter_number_dialog_init,
			NULL,
			NULL,
			(GtkClassInitFunc) NULL,
		};

		enter_number_dialog_type = gtk_type_unique (gtk_window_get_type(), &enter_number_dialog_info);
	}

	return enter_number_dialog_type;
}

GtkWidget *enter_number_dialog_new  (gchar  *caption,
				    gint    width,
				    gint    height)
{
	GtkWidget *dialog;

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_input_number.c [enter_number_dialog_new]\n"));
#endif

	dialog = GTK_WIDGET(gtk_type_new(TYPE_ENTER_NUMBER_DIALOG));

	if (caption) {
		gtk_window_set_title(GTK_WINDOW(dialog), caption);
	}

	return dialog;
}

static void enter_number_dialog_destroy (GtkObject *object)
{
	EnterNumberDialog *mld;

#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_input_number.c [enter_number_dialog_destroy]\n"));
#endif

	g_return_if_fail (mld = ENTER_NUMBER_DIALOG (object));

	if (GTK_OBJECT_CLASS(parent_class)->destroy)
		(* GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}

void enter_number_dialog_show(EnterNumberDialog* dialog, GtkWindow *parent, 
	gboolean at_cursor, gboolean modal)
{
#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_input_number.c [enter_number_dialog_show]\n"));
#endif

	gtk_window_set_transient_for (GTK_WINDOW(dialog), GTK_WINDOW(parent));
	gtk_window_set_modal(GTK_WINDOW(dialog), modal);

	gtk_widget_show (GTK_WIDGET(dialog));

	if (!at_cursor)
		gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	else
		gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);

	gtk_main();
}

void enter_number_dialog_hide (EnterNumberDialog* dialog)
{
#ifdef CODEDEBUG
	DEBUG(DLV_ALL, ("dlg_input_number.c [enter_number_dialog_hide]\n"));
#endif

	gtk_widget_hide (GTK_WIDGET(dialog));
	gtk_main_quit();
}
