/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include <singit_macros.h>
#include <singit_config.h>
#include <singit_config_xmms.h>

#include "displayer_clist_config.h"

SingitConfigGen *displayer_clist_config = NULL;

static gpointer displayer_clist_config_init_event(SingitConfigGen *scg, gpointer user_data)
{
	CListConfigData *clist_config_data = g_malloc(sizeof(CListConfigData));

	clist_config_data->forceGlobals = TRUE;
	clist_config_data->debugEnable = FALSE;

	clist_config_data->lyricFontName = NULL;
	clist_config_data->backgroundColor = NULL;
	clist_config_data->normalTextColor = NULL;
	clist_config_data->normalBarColor = NULL;
	clist_config_data->progressTextColor = NULL;
	clist_config_data->progressBarColor = NULL;

	return clist_config_data;
}

static void displayer_clist_config_free_event(SingitConfigGen *scg, CListConfigData *cfg_data, gpointer user_data)
{

	if (cfg_data->lyricFontName) { g_free(cfg_data->lyricFontName); }
	if (cfg_data->backgroundColor) { g_free(cfg_data->backgroundColor); }
	if (cfg_data->normalTextColor) { g_free(cfg_data->normalTextColor); }
	if (cfg_data->normalBarColor) { g_free(cfg_data->normalBarColor); }
	if (cfg_data->progressTextColor) { g_free(cfg_data->progressTextColor); }
	if (cfg_data->progressBarColor) { g_free(cfg_data->progressBarColor); }

	g_free(cfg_data);
}

#define GLOBAL_VAR   forceGlobals
#define GLOBAL_DATA  scd
#define CFG_DATA     cfg_data
#define CFG_FILE     cfg_file
#define SECTION     "DisplayerCList"

static void displayer_clist_config_load_event(SingitConfigGen *scg, ConfigFile* cfg_file, CListConfigData *cfg_data, gpointer user_data)
{
	SingitConfigData *scd = GET_SCD;

	READ_CFG_DEF(boolean,forceGlobals,TRUE);

	READ_CFG_DEF_GBL(boolean, hideIfNotFound,);
	READ_CFG_DEF_GBL(boolean, showEmpty,);
	READ_CFG_DEF_GBL(boolean, autoResize,);
#ifdef CODEDEBUG
	READ_CFG_DEF_GBL(boolean,debugEnable,);
#endif

	READ_CFG_DEF_GBL(string,lyricFontName,g_strdup);

	READ_CFG_DEF_GBL(color,backgroundColor,g_strdup);
	READ_CFG_DEF_GBL(color,normalTextColor,g_strdup);
	READ_CFG_DEF_GBL(color,normalBarColor,g_strdup);
	READ_CFG_DEF_GBL(color,progressTextColor,g_strdup);
	READ_CFG_DEF_GBL(color,progressBarColor,g_strdup);

	// * global independant config *
	READ_CFG_DEF(boolean,showOnText,TRUE);

	READ_CFG_DEF(int,winPosX,-1);
	READ_CFG_DEF(int,winPosY,-1);

	// * global config copies *
	cfg_data->gblToggleYZ = scd->toggleYZ;
}

static void displayer_clist_config_save_event(SingitConfigGen *scg, ConfigFile* cfg_file, CListConfigData *cfg_data, gpointer user_data)
{
	// * boolean values *
	WRITE_CFG(boolean, forceGlobals);
	WRITE_CFG(boolean, hideIfNotFound);
	WRITE_CFG(boolean, showEmpty);
	WRITE_CFG(boolean, autoResize);
#ifdef CODEDEBUG
	WRITE_CFG(boolean, debugEnable);
#endif

	// * string values *
	WRITE_CFG(del_string, lyricFontName);
	WRITE_CFG(del_string, backgroundColor);
	WRITE_CFG(del_string, normalTextColor);
	WRITE_CFG(del_string, normalBarColor);
	WRITE_CFG(del_string, progressTextColor);
	WRITE_CFG(del_string, progressBarColor);

	// * global independant config *
	WRITE_CFG(boolean, showOnText);

	WRITE_CFG(int, winPosX);
	WRITE_CFG(int, winPosY);
}

#undef SECTION
#undef CFG_FILE
#undef CFG_DATA
#undef GLOBAL_DATA
#undef GLOBAL_VAR

static void displayer_clist_config_destroy_event(SingitConfigGen *scg, gpointer user_data)
{
	displayer_clist_config = NULL;
}

SingitConfigGen* displayer_clist_config_new(void)
{
	GtkObject *dcc;

	if (displayer_clist_config != NULL) { return displayer_clist_config; }

	dcc = singit_config_gen_new(CONFIG_FILENAME, NULL);

	gtk_signal_connect(GTK_OBJECT(dcc), "init",
		GTK_SIGNAL_FUNC(displayer_clist_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "free",
		GTK_SIGNAL_FUNC(displayer_clist_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "load",
		GTK_SIGNAL_FUNC(displayer_clist_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "save",
		GTK_SIGNAL_FUNC(displayer_clist_config_save_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "destroy",
		GTK_SIGNAL_FUNC(displayer_clist_config_destroy_event), NULL);

	return SINGIT_CONFIG_GEN(dcc);
}
