/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "displayer_karaoke_window_status.h"

KaraokeWindowStatus karaoke_window_status;

void displayer_karaoke_window_status_init(void)
{
	karaoke_window_status.karaoke_widget = NULL;
	karaoke_window_status.timestamp_context_id = 0;
	karaoke_window_status.song_context_id = 0;
	karaoke_window_status.messageCounter = 0;
	karaoke_window_status.canChangeVisibility = TRUE;
	karaoke_window_status.fileName = NULL;
	karaoke_window_status.song = NULL;
	karaoke_window_status.jump_to_song = 0;
}

void displayer_karaoke_window_status_finish(void)
{
	karaoke_window_status.messageCounter = 0;
	karaoke_window_status.timestamp_context_id = 0;

	if (karaoke_window_status.fileName) {
		g_free(karaoke_window_status.fileName);
		karaoke_window_status.fileName = NULL;
	}

	singit_song_detach(&(karaoke_window_status.song));
}
