/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "displayer_opengl_status.h"

OpenGLStatus displayer_opengl_status;

void displayer_opengl_status_init(void)
{
	displayer_opengl_status.gl_area_widget = NULL;

	displayer_opengl_status.hide_mouse_id = 0;
	displayer_opengl_status.jump_to_song = 0;
	displayer_opengl_status.time = 0;

	displayer_opengl_status.toggle_yz = 0;

	displayer_opengl_status.song = NULL;

	displayer_opengl_status.stereo_bass[0][0] = 0;
	displayer_opengl_status.stereo_bass[0][1] = 0;
	displayer_opengl_status.stereo_bass[1][0] = 0;
	displayer_opengl_status.stereo_bass[1][1] = 0;

	displayer_opengl_status.print_debug = FALSE;
	displayer_opengl_status.rotate = TRUE;

	displayer_opengl_status.display_list = 0;

	displayer_opengl_status.beat = FALSE;

	displayer_opengl_status.level[0] = 0;
	displayer_opengl_status.level[1] = 0;
	displayer_opengl_status.level[2] = 0;
}

void displayer_opengl_status_finish(void)
{
	displayer_opengl_status.gl_area_widget = NULL;

	singit_song_detach(&displayer_opengl_status.song);
}
