/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include <xmms/configfile.h>

#include "singit_macros.h"
#include "singit_config.h"

#include "singit_config_gen.h"
#include "displayer_sdl_config.h"
#include "displayer_sdl_config_dlg.h"

#include "singit_wgt_colorbutton.h"

static GtkWidget *displayer_sdl_config_win = NULL;
static GtkWidget
	*displayer_sdl_config_vbox,
		*displayer_sdl_config_force_globals_frame,
			*displayer_sdl_config_force_globals_check_button,
		*displayer_sdl_config_notebook,
		*displayer_sdl_config_displayer_vbox, *displayer_sdl_config_displayer_label,
			*displayer_sdl_config_font_frame, *displayer_sdl_config_font_vbox,
				*displayer_sdl_config_font_hbox,
				*displayer_sdl_config_font_entry,
				*displayer_sdl_config_font_browse_button,
				*displayer_sdl_config_fontsel,
				*displayer_sdl_config_font_size_hbox,
				*displayer_sdl_config_font_size_label,
				*displayer_sdl_config_font_size_spinbutton,
				*displayer_sdl_config_optimize_font_size_check_button,
		*displayer_sdl_config_displayer_toggle_vbox, *displayer_sdl_config_displayer_toggle_label,
			*displayer_sdl_config_hide_if_not_found_check_button,
			*displayer_sdl_config_show_empty_check_button,
			*displayer_sdl_config_auto_resize_check_button,
#ifdef CODEDEBUG
			*displayer_sdl_config_enable_debug_check_button,
#endif
			*displayer_sdl_config_1_hsep,
			*displayer_sdl_config_hide_if_not_found_fullscreen_check_button,
		*bottom_button_hbox,
			*bottom_button_ok,
			*bottom_button_cancel,
			*bottom_button_apply;

// static GtkWidget *font_select_dialog = NULL;
/*
static GtkTooltips
		*plugin_sdl_tooltips = NULL;
*/

static GtkObject
	*displayer_sdl_config_font_size_spinbutton_adj;

typedef struct {

	guchar *color_array;

	gboolean updating_displayer_list;

} ConfigStatus;

ConfigStatus displayer_sdl_config_status;
extern SingitConfigGen *displayer_sdl_config;

static void displayer_sdl_config_font_browse_ok(GtkWidget * w, gpointer data)
{
        gtk_entry_set_text(GTK_ENTRY(displayer_sdl_config_font_entry), 
		gtk_file_selection_get_filename(GTK_FILE_SELECTION(displayer_sdl_config_fontsel)));
        gtk_widget_destroy(displayer_sdl_config_fontsel);
	displayer_sdl_config_fontsel = NULL;
}

static void displayer_sdl_config_font_browse_cb(GtkWidget * w, gpointer data)
{
	if (displayer_sdl_config_fontsel != NULL)
		{ return; }
	
	displayer_sdl_config_fontsel = gtk_file_selection_new(_("Select preferred TTF font"));
	gtk_window_set_modal(GTK_WINDOW(displayer_sdl_config_fontsel), TRUE);

	gtk_signal_connect(GTK_OBJECT(displayer_sdl_config_fontsel), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &displayer_sdl_config_fontsel);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(displayer_sdl_config_fontsel)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(displayer_sdl_config_font_browse_ok), (gpointer) displayer_sdl_config_fontsel);

	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(displayer_sdl_config_fontsel)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), (gpointer) displayer_sdl_config_fontsel);

	gtk_file_selection_set_filename(GTK_FILE_SELECTION(displayer_sdl_config_fontsel),
			GET_DSCD(displayer_sdl_config)->lyricFontName);
	gtk_file_selection_complete(GTK_FILE_SELECTION(displayer_sdl_config_fontsel), "*.ttf");

	gtk_window_set_transient_for(GTK_WINDOW(displayer_sdl_config_fontsel), GTK_WINDOW(displayer_sdl_config_win));
	gtk_window_set_modal(GTK_WINDOW(displayer_sdl_config_fontsel), TRUE);
	gtk_window_set_position(GTK_WINDOW(displayer_sdl_config_fontsel), GTK_WIN_POS_MOUSE);
	gtk_widget_show(displayer_sdl_config_fontsel);
}

static void displayer_sdl_config_force_globals_toggle_event(GtkToggleButton *toggleButton,  gpointer data)
{
	gboolean state = !gtk_toggle_button_get_active(toggleButton);

	gtk_widget_set_sensitive(displayer_sdl_config_font_entry, state);
	gtk_widget_set_sensitive(displayer_sdl_config_font_browse_button, state);
	gtk_widget_set_sensitive(displayer_sdl_config_hide_if_not_found_check_button, state);
	gtk_widget_set_sensitive(displayer_sdl_config_show_empty_check_button, state);
	gtk_widget_set_sensitive(displayer_sdl_config_auto_resize_check_button, state);
#	ifdef CODEDEBUG
	gtk_widget_set_sensitive(displayer_sdl_config_enable_debug_check_button, state);
#	endif
}

static void displayer_sdl_config_cleanup()
{
	SDLConfigData *scd = GET_DSCD(displayer_sdl_config);

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [displayer_sdl_config_cleanup]\n"));
#	endif

	if (displayer_sdl_config_win && displayer_sdl_config_win->window && scd) {
		gdk_window_get_position(displayer_sdl_config_win->window,
			&(scd->winPosX), &(scd->winPosY));
//		displayer_sdl_config_save_positions();
	}

	g_free(displayer_sdl_config_status.color_array);

	singit_config_gen_detach(SINGIT_CONFIG_GEN(displayer_sdl_config));
}

static void displayer_sdl_config_apply_clicked(GtkButton *button, gpointer user_data)
{
	gchar tmp[13];
	SDLConfigData *scd = GET_DSCD(displayer_sdl_config);

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [displayer_sdl_config_apply_clicked] : "));
#	endif

	if (!(displayer_sdl_config_win &&
		displayer_sdl_config_win->window &&
		singit_config_gen_attach(displayer_sdl_config)))
	{
#		ifdef CODEDEBUG
		DEBUG(("failed\n"));
#		endif
		return;
	}

	tmp[12] = '\0';

	g_free(scd->lyricFontName);

	/* set new values */

	scd->forceGlobals = GTK_TOGGLE_BUTTON(displayer_sdl_config_force_globals_check_button)->active;

	scd->lyricFontName = gtk_editable_get_chars(GTK_EDITABLE(displayer_sdl_config_font_entry), 0, -1);
	scd->showEmpty = GTK_TOGGLE_BUTTON(displayer_sdl_config_show_empty_check_button)->active;
	scd->autoResize = GTK_TOGGLE_BUTTON(displayer_sdl_config_auto_resize_check_button)->active;
	scd->hideIfNotFound = GTK_TOGGLE_BUTTON(displayer_sdl_config_hide_if_not_found_check_button)->active;
	scd->hideIfNotFoundFullscreen = GTK_TOGGLE_BUTTON(displayer_sdl_config_hide_if_not_found_fullscreen_check_button)->active;
	scd->optimizeFontSize = GTK_TOGGLE_BUTTON(displayer_sdl_config_optimize_font_size_check_button)->active;

#	ifdef CODEDEBUG
	scd->debugEnable = GTK_TOGGLE_BUTTON(displayer_sdl_config_enable_debug_check_button)->active;
#	endif

	scd->lyricFontName = gtk_editable_get_chars(GTK_EDITABLE(displayer_sdl_config_font_entry), 0, -1);

	scd->lyricFontSize =
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(displayer_sdl_config_font_size_spinbutton));

#	ifdef CODEDEBUG
	DEBUG(("Ok\n"));
#	endif

	singit_config_gen_emit_update(SINGIT_CONFIG_GEN(displayer_sdl_config));
	singit_config_gen_save(SINGIT_CONFIG_GEN(displayer_sdl_config));
	singit_config_gen_detach(SINGIT_CONFIG_GEN(displayer_sdl_config));
}

static void displayer_sdl_config_ok_clicked(GtkButton *button, gpointer user_data)
{
	/* apply and save config */
	displayer_sdl_config_apply_clicked(NULL, NULL);
	displayer_sdl_config_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(displayer_sdl_config_win);
}

static void displayer_sdl_config_cancel_clicked(GtkButton *button, gpointer user_data)
{
	displayer_sdl_config_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(displayer_sdl_config_win);
}

static gint dlg_displayer_sdl_config_delete_event( GtkWidget *widget, GdkEvent  *event, gpointer data )
{
	displayer_sdl_config_cleanup();

	/* close and destroy window */
	gtk_widget_destroy(displayer_sdl_config_win);

	return (FALSE);
}

void displayer_sdl_config_show(void)
{
	SDLConfigData *scd;
	gchar *temp;

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [displayer_sdl_config_show]\n"));
#	endif

	if (displayer_sdl_config_win) {
		gdk_window_raise(displayer_sdl_config_win->window);
		return;
	}

	if (!singit_config_gen_attach(displayer_sdl_config)) {
		displayer_sdl_config = displayer_sdl_config_new();
		singit_config_gen_load(SINGIT_CONFIG_GEN(displayer_sdl_config));
	}
	scd = GET_DSCD(displayer_sdl_config);
	if (!scd) {
		singit_config_gen_detach(SINGIT_CONFIG_GEN(displayer_sdl_config));
		return;
	}

	displayer_sdl_config_status.color_array = g_malloc(sizeof(guchar) * 9);
	displayer_sdl_config_status.updating_displayer_list = FALSE;

//	plugin_sdl_tooltips = gtk_tooltips_new ();

	displayer_sdl_config_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(displayer_sdl_config_win), "delete_event",
		GTK_SIGNAL_FUNC(dlg_displayer_sdl_config_delete_event), NULL);

	/* update displayer_sdl_config_win when window is destroyed */
	gtk_signal_connect(GTK_OBJECT(displayer_sdl_config_win), "destroy",
		       GTK_SIGNAL_FUNC(gtk_widget_destroyed), &displayer_sdl_config_win);

	gtk_window_set_title(GTK_WINDOW(displayer_sdl_config_win), _("Navigation displayer config"));
	gtk_window_set_policy(GTK_WINDOW(displayer_sdl_config_win), FALSE, FALSE, FALSE);
	gtk_container_border_width(GTK_CONTAINER(displayer_sdl_config_win), 5);
//	gtk_object_set_data (GTK_OBJECT(displayer_sdl_config_win), "tooltips", plugin_sdl_tooltips);

	displayer_sdl_config_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(displayer_sdl_config_win), displayer_sdl_config_vbox);
	gtk_widget_show(displayer_sdl_config_vbox);

	displayer_sdl_config_force_globals_frame = gtk_frame_new("Force globals");
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_vbox), displayer_sdl_config_force_globals_frame, FALSE, FALSE, 0);
	gtk_widget_show(displayer_sdl_config_force_globals_frame);

	displayer_sdl_config_force_globals_check_button = gtk_check_button_new_with_label(_("Force global settings"));
	gtk_container_add(GTK_CONTAINER(displayer_sdl_config_force_globals_frame), displayer_sdl_config_force_globals_check_button);
//	gtk_widget_set_sensitive(displayer_sdl_config_force_globals_check_button, FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_sdl_config_force_globals_check_button),
		scd->forceGlobals);
	gtk_signal_connect(GTK_OBJECT(displayer_sdl_config_force_globals_check_button),
		"toggled", GTK_SIGNAL_FUNC(displayer_sdl_config_force_globals_toggle_event), NULL);
	gtk_widget_show(displayer_sdl_config_force_globals_check_button);


	displayer_sdl_config_notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(displayer_sdl_config_notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_vbox), displayer_sdl_config_notebook, FALSE, FALSE, 0);
	gtk_widget_show(displayer_sdl_config_notebook);

	/* lyrics displayer config page */
	displayer_sdl_config_displayer_vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(displayer_sdl_config_displayer_vbox), 2);
	gtk_widget_show (displayer_sdl_config_displayer_vbox);
	displayer_sdl_config_displayer_label = gtk_label_new(_("Font"));
	gtk_widget_show(displayer_sdl_config_displayer_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(displayer_sdl_config_notebook), displayer_sdl_config_displayer_vbox, displayer_sdl_config_displayer_label);

	/* font selection box (from XMMS) */
        displayer_sdl_config_font_frame = gtk_frame_new(_("Lyrics font"));
        gtk_box_pack_start(GTK_BOX(displayer_sdl_config_displayer_vbox), displayer_sdl_config_font_frame, FALSE, FALSE, 2);
	gtk_widget_show(displayer_sdl_config_font_frame);

	displayer_sdl_config_font_vbox = gtk_vbox_new(FALSE, 5);
        gtk_container_border_width(GTK_CONTAINER(displayer_sdl_config_font_vbox), 5);
        gtk_container_add(GTK_CONTAINER(displayer_sdl_config_font_frame), displayer_sdl_config_font_vbox);
	gtk_widget_show(displayer_sdl_config_font_vbox);

	displayer_sdl_config_font_hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_border_width(GTK_CONTAINER(displayer_sdl_config_font_hbox), 5);
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_font_vbox), displayer_sdl_config_font_hbox, TRUE, TRUE, 0);
	gtk_widget_show(displayer_sdl_config_font_hbox);

        displayer_sdl_config_font_entry = gtk_entry_new();
        gtk_box_pack_start(GTK_BOX(displayer_sdl_config_font_hbox), displayer_sdl_config_font_entry, TRUE, TRUE, 0);
	gtk_entry_set_text(GTK_ENTRY(displayer_sdl_config_font_entry), scd->lyricFontName);
	gtk_widget_show(displayer_sdl_config_font_entry);

        displayer_sdl_config_font_browse_button = gtk_button_new_with_label(_("Browse"));
        gtk_signal_connect(GTK_OBJECT(displayer_sdl_config_font_browse_button), "clicked",
		GTK_SIGNAL_FUNC(displayer_sdl_config_font_browse_cb), NULL);
        gtk_widget_set_usize(displayer_sdl_config_font_browse_button, 85, 17);
        gtk_box_pack_start(GTK_BOX(displayer_sdl_config_font_hbox),
		displayer_sdl_config_font_browse_button, FALSE, TRUE, 0);
	gtk_widget_show(displayer_sdl_config_font_browse_button);

	displayer_sdl_config_font_size_hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_border_width(GTK_CONTAINER(displayer_sdl_config_font_size_hbox), 5);
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_font_vbox), displayer_sdl_config_font_size_hbox, TRUE, TRUE, 0);
	gtk_widget_show(displayer_sdl_config_font_size_hbox);

	temp = g_strconcat(_("Font size"), ":", NULL);
	displayer_sdl_config_font_size_label = gtk_label_new(temp);
	g_free(temp);
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_font_size_hbox), displayer_sdl_config_font_size_label, TRUE, TRUE, 0);
	gtk_widget_show(displayer_sdl_config_font_size_label);

	displayer_sdl_config_font_size_spinbutton_adj = gtk_adjustment_new
		(scd->lyricFontSize, 8, 50, 1, 1, 1);
	displayer_sdl_config_font_size_spinbutton = 
		gtk_spin_button_new(GTK_ADJUSTMENT(displayer_sdl_config_font_size_spinbutton_adj), 1, 0);
	gtk_entry_set_max_length(GTK_ENTRY(displayer_sdl_config_font_size_spinbutton), 2);
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_font_size_hbox), 
		displayer_sdl_config_font_size_spinbutton, FALSE, FALSE, 2);
	gtk_widget_show (displayer_sdl_config_font_size_spinbutton);
	
	displayer_sdl_config_optimize_font_size_check_button = 
		gtk_check_button_new_with_label(_("Optimize font size"));
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_font_vbox), 
		displayer_sdl_config_optimize_font_size_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_sdl_config_optimize_font_size_check_button),
		scd->optimizeFontSize);
	gtk_widget_show(displayer_sdl_config_optimize_font_size_check_button);

/*
	lyrics displayer checkboxes config page
*/
	displayer_sdl_config_displayer_toggle_vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(displayer_sdl_config_displayer_toggle_vbox), 2);
	gtk_widget_show (displayer_sdl_config_displayer_toggle_vbox);
	displayer_sdl_config_displayer_toggle_label = gtk_label_new(_("Options"));
	gtk_widget_show(displayer_sdl_config_displayer_toggle_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(displayer_sdl_config_notebook),
		displayer_sdl_config_displayer_toggle_vbox, displayer_sdl_config_displayer_toggle_label);

	displayer_sdl_config_show_empty_check_button = gtk_check_button_new_with_label(_("Show empty lines"));
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_displayer_toggle_vbox), displayer_sdl_config_show_empty_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_sdl_config_show_empty_check_button),
		scd->showEmpty);
	gtk_widget_show(displayer_sdl_config_show_empty_check_button);

	displayer_sdl_config_auto_resize_check_button = gtk_check_button_new_with_label(_("Automagically resize lyric displayer"));
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_displayer_toggle_vbox), displayer_sdl_config_auto_resize_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_sdl_config_auto_resize_check_button),
		scd->autoResize);
	gtk_widget_show(displayer_sdl_config_auto_resize_check_button);

	displayer_sdl_config_hide_if_not_found_check_button = gtk_check_button_new_with_label(_("Hide displayer if no lyrics were found"));
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_displayer_toggle_vbox), displayer_sdl_config_hide_if_not_found_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_sdl_config_hide_if_not_found_check_button),
		scd->hideIfNotFound);
	gtk_widget_show(displayer_sdl_config_hide_if_not_found_check_button);

#	ifdef CODEDEBUG
	displayer_sdl_config_enable_debug_check_button = gtk_check_button_new_with_label(_("Enable console debug output"));
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_displayer_toggle_vbox), displayer_sdl_config_enable_debug_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_sdl_config_enable_debug_check_button),
		scd->debugEnable);
	gtk_widget_show(displayer_sdl_config_enable_debug_check_button);
#	endif

	displayer_sdl_config_1_hsep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_displayer_toggle_vbox), displayer_sdl_config_1_hsep, FALSE, FALSE, 3);
	gtk_widget_show(displayer_sdl_config_1_hsep);

	displayer_sdl_config_hide_if_not_found_fullscreen_check_button = gtk_check_button_new_with_label(_("Hide fullscreen displayer if no lyrics were found"));
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_displayer_toggle_vbox), displayer_sdl_config_hide_if_not_found_fullscreen_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(displayer_sdl_config_hide_if_not_found_fullscreen_check_button),
		scd->hideIfNotFoundFullscreen);
	gtk_widget_show(displayer_sdl_config_hide_if_not_found_fullscreen_check_button);

/*
	Bottom button row ([Ok] [Cancel] [Apply])
*/
	bottom_button_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bottom_button_hbox), 5);
	gtk_box_pack_start(GTK_BOX(displayer_sdl_config_vbox), bottom_button_hbox, FALSE, FALSE, 0);
	gtk_widget_show(bottom_button_hbox);

	bottom_button_ok = gtk_button_new_with_label(_("Ok"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_ok), "clicked", GTK_SIGNAL_FUNC(displayer_sdl_config_ok_clicked), (GtkObject*) TRUE);
	GTK_WIDGET_SET_FLAGS(bottom_button_ok, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_ok, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_ok);

	bottom_button_cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_cancel), "clicked", GTK_SIGNAL_FUNC(displayer_sdl_config_cancel_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_cancel, TRUE, TRUE, 0);
	gtk_widget_grab_default(bottom_button_cancel);
	gtk_widget_show(bottom_button_cancel);

	bottom_button_apply = gtk_button_new_with_label(_("Apply"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_apply), "clicked", GTK_SIGNAL_FUNC(displayer_sdl_config_apply_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_apply, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_apply, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_apply);

	gtk_widget_show(displayer_sdl_config_win);

/*
	We have to wait until every widget is created
	To set their state dependend on the globas toggle button
*/
	displayer_sdl_config_force_globals_toggle_event
		(GTK_TOGGLE_BUTTON(displayer_sdl_config_force_globals_check_button), NULL);

	if ((scd->winPosX < 0) || (scd->winPosY < 0)) {
		gtk_window_set_position(GTK_WINDOW(displayer_sdl_config_win), GTK_WIN_POS_MOUSE);
	}
	else {
		gtk_widget_set_uposition(displayer_sdl_config_win, scd->winPosX, scd->winPosY);
	}
}

void displayer_sdl_config_hide(void)
{
#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [displayer_sdl_config_hide]\n"));
#	endif

	if (displayer_sdl_config_win) {
		displayer_sdl_config_cancel_clicked(NULL, NULL);
	}
}
