/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_SDL_LYRICS_H__
#define __DISPLAYER_SDL_LYRICS_H__

#include <glib.h>

#include <SDL/SDL_video.h>

#include "singit_song.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

void sdl_lyrics_init(void);

void sdl_lyrics_finish(void);

gboolean sdl_lyrics_set_text_colors
	(SDL_Color text_color, SDL_Color blurred_color, SDL_Color background_color);

void sdl_lyrics_remap_colors(void);

gboolean sdl_lyrics_set_font(const gchar *font_file, gint ptsize, gboolean lock);

void sdl_lyrics_set_song(SingitSong *cur_song);

void sdl_lyrics_render_text(guint time);

void sdl_lyrics_draw_blurred(SDL_Surface *surface);

void sdl_lyrics_draw_solid(SDL_Surface *surface);

void sdl_lyrics_resize(void);

void sdl_lyrics_draw_mode(gboolean switch_mode);

void sdl_lyrics_set_optimize_font(gboolean optimize);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __DISPLAYER_SDL_LYRICS_H__
