/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include <stdlib.h>
#include <stdio.h>

#include <xmms/xmmsctrl.h>
#include <xmms/util.h>

#include <SDL/SDL_types.h>
#include <SDL/SDL_syswm.h>
#include <SDL/SDL_ttf.h>

#include "singit_displayer_plugin.h"
#include "displayer_sdl.h"
#include "displayer_sdl_config.h"
#include "sdl_skd_handlers.h"

extern SingitConfigGen *displayer_sdl_config;

static gint sdl_skd_render(SingitKaraokeData *skd, gpointer font, gchar* text)
{
	gint w, h;
	TTF_SizeText((TTF_Font*) font, text, &w, &h);
	return w;
}
/*
void singit_karaoke_widget_build_lyric_pixmaps (SingitKaraokeWidget *skw)
{
	GList *item = 0;
	GdkGC *curgc = NULL;
	SingitSong *my_song = NULL;
	GdkFont *my_font = SKW_FONT;
	gint i, height;
	gint string_left_offset = left_right_line_border;

	if (!(GTK_WIDGET(skw)->window && skw->double_buffer_pixmap &&
		GTK_WIDGET_REALIZED(GTK_WIDGET(skw)))) { return; }

	curgc = gdk_gc_new(GTK_WIDGET(skw)->window);
	gdk_gc_set_foreground (curgc, &skw->private_color[skwc_background]);
	gdk_gc_set_fill (curgc, GDK_SOLID);

	skw_draw_line_rects(skw, skw->double_buffer_pixmap, curgc);

	my_song = singit_song_attach(SINGIT_KARAOKE_DATA(skw->skd)->song);
	if (my_song) {

		if (skw->mode == skwm_line_scroll) {
			item = my_song->active_token;

			i = SINGIT_KARAOKE_DATA(skw->skd)->top_lines;
			height = SINGIT_KARAOKE_DATA(skw->skd)->top_lines_height;
			if (SINGIT_KARAOKE_DATA(skw->skd)->use_ball) {
				height += (SINGIT_KARAOKE_DATA(skw->skd)->ball_line_height +
					SINGIT_KARAOKE_DATA(skw->skd)->line_seperator_high);
			}

			if (item) {
				if ((!SINGIT_KARAOKE_DATA(skw->skd)->show_empty_lines) && (singit_song_is_empty_item(my_song, item)))
					item = singit_song_find_next_lyric_line(my_song, item, FALSE, NULL);

				if (item) {
//					skw->line_info = singit_karaoke_widget_fill_str_line_info
//						(skw->line_info, my_font, tText(my_song, item));

					while ((i > 0) && item) {
						item = singit_song_find_prev_lyric_line(my_song, item,
							SINGIT_KARAOKE_DATA(skw->skd)->show_empty_lines, NULL);
						i--;
					}
					if (!item) {
						item = my_song->first_token;
						i++;
					}
					if (i < SINGIT_KARAOKE_DATA(skw->skd)->top_lines) {
						height = i * (SINGIT_KARAOKE_DATA(skw->skd)->text_line_height +
							SINGIT_KARAOKE_DATA(skw->skd)->line_seperator_high);
					}
					else if (i > SINGIT_KARAOKE_DATA(skw->skd)->top_lines) {
						height = i * (SINGIT_KARAOKE_DATA(skw->skd)->text_line_height +
							SINGIT_KARAOKE_DATA(skw->skd)->line_seperator_high) +
							2 * SINGIT_KARAOKE_DATA(skw->skd)->active_line_seperator_high;
						if (SINGIT_KARAOKE_DATA(skw->skd)->use_ball) {
							height += (SINGIT_KARAOKE_DATA(skw->skd)->ball_line_height +
								SINGIT_KARAOKE_DATA(skw->skd)->line_seperator_high);
						}
					}
				}
			}
			else {
				item = my_song->first_token;
				if (SINGIT_KARAOKE_DATA(skw->skd)->show_empty_lines) {
					i++;
					height = i * (SINGIT_KARAOKE_DATA(skw->skd)->text_line_height +
						SINGIT_KARAOKE_DATA(skw->skd)->line_seperator_high) +
						2 * SINGIT_KARAOKE_DATA(skw->skd)->active_line_seperator_high;
					if (SINGIT_KARAOKE_DATA(skw->skd)->use_ball) {
						height += (SINGIT_KARAOKE_DATA(skw->skd)->ball_line_height +
							SINGIT_KARAOKE_DATA(skw->skd)->line_seperator_high);
					}
				}
			}

			gdk_gc_set_foreground (curgc, &skw->private_color[skwc_text]);
			while (i < SINGIT_KARAOKE_DATA(skw->skd)->lines) {
				if (item) {
					string_left_offset = singit_karaoke_data_calc_line_offset
						(SINGIT_KARAOKE_DATA(skw->skd), FALSE, tText(my_song, item));
					gdk_draw_string (skw->double_buffer_pixmap, my_font,
						curgc, string_left_offset, height + my_font->ascent + 1,
						tText(my_song, item));
					item = singit_song_find_next_lyric_line(my_song, item,
						SINGIT_KARAOKE_DATA(skw->skd)->show_empty_lines, NULL);
				}
				if (i == (SINGIT_KARAOKE_DATA(skw->skd)->top_lines - 1)) {
					height += SINGIT_KARAOKE_DATA(skw->skd)->active_line_seperator_high;
					if (SINGIT_KARAOKE_DATA(skw->skd)->use_ball) {
						height += (SINGIT_KARAOKE_DATA(skw->skd)->ball_line_height +
							SINGIT_KARAOKE_DATA(skw->skd)->line_seperator_high);
					}
				}
				else if (i == SINGIT_KARAOKE_DATA(skw->skd)->top_lines) {
					height += SINGIT_KARAOKE_DATA(skw->skd)->active_line_seperator_high;
				}

				i++;
				height += (SINGIT_KARAOKE_DATA(skw->skd)->text_line_height +
					SINGIT_KARAOKE_DATA(skw->skd)->line_seperator_high);
			}
		}
		my_song = singit_song_detach(my_song);
	}

	gdk_gc_unref(curgc);
}
*/
// void draw_timeline(SingitKaraokeWidget *skw, gint time, GdkRectangle *area);

static gboolean sdl_skd_expose(SingitKaraokeData *skd, GdkRectangle *area, gint event, gint time, gpointer user_data)
{
/*
	gint offset = 0;
	SingitKaraokeWidget *skw;
	GdkRectangle combined_area;

	if (!GTK_WIDGET_DRAWABLE(GTK_WIDGET(user_data))) { return FALSE; }
*/
	if (event == 0) { return TRUE; }
/*
	skw = SINGIT_KARAOKE_WIDGET(user_data);

//	if ((area->width != 0) && (area->height != 0)) {
//		g_print("Area: %i\n", time);
		if (event & SKD_EXPOSE_ALL) {
			sdl_skd_build_lyric_pixmaps(skw);
		}
		if (event & SKD_EXPOSE_PROGRESS) {
			offset =  sdl_skd_update_progess_bar
				(skw, tText(skd->song, skd->current));
			offset -= ((skd->ball_diameter / 2) + 1);
		}
		if ((offset >= 0) && (event & SKD_EXPOSE_BALL)) {
			sdl_skd_update_ball(skw, offset);
		}

		if ((displayer_sdl_status.timeIndicators == FALSE) || (event & SKD_EXPOSE_TIMELINE) != event) {
//			g_print("Expose-Area: %i\n", time);
			gtk_widget_queue_draw_area(GTK_WIDGET(user_data),
				area->x + displayer_sdl_status.sizes[LEFT_RIGHT_WIDGET_BORDER],
				area->y + displayer_sdl_status.sizes[TOP_BOTTOM_WIDGET_BORDER],
				area->width, area->height);
		}
//	}

	if ((displayer_sdl_status.timeIndicators == TRUE) && (event & SKD_EXPOSE_TIMELINE)) {
		if ((event & SKD_EXPOSE_TIMELINE) == event) {
//			g_print("Timeline: %i\n", time);
			combined_area = *area;
			draw_timeline(skw, time, &combined_area);
			gtk_widget_queue_draw_area(GTK_WIDGET(user_data),
				combined_area.x + displayer_sdl_status.sizes[LEFT_RIGHT_WIDGET_BORDER],
				combined_area.y + displayer_sdl_status.sizes[TOP_BOTTOM_WIDGET_BORDER],
				combined_area.width, combined_area.height);
		}
	}
*/
	return TRUE;

}
/*
void draw_timeline(SingitKaraokeWidget *skw, gint time, GdkRectangle *area)
{
	GList *next_item, *current;
	GdkGC *draw_gc = NULL;
	gint balls, light_balls;
	gint pos_x = SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter / 2 + 1;
	gint pos_y = SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->top_lines_height +
		(SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->text_line_height - SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter) / 2;
	GdkRectangle area_update;
	gboolean big_ball;

	if (displayer_sdl_status.double_buffer_pixmap == NULL) { return; }

	current = SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->song->active_token;
	if (current == NULL) { return; }
	next_item = inl_singit_song_get_next_token(SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->song);
	if (next_item == NULL) { return; }
	balls = (tTime(next_item) - tTime(current)) / 1000;
	if (balls < 2) { return; }
	light_balls = balls - (time + 100 - tTime(current)) / 1000;
//	g_print("%i / %i / %i\n", balls, light_balls, time);

	// If we have to pass more then 10 seconds just print 10 balls
	// And blink with the first one
	if (balls > 10) {
		if (light_balls > 10)
			light_balls = (light_balls % 2 != 0) ? 9 : 10;
		balls = 10;
	}

	if (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->use_ball) {
		pos_y += SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_line_height +
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->line_seperator_high;
	}

	draw_gc = gdk_gc_new (GTK_WIDGET(skw)->window);
	gdk_gc_set_fill (draw_gc, GDK_SOLID);
	gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_active]);

	area_update.x = pos_x;
	area_update.y = pos_y;
	area_update.width = SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter * 2 * balls;
	area_update.height = SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter;
	gdk_rectangle_union(area, &area_update, area);

	big_ball = (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter > 5);
	while (balls > 0) {
		if (big_ball) {
			gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_text]);
		}
		else {
			if (balls > light_balls)
				gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_active]);
			else
				gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_text]);
		}

		gdk_draw_arc (displayer_sdl_status.double_buffer_pixmap, draw_gc, TRUE, pos_x, pos_y,
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter,
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter, 0, 360 * 64);

		if (big_ball && (balls > light_balls)) {
			gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_active]);

			gdk_draw_arc (displayer_sdl_status.double_buffer_pixmap, draw_gc, TRUE, 2 + pos_x, pos_y + 2,
				SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter - 4,
				SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter - 4, 0, 360 * 64);
		}

		balls--;
		pos_x += SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter * 2;
	}

	gdk_gc_unref(draw_gc);
}

void create_new_ball_pixmap(SingitKaraokeWidget *skw)
{
	GdkGC *draw_gc = NULL;

	g_return_if_fail(skw != NULL);
	g_return_if_fail(IS_SINGIT_KARAOKE_WIDGET(skw));

	if (!GTK_WIDGET_REALIZED(skw)) { return; }

#	ifdef WIDGET_DEBUG
	g_print("New ball pixmap\n");
#	endif

	if (displayer_sdl_status.ball_pixmap != NULL)
		{ gdk_pixmap_unref(displayer_sdl_status.ball_pixmap); }

	if (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter <= 0) {
		displayer_sdl_status.ball_pixmap = NULL;
		return;
	}

	draw_gc = gdk_gc_new (GTK_WIDGET(skw)->window);
	gdk_gc_set_fill (draw_gc, GDK_SOLID);
	gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_background]);

	displayer_sdl_status.ball_pixmap = gdk_pixmap_new(GTK_WIDGET(skw)->window,
		SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter, SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter, -1);
	gdk_draw_rectangle(displayer_sdl_status.ball_pixmap, draw_gc, TRUE, 0, 0,
		SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter, SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter);

	gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_text]);
	gdk_draw_arc (displayer_sdl_status.ball_pixmap, draw_gc, TRUE, 0, 0,
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter, SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter, 0, 360 * 64);

	if (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter > 5) {
		gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_active]);
#	ifdef WIDGET_DEBUG
		g_print("  Ball-Sizes: %i / %i / %i\n", SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter,
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter / 8,
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter / 4);
#	endif
		gdk_draw_arc (displayer_sdl_status.ball_pixmap, draw_gc, TRUE,
			2 + (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter / 8),
			2 + (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter / 8),
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter - 4
			- (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter / 4),
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter - 4
			- (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_diameter / 4),
			0, 360 * 64);
	}

	gdk_gc_unref(draw_gc);
}

void skw_draw_line_rects(SingitKaraokeWidget *skw, GdkPixmap *pixmap, GdkGC *draw_gc)
{
	gint height, i;

	g_return_if_fail(skw != NULL);
	g_return_if_fail(IS_SINGIT_KARAOKE_WIDGET(skw));

	if ((pixmap == NULL) || (draw_gc == NULL)) { return; }

#	ifdef WIDGET_DEBUG
	g_print("skw_draw_line_rects\n");
#	endif

	height = 0;
	for (i = 0; i < SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->top_lines; i++) {
		gdk_draw_rectangle(pixmap, draw_gc,
			TRUE, 0,height, SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->visual_min_width,
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->text_line_height);
		height += SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->text_line_height +
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->line_seperator_high;
	}
	height += SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->active_line_seperator_high;

	if (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->use_ball) {
		gdk_draw_rectangle(pixmap, draw_gc,
			TRUE, 0, height, SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->visual_min_width,
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_line_height);
		height += SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->ball_line_height + SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->line_seperator_high;
	}

	for (i = 0; i < (SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->lines - SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->top_lines); i++) {
		gdk_draw_rectangle(pixmap, draw_gc,
			TRUE, 0,height, SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->visual_min_width,
			SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->text_line_height);
		height += SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->text_line_height + SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->line_seperator_high;
		if (i == 0) { height += SINGIT_KARAOKE_DATA(displayer_sdl_status.skd)->active_line_seperator_high; }
	}
}
*/
static void sdl_skd_new_ball(SingitKaraokeData *skd, gint ball_diameter, gpointer user_data)
{
	/*
	GdkGC *draw_gc = NULL;
	SingitKaraokeWidget *skw;

	g_return_if_fail(skd != NULL);
	g_return_if_fail(IS_SINGIT_KARAOKE_DATA(skd));
	g_return_if_fail(IS_SINGIT_KARAOKE_WIDGET(user_data));

	if (!GTK_WIDGET_REALIZED(user_data)) { return; }

	skw = SINGIT_KARAOKE_WIDGET(user_data);

#	ifdef WIDGET_DEBUG
	g_print("New ball pixmap\n");
#	endif

	if (displayer_sdl_status.ball_pixmap != NULL)
		{ gdk_pixmap_unref(displayer_sdl_status.ball_pixmap); }

	if (ball_diameter <= 0) {
		displayer_sdl_status.ball_pixmap = NULL;
		return;
	}

	draw_gc = gdk_gc_new (GTK_WIDGET(skw)->window);
	gdk_gc_set_fill (draw_gc, GDK_SOLID);
	gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_background]);

	displayer_sdl_status.ball_pixmap = gdk_pixmap_new(GTK_WIDGET(skw)->window,
		ball_diameter, ball_diameter, -1);
	gdk_draw_rectangle(displayer_sdl_status.ball_pixmap, draw_gc, TRUE, 0, 0,
		ball_diameter, ball_diameter);

	gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_text]);
	gdk_draw_arc (displayer_sdl_status.ball_pixmap, draw_gc, TRUE, 0, 0,
			ball_diameter, ball_diameter, 0, 360 * 64);

	if (ball_diameter > 5) {
		gdk_gc_set_foreground (draw_gc, &displayer_sdl_status.private_color[skwc_active]);

		gdk_draw_arc (displayer_sdl_status.ball_pixmap, draw_gc, TRUE, 2, 2,
			ball_diameter - 4, ball_diameter - 4, 0, 360 * 64);
	}

	gdk_gc_unref(draw_gc);
	*/
}

static void sdl_skd_new_visual(SingitKaraokeData *skd, gint wx, gint wy, gpointer user_data)
{
	/*
	GdkGC *draw_gc;
	SingitKaraokeWidget *skw;

	g_return_if_fail(skd != NULL);
	g_return_if_fail(IS_SINGIT_KARAOKE_DATA(skd));
	g_return_if_fail(IS_SINGIT_KARAOKE_WIDGET(user_data));

	if (!GTK_WIDGET_REALIZED(user_data)) { return; }

	skw = SINGIT_KARAOKE_WIDGET(user_data);

#	ifdef WIDGET_DEBUG
	g_print("New doublebuffer pixmap\n");
#	endif

	if (skw->double_buffer_pixmap)
		{ gdk_pixmap_unref(skw->double_buffer_pixmap); }

	if ((wx <= 0) || (wy <= 0)) {
		skw->double_buffer_pixmap = NULL;
		return;
	}

	skw->double_buffer_pixmap = gdk_pixmap_new(GTK_WIDGET(skw)->window, wx, wy, -1);
	gdk_draw_rectangle(skw->double_buffer_pixmap, GTK_WIDGET(skw)->style->bg_gc[0], TRUE,
		0, 0, wx, wy);

	draw_gc = gdk_gc_new (GTK_WIDGET(skw)->window);
	gdk_gc_set_fill (draw_gc, GDK_SOLID);
	gdk_gc_set_foreground (draw_gc, &skw->private_color[skwc_background]);

	skw_draw_line_rects(skw, skw->double_buffer_pixmap, draw_gc);

	gdk_gc_unref(draw_gc);
*/
}

void sdl_skd_init(void)
{
#	ifdef CODEDEBUG
	DEBUG(("displayer_sdl.c [sdl_skd_init]\n"));
#	endif

	displayer_sdl_status.skd = (gpointer) singit_karaoke_data_new();
	singit_karaoke_data_set_lines(displayer_sdl_status.skd, 2);
	singit_karaoke_data_set_toplines(displayer_sdl_status.skd, 1);
	singit_karaoke_data_set_font(displayer_sdl_status.skd, 
		displayer_sdl_status.font, TTF_FontHeight(displayer_sdl_status.font));
	gtk_signal_connect(GTK_OBJECT(displayer_sdl_status.skd), "render", GTK_SIGNAL_FUNC(sdl_skd_render), NULL);
	gtk_signal_connect(GTK_OBJECT(displayer_sdl_status.skd), "expose", GTK_SIGNAL_FUNC(sdl_skd_expose), NULL);
	gtk_signal_connect(GTK_OBJECT(displayer_sdl_status.skd), "new_ball", GTK_SIGNAL_FUNC(sdl_skd_new_ball), NULL);
	gtk_signal_connect(GTK_OBJECT(displayer_sdl_status.skd), "new_visual", GTK_SIGNAL_FUNC(sdl_skd_new_visual), NULL);
}

void sdl_skd_finish(void)
{
#	ifdef CODEDEBUG
	DEBUG(("displayer_sdl.c [displayer_sdl_finish]\n"));
#	endif

	if (displayer_sdl_status.skd != NULL) {
		gtk_object_unref(GTK_OBJECT(displayer_sdl_status.skd));
		displayer_sdl_status.skd = NULL;
	}
}
