/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __TEST_SDL_NEW_LYRICS_H__
#define __TEST_SDL_NEW_LYRICS_H__

#include <glib.h>

#include <SDL/SDL_video.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

void lyrics_init(void);

void lyrics_finish(void);

gboolean lyrics_set_text_colors(SDL_Color text_color, SDL_Color blurred_color, SDL_Color background_color);

void lyrics_remap_colors(void);

gboolean lyrics_set_font(const gchar *font_file, gint ptsize, gboolean lock);

void lyrics_set_song(SingitSong *cur_song);

void lyrics_render_text(guint time);

void lyrics_draw_blurred(SDL_Surface *surface);

void lyrics_draw_solid(SDL_Surface *surface);

void lyrics_resize(void);

void lyrics_draw_mode(gboolean switch_mode);

void lyrics_set_optimize_font(gboolean optimize);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __TEST_SDL_NEW_LYRICS_H__
