/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __EDITOR_SINGIT_PRIVATE__
#define __EDITOR_SINGIT_PRIVATE__

#include <glib.h>

typedef struct _EditorStatus {

	gboolean   cleanedUp;
	guint      time_context_id;
	guint      mode_context_id;
	guint      modified_context_id;
	guint      filename_context_id;
	guint      valid_consistency_id;

	gchar     *filename;
	gboolean   is_guessed_filename;
	gboolean   text_changed;
	gboolean   valid_consistency;
	gchar     *changed_spaces;
	gboolean   continue_func;

	gint       strip_html_state;

	gchar     *text;
	gint       text_carret;
}
EditorStatus;

#define EDITOR_STATUS_INITIALIZER { FALSE, 0, 0, 0, 0, 0, NULL, FALSE, \
	FALSE, FALSE, NULL, FALSE, 0, NULL, 0 }

void toggle_modified_state (gboolean state);
gboolean check_user_continue (void);

#endif // __EDITOR_SINGIT_PRIVATE__
