/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_CONFIG_XMMS_H__
#define __SINGIT_CONFIG_XMMS_H__

#include <singit_config_gen.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void        xmms_cfg_write_del_string (ConfigFile *cfg, gchar *section, gchar* entry, gchar *value);
gboolean    xmms_cfg_read_color       (ConfigFile *cfg, gchar *section, gchar *key, gchar **color_str);

// Convenience macros to prevent compiler complains
#define singit_config_xmms_read(type, cfg, section, key, value) \
	xmms_cfg_read_##type(cfg, (gchar*) section, (gchar*) key, value)

#define singit_config_xmms_write(type, cfg, section, key, value) \
	xmms_cfg_write_##type(cfg, (gchar*) section, (gchar*) key, value)

#define singit_config_xmms_remove_key(cfg, section, key) \
	singit_config_xmms_remove_key(cfg, (gchar*) section, (gchar*) key)


// *  The following macros help to get config values
// *  You have to define the following values to use them
// *
// * #define GLOBAL_VAR	global
// * #define GLOBAL_DATA scd
// * #define CFG_DATA	cfg_data
// * #define CFG_FILE	cfg_file
// * #define SECTION	"Global"

#define READ_CFG_DEF(type,val,def) \
do { \
	if (!singit_config_xmms_read(type, CFG_FILE, SECTION, #val, &(CFG_DATA->val))) \
		{ CFG_DATA->val = def; } \
} while (0)


#define READ_CFG_DEF_GBL(type,val,dup_func) \
do { \
	if (CFG_DATA->GLOBAL_VAR || !singit_config_xmms_read(type, CFG_FILE, SECTION, #val, &(CFG_DATA->val))) \
		{ CFG_DATA->val = dup_func(GLOBAL_DATA->val); } \
} while (0)

#define WRITE_CFG(type,val) \
do { \
	singit_config_xmms_write(type, CFG_FILE, SECTION, #val, CFG_DATA->val); \
} while (0)


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  // __SINGIT_CONFIG_XMMS_H__
