/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_KARAOKE_WIDGET_H__
#define __SINGIT_KARAOKE_WIDGET_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtkdrawingarea.h>
	
#include "singit_song.h"

#define TYPE_SINGIT_KARAOKE_WIDGET            (singit_karaoke_widget_get_type ())
#define SINGIT_KARAOKE_WIDGET(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_KARAOKE_WIDGET, SingitKaraokeWidget))
#define SINGIT_KARAOKE_WIDGET_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_KARAOKE_WIDGET, SingitKaraokeWidget))
#define IS_SINGIT_KARAOKE_WIDGET(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_KARAOKE_WIDGET))
#define IS_SINGIT_KARAOKE_WIDGET_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_KARAOKE_WIDGET))

typedef struct _SingitKaraokeWidget       SingitKaraokeWidget;
typedef struct _SingitKaraokeWidgetClass  SingitKaraokeWidgetClass;

typedef enum {
	skwm_line_scroll,
	skwm_site_per_freeline
}
SingitWidgetMode;

typedef enum {
	skwc_background = 0,
	skwc_normal_text,
	skwc_normal_bar,
	skwc_progress_text,
	skwc_progress_bar,
	skwc_last,
}
SingitKaraokeWidgetColor;

struct _SingitKaraokeWidget
{
	GtkDrawingArea    area;

	gchar            *private_font_name;

	GdkColor          private_color[skwc_last];
	GdkGC            *private_gc[skwc_last];
	GdkPixmap        *double_buffer_pixmap;
	GdkPixmap        *ball_pixmap;

	// Array of internal size vaules (see enums in .c)
	gint             *sizes;

	gboolean          update_background;

	// Frames per second
	gdouble           fps;

	gint              frames;
	GTimeVal          last_rtc_time, new_rtc_time;
	gint              last_time;

	// Widget behaviour
	SingitWidgetMode  mode;
	gint              freezers;
	gboolean          maxLineWidth;
	gboolean          maxRows;
	gboolean          timeIndicators;

	gpointer          skd;
};

struct _SingitKaraokeWidgetClass
{
	GtkDrawingAreaClass parent_class;
};

GtkType    singit_karaoke_widget_get_type               (void);
GtkWidget *singit_karaoke_widget_new                    (void);

void       singit_karaoke_widget_set_song               (SingitKaraokeWidget *skw, SingitSong *new_song);
void       singit_karaoke_widget_set_time               (SingitKaraokeWidget *skw, guint time);

void       singit_karaoke_widget_freeze                 (SingitKaraokeWidget *skw);
void       singit_karaoke_widget_thaw                   (SingitKaraokeWidget *skw);

// Get / Set lines
void       singit_karaoke_widget_set_lines              (SingitKaraokeWidget *skw, guint value);
guint      singit_karaoke_widget_get_lines              (SingitKaraokeWidget *skw);

// Get / Set top lines
void       singit_karaoke_widget_set_toplines           (SingitKaraokeWidget *skw, guint value);
guint      singit_karaoke_widget_get_toplines           (SingitKaraokeWidget *skw);

// Get / Set centered lines
void       singit_karaoke_widget_set_centered_lines     (SingitKaraokeWidget *skw, gboolean value);
gboolean   singit_karaoke_widget_get_centered_lines     (SingitKaraokeWidget *skw);

// Get / Set time indicators
void       singit_karaoke_widget_set_time_indicators    (SingitKaraokeWidget *skw, gboolean value);
gboolean   singit_karaoke_widget_get_time_indicators    (SingitKaraokeWidget *skw);


void       singit_karaoke_widget_set_color              (SingitKaraokeWidget *skw, SingitKaraokeWidgetColor item, gchar *color);
void       singit_karaoke_widget_set_color_gdk          (SingitKaraokeWidget *skw, SingitKaraokeWidgetColor item, GdkColor *new_color);
void       singit_karaoke_widget_set_font               (SingitKaraokeWidget *skw, const gchar *font);
void       singit_karaoke_widget_set_show_empty_lines   (SingitKaraokeWidget *skw, const gboolean value);
void       singit_karaoke_widget_set_jumping_ball       (SingitKaraokeWidget *skw, const gboolean value);

// Calculate optimal font size
void       singit_karaoke_widget_set_optimal_font       (SingitKaraokeWidget *skw);

gdouble    singit_karaoke_widget_get_frames_per_second  (SingitKaraokeWidget *skw);

void       singit_karaoke_widget_get_minimal_sizes      (SingitKaraokeWidget *skw, gint *width, gint *height);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  // __SINGIT_KARAOKE_WIDGET_H__
