/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_DEBUG_H__
#define __SINGIT_DEBUG_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef CODEDEBUG

#include <xmms/singit/singit_macros.h>
#include <xmms/singit/singit_config.h>

#define DLV_ALL 9
#define DLV_EDITOR 7
#define DLV_XMMS 1

#define DEBUG_AREA(lvl,output) \
	do { \
		if (singit_config == NULL) \
			{ break; } \
		\
		SingitConfigData* data = GET_SCD; \
		if ((data != NULL) && (data->debugEnable == TRUE) && \
			(((data->debugLevelExcl == TRUE) && (lvl == data->debugLevel)) || \
			 ((data->debugLevelExcl == FALSE) && (lvl <= data->debugLevel)))) \
		do { \
			output \
		} while (0); \
	} while (0)

#define DEBUG(x,y) \
	DEBUG_AREA(x, debug y; )

#define PERROR(x,y) \
	DEBUG_AREA(x, perror(y); )


#endif // CODEDEBUG

#endif  // __SINGIT_DEBUG_H__
