/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "singit_main_status.h"

#define SINGIT_STATUS_INITILAIZER { NULL, 0, 0, PTHREAD_MUTEX_INITIALIZER, \
	PTHREAD_MUTEX_INITIALIZER, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, \
	NULL, NULL, 0 }

SingitStatus singit_status = SINGIT_STATUS_INITILAIZER;

void singit_main_status_init(void)
{
        singit_status.next_lyric_line = NULL;

	singit_status.display_thread = 0;
	singit_status.check_thread = 0;

	pthread_mutex_init(&singit_status.config_rw_mutex, NULL);
	pthread_mutex_init(&singit_status.lyrics_rw_mutex, NULL);

	singit_status.kill_threads = FALSE;
	singit_status.initialize_plugins = FALSE;

	singit_status.config_update = FALSE;
	singit_status.playing = FALSE;
	singit_status.song_changed = TRUE;
	singit_status.text_update = FALSE;

	singit_status.singit_sound_precalcs = NULL;
	singit_status.singit_framerate_counter = NULL;

	singit_status.attachments = 0;
}

void singit_main_status_finish(void)
{
	pthread_mutex_destroy(&singit_status.config_rw_mutex);
	pthread_mutex_destroy(&singit_status.lyrics_rw_mutex);

	if (singit_status.singit_sound_precalcs != NULL)
		g_free(singit_status.singit_sound_precalcs);

	if (singit_status.singit_framerate_counter != NULL)
		gtk_object_destroy(GTK_OBJECT(singit_status.singit_framerate_counter));

        singit_status.next_lyric_line = NULL;
	singit_status.attachments = 0;
}
