/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_SONG_PRIVATE_H__
#define __SINGIT_SONG_PRIVATE_H__

#include "singit_macros.h"

#include <stdio.h>

gboolean singit_song_set_song_filename(SingitSong *song, gchar *filename);

/* loads lyrics into song structure (text / id3v2xx / midi) */
gboolean singit_song_load_lyrics(SingitSong *song, gchar *filename);

/* save lyrics into text file : filename = NULL -> use song lyric file */
gboolean singit_song_save_lyrics(SingitSong *song, gchar *filename);

/* text handlers */

gboolean singit_song_load_from_text_file(SingitSong *song, gchar *filename);
gboolean singit_song_save_to_text_file(SingitSong *song, gchar *filename, gint tag_type);

gboolean singit_song_read_text_stream(SingitSong *song, gchar *buffer);
gboolean singit_song_write_text_stream(SingitSong *song, gchar **buffer, gint tag_type);

#ifdef HAVE_ID3
gboolean singit_song_read_id3v2_sync_stream(SingitSong *song, gpointer stream, guint slength);
gboolean singit_song_write_id3v2_sync_stream(SingitSong *song, gpointer *stream, guint *slength);

/* save lyrics into text file : filename = NULL -> use song file */
gboolean singit_song_save_id3v2_lyrics(SingitSong *ssong, gchar *filename, gint tag_type);

gboolean singit_song_load_id3v2xx_lyrics(SingitSong *song, gchar *filename);
#endif

gboolean singit_song_load_midi_lyrics(SingitSong *song, gchar *buffer);

/* compare funtion to sort the tags by time */
gint compare_token_by_time(gconstpointer a, gconstpointer b);

/* compare funtion to sort the tags by reverse position */
gint compare_token_by_rpos(gconstpointer a, gconstpointer b);

/* compare funtion to sort the tags by position */
gint compare_token_by_pos(gconstpointer a, gconstpointer b);

/*
 * Get the timetag type / tag = string with maybe prepended tag
 * Result :
 *	0 = no tag
 * 	1 = short tag
 *	2 = long tag
 */
gint singit_song_get_timetag_type(gchar* tag);

/*
 * Extract timetag information from string position
 * Result true if tag found
 */
inline gboolean extrakt_timetag_information(gchar* tag, guint* time);

/*
 * Extract the token time from a token number
 */
gboolean singit_song_extract_token(gchar *lyric_text, gint token_nr, gint *time);

/*
 * Remove a token number from a string
 */
gchar*   singit_song_remove_token(gchar *lyric_text, gint token_nr);

#endif // __SINGIT_SONG_PRIVATE_H__
