/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __LIST_LANGUAGES_H__
#define __LIST_LANGUAGES_H__

#include "singit_macros.h"

typedef struct
{
	const char *language_iso;
	const char *language_string;
}
language_list_entry;

#define list_languages_count 428
static language_list_entry list_languages[] = {

	{ "   ", N_("(unknown)") },
	{ "aar", N_("Afar") },
	{ "abk", N_("Abkhazian") },
	{ "ace", N_("Achinese") },
	{ "ach", N_("Acoli") },
	{ "ada", N_("Adangme") },
	{ "afa", N_("Afro-Asiatic (Other)") },
	{ "afh", N_("Afrihili") },
	{ "afr", N_("Afrikaans") },
	{ "aka", N_("Akan") },
	{ "akk", N_("Akkadian") },
	{ "alb", N_("Albanian") },
	{ "ale", N_("Aleut") },
	{ "alg", N_("Algonquian Languages") },
	{ "amh", N_("Amharic") },
	{ "ang", N_("English, Old (ca. 450-1100)") },
	{ "apa", N_("Apache Languages") },
	{ "ara", N_("Arabic") },
	{ "arc", N_("Aramaic") },
	{ "arm", N_("Armenian") },
	{ "arn", N_("Araucanian") },
	{ "arp", N_("Arapaho") },
	{ "art", N_("Artificial (Other)") },
	{ "arw", N_("Arawak") },
	{ "asm", N_("Assamese") },
	{ "ath", N_("Athapascan Languages") },
	{ "ava", N_("Avaric") },
	{ "ave", N_("Avestan") },
	{ "awa", N_("Awadhi") },
	{ "aym", N_("Aymara") },
	{ "aze", N_("Azerbaijani") },
	{ "bad", N_("Banda") },
	{ "bai", N_("Bamileke Languages") },
	{ "bak", N_("Bashkir") },
	{ "bal", N_("Baluchi") },
	{ "bam", N_("Bambara") },
	{ "ban", N_("Balinese") },
	{ "baq", N_("Basque") },
	{ "bas", N_("Basa") },
	{ "bat", N_("Baltic (Other)") },
	{ "bej", N_("Beja") },
	{ "bel", N_("Byelorussian") },
	{ "bem", N_("Bemba") },
	{ "ben", N_("Bengali") },
	{ "ber", N_("Berber (Other)") },
	{ "bho", N_("Bhojpuri") },
	{ "bih", N_("Bihari") },
	{ "bik", N_("Bikol") },
	{ "bin", N_("Bini") },
	{ "bis", N_("Bislama") },
	{ "bla", N_("Siksika") },
	{ "bnt", N_("Bantu (Other)") },
	{ "bod", N_("Tibetan") },
	{ "bra", N_("Braj") },
	{ "bre", N_("Breton") },
	{ "bua", N_("Buriat") },
	{ "bug", N_("Buginese") },
	{ "bul", N_("Bulgarian") },
	{ "bur", N_("Burmese") },
	{ "cad", N_("Caddo") },
	{ "cai", N_("Central American Indian (Other)") },
	{ "car", N_("Carib") },
	{ "cat", N_("Catalan") },
	{ "cau", N_("Caucasian (Other)") },
	{ "ceb", N_("Cebuano") },
	{ "cel", N_("Celtic (Other)") },
	{ "ces", N_("Czech") },
	{ "cha", N_("Chamorro") },
	{ "chb", N_("Chibcha") },
	{ "che", N_("Chechen") },
	{ "chg", N_("Chagatai") },
	{ "chi", N_("Chinese") },
	{ "chm", N_("Mari") },
	{ "chn", N_("Chinook jargon") },
	{ "cho", N_("Choctaw") },
	{ "chr", N_("Cherokee") },
	{ "chu", N_("Church Slavic") },
	{ "chv", N_("Chuvash") },
	{ "chy", N_("Cheyenne") },
	{ "cop", N_("Coptic") },
	{ "cor", N_("Cornish") },
	{ "cos", N_("Corsican") },
	{ "cpe", N_("Creoles and Pidgins, English-based (Other)") },
	{ "cpf", N_("Creoles and Pidgins, French-based (Other)") },
	{ "cpp", N_("Creoles and Pidgins, Portuguese-based (Other)") },
	{ "cre", N_("Cree") },
	{ "crp", N_("Creoles and Pidgins (Other)") },
	{ "cus", N_("Cushitic (Other)") },
	{ "cym", N_("Welsh") },
	{ "cze", N_("Czech") },
	{ "dak", N_("Dakota") },
	{ "dan", N_("Danish") },
	{ "del", N_("Delaware") },
	{ "deu", N_("German") },
	{ "din", N_("Dinka") },
	{ "div", N_("Divehi") },
	{ "doi", N_("Dogri") },
	{ "dra", N_("Dravidian (Other)") },
	{ "dua", N_("Duala") },
	{ "dum", N_("Dutch, Middle (ca. 1050-1350)") },
	{ "dut", N_("Dutch") },
	{ "dyu", N_("Dyula") },
	{ "dzo", N_("Dzongkha") },
	{ "efi", N_("Efik") },
	{ "egy", N_("Egyptian (Ancient)") },
	{ "eka", N_("Ekajuk") },
	{ "ell", N_("Greek, Modern (1453-)") },
	{ "elx", N_("Elamite") },
	{ "eng", N_("English") },
	{ "enm", N_("English, Middle (ca. 1100-1500)") },
	{ "epo", N_("Esperanto") },
	{ "esk", N_("Eskimo (Other)") },
	{ "esl", N_("Spanish") },
	{ "est", N_("Estonian") },
	{ "eus", N_("Basque") },
	{ "ewe", N_("Ewe") },
	{ "ewo", N_("Ewondo") },
	{ "fan", N_("Fang") },
	{ "fao", N_("Faroese") },
	{ "fas", N_("Persian") },
	{ "fat", N_("Fanti") },
	{ "fij", N_("Fijian") },
	{ "fin", N_("Finnish") },
	{ "fiu", N_("Finno-Ugrian (Other)") },
	{ "fon", N_("Fon") },
	{ "fra", N_("French") },
	{ "fre", N_("French") },
	{ "frm", N_("French, Middle (ca. 1400-1600)") },
	{ "fro", N_("French, Old (842- ca. 1400)") },
	{ "fry", N_("Frisian") },
	{ "ful", N_("Fulah") },
	{ "gaa", N_("Ga") },
	{ "gae", N_("Gaelic (Scots)") },
	{ "gai", N_("Irish") },
	{ "gay", N_("Gayo") },
	{ "gdh", N_("Gaelic (Scots)") },
	{ "gem", N_("Germanic (Other)") },
	{ "geo", N_("Georgian") },
	{ "ger", N_("German") },
	{ "gez", N_("Geez") },
	{ "gil", N_("Gilbertese") },
	{ "glg", N_("Gallegan") },
	{ "gmh", N_("German, Middle High (ca. 1050-1500)") },
	{ "goh", N_("German, Old High (ca. 750-1050)") },
	{ "gon", N_("Gondi") },
	{ "got", N_("Gothic") },
	{ "grb", N_("Grebo") },
	{ "grc", N_("Greek, Ancient (to 1453)") },
	{ "gre", N_("Greek, Modern (1453-)") },
	{ "grn", N_("Guarani") },
	{ "guj", N_("Gujarati") },
	{ "hai", N_("Haida") },
	{ "hau", N_("Hausa") },
	{ "haw", N_("Hawaiian") },
	{ "heb", N_("Hebrew") },
	{ "her", N_("Herero") },
	{ "hil", N_("Hiligaynon") },
	{ "him", N_("Himachali") },
	{ "hin", N_("Hindi") },
	{ "hmo", N_("Hiri Motu") },
	{ "hun", N_("Hungarian") },
	{ "hup", N_("Hupa") },
	{ "hye", N_("Armenian") },
	{ "iba", N_("Iban") },
	{ "ibo", N_("Igbo") },
	{ "ice", N_("Icelandic") },
	{ "ijo", N_("Ijo") },
	{ "iku", N_("Inuktitut") },
	{ "ilo", N_("Iloko") },
	{ "ina", N_("Interlingua (International Auxiliary language Association)") },
	{ "inc", N_("Indic (Other)") },
	{ "ind", N_("Indonesian") },
	{ "ine", N_("Indo-European (Other)") },
	{ "ine", N_("Interlingue") },
	{ "ipk", N_("Inupiak") },
	{ "ira", N_("Iranian (Other)") },
	{ "iri", N_("Irish") },
	{ "iro", N_("Iroquoian uages") },
	{ "isl", N_("Icelandic") },
	{ "ita", N_("Italian") },
	{ "jav", N_("Javanese") },
	{ "jaw", N_("Javanese") },
	{ "jpn", N_("Japanese") },
	{ "jpr", N_("Judeo-Persian") },
	{ "jrb", N_("Judeo-Arabic") },
	{ "kaa", N_("Kara-Kalpak") },
	{ "kab", N_("Kabyle") },
	{ "kac", N_("Kachin") },
	{ "kal", N_("Greenlandic") },
	{ "kam", N_("Kamba") },
	{ "kan", N_("Kannada") },
	{ "kar", N_("Karen") },
	{ "kas", N_("Kashmiri") },
	{ "kat", N_("Georgian") },
	{ "kau", N_("Kanuri") },
	{ "kaw", N_("Kawi") },
	{ "kaz", N_("Kazakh") },
	{ "kha", N_("Khasi") },
	{ "khi", N_("Khoisan (Other)") },
	{ "khm", N_("Khmer") },
	{ "kho", N_("Khotanese") },
	{ "kik", N_("Kikuyu") },
	{ "kin", N_("Kinyarwanda") },
	{ "kir", N_("Kirghiz") },
	{ "kok", N_("Konkani") },
	{ "kom", N_("Komi") },
	{ "kon", N_("Kongo") },
	{ "kor", N_("Korean") },
	{ "kpe", N_("Kpelle") },
	{ "kro", N_("Kru") },
	{ "kru", N_("Kurukh") },
	{ "kua", N_("Kuanyama") },
	{ "kum", N_("Kumyk") },
	{ "kur", N_("Kurdish") },
	{ "kus", N_("Kusaie") },
	{ "kut", N_("Kutenai") },
	{ "lad", N_("Ladino") },
	{ "lah", N_("Lahnda") },
	{ "lam", N_("Lamba") },
	{ "lao", N_("Lao") },
	{ "lat", N_("Latin") },
	{ "lav", N_("Latvian") },
	{ "lez", N_("Lezghian") },
	{ "lin", N_("Lingala") },
	{ "lit", N_("Lithuanian") },
	{ "lol", N_("Mongo") },
	{ "loz", N_("Lozi") },
	{ "ltz", N_("Letzeburgesch") },
	{ "lub", N_("Luba-Katanga") },
	{ "lug", N_("Ganda") },
	{ "lui", N_("Luiseno") },
	{ "lun", N_("Lunda") },
	{ "luo", N_("Luo (Kenya and Tanzania)") },
	{ "mac", N_("Macedonian") },
	{ "mad", N_("Madurese") },
	{ "mag", N_("Magahi") },
	{ "mah", N_("Marshall") },
	{ "mai", N_("Maithili") },
	{ "mak", N_("Macedonian") },
	{ "mak", N_("Makasar") },
	{ "mal", N_("Malayalam") },
	{ "man", N_("Mandingo") },
	{ "mao", N_("Maori") },
	{ "map", N_("Austronesian (Other)") },
	{ "mar", N_("Marathi") },
	{ "mas", N_("Masai") },
	{ "max", N_("Manx") },
	{ "may", N_("Malay") },
	{ "men", N_("Mende") },
	{ "mga", N_("Irish, Middle (900 - 1200)") },
	{ "mic", N_("Micmac") },
	{ "min", N_("Minangkabau") },
	{ "mis", N_("Miscellaneous (Other)") },
	{ "mkh", N_("Mon-Kmer (Other)") },
	{ "mlg", N_("Malagasy") },
	{ "mlt", N_("Maltese") },
	{ "mni", N_("Manipuri") },
	{ "mno", N_("Manobo Languages") },
	{ "moh", N_("Mohawk") },
	{ "mol", N_("Moldavian") },
	{ "mon", N_("Mongolian") },
	{ "mos", N_("Mossi") },
	{ "mri", N_("Maori") },
	{ "msa", N_("Malay") },
	{ "mul", N_("Multiple Languages") },
	{ "mun", N_("Munda Languages") },
	{ "mus", N_("Creek") },
	{ "mwr", N_("Marwari") },
	{ "mya", N_("Burmese") },
	{ "myn", N_("Mayan Languages") },
	{ "nah", N_("Aztec") },
	{ "nai", N_("North American Indian (Other)") },
	{ "nau", N_("Nauru") },
	{ "nav", N_("Navajo") },
	{ "nbl", N_("Ndebele, South") },
	{ "nde", N_("Ndebele, North") },
	{ "ndo", N_("Ndongo") },
	{ "nep", N_("Nepali") },
	{ "new", N_("Newari") },
	{ "nic", N_("Niger-Kordofanian (Other)") },
	{ "niu", N_("Niuean") },
	{ "nla", N_("Dutch") },
	{ "nno", N_("Norwegian (Nynorsk)") },
	{ "non", N_("Norse, Old") },
	{ "nor", N_("Norwegian") },
	{ "nso", N_("Sotho, Northern") },
	{ "nub", N_("Nubian Languages") },
	{ "nya", N_("Nyanja") },
	{ "nym", N_("Nyamwezi") },
	{ "nyn", N_("Nyankole") },
	{ "nyo", N_("Nyoro") },
	{ "nzi", N_("Nzima") },
	{ "oci", N_("Langue d'Oc (post 1500)") },
	{ "oji", N_("Ojibwa") },
	{ "ori", N_("Oriya") },
	{ "orm", N_("Oromo") },
	{ "osa", N_("Osage") },
	{ "oss", N_("Ossetic") },
	{ "ota", N_("Turkish, Ottoman (1500 - 1928)") },
	{ "oto", N_("Otomian Languages") },
	{ "paa", N_("Papuan-Australian (Other)") },
	{ "pag", N_("Pangasinan") },
	{ "pal", N_("Pahlavi") },
	{ "pam", N_("Pampanga") },
	{ "pan", N_("Panjabi") },
	{ "pap", N_("Papiamento") },
	{ "pau", N_("Palauan") },
	{ "peo", N_("Persian, Old (ca 600 - 400 B.C.)") },
	{ "per", N_("Persian") },
	{ "phn", N_("Phoenician") },
	{ "pli", N_("Pali") },
	{ "pol", N_("Polish") },
	{ "pon", N_("Ponape") },
	{ "por", N_("Portuguese") },
	{ "pra", N_("Prakrit uages") },
	{ "pro", N_("Provencal, Old (to 1500)") },
	{ "pus", N_("Pushto") },
	{ "que", N_("Quechua") },
	{ "raj", N_("Rajasthani") },
	{ "rar", N_("Rarotongan") },
	{ "roa", N_("Romance (Other)") },
	{ "roh", N_("Rhaeto-Romance") },
	{ "rom", N_("Romany") },
	{ "ron", N_("Romanian") },
	{ "rum", N_("Romanian") },
	{ "run", N_("Rundi") },
	{ "rus", N_("Russian") },
	{ "sad", N_("Sandawe") },
	{ "sag", N_("Sango") },
	{ "sah", N_("Yakut") },
	{ "sai", N_("South American Indian (Other)") },
	{ "sal", N_("Salishan Languages") },
	{ "sam", N_("Samaritan Aramaic") },
	{ "san", N_("Sanskrit") },
	{ "sco", N_("Scots") },
	{ "scr", N_("Serbo-Croatian") },
	{ "sel", N_("Selkup") },
	{ "sem", N_("Semitic (Other)") },
	{ "sga", N_("Irish, Old (to 900)") },
	{ "shn", N_("Shan") },
	{ "sid", N_("Sidamo") },
	{ "sin", N_("Singhalese") },
	{ "sio", N_("Siouan Languages") },
	{ "sit", N_("Sino-Tibetan (Other)") },
	{ "sla", N_("Slavic (Other)") },
	{ "slk", N_("Slovak") },
	{ "slo", N_("Slovak") },
	{ "slv", N_("Slovenian") },
	{ "smi", N_("Sami Languages") },
	{ "smo", N_("Samoan") },
	{ "sna", N_("Shona") },
	{ "snd", N_("Sindhi") },
	{ "sog", N_("Sogdian") },
	{ "som", N_("Somali") },
	{ "son", N_("Songhai") },
	{ "sot", N_("Sotho, Southern") },
	{ "spa", N_("Spanish") },
	{ "sqi", N_("Albanian") },
	{ "srd", N_("Sardinian") },
	{ "srr", N_("Serer") },
	{ "ssa", N_("Nilo-Saharan (Other)") },
	{ "ssw", N_("Siswant") },
	{ "ssw", N_("Swazi") },
	{ "suk", N_("Sukuma") },
	{ "sun", N_("Sudanese") },
	{ "sus", N_("Susu") },
	{ "sux", N_("Sumerian") },
	{ "sve", N_("Swedish") },
	{ "swa", N_("Swahili") },
	{ "swe", N_("Swedish") },
	{ "syr", N_("Syriac") },
	{ "tah", N_("Tahitian") },
	{ "tam", N_("Tamil") },
	{ "tat", N_("Tatar") },
	{ "tel", N_("Telugu") },
	{ "tem", N_("Timne") },
	{ "ter", N_("Tereno") },
	{ "tgk", N_("Tajik") },
	{ "tgl", N_("Tagalog") },
	{ "tha", N_("Thai") },
	{ "tib", N_("Tibetan") },
	{ "tig", N_("Tigre") },
	{ "tir", N_("Tigrinya") },
	{ "tiv", N_("Tivi") },
	{ "tli", N_("Tlingit") },
	{ "tmh", N_("Tamashek") },
	{ "tog", N_("Tonga (Nyasa)") },
	{ "ton", N_("Tonga (Tonga Islands)") },
	{ "tru", N_("Truk") },
	{ "tsi", N_("Tsimshian") },
	{ "tsn", N_("Tswana") },
	{ "tso", N_("Tsonga") },
	{ "tuk", N_("Turkmen") },
	{ "tum", N_("Tumbuka") },
	{ "tur", N_("Turkish") },
	{ "tut", N_("Altaic (Other)") },
	{ "twi", N_("Twi") },
	{ "tyv", N_("Tuvinian") },
	{ "uga", N_("Ugaritic") },
	{ "uig", N_("Uighur") },
	{ "ukr", N_("Ukrainian") },
	{ "umb", N_("Umbundu") },
	{ "und", N_("Undetermined") },
	{ "urd", N_("Urdu") },
	{ "uzb", N_("Uzbek") },
	{ "vai", N_("Vai") },
	{ "ven", N_("Venda") },
	{ "vie", N_("Vietnamese") },
	{ "vol", N_("Volap&uuml;k") },
	{ "vot", N_("Votic") },
	{ "wak", N_("Wakashan Languages") },
	{ "wal", N_("Walamo") },
	{ "war", N_("Waray") },
	{ "was", N_("Washo") },
	{ "wel", N_("Welsh") },
	{ "wen", N_("Sorbian Languages") },
	{ "wol", N_("Wolof") },
	{ "xho", N_("Xhosa") },
	{ "yao", N_("Yao") },
	{ "yap", N_("Yap") },
	{ "yid", N_("Yiddish") },
	{ "yor", N_("Yoruba") },
	{ "zap", N_("Zapotec") },
	{ "zen", N_("Zenaga") },
	{ "zha", N_("Zhuang") },
	{ "zho", N_("Chinese") },
	{ "zul", N_("Zulu") },
	{ "zun", N_("Zuni") },
	{ NULL, NULL }, 
};

#endif // __LIST_LANGUAGES_H__
