/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __LIST_OGGTAGS_H__
#define __LIST_OGGTAGS_H__

typedef struct {

	gchar *tagName;
	gboolean multiple;
	gchar *tagLongName;
}
oggtag_list_entry;

#define list_oggtags_count 30
static oggtag_list_entry list_oggtags[] = {

	{ "ALBUM",         FALSE,  N_("Album/Movie/Show title") },
	{ "ARTIST",        FALSE,  N_("Artist(s)/Performer(s)") },
	{ "PUBLISHER",     FALSE,  N_("Publisher") },
	{ "COPYRIGHT",     FALSE,  N_("Copyright message") },
	{ "DISCNUMBER",    FALSE,  N_("Multi-disc album number") },
	{ "ISRC",          FALSE,  N_("ISRC (international standard recording code)") },
	{ "EAN/UPN",       FALSE,  N_("EAN/UPN (Universal Product Number)") },
	{ "LABEL",         FALSE,  N_("Record label/Imprint") },
	{ "LABELNO",       FALSE,  N_("Record labels catalog number") },
	{ "LICENSE",       FALSE,  N_("License/URL") },
	{ "OPUS",          FALSE,  N_("Number of the work") },
	{ "SOURCEMEDIA",   FALSE,  N_("Media type") },
	{ "TITLE",         FALSE,  N_("Title/songname/content description") },
	{ "TRACKNUMBER",   FALSE,  N_("Track number/Position in set") },
	{ "VERSION",       FALSE,  N_("Interpreted/Remixed/Modified title") },
	{ "ENCODING",      FALSE,  N_("Ogg encoder settings") },
	{ "DESCRIPTION",   FALSE,  N_("Description") },
	{ "ORGANIZATION",  FALSE,  N_("Organization") },

	{ "COMPOSER",       TRUE,  N_("Composer") },
	{ "ARRANGER",       TRUE,  N_("Arranger") },
	{ "LYRICIST",       TRUE,  N_("Lyricist/Text writer") },
	{ "AUTHOR",         TRUE,  N_("Author") },
	{ "CONDUCTOR",      TRUE,  N_("Conductor") },
	{ "PERFORMER",      TRUE,  N_("Performer") },
	{ "ENSEMBLE",       TRUE,  N_("Ensamble") },
	{ "PART",           TRUE,  N_("Part") },
	{ "GENRE",          TRUE,  N_("Genre") },
	{ "DATE",           TRUE,  N_("Date") },
	{ "LOCATION",       TRUE,  N_("Location") },
	{ "COMMENT",        TRUE,  N_("Comments") },
	{ NULL }
};

#ifdef HAVE_ID3
static ID3_FrameID map_ogg_id3[] = {
{
	ID3FID_ALBUM,
	ID3FID_NOFRAME,
	ID3FID_PUBLISHER,
	ID3FID_COPYRIGHT,
	ID3FID_NOFRAME,
	ID3FID_ISRC,
	ID3FID_NOFRAME,
	ID3FID_NOFRAME,
	ID3FID_NOFRAME,
	ID3FID_NOFRAME,
	ID3FID_NOFRAME,
	ID3FID_MEDIATYPE,
	ID3FID_TITLE,
	ID3FID_TRACKNUM,
	ID3FID_NOFRAME,
	ID3FID_ENCODERSETTINGS,
	ID3FID_NOFRAME,
	ID3FID_NOFRAME,

	ID3FID_COMPOSER,
	ID3FID_NOFRAME,
	ID3FID_LYRICIST,
	ID3FID_NOFRAME,
	ID3FID_CONDUCTOR,
	ID3FID_NOFRAME,
	ID3FID_NOFRAME,
	ID3FID_NOFRAME,
	ID3FID_NOFRAME,
	ID3FID_DATE,
	ID3FID_NOFRAME,
	ID3FID_COMMENT,
	0,
};
#endif

#endif // __LIST_OGGTAGS_H__
