/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>

#include <stdio.h>
#include <string.h>

#include "singit_debug.h"

// #include "list_genres.h"
// #include "list_languages.h"
#include "singit_macros.h"
#include "singit_tag_manager.h"
#include "singit_tag_manager_private.h"
#include "singit_tools.h"

static GtkWidget *id3_v2_frames_vbox, *id3_v2_frame_label,
			*id3_v2_hirarchie_frame, *id3_v2_hirarchie_scrolledwindow,
				*id3_v2_hirarchie_viewport, *id3_v2_hirarchie_tree,
			*id3_v2_tree_modificators_frame, *id3_v2_modificators_table,
				*id3_v2_frame_id_optionmenu, *id3_v2_frame_id_optionmenu_menu,
				*id3_v2_frame_encoding_label,
					*id3_v2_frame_encoding_optionmenu, *id3_v2_frame_encoding_optionmenu_menu,
				*id3_v2_frame_type_label,
					*id3_v2_frame_type_optionmenu, *id3_v2_frame_type_optionmenu_menu,
  			*id3_v2_frame_text_vbox,
				*id3_v2_frame_text_label,
					*id3_v2_frame_text_scrolledwindow, *id3_v2_frame_text_text,
				*id3_v2_frame_line_label, *id3_v2_frame_line_entry,
				*id3_v2_frame_file_selector_button;

extern Id3DlgStatus id3dlg_status;

#define id3_widget_descr(widget, widget_var_name, show) \
	create_std_wgt_description(widget, widget_var_name, show, window)

static void insert_id3v2_tree_modification_frame(GtkWidget *window)
{
	id3_v2_tree_modificators_frame = gtk_frame_new (_("id3v2 tree modificators"));
	id3_widget_descr (id3_v2_tree_modificators_frame, "id3_v2_tree_modificators_frame", TRUE);
	gtk_box_pack_start (GTK_BOX (id3_v2_frames_vbox), id3_v2_tree_modificators_frame, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v2_tree_modificators_frame), 2);

	id3_v2_modificators_table = gtk_table_new (4, 4, FALSE);
	id3_widget_descr (id3_v2_modificators_table, "id3_v2_modificators_table", TRUE);
	gtk_container_add (GTK_CONTAINER (id3_v2_tree_modificators_frame), id3_v2_modificators_table);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v2_modificators_table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (id3_v2_modificators_table), 2);
	gtk_table_set_col_spacings (GTK_TABLE (id3_v2_modificators_table), 2);

	id3_v2_frame_id_optionmenu = gtk_option_menu_new ();
	id3_widget_descr (id3_v2_frame_id_optionmenu, "id3_v2_frame_id_optionmenu", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_id_optionmenu, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
	id3_v2_frame_id_optionmenu_menu = gtk_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (id3_v2_frame_id_optionmenu), id3_v2_frame_id_optionmenu_menu);

	id3_v2_frame_encoding_optionmenu = gtk_option_menu_new ();
	id3_widget_descr (id3_v2_frame_encoding_optionmenu, "id3_v2_frame_encoding_optionmenu", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_encoding_optionmenu, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
	id3_v2_frame_encoding_optionmenu_menu = gtk_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (id3_v2_frame_encoding_optionmenu), id3_v2_frame_encoding_optionmenu_menu);

	id3_v2_frame_encoding_label = gtk_label_new (transadd(_("Encoding"), ":"));
	id3_widget_descr (id3_v2_frame_encoding_label, "id3_v2_frame_encoding_label", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_encoding_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

	id3_v2_frame_type_label = gtk_label_new (transadd(_("Frame type"), ":"));
	id3_widget_descr (id3_v2_frame_type_label, "id3_v2_frame_type_label", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_type_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

	id3_v2_frame_line_label = gtk_label_new (transadd(_("Frame line"), ":"));
	id3_widget_descr (id3_v2_frame_line_label, "id3_v2_frame_line_label", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_line_label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

	id3_v2_frame_type_optionmenu = gtk_option_menu_new ();
	id3_widget_descr (id3_v2_frame_type_optionmenu, "id3_v2_frame_type_optionmenu", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_type_optionmenu, 2, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
	id3_v2_frame_type_optionmenu_menu = gtk_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (id3_v2_frame_type_optionmenu), id3_v2_frame_type_optionmenu_menu);

	id3_v2_frame_text_vbox = gtk_vbox_new (FALSE, 1);
	id3_widget_descr (id3_v2_frame_text_vbox, "id3_v2_frame_text_vbox", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_text_vbox, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v2_frame_text_vbox), 1);

	id3_v2_frame_text_label = gtk_label_new (transadd(_("Frame text"), ":"));
	id3_widget_descr (id3_v2_frame_text_label, "id3_v2_frame_text_label", TRUE);
	gtk_box_pack_start (GTK_BOX (id3_v2_frame_text_vbox), id3_v2_frame_text_label, FALSE, TRUE, 0);

	id3_v2_frame_text_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	id3_widget_descr (id3_v2_frame_text_scrolledwindow, "id3_v2_frame_text_scrolledwindow", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_text_scrolledwindow, 1, 4, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (id3_v2_frame_text_scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	id3_v2_frame_text_text = gtk_text_new (NULL, NULL);
	id3_widget_descr (id3_v2_frame_text_text, "id3_v2_frame_text_text", TRUE);
	gtk_container_add (GTK_CONTAINER (id3_v2_frame_text_scrolledwindow), id3_v2_frame_text_text);

	id3_v2_frame_line_entry = gtk_entry_new ();
	id3_widget_descr (id3_v2_frame_line_entry, "id3_v2_frame_line_entry", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_line_entry, 1, 4, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 2);

	id3_v2_frame_file_selector_button = gtk_button_new_with_label (_("File selector..."));
	id3_widget_descr (id3_v2_frame_file_selector_button, "id3_v2_frame_file_selector_button", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_file_selector_button, 2, 3, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 2, 0);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v2_frame_file_selector_button), 1);
}

static void insert_oggvorbis_tree_modification_frame(GtkWidget *window)
{
	id3_v2_tree_modificators_frame = gtk_frame_new (_("ogg vorbis comment tree modificators"));
	id3_widget_descr (id3_v2_tree_modificators_frame, "id3_v2_tree_modificators_frame", TRUE);
	gtk_box_pack_start (GTK_BOX (id3_v2_frames_vbox), id3_v2_tree_modificators_frame, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v2_tree_modificators_frame), 2);

	id3_v2_modificators_table = gtk_table_new (2, 2, FALSE);
	id3_widget_descr (id3_v2_modificators_table, "id3_v2_modificators_table", TRUE);
	gtk_container_add (GTK_CONTAINER (id3_v2_tree_modificators_frame), id3_v2_modificators_table);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v2_modificators_table), 2);
	gtk_table_set_row_spacings (GTK_TABLE (id3_v2_modificators_table), 2);
	gtk_table_set_col_spacings (GTK_TABLE (id3_v2_modificators_table), 2);

	id3_v2_frame_line_label = gtk_label_new (transadd(_("Comment type"), ":"));
	id3_widget_descr (id3_v2_frame_line_label, "id3_v2_frame_line_label", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_line_label, 0, 1, 0, 1,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (0), 0, 0);

	id3_v2_frame_text_vbox = gtk_vbox_new (FALSE, 1);
	id3_widget_descr (id3_v2_frame_text_vbox, "id3_v2_frame_text_vbox", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_text_vbox, 0, 1, 1, 2,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v2_frame_text_vbox), 1);

	id3_v2_frame_text_label = gtk_label_new (transadd(_("Comment text"), ":"));
	id3_widget_descr (id3_v2_frame_text_label, "id3_v2_frame_text_label", TRUE);
	gtk_box_pack_start (GTK_BOX (id3_v2_frame_text_vbox), id3_v2_frame_text_label, FALSE, TRUE, 0);

	id3_v2_frame_file_selector_button = gtk_button_new_with_label (_("From file..."));
	id3_widget_descr (id3_v2_frame_file_selector_button, "id3_v2_frame_file_selector_button", TRUE);
	gtk_box_pack_start (GTK_BOX (id3_v2_frame_text_vbox), id3_v2_frame_file_selector_button, FALSE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v2_frame_file_selector_button), 1);

	id3_v2_frame_line_entry = gtk_entry_new ();
	id3_widget_descr (id3_v2_frame_line_entry, "id3_v2_frame_line_entry", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_line_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 2);

	id3_v2_frame_text_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	id3_widget_descr (id3_v2_frame_text_scrolledwindow, "id3_v2_frame_text_scrolledwindow", TRUE);
	gtk_table_attach (GTK_TABLE (id3_v2_modificators_table), id3_v2_frame_text_scrolledwindow, 1, 2, 1, 2,
		(GtkAttachOptions) (GTK_FILL),
		(GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (id3_v2_frame_text_scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	id3_v2_frame_text_text = gtk_text_new (NULL, NULL);
	id3_widget_descr (id3_v2_frame_text_text, "id3_v2_frame_text_text", TRUE);
	gtk_container_add (GTK_CONTAINER (id3_v2_frame_text_scrolledwindow), id3_v2_frame_text_text);
}

void append_hierachial_view_page(GtkWidget *notebook, GtkWidget *window)
{
	gchar *trans_str[2];

	g_return_if_fail(notebook != NULL);
	g_return_if_fail(window != NULL);

	g_return_if_fail(GTK_IS_NOTEBOOK(notebook));
	g_return_if_fail(GTK_IS_WINDOW(window));

	id3_v2_frames_vbox = gtk_vbox_new (FALSE, 0);
	id3_widget_descr (id3_v2_frames_vbox, "id3_v2_frames_vbox", TRUE);

	switch (id3dlg_status.info_type) {
	case IT_VORBIS:
		trans_str[0] = _("vorbis comments");
		trans_str[1] = _("vorbis comments hirarchial tree");
		break;
	case IT_MPEG:
	default:
		trans_str[0] = _("id3v2 frames");
		trans_str[1] = _("id3v2 hirarchie tree");
		break;
	}
	
	id3_v2_frame_label = gtk_label_new (trans_str[0]);
	id3_widget_descr (id3_v2_frame_label, "id3_v2_frame_label", TRUE);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), id3_v2_frames_vbox, id3_v2_frame_label);

	id3_v2_hirarchie_frame = gtk_frame_new (trans_str[1]);
	id3_widget_descr (id3_v2_hirarchie_frame, "id3_v2_hirarchie_frame", TRUE);
	gtk_box_pack_start (GTK_BOX (id3_v2_frames_vbox), id3_v2_hirarchie_frame, TRUE, TRUE, 0);

	id3_v2_hirarchie_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	id3_widget_descr (id3_v2_hirarchie_scrolledwindow, "id3_v2_hirarchie_scrolledwindow", TRUE);
	gtk_container_add (GTK_CONTAINER (id3_v2_hirarchie_frame), id3_v2_hirarchie_scrolledwindow);
	gtk_container_set_border_width (GTK_CONTAINER (id3_v2_hirarchie_scrolledwindow), 2);

	id3_v2_hirarchie_viewport = gtk_viewport_new (NULL, NULL);
	id3_widget_descr (id3_v2_hirarchie_viewport, "id3_v2_hirarchie_viewport", TRUE);
	gtk_container_add (GTK_CONTAINER (id3_v2_hirarchie_scrolledwindow), id3_v2_hirarchie_viewport);

	id3_v2_hirarchie_tree = gtk_tree_new ();
	id3_widget_descr (id3_v2_hirarchie_tree, "id3_v2_hirarchie_tree", TRUE);
	gtk_container_add (GTK_CONTAINER (id3_v2_hirarchie_viewport), id3_v2_hirarchie_tree);

	switch (id3dlg_status.info_type) {
	case IT_VORBIS:
		insert_oggvorbis_tree_modification_frame(window);
		break;
	case IT_MPEG:
	default:
		insert_id3v2_tree_modification_frame(window);
		break;
	}
}
