// TempMem.cpp

#include "TempMem.h"



#if EG_MAC
#include <Memory.h>
#endif

TempMem::TempMem() {
	
	mDimSize = 0;
	mPtr = nil;
	
	#if EG_MAC
	mTempH = nil;
	#endif
}


TempMem::~TempMem() {

	#if EG_MAC
	OSErr err;
	if ( mTempH ) {
		::TempHUnlock( mTempH, &err );
		::TempDisposeHandle( mTempH, &err );
	}
	#endif
}


char* TempMem::Dim( long inBytes ) {

	// Realloc if current buf is too small or too wasteful
	if ( inBytes > mDimSize || mDimSize > inBytes + 50000 ) {
		mDimSize = 0;
		mPtr = nil;
		
		#if EG_MAC
		OSErr err;
		if ( mTempH ) {
			::TempHUnlock( mTempH, &err );
			::TempDisposeHandle( mTempH, &err );
		}
	
		mTempH = ::TempNewHandle( inBytes, &err );
		if ( ! err && mTempH ) {
			::TempHLock( mTempH, &err );
			mPtr = *mTempH;
		}
		#else
		mPtr = mTemp.Dim( inBytes );
		#endif
		
		if ( mPtr )
			mDimSize = inBytes;
	}
	

	
	return mPtr;
}


char* TempMem::Assign( void* inPtr, long inBytes ) {

	char* dest = Dim( inBytes );
	
	if ( dest && inPtr )
		UtilStr::Move( dest, inPtr, inBytes );


	return dest;
}




void TempMem::Clear() {
	long i, n = mDimSize;
	
	// Clear using 4-byte stores  
	n = n >> 2;
	for ( i = 0; i < n; i++ )
		( (long*) mPtr )[ i ] = 0;
		
	// Clear what's left
	for ( i = n << 2; i < mDimSize; i++ )
		mPtr[ i ] = 0;
}
