/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <stdlib.h>
#include <stdio.h>

#include <xmms/xmmsctrl.h>
#include <xmms/util.h>

#include "singit/displayer_plugin.h"
#include "displayer_test_msg_status.h"

static void displayer_test_msg_init(void);
static void displayer_test_msg_finish(void);
static void displayer_test_msg_config_update(void);

static void displayer_test_msg_set_song(SingitSong *cur_song);
static void displayer_test_msg_set_time(guint time, GList *real_next);

static void displayer_test_msg_about(void);
static void displayer_test_msg_configure(void);

static void displayer_test_msg_playback_start(void);
static void displayer_test_msg_playback_stop(void);

DisplayerPlugin test_msg_dp =
{
	NULL,
	NULL,
	0,
	0,
	NULL,

	"Test MSG displayer",

	displayer_test_msg_init,
	displayer_test_msg_finish,
	displayer_test_msg_config_update,

	displayer_test_msg_set_song,
	displayer_test_msg_set_time,

	displayer_test_msg_about,
	displayer_test_msg_configure,

	displayer_test_msg_playback_start,
	displayer_test_msg_playback_stop,

	NULL,
	NULL
};

DIPSPLAYER_SYMBOL(libdisplayer_test_msg, test_msg_dp)

static void displayer_test_msg_init(void)
{
	g_print("displayer_test_msg.c [init]\n");

	displayer_test_msg_status_init();
}

static void displayer_test_msg_finish(void)
{
	g_print("displayer_test_msg.c [finish]\n");

	displayer_test_msg_status_finish();
}

static void displayer_test_msg_config_update(void)
{
	g_print("displayer_test_msg.c [config_update]\n");
}


static void displayer_test_msg_set_song(SingitSong *new_song)
{
	SingitSong *tmp_song;

	g_print("displayer_test_msg.c [set_song] : ");

	tmp_song = displayer_test_msg_status.song;
	displayer_test_msg_status.song = singit_song_attach(new_song);
	singit_song_detach(&tmp_song);

	if (new_song && singit_song_lyrics_found(new_song)) {
		g_print("Show\n");
	}
	else {
		g_print("Hide\n");
	}
}

static void displayer_test_msg_set_time(guint time, GList *real_next)
{
	SingitSong *my_song;

	my_song = singit_song_attach(displayer_test_msg_status.song);

	singit_song_detach(&my_song);
}

static void displayer_test_msg_about(void)
{
	g_print("displayer_test_msg.c [about]\n");
}

static void displayer_test_msg_configure(void)
{
	g_print("displayer_test_msg.c [configure]\n");
}


static void displayer_test_msg_playback_start(void)
{
	g_print("displayer_test_msg.c [playback_start]\n");

	displayer_test_msg_status.xmms_playing = TRUE;
}

static void displayer_test_msg_playback_stop(void)
{
	g_print("displayer_test_msg.c [playback_stop]\n");

	displayer_test_msg_status.xmms_playing = FALSE;
}
