
#include "VFrameBuffer.h"

#include "RectUtils.h"
#include "PixPort.h"

VFrameBuffer::VFrameBuffer() {

	mDepth = 8;
	mBytesPerRow = 0;
	mBounds.left = mBounds.top = mBounds.right = mBounds.bottom = 0;
	mBits = 0;
	mImageFlipped = false;
}

void VFrameBuffer::ClipSourceRect( const Rect& inSrceRect, int inX, int inY, Rect& outSrceRect ) const {

	OffsetRect( inSrceRect, &outSrceRect, inX, inY );
	IntersectRect( &mBounds, &outSrceRect, &outSrceRect );
	OffsetRect( &outSrceRect, - inX, - inY );
}


#define __Load16				pixVal = ((unsigned short*) srce)[ x ];							\
								__16ToByte(pixVal,R,G,B)

#define __Load32				pixVal = ((unsigned long*) srce)[ x ];							\
								__32ToByte(pixVal,R,G,B)

#define __Load24				__24ToByte(srce,R,G,B)											\
								srce += 3;

#define __Store8				dest[ x ] = __ByteToIntensity(R,G,B);

#define __Store16				( (unsigned short*) dest )[ x ] = __ByteTo16(R,G,B);

#define __Store32				( (unsigned long*)  dest )[ x ] = __ByteTo32(R,G,B);


/*
#if EG_MAC
	unsigned char* c = (unsigned char*) ( &inPal[ srce[ x ] ] );
	( (unsigned long*) dest )[ x ] = __ByteTo32( c[0],c[2],c[4] );
#endif

#if EG_WIN
	unsigned char* c = (unsigned char*) ( &inPal[ srce[ x ] ] );
	( (unsigned long*) dest )[ x ] = __ByteTo32( c[3],c[2],c[1] );
#endif
*/


void VFrameBuffer::CopyBits( PixPort* inSrceBuf, Rect& inSrce, int inX, int inY ) {

	unsigned long pal[ 256 ], i;

	if ( inSrceBuf ) {

		// If we'll have to do color lookups, we need to fetch the palette entries...
		if ( inSrceBuf -> GetDepth() == 8 && mDepth != 8 ) {

			#if EG_WIN
			::GetDIBColorTable( inSrceBuf -> GetDC(), 0, 256, (RGBQUAD*) pal );
			#endif

			#if EG_MAC
			CTabHandle offscreenTable = (**inSrceBuf -> GetPixMap()).pmTable;
			for ( i = 0; i < 256; i++ ) {
				pal[ i ] = __REFTo32( (**offscreenTable).ctTable[ i ].rgb );
			}
			#endif

			// Change 32bit pixel values to 16bit pixel values if dest depth is 16 bit
			if ( mDepth == 16 ) {
				for ( i = 0; i < 256; i++ )
					( (unsigned short*) pal )[ i ] = __32To16( pal[ i ] );
			}
		}
	}

	CopyBits( inSrceBuf, inSrce, inX, inY, pal );
}


#define __pixLoop		for ( y = inSrce.top; y < inSrce.bottom; y++ ) {		\
							for ( x = 0; x < width; x++ ) {						\


#define __endLoop			}													\
							srce += srceBytesPerRow;							\
							dest += mBytesPerRow;								\
						}

void VFrameBuffer::CopyBits( const VFrameBuffer* inSrceBuf, Rect& inSrce, int inX, int inY, void* inPal ) {

	Rect r;
	const unsigned char* srce;
	unsigned char* dest;
	int width, srceDepth, srceBytesPerRow;
	long x, y, R, B, G;
	unsigned long pixVal;

	if ( inSrceBuf ) {

		srceDepth = inSrceBuf -> GetDepth();

		// Don't copy bits over undimmed rgns
		IntersectRect( &inSrce, &inSrceBuf -> mBounds, &r );
		OffsetRect( &r, inX, inY );
		IntersectRect( &r, &mBounds, &r );
		OffsetRect( &r, - inX, - inY );

		if ( IsValidRect( r ) ) {

			// Calculate the source and dest addr...
			srceBytesPerRow = inSrceBuf -> mBytesPerRow;
			y = inSrce.top;
			/*
			if ( inFlipVertical ) {
				y = inSrceBuf -> GetY() - y;
				srceBytesPerRow = - srceBytesPerRow;
			} */
			srce = inSrceBuf -> GetRow( y ) + ( ( inSrce.left * srceDepth ) >> 3 );
			dest = GetRow( inY ) + ( ( inX * mDepth ) >> 3 );
			width = inSrce.right - inSrce.left;

			// If this is an 8 bit image, go thru each RGB pixel and store it as an intensity
			if ( mDepth == 8 ) {

				// Got thru each RGB pixel and store it as an intensity
				switch ( srceDepth ) {

					case 8:
						__pixLoop
							dest[ x ] = srce[ x ];
						__endLoop
						break;

					case 16:
						__pixLoop
							__Load16
							__Store8
						__endLoop
						break;

					case 24:
						__pixLoop
							__Load24
							__Store8
						__endLoop
						break;

					case 32:
						__pixLoop
							__Load32
							__Store8
						__endLoop
						break;
				} }

			else if ( mDepth == 16 ) {

				switch ( srceDepth ) {

					// In this case, we'll need a palette to restore color
					case 8:
						__pixLoop
							( (unsigned short*) dest )[ x ] = ( (unsigned short*) inPal )[ srce[ x ] ];
						__endLoop
						break;

					case 16:
						__pixLoop
							( (short*) dest )[ x ] = ( (short*) srce )[ x ];
						__endLoop
						break;


					case 24:
						__pixLoop
							__Load24
							__Store16
						__endLoop
						break;

					case 32:
						__pixLoop
							__Load32
							__Store16
						__endLoop
						break;
				} }

			else if ( mDepth == 32 ) {


				switch ( srceDepth ) {

					// In this case, we'll need a palette to restore color
					case 8:
						__pixLoop
							( (unsigned long*) dest )[ x ] = ( (unsigned long*) inPal )[ srce[ x ] ];
						__endLoop
						break;

					case 16:
						__pixLoop
							__Load16
							__Store32
						__endLoop
						break;


					case 24:
						__pixLoop
							__Load24
							__Store32
						__endLoop
						break;

					case 32:
						__pixLoop
							( (long*) dest )[ x ] = ( (long*) srce )[ x ];
						__endLoop
						break;
				}
			}
		}
	}
}

void VFrameBuffer::Assign( char* inBits, int inWidth, int inHeight, int inBytesPerRow, int inDepth ) {

	mDepth = inDepth;
	mBytesPerRow = inBytesPerRow;
	::SetRect( &mBounds, 0, 0, inWidth, inHeight );
	mBits = inBits;
}



#undef  __pixLoop
#define __pixLoop		for ( y = inSrce.top; y < inSrce.bottom; y++ ) {		\
							for ( x = 0; x < width; x++ ) {						\


#undef  __endLoop
#define __endLoop			}													\
							srce += srceBytesPerRow;							\
							dest += mBytesPerRow;								\
						}

/*
void VFrameBuffer::InvertRect( const Rect* inRect ) {
	long height;
	int x, y;
	char*	bits;
	Rect	r;

	// Don't let us draw in random parts of memory -- clip inRect
	if ( inRect )
		IntersectRect( inRect, &mBounds, &r );
	else
		r = mBounds;

	if ( IsValidRect( r ) ) {

		height	= r.bottom - r.top;



		bits = inSrceBuf -> GetRow( y ) + ( ( inSrce.left * srceDepth ) >> 3 );

		if ( mDepth == 8 ) {

			__pixLoop
				bits[ x ] = 0xFF - bits[ x ];
			__endLoop

			}
		else if ( mDepth == 16 ) {

			__pixLoop
				pixVal = ( (unsigned short*) bits )[ x ];
				__16To5Bit( pixVal, R, G, B )
				R = 0x1F - R;
				G = 0x1F - G;
				B = 0x1F - B;
				( (unsigned short*) bits )[ x ] = __5BitTo16( R, G, B );
			__endLoop
		}
		else if ( mDepth == 32 ) {

			__pixLoop
				pixVal = ( (unsigned long*) bits )[ x ];
				__32ToByte( pixVal, R, G, B )
				R = 0xFF - R;
				G = 0xFF - G;
				B = 0xFF - B;
				( (unsigned long*) bits )[ x ] = __ByteTo32( R, G, B );
			__endLoop
		}
	}
}
*/
