/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_ID3LIB_WRAPPER_H__
#define __SINGIT_ID3LIB_WRAPPER_H__

#include <id3.h>
#include <glib.h>

/*
 *  As the ID3Tag_Link function of id3lib-3.8.0pre2 returns the ID3v1 tags
 *  when a file has both ID3v1 and ID3v2 tags, we first try to explicitely
 *  get the ID3v2 tags with ID3Tag_LinkWithFlags and, if we cannot get them,
 *  fall back to the ID3v1 tags.
 *  (Written by Holger Schemel).
 */
size_t ID3Tag_Link_WRP(ID3Tag *id3tag, const gchar *filename);

/*
 *  As the ID3Field_GetASCII function differs with the version of id3lib, we must redefine it.
 */
size_t ID3Field_GetASCII_WRP(const ID3Field *field, gchar *buffer, size_t maxChars);

#endif // __SINGIT_ID3LIB_WRAPPER_H__
