/* Speex Xmms Plugin
 * (c) Jens Burkal, license: GPL
 */

#ifndef __LIBSPEEX_H__
#define __LIBSPEEX_H__

#include <speex.h>
#include <xmms/plugin.h>
#include "speexutil.h"

#define SPEEX_EXT ".spx"

typedef struct
{
	FILE *spxfile;
	gboolean playing, streaming, eof, eos;
	int length, seek_to, framesize;
	char /* *filename, */ *title;
	SpeexMode mode;
	int freq, channels, vbr, nframes;
} Speex_File_State;

typedef struct
{
	gboolean use_enhancer;
	gint buffersize, prebuffer;
	gboolean use_proxy, use_auth;
	gchar *proxy_host;
	gint proxy_port;
	gchar *proxy_user, *proxy_passwd;
	gboolean save_stream;
	gchar *save_path;
	gboolean use_title;
	gchar *title_format;
} Speex_Configuration;

extern Speex_File_State *speex_fs;
extern Speex_Configuration *speex_cfg;
extern InputPlugin speex_ip;

extern char *generate_title(char *, speex_comment_t*);

#endif
