#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "stdio.h"
#include "strings.h"
#include "string.h"

#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

//#include <gdk/gdk.h>

#include "gtktopdata.h"

#include "gtk_subimagesel.h"

#include "main.h"

#include "callbacks.h"
#include "interface.h"
#include "support.h"
//#include "pixmaps.h"
#include "mesh-gtk.h"
#include "utils.h"
#include "feature.h"
#include "gtk-extra.h"
#include "../libmorph/relax.h"
#include "mag.h"

/* we will implement UNDO by copying this structure and its substructures */
gtkmorph_status_t  settings,
  *sp = &settings;


#define PRINT_MORPH_TIME

char * theunimplemented_text="sorry this functions is as yet unimplemented";
#define unimplemented_text  (_(theunimplemented_text))


#define g_debug(A,...) 


/* some code was taken from the gtk-tutorial , the "scribble" example */


/*******************************************************************
******************************************************************

                    main window 

**********************************************************************
**********************************************************************

*/





gboolean
on_window_main_delete                  (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  if(guide_callback("delete_event",MAIN_WIN)) {
    gtk_widget_hide(widget);  
    return TRUE;
  }
  else
    {
      on_quit1_activate(NULL,NULL);
      return TRUE;
    }
}


void 
on_quit1_activate                      (GtkMenuItem     *menuitem,
					gpointer         user_data) 
{ 
  int lp; char s[MAX_WINS*5+10];
  s[0]=0;
  /* FIXME < or <= ?? */
  for(lp=1;lp<=MAX_WINS; lp++) {
    if(  mesh_need_saving(lp) ) {
      int l=strlen(s); sprintf(s+l," %d",lp);
    }
  }
  if ( s[0]) {
    GtkWidget *q=create_question(), *b;
    char *z=g_strdup_printf
      (_("the mesh(es) %s were not saved! do you want to exit anyway?"),s);
    //gtk_window_set_title(GTK_WINDOW(q),z);
    
    gtk_widget_show(q);
    b=lookup_widget(q,"yes");
    gtk_signal_connect (GTK_OBJECT (b), "clicked",
			GTK_SIGNAL_FUNC (gtk_main_quit),
			NULL);
    b=lookup_widget(q,"no");
    gtk_signal_connect (GTK_OBJECT (b), "clicked",
			GTK_SIGNAL_FUNC (gtk_widget_destroy),
			q);
    b=lookup_widget(q,"questionlabel"); 
    gtk_label_set_text(GTK_LABEL(b),z);

    g_free(z);
  }
  else
    gtk_main_quit();
}




void
on_resulting_image_size_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget* hb= lookup_widget  ( sp->im_widget[MAIN_WIN]  ,
				  "handlebox_res_size");
  g_assert(hb);
  gtk_widget_show(hb);
}


void
on_show_morph_factors_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    int lp;
  for(lp=1 ; lp <= MAX_WINS;  lp ++)
    if(sp->im_widget[lp] != NULL) {      
      set_editview(lp,EDITVIEW_SHOWMESHES );
    }
}




void
on_generic_help_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_info( _("\
Here are a few tips at using this program\n\
0) at startup the program is set for ``warping'': read the ``warp help''\n\
1) to morph, you need to have 2 or more `input images' :\n\
 use `add an image' (it is in the `file' menu); read the ``morph help''\n\
2) if you keep the mouse still on a menu voice or on a button\n\
  for a moment, you may read the help tips.\n\
3) when the mouse pointer is in on the mesh grid, by hitting\n\
  the right button, you get an useful menu.\n\
\n\n\
If you need more help, activate the guide.")  );
}




void
on_morph_help_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_info( _("\
To morph:\n\
  1) load an image in each `input image',\n\
  2) edit the meshes by dragging the points (and use the menu that you get\n\
       by the right mouse button)\n\
  3) set the `blending factors' and `mesh factors' as desired\n\
  3) and hit `do morph'\n\
")  );
}


void
on_warp_help_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  show_info( _("\
It is not difficult to use this program for warping: just\n\
  1) load an image in the `input image 1',\n\
  2) edit the meshes by dragging the points (and use the menu that you get\n\
       by the right mouse button)\n\
  3) and hit `do warp'\n\
")  );
}


//void
//on_logtext_realize                     (GtkWidget       *widget,
//                                        gpointer         user_data)
//{
//
//}



/*
  main menus callbacks 

 */

/* see utils.h */

fileselection_hook_t fileselection_hook=NULL;

void show_fs(GtkWidget *widget,
	     char *title /* fileselection title */
	     );

void
on_load_session_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  fileselection_hook=load_session;
  //fileselection1_for_image_num_g=MAIN_WIN;
  gtk_file_selection_set_filename ((imageselection1_g), 
				   "");
  show_fs(GTK_WIDGET(menuitem), _("load session") );
}


void
on_save_session_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  fileselection_hook=save_session;
  //fileselection1_for_image_num_g=MAIN_WIN;
  gtk_file_selection_set_filename ((imageselection1_g), 
				   "");
  show_fs(GTK_WIDGET(menuitem), _("save session") );
}





void
on_add_an_image_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    int lp;
    for(lp=1 ; lp <= MAX_WINS;  lp ++)
      if(sp->im_widget[lp] == NULL)
	{
	  /* we set this before, 
	     otherwise the "factor_normalize" goes berseker */
	  sp->max_wins++;

	  create_and_show_image_win(lp);	
	  setup_handlebox_factors();
	  return; 
	}
}





void
on_view_images1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int lp;
  for(lp=1 ; lp <= MAIN_WIN ; lp ++)
    {
      if(sp->im_widget[lp] != NULL)
	gtk_widget_show (sp->im_widget[lp]);
    }
}



double
tot_mixing_factors()
{
  double  totdiss;
  int lp;
  totdiss=0;
  for ( lp =1; lp <= MAX_WINS; lp++)
    if(sp->im_widget[lp] != NULL)
      totdiss += sp->mf.im_dissolve_factor[lp];
  // FIXME this is not shown
  sp->mf.im_dissolve_factor[MAIN_WIN]=totdiss; 
  
  return totdiss;
}

double
tot_mixing_factors_nice()
{
  double totdiss=tot_mixing_factors();
  int lp;
  if ( ABS(totdiss) < 0.001)
    {
      show_warning( _("\
to blend the images, the sum of the all `image mixing factors' must be nonzero\
\nI have put default values for you"));
      
      for ( lp =1; lp <= MAX_WINS; lp++)
	if(sp->im_widget[lp] != NULL) {
	  sp->mf.im_dissolve_factor[lp]=1.0/(double)sp->max_wins;
	  //gtk_widget_get_data_top(sp->im_widget[lp],"imagenum")
	}
      totdiss =1;
      redraw_spins(-3);
    }
  return totdiss;
}


/********************************
does the actual morphing 
********************************/

void
on_morph_images1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int lp;
  //double  totdiss=tot_mixing_factors_nice();

#ifdef PRINT_MORPH_TIME
  GTimeVal bef,aft;
  g_get_current_time(&bef);
#endif

  if( sp->max_wins<=1)
    {
      show_error( _("\
to morph, you must have at least two input images"));
      return;
    }
  
 if( settings_get_value("automatic mesh interpolation"))
   on_interpolate_meshes1_activate (NULL,NULL);

  for ( lp =1; lp <= MAX_WINS; lp++)
    if(sp->im_widget[lp] != NULL)
      {
	if( ABS(sp->mf.im_dissolve_factor[lp]) < 0.001 )      
	  g_message("NOT morphing image %d to resulting image", lp);
	else
	  {
	    //g_message("morphing image %d to inbetween\n", lp);
	    //	    do_warp_an_image_old(lp,r,g,b);
	    do_warp_an_image_new(lp);
	  }
      }

  on_do_mixing_clicked(NULL,NULL);
#ifdef PRINT_MORPH_TIME
  g_get_current_time(&aft);
  g_message("morph time %.2f",(double)(aft.tv_sec-bef.tv_sec) +
	    (double)(aft.tv_usec -bef.tv_usec) /1e6 );
#endif
  
  if(settings_get_value( "show warp after warp"))
    set_editview(MAIN_WIN, EDITVIEW_SHOW);
  gtk_widget_draw (sp->im_widget[MAIN_WIN] , NULL);
}






/***********************************************************
 *
 *************************** file selection  ************
 *
 **********************************************************

 the following hook is set 
 so that the same fileselection dialog will be used for many
 different purposes

*/


void
on_ok_button1_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
//  GtkWidget       *widget_f=  gtk_widget_get_toplevel (widget);
// doesnt work
//  gtk_container_add (GTK_CONTAINER (widget_f), 
//		     menu_image_num_g);

//  gtk_menu_item_set_submenu(widget,create_menu_image_num_g );
}



void
on_ok_button1_clicked         (GtkButton       *button,
			       gpointer         user_data)
{  
  const char *file=
    gtk_file_selection_get_filename
    (GTK_FILE_SELECTION (imageselection1_g));

  g_assert(fileselection1_for_image_num_g > 0);

  if( //e.g.   fileselection_hook=load_image_from_file
     fileselection_hook  (fileselection1_for_image_num_g,
			  file))
    {
      gtk_widget_hide(GTK_WIDGET(imageselection1_g));
      gtk_file_selection_complete     (imageselection1_g,"");
      gtk_widget_show( sp-> im_widget[fileselection1_for_image_num_g]);  

      guide_callback("file",fileselection1_for_image_num_g);
      // lets be nasty
      fileselection1_for_image_num_g=-2;
      fileselection_hook=NULL;      
    }
}


/********************************************************************
 *
 * input image window, drawingarea
 *

 note: many callbacks are shared with the "resulting image window"

 ******************************************************************
**/




/***************************************************************

 *		drawing area callbacks

 ***********************************************************
*/ 



void
on_drawingarea_realize                 (GtkWidget       *widget,
				     gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  /* the drawing area widget will be accessible tru this */
  gtk_widget_set_data_top(widget, "drawingarea widget", widget);

  sp->im_drawingarea_widget[i] = widget;
  {
    int j ; 
    for (j=2;j>=0;j--) {
      create__pixmap(i,j);// must do this now-- need a window
    }}
  //  drawingarea_configure  (i);
}



/* save also the viewport widget address, so we can resize it easily 
   
   actually "glade" does the same thing, and I didnt know it
*/

void
on_viewport3_realize                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_widget_set_data_top(widget, "viewport widget", widget);
}



gboolean
on_drawingarea_configure_event         (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  //g_message(" configure drawingarea %d",i);
  // this loops
  //`drawingarea_configure(i);
  return FALSE;
}



const double transl[6]={1,0,PIXEDITBORDER,0,1,PIXEDITBORDER},
  ident[6]={1,0,0,0,1,0};
double loaded[6];
double * matrix_for_image(int i) 
{
  double *a=ident;
  if( sp->im_editview[i]==EDITVIEW_EYES )
    {
      a=loaded;
      memcpy(a,&sp->transforms[i].subimage2loaded,6*sizeof(double));
      a[2]+=PIXLOADEDBORDER;
      a[5]+=PIXLOADEDBORDER;
    }
  if( sp->im_editview[i]==EDITVIEW_EDIT)
    a=transl;
  return a;
}

gboolean
on_expose_event                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  GdkPixmap *pixmap ,
    **pixmap_p=which_pixmap_is_visible(i);

  g_assert(i > 0);
  g_assert(pixmap_p);
  pixmap=*pixmap_p;
  
  if ( ! mpl_gc) 
    allocate_colors( widget );


  /* the gtk+ manual (see "drawing area" section)
     says we have to:*/
  gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
			     &event->area);

  // this one flashes too much
  //gdk_window_clear_area (widget->window,
  //                        event->area.x, event->area.y,
  //                        event->area.width, event->area.height);

  /* then we draw...*/ 
  if(pixmap == NULL) 
    g_critical("THERE IS NO PIXMAP of type %d  for image %d",
	       sp->which_pix[i],i);
  else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    pixmap,
		    event->area.x, event->area.y,
		    event->area.x, event->area.y,
		    event->area.width, event->area.height);

  if(image_settings_get_value("view eyes",i)) {
   {
     gdk_subimagesel_draw( widget->window, &(sp->subimasel[i]), mpl_gc);
   }
  }
 {
   double *a=matrix_for_image(i);

   if( mpl_gc ) {
     gdk_draw_mesh(widget->window,
		   image_settings_get_value("view original mesh",i),
		   mpl_gc ,
		   (image_settings_get_value("view original points",i))?
		   features_max_n:0,
		   features_gc,
		   0,//image_settings_get_value("view original features",i),
		   &(sp->im_mesh[i]),// MeshT *mesh, 
		   //sp->resulting_height,
		   //sp->resulting_width,
		   a
		   );
     gdk_draw_mesh(widget->window,
		   image_settings_get_value("view warped mesh",i),
		   widget->style->white_gc ,
		   (image_settings_get_value("view warped points",i))?
		   features_max_n:0,
		   features_gc,
		   0,//image_settings_get_value("view warped features",i),
		   &(sp->im_mesh[MAIN_WIN]),// MeshT *mesh,
		   //sp->resulting_height,
		   //sp->resulting_width,
		   a
		   );       
   }
   else   g_critical("colors unavaible: can't draw meshes!");
/*    if( sp->im_editview[i]==EDITVIEW_EYES || */
/*        sp->im_editview[i]==EDITVIEW_EDIT) */
/*      { */
/*        a[2]-=PIXLOADEDBORDER; */
/*        a[5]-=PIXLOADEDBORDER; */
/*      } */
/*    if( sp->im_editview[i]==EDITVIEW_EYES || */
/*        sp->im_editview[i]==EDITVIEW_EDIT) */
/*      { */
/*        a[2]-=PIXLOADEDBORDER; */
/*        a[5]-=PIXLOADEDBORDER; */
/*      } */

 }
 /* after that, we  */
 gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
			    NULL);
 return TRUE;
}
























 

/********************************************************************
 *
 * input image window, top bar buttons
 *

 note: many callbacks are shared with the "resulting image window"

 ******************************************************************
**/



/***********************************************************************
  load/save interface
*/




void check_fs()
{
  /*gtk_widget_destroy(imageselection1_g);*/
  if (! GTK_IS_WIDGET (imageselection1_g))
    {
      g_warning("lost image selection widget\n");
      imageselection1_g = GTK_FILE_SELECTION(create_imageselection1() );
    }
}

/***  show file selector 
      
      if title==NULL, make up a title
      
      adds to the title the window number      

      sets the variable fileselection1_for_image_num_g
*/

void show_fs(GtkWidget *widget,
	     char *title /* fileselection title */
	     ) 
{
  char s[200];
  check_fs();

  //g_assert(fileselection1_for_image_num_g < 0);

  fileselection1_for_image_num_g= 
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 

  g_assert(fileselection1_for_image_num_g > 0);

  {
    int d=fileselection1_for_image_num_g;
    if(d==MAIN_WIN) d=0;
    sprintf(s,"%s %d",
	    ((title==NULL)?
	     gtk_widget_get_name(GTK_WIDGET(widget)) :
	     title)    , d);
  }
 
  gtk_window_set_title(GTK_WINDOW (imageselection1_g), s);  

  gtk_widget_show( GTK_WIDGET(imageselection1_g));
}




void
on_loadimage_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  
  int i = GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 

  fileselection_hook=load_image_from_file;
  
  if (sp->im_filename_in[i] != NULL)
    gtk_file_selection_set_filename ((imageselection1_g),
				     sp->im_filename_in[i] );
  else {
    if(i==MAIN_WIN) i=0;
    gtk_file_selection_set_filename ((imageselection1_g), 
				     g_strdup_printf("image%d.png",i));
  }
  show_fs(GTK_WIDGET(button), _("load image") );  
}

/***** 
       returns TRUE if it was already known
***/
static gboolean
set_fs_mesh_filename(int i)
{
  if ( sp->im_mesh_filename[i] != NULL) {   
      gtk_file_selection_set_filename(imageselection1_g,
				      sp->im_mesh_filename[i]);
      return TRUE;
  } else {
      char *file= sp-> im_filename_in[i];
      
      if(file != NULL) { 
	char *s = g_strdup_printf("%s.mesh",file);
	gtk_file_selection_set_filename(imageselection1_g,  s);
	g_free(s);
      } else
	gtk_file_selection_complete     (imageselection1_g,"*.mesh");
      //gtk_file_selection_set_filename(imageselection1_g,  "");
      return FALSE;
  }
}

void
on_loadmesh_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  int i =
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 
  fileselection_hook=load_mesh_from_file;
  set_fs_mesh_filename(i);
  show_fs(GTK_WIDGET(button), _( "load mesh") ); 
  if(0)
  {
    GtkWidget *b=gtk_button_new_with_label("filter");
    GtkWidget *z=gtk_button_new_with_label("che faccio");
    //imageselection1_g->fileop_dialog=gtk_dialog_new();
    g_return_if_fail(imageselection1_g->fileop_c_dir);
    gtk_widget_hide(imageselection1_g->fileop_c_dir);
    //g_return_if_fail(imageselection1_g->fileop_dialog);
    gtk_widget_show(b);    gtk_widget_show(z);
    //gtk_widget_show(imageselection1_g->fileop_dialog);
    gtk_container_add (GTK_CONTAINER 
		       (GTK_DIALOG(imageselection1_g)->action_area),
		       b);
    gtk_container_add (GTK_CONTAINER 
		       (GTK_DIALOG(imageselection1_g)->vbox),
		       z);
  }
  // gtk_dialog_has_separator(imageselection1_g->fileop_dialog,TRUE);
  //gtk_dialog_add_button(imageselection1_g,"NEW",999);
}


void
on_savemesh_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

  int i = GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 

  fileselection_hook=save_mesh_to_file;
  
  set_fs_mesh_filename(i);

  //FIXME auto save doesnt work
  //if( set_fs_mesh_filename(i) == FALSE|| button->state & GDK_SHIFT_MASK)
  show_fs(GTK_WIDGET(button), _( "save mesh n.") ); 
  //  else
  /* directly simulate as if OK was hit */
  //on_ok_button1_clicked   (NULL,NULL); 
}



void
on_save_image_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  int i = GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 


  GdkPixbuf * pb=*(which_pixbuf_is_visible(i));

  if( pb ==NULL)
    {
      show_error(_("internal error: the image doesnt exist!"));
      return ;
    }

  if( gdk_pixbuf_get_n_channels(pb) != 3)
    {
      show_error
	(g_strdup_printf
	 (  " cant save :-( the image has %d channels", 
	    gdk_pixbuf_get_n_channels(pb)  ));
      return ;
    }
 

  fileselection_hook=save_image_to_file;

  if(sp-> im_filename_out[i] != NULL)  { 
    gtk_file_selection_set_filename
      (GTK_FILE_SELECTION(imageselection1_g),sp-> im_filename_out[i]);
  } else if(!sp-> im_filename_in[i]) {
    char *s = g_strdup_printf("%s_out.ppm",sp-> im_filename_in[i]);
    gtk_file_selection_set_filename
      (GTK_FILE_SELECTION(imageselection1_g), s);
    g_free(s);
  } else 
    gtk_file_selection_set_filename
      (GTK_FILE_SELECTION(imageselection1_g), "");

  show_fs(GTK_WIDGET(button), _( "save image (only PPM format) n.") ); 
}















void
on_settings_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{  
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 
  GtkWidget* m=sp->im_menu_settings[i];
  
  gtk_menu_popup (GTK_MENU(m),//GtkMenu *menu,
		  NULL,//GtkWidget *parent_menu_shell,
		  NULL,//GtkWidget *parent_menu_item,
		  NULL,//GtkMenuPositionFunc func,
		  NULL,//gpointer data,
		  1,//guint button,
		  0);//guint32 activate_time);
}






void
on_do_warp_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(button),"imagenum")); 
 
  /* geometry of the resulting image */
  
  do_warp_an_image(i);
}


/*** this routine behaves correclt even if some image factors 
     are negative; the "do_morph" routine didnt
*/
void
on_do_mixing_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  int lp;
  double  totdiss=tot_mixing_factors_nice();

  int     
    w=sp->resulting_width, h=sp->resulting_height;    
  
  if( sp->max_wins<=1)
    {
      show_warning( _("\
to mix images, you must have at least two input images"));
      return;
    }

  {
    GdkPixbuf *dpb = sp-> im_warped_pixbuf[MAIN_WIN];
    if(dpb==NULL)
      create__pixbuf(MAIN_WIN, PIXWARPED);
  }
  {

    GdkPixbuf *dpb = sp-> im_warped_pixbuf[MAIN_WIN];
    guchar  *ddata = gdk_pixbuf_get_pixels(dpb);	
    
    int drowstride= gdk_pixbuf_get_rowstride (dpb) ;
    
    int i,j , dch= gdk_pixbuf_get_n_channels(dpb);

    double val;
    
    long dp=0; /* data position */
    
    /* we precompute some data */
    double fact[MAX_WINS];
    guint8 *data[MAX_WINS];
    int effective_max_wins=0;
    for ( lp =1; lp <= MAX_WINS; lp++) 
      {
	if(sp->im_widget[lp] != NULL &&	  
	   ABS(sp->mf.im_dissolve_factor[lp]) >= 0.001 )	    
	  {  	     	     	     
	    fact[lp] = sp->mf.im_dissolve_factor[lp] / totdiss;
	    data[lp] =	gdk_pixbuf_get_pixels(sp-> im_warped_pixbuf[lp]);
	    g_assert( data[lp] != NULL);

	    effective_max_wins=lp;
	  }
	else
	  data[lp]=NULL;
      }

    //we clear the old image
    gdk_pixbuf_clear(dpb);

    for( j=0; j<  h ; j++)	      
      {
	dp= drowstride * j;
	/* this interpolates also the alpha value, if any  */
	for( i=0; i< w  * dch ; i++)
	  {
	    val = 0 ;   
	    for ( lp =effective_max_wins; lp >= 1; lp--) {
	      if (data[lp] != NULL)
		{
		  val +=  fact[lp] * (double) (data[lp])[dp + i]  ;
		}}
	    /* if teh image is not 8 bit */ 
	    ddata[dp + i] = CLAMP(val, 0, 255);
	  }
      }
  }
  
  render_pixmap(MAIN_WIN, PIXWARPED);
 
  set_editview(MAIN_WIN,  settings_get_value( "show warp after warp")); 
  gtk_widget_draw (sp->im_widget[MAIN_WIN] , NULL);  
}

void do_mesh_factors_equal()
{
  int lp;
  for ( lp =1; lp <= MAX_WINS; lp++)
    if( sp->im_widget[lp] != NULL)
      sp->mf.im_warp_factor[lp]=1.0/ (double)sp->max_wins;
}

void
on_interpolate_meshes1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  
  int lp,
    nx=sp-> im_mesh[1].nx ,
    ny=sp-> im_mesh[1].ny ;
  double totwarp;

 if( sp->max_wins<=1)
    {
      show_warning( _("\
to interpolate meshes, you must have at least two input images"));
      return;
    }
 totwarp=0;
 for ( lp =1; lp <= MAX_WINS; lp++)
   if( sp->im_widget[lp] != NULL)
     totwarp += sp->mf.im_warp_factor[lp];
 // FIXME this is not shown
 sp->mf.im_warp_factor[MAIN_WIN]=totwarp;
 
 if ( ABS(totwarp)< 0.0001) {
   show_warning( _("\
to interpolate the meshes, the sum of the all `mesh factors' should be nonzero\n\
I have set some default values for you") );
   do_mesh_factors_equal();
   totwarp =1;
   redraw_spins(-3);
 }
 {
   int xi, yi;  
   double vx,vy;
     
     for(yi=0; yi < ny; yi++) {
       for(xi=0; xi < nx; xi++) {
	 vx=vy=0;
	 for ( lp =1; lp <= MAX_WINS; lp++)
	   if( sp->im_widget[lp] != NULL)
	     {
	       vx += meshGetx( &(sp->im_mesh[lp]), xi, yi)
		 * sp->mf.im_warp_factor[lp];
	       vy += meshGety( &(sp->im_mesh[lp]), xi, yi)
		 * sp->mf.im_warp_factor[lp];	      
	     }
	 //printf("%d %d %f %f\n",  xi, yi, vx, vy);
	 meshSetNoundo((&(sp->im_mesh[MAIN_WIN])),  xi, yi, vx /totwarp, vy /totwarp);
       }}
  }
  for ( lp =1; lp <= MAX_WINS; lp++)
    if( sp->im_widget[lp] != NULL)
      gtk_widget_draw (sp->im_widget[lp], NULL);
}




/*****************************************************************************

 *               edit/view option menu

 ****************************************************************************/





void
on_optionmenu_editview_released        (GtkButton       *button,
                                        gpointer         user_data)
{
  /* this signal is (almost) never emitted
  printf("the choice is %s \n",
	 gtk_widget_get_name(gtk_menu_get_active (GTK_MENU(user_data)))); 
   */
}


void
on_optionmenu_editview_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  /* this signal is never emitted
     printf("the click choice is %s \n",
     gtk_widget_get_name(gtk_menu_get_active (GTK_MENU(user_data)))); 
  */
}


void
on_optionmenu_editview_pressed         (GtkButton       *button,
                                        gpointer         user_data)
{
  /* this signal is never emitted
  g_message("at %s %d PRESSED" ,__FILE__ , __LINE__);
  */
}



/* since the 3 above do not work... this comes from the glade FAQ */
void
on_optionmenu_editview__selected (GtkMenuShell *menu_shell,
                    gpointer data)
{
  GtkWidget *active_item;
  gint item_index;

  /* the following fails: the menu_shell has a different window
    int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(data),
					     "imagenum")); 
  */
  int i=
    GPOINTER_TO_UINT(data);
  g_assert(i>0);

  active_item = gtk_menu_get_active (GTK_MENU (menu_shell));
  item_index = g_list_index (menu_shell->children, active_item);

  /* thanks GOD this works!!
    g_print ("In on_option_selected active: %i\n", item_index);*/
  sp->im_editview[i]=item_index;

  editview_callback(i);

  gtk_widget_draw (sp->im_widget[i] , NULL);
}















/*
**********************************************************************

************** resulting image,  spinbuttons      ********************

**********************************************************************
*/


void
on_resulting_apply_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{

  int lp;
  for( lp =1; lp <= MAIN_WIN; lp++)
    if ( sp->im_widget[lp] ) 
      {       
	destroy_image_win_pixbufs(lp,1);
      }

  sp->resulting_width =  sp->resulting_width_sp;
  sp->resulting_height = sp->resulting_height_sp;


  for( lp =1; lp <= MAIN_WIN; lp++)
   if ( sp->im_widget[lp] ) 
     {
       alloc_image_win_data(lp,1);
       {
	 int j ; 
	 for (j=2;j>=1;j--) {
	   //  do this now-- need a window --
	   create__pixmap(lp,j);
	 }
       }
       subimage2affines(lp);
       reload_and_scale_image(lp);

       meshScale( &(sp->im_mesh[lp]),
		  //(double)sp->resulting_width_sp/
		  (double)sp->resulting_width, 
		  //(double)sp->resulting_height_sp/
		  (double)sp->resulting_height);
    

       drawingarea_configure(lp);
       gtk_widget_draw( sp-> im_widget[lp], NULL);  
     }
  {
    GtkWidget* hb= lookup_widget  ( sp->im_widget[MAIN_WIN]  ,
				    "handlebox_res_size");
    g_assert(hb);
    gtk_widget_hide(hb);
  }
  guide_callback("resulting size",MAIN_WIN);
}


void spinbutton_res_set()
{
  GtkWidget *widget=lookup_widget(sp->im_widget[MAIN_WIN],
				  "spinbutton_reswidth");
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),
			     sp->resulting_width_sp );
  widget=lookup_widget(sp->im_widget[MAIN_WIN],"spinbutton_resheight");
  gtk_spin_button_set_value (GTK_SPIN_BUTTON(widget),
			     sp->resulting_height_sp );
}

void
on_spinbutton_reswidth_changed         (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton *spin = GTK_SPIN_BUTTON (editable);
  sp->resulting_width_sp =gtk_spin_button_get_value_as_float (spin);
}


void
on_spinbutton_resheight_changed        (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton *spin = GTK_SPIN_BUTTON (editable);
  sp->resulting_height_sp =gtk_spin_button_get_value_as_float (spin);
}





void
on_double_size_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  if( sp->resulting_height_sp <= 5000 &&  sp->resulting_width_sp <= 5000 ) {
    sp->resulting_height_sp *= 2;
    sp->resulting_width_sp *=2;
    spinbutton_res_set();
    gtk_widget_draw( sp-> im_widget[MAIN_WIN], NULL);  
  }
}


void
on_halve_size_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  if( sp->resulting_height_sp > 8 &&  sp->resulting_width_sp > 8 ) {
    sp->resulting_height_sp /= 2;
    sp->resulting_width_sp /= 2;
    spinbutton_res_set();
    gtk_widget_draw( sp-> im_widget[MAIN_WIN], NULL);  
  }
}



/***********************************************************************
**********************************************************************

image windows callbacks


 note: many callbacks are shared with the "resulting image window"

**********************************************************************
*/


gboolean
on_image_win_1_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{  
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 

  mag_xy_track(MAIN_WIN,0,0);

  destroy_image_win_data(i);

  sp->mf.im_warp_factor[i]=0;
  sp->mf.im_dissolve_factor[i]=0;



  return FALSE;
}

/***************************************************************

 *		drawing area mesh editing

 ***********************************************************
*/ 





/******************************* sometimes when we change the labels..*/
int all_images_need_redraw=0;


static void
flash_point(GdkDrawable  *drawable,
	    int x,int y	    )
{ 
  int MP_SIZE=10, MP_ARC=360 * 64;
  extern GdkGC *flash_gc;
  gdk_draw_arc  (drawable, flash_gc,
		 TRUE,
		 x - MP_SIZE/2,  y - MP_SIZE/2, MP_SIZE,MP_SIZE,0,MP_ARC);
}

guint flash_points_id;
int flash_mi=0,flash_mj=0;

static gboolean flash_points(gpointer ignored)
{
  int lp=MAIN_WIN; 
  all_images_need_redraw++;
  for(; lp>=0; lp--) 
    if(sp->im_widget[lp] != NULL) {
      flash_point(sp->im_drawingarea_widget[lp]->window,
		  PIXEDITBORDER+meshGetx(&sp->im_mesh[lp],flash_mi,flash_mj),
		  PIXEDITBORDER+meshGety(&sp->im_mesh[lp],flash_mi,flash_mj)    );
		  
    }
  return TRUE;
}


gboolean
on_drawingarea_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  int i= GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  g_assert(i > 0);


  if(sp->im_editview[i]==EDITVIEW_EYES  )     
    return FALSE;//gdk_subimagesel_button_press_event (widget,event,user_data);

  if( ( i == MAIN_WIN) && sp->max_wins>1 &&
      settings_get_value("automatic mesh interpolation")
      //&& EDITVIEW_FEATURES != sp->im_editview[MAIN_WIN]
      ) 
    { 
      show_warning(_("you cant edit this mesh - it is automatically generated as an interpolation\nof the input images meshes .\n(but if you really want to edit, unset 'automatic mesh interpolation')"));
      return FALSE;     
    }

  /* if the menu says "view", do not edit */
  if( sp->im_editview[i] == EDITVIEW_SHOWMESHES ||
      sp->im_editview[i] == EDITVIEW_SHOW  )
    {
      show_warning(_("\
You are currently viewing the warped version of the image\n\
you may not edit this mesh (which refers to the loaded image).\n\
To edit the mesh, select `edit mesh' in the menu (at top center).\n\
I have done it now for you")); 
      set_editview(i, EDITVIEW_EDIT); 
      return FALSE; 
    }
  if(i!=MAIN_WIN)
    {
      /* hide bar-makes room for editing */
      GtkWidget* hb= lookup_widget  ( sp->im_widget[i]  ,
				      "handlebox_factors");
      GtkWidget* hs= lookup_widget  ( sp->im_widget[i]  ,
				      "handleboxsubimage");
      gtk_widget_hide(hb);gtk_widget_hide(hs);
    }
  {
    int mi,mj,mlabel; enum tools action;
    gboolean b;
    b= gdk_mesh_key_press_event  (widget,event,
				  user_data, &(sp->im_mesh[i]),
				  &mi,&mj,&mlabel, &action
				  );
    {
      int x,y; //,dx,dy;
      //long d;
      GdkModifierType state;
      gdk_window_get_pointer (event->window, &x, &y, &state);
      mag_xy_track(i,x,y);
    }
    //if(b && event->button==1) { flash_mi=mi; flash_mj=mj;
    //  flash_points_id=gtk_timeout_add(200,flash_points,NULL);
    //}
    return b;
  }

  return FALSE;
}



gboolean
on_button_press_event                  (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  int i= GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  g_assert(i > 0);
  //mag_start_track(i,event);

  if(sp->im_editview[i]==EDITVIEW_EYES  )     
    return gdk_subimagesel_button_press_event (widget,event,user_data);  

  if( ( i == MAIN_WIN) && sp->max_wins>1 &&
      settings_get_value("automatic mesh interpolation")
      ) 
    { 
      show_warning(_("you cant edit this mesh - it is automatically generated as an interpolation\nof the input images meshes .\n(but if you really want to edit, unset 'automatic mesh interpolation')"));
      return FALSE;     
    }

  /* if the menu says "view", do not edit */
  if( sp->im_editview[i] == EDITVIEW_SHOWMESHES ||
      sp->im_editview[i] == EDITVIEW_SHOW  )
    {
      show_warning(_("\
You are currently viewing the warped version of the image\n\
you may not edit this mesh (which refers to the loaded image).\n\
To edit the mesh, select `edit mesh' in the menu (at top center).\n\
I have done it now for you")); 
      set_editview(i, EDITVIEW_EDIT); 
      return FALSE; 
    }
  if(i!=MAIN_WIN)
    {
      /* hide bar-makes room for editing */
      GtkWidget* hb= lookup_widget  ( sp->im_widget[i]  ,
				      "handlebox_factors");
      GtkWidget* hs= lookup_widget  ( sp->im_widget[i]  ,
				      "handleboxsubimage");
      gtk_widget_hide(hb);gtk_widget_hide(hs);
    }
  {
    int mi,mj,mlabel; enum tools action;
    gboolean b;
    b= gdk_mesh_button_press_event  (widget,event,
				     user_data, &(sp->im_mesh[i]),
				     &mi,&mj,&mlabel, &action);   
    if(b && event->button==1) { flash_mi=mi; flash_mj=mj;
      flash_points_id=gtk_timeout_add(200,flash_points,NULL);
      gtk_widget_grab_focus (widget);
    }
    return b;
  }
}




gboolean
on_motion_notify_event                 (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  g_assert(i > 0);

  if(sp->im_editview[i]==EDITVIEW_EYES )
    return gdk_subimagesel_motion_notify_event (widget,event,user_data);

  if( ( i == MAIN_WIN) && sp->max_wins>1 &&
      settings_get_value("automatic mesh interpolation"))
    return FALSE;

  /* if the menu says "view", do not edit */
  if (sp->im_editview[i] == EDITVIEW_SHOWMESHES ||
      sp->im_editview[i] ==EDITVIEW_SHOW )
    return FALSE;
  

  {
    int mi,mj;
    //g_warning("mesh");
    gboolean b=gdk_mesh_motion_notify_event   (widget,event,
					       user_data, &(sp->im_mesh[i]),
					       &mi,&mj);


    //FIXME if movement is an hint, it does not work
  event->x-= PIXEDITBORDER;
  event->y-= PIXEDITBORDER;

  mag_track(i,event);

  return b;
      {
	//if(settings_get_value("mesh auto sync"))
	//  flash_points(NULL);

      }
  }

}

void redraw_images()
{
  int lp=MAX_WINS; for(; lp>=0; lp--) 
    if(sp->im_widget[lp] != NULL) {	 	
      gtk_widget_draw (sp->im_drawingarea_widget[lp] , NULL);	
    }
  all_images_need_redraw=0;
}

gboolean
on_drawingarea_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  gboolean bool;
  if(flash_points_id)
    gtk_timeout_remove(flash_points_id);
 
  g_assert(i > 0);
  if(//event->state & GDK_BUTTON1_MASK && 
     sp->im_editview[i]==EDITVIEW_EYES )  {
      bool= gdk_subimagesel_button_release_event (widget,event,user_data);
      if (bool && i == MAIN_WIN )
	all_images_need_redraw++;
  } else {
    // FIXME perche'??????????
    //if( ( i == MAIN_WIN) && sp->max_wins>1) {
    //  if(settings_get_value("automatic mesh interpolation")) {
    //on_interpolate_meshes1_activate(NULL,NULL);
    //	gtk_widget_draw (sp->im_drawingarea_widget[MAIN_WIN] , NULL);
    // }
    //return FALSE;
    //}

    /* if the menu says "view", do not edit */
    if (sp->im_editview[i] == EDITVIEW_SHOWMESHES || sp->im_editview[i]==EDITVIEW_SHOW )
      return FALSE;
    
    { 
      int mi,mj; 
      bool=gdk_mesh_button_release_event    ( widget,event,
					      user_data, &(sp->im_mesh[i]),
					      &mi,&mj);
      if( settings_get_value("automatic mesh interpolation")&& sp->max_wins>1)
	{
	  on_interpolate_meshes1_activate(NULL,NULL);	 
	  gtk_widget_draw (sp->im_drawingarea_widget[MAIN_WIN] , NULL);
	}      
      set_frame_label(i);

 ///this needs a lot of work
      if(settings_get_value("cursor jump"))
      {
	GtkWidget *d=gtk_widget_get_data_top((sp->im_widget[i]),
					     "scrolledwindow_image");
	//if(d)
	// d=gtk_widget_get_parent(d);
	if(d) {
	  gint width, height;
#if GTK_MAJOR_VERSION == 1
	  //gtk_widget_get_usize(d,&width,&height);
    //  gdk_window_get_size(drawable,&width,&height);
#else
    // gdk_drawable_get_size(drawable,&width,&height);
#endif
	  GtkAdjustment* H=gtk_scrolled_window_get_hadjustment
	    (GTK_SCROLLED_WINDOW(d));
	  GtkAdjustment* V=gtk_scrolled_window_get_vadjustment
	    (GTK_SCROLLED_WINDOW(d));

	  width=d->allocation.width;
	  height=d->allocation.height;

	  //g_message("scroll frame window %d %d", width,height);
	  if(H && V) {
	    H->value=event->x-width/2;
	    V->value=event->y-height/2;
	    gtk_scrolled_window_set_hadjustment(d,H);
	    gtk_scrolled_window_set_vadjustment(d,V);
	    gtk_adjustment_value_changed(H);
	    gtk_adjustment_value_changed(V);
	  }  else  g_warning("adjustments of scrolls %i unavailable",i);
	} else  g_warning("scrooolls %i unavailable",i);
      }


    }
  }


  if ( all_images_need_redraw) {
    redraw_images();
  }
  else { 
    gtk_widget_draw (widget , NULL);  
  }
  return bool;
}




/***************************************************************************
**************************************************************************

                  handlebox of ranges 

              ****************************

  used to enter the numerical values for im_warp_factor
  and  im_dissolve_factor

**********************************************************************
 */



void 
on_handlebox_factors_show                     (GtkWidget       *widget,
					       gpointer         user_data)
{
/*   int i= */
/*     GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum"));  */
/*   g_assert(i > 0); */
/*   //FIXME this doesnt work since we use a different window in glade */
/*   // so it is actually unused now */
/*   if ( i == MAIN_WIN) */
/*     gtk_widget_hide(widget); */
}

gboolean lock_factor_normalize= 0;

void im_factor_normalize(double *p, int i)
{
  double t=0,tt=0;
  int lp;
  
  if(lock_factor_normalize)
  {
  	g_debug("factor normalize is locked");
  	return;
  }	
  lock_factor_normalize=!0;
  
  if((p==sp->mf.im_warp_factor && 
      0== settings_get_value("mesh factors sum to 1"))
     || 
     (p==sp->mf.im_dissolve_factor && 
      0== settings_get_value("image factors sum to 1")))
    return;

  for (lp=1 ; lp<=MAX_WINS ; lp++)
    if(sp->im_widget[lp] != NULL ) {
      tt += p[lp];
      if(i!=lp) t+= p[lp];
    }

  for (lp=1 ; lp<=MAX_WINS ; lp++)
    if(sp->im_widget[lp] != NULL ) {
      if(i!=lp) {
	if(sp->max_wins==2) 
	  p[lp] = 1-p[i];
	else {
	  if( ABS(t) > 0.01)
	    p[lp] = p[lp] * (1 - p[i]) / t;
	  else
	    p[lp] = (1 - p[i]) / ((double) sp->max_wins-1.0) ;
	}
      }
    }
  redraw_spins(i);
  lock_factor_normalize=0;
}

void
redraw_spins(int skip)
{
  int lp;
  GtkWidget *w;
  GtkSpinButton *s;
  for (lp=1 ; lp<=MAX_WINS ; lp++) {
    w=sp->im_widget[lp];
    if ( w != NULL) {
      if( lp!=skip ) {
	s=GTK_SPIN_BUTTON(lookup_widget(w,"spinbutton_mesh"));
	gtk_spin_button_set_value (s,sp->mf.im_warp_factor[lp] * 100);
	s=GTK_SPIN_BUTTON(lookup_widget(w,"spinbutton_image"));
	gtk_spin_button_set_value (s,sp->mf.im_dissolve_factor[lp] * 100);
      }
      set_frame_label(lp);
    }
  }
}



void
on_spinbutton_mesh_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton *spin = GTK_SPIN_BUTTON (editable);
  GtkRange *range=GTK_RANGE(lookup_widget(GTK_WIDGET(editable),
					  "hscale_mesh"));

  double val;
  int i=GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(editable)
						 ,"imagenum"));

  g_debug ( "spin mesh %d %0.*f\n",i, spin->digits,
  	      gtk_spin_button_get_value_as_float (spin));

  
  sp->mf.im_warp_factor[i]=val=gtk_spin_button_get_value_as_float (spin)/100.0;
  im_factor_normalize(sp->mf.im_warp_factor,i);
  g_debug(" spin mesh %d %f\n",i,sp->mf.im_warp_factor[i]);
  if(range) {     
    range->adjustment->value=val * 100;
    gtk_signal_emit_by_name (GTK_OBJECT (range->adjustment), "changed");
    
    if( settings_get_value("automatic mesh interpolation")&& sp->max_wins>1)
      on_interpolate_meshes1_activate        (NULL,NULL);
  } else g_critical("no adjustment");    
  set_frame_label(i);
}


void
on_spinbutton_image_changed            (GtkEditable     *editable,
                                        gpointer         user_data)
{
  GtkSpinButton *spin = GTK_SPIN_BUTTON (editable);
  //GtkRange *range=GTK_RANGE(user_data);
  GtkRange *range=GTK_RANGE(lookup_widget(GTK_WIDGET(editable),
					  "hscale_image"));
  double val;
  int i=GPOINTER_TO_UINT(gtk_widget_get_data_top(GTK_WIDGET(editable),
						 "imagenum"));
    
  g_debug ( "spin image %d %0.*f\n",i, spin->digits,
  	      gtk_spin_button_get_value_as_float (spin));
  
  sp->mf.im_dissolve_factor[i]=val=gtk_spin_button_get_value_as_float (spin)/100.0; 
  im_factor_normalize(sp->mf.im_dissolve_factor, i);
  g_debug(" spin image %d %f\n",i,sp->mf.im_warp_factor[i]);
 
  if(range) {
    range->adjustment->value=val * 100;
    gtk_signal_emit_by_name (GTK_OBJECT (range->adjustment), "changed");

    if( settings_get_value("automatic blending")&& sp->max_wins>1)
      on_do_mixing_clicked        (NULL,NULL);
  } else g_critical("no v adjustment");
}


gboolean
on_hscale_mesh_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkRange *range=GTK_RANGE(widget);
  //GtkSpinButton *spin=GTK_SPIN_BUTTON(user_data);
  GtkSpinButton *spin=GTK_SPIN_BUTTON(lookup_widget(widget,"spinbutton_mesh"));

  if(spin) {
    gtk_spin_button_set_value (spin, range->adjustment->value);
  } else g_critical("no adjustment");
  return FALSE;
}

gboolean
on_hscale_image_button_release_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkRange *range=GTK_RANGE(widget);
  //GtkSpinButton *spin=GTK_SPIN_BUTTON(user_data);
  GtkSpinButton *spin=GTK_SPIN_BUTTON(lookup_widget(widget,"spinbutton_image"));
  if(spin) {  
    gtk_spin_button_set_value (spin, range->adjustment->value);
  } else g_critical("no adjustment");
  return FALSE;
}






















/****************************************************************************/






gboolean
on_window_warped_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  g_return_val_if_fail(i > 0,FALSE);
  g_return_val_if_fail(sp->im_warped_widget[i] == widget,FALSE);
  sp->im_warped_widget[i]=NULL;
  return FALSE;
}


gboolean
on_drawingarea_warped_expose_event     (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  //  int w=sp->resulting_width, h=sp->resulting_height;
  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  GdkPixmap *pixmap = sp->im_warped_pixmap[i];
  g_assert(i > 0);
  g_assert(pixmap != NULL);
  gdk_gc_set_clip_rectangle (widget->style->fg_gc[widget->state],
			     &event->area);
  g_assert( pixmap);
  gdk_draw_pixmap(widget->window,
		  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		  pixmap,
		  event->area.x, event->area.y,
		  event->area.x, event->area.y,
		  event->area.width, event->area.height);

 
  return TRUE;
}



gboolean
on_drawingarea_warped_configure_event  (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{

  int i=
    GPOINTER_TO_UINT(gtk_widget_get_data_top(widget,"imagenum")); 
  //GdkPixmap *pixmap = sp->im_pixmap_subimage[i];
  g_assert(i>0);
  
  return FALSE;
}














/*********************************************************************
**********************************************************************

 * warning dialog hook
 FIXME: I think this is not the right way to do it

**********************************************************************
**********************************************************************
**/


/* the text of the warning */
char dialogwarning_text[1001]="";

 
void
on_labelwarning_show                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_label_set_text              (GTK_LABEL(widget),
				   dialogwarning_text);
}

void
on_labelwarning_realize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_label_set_text              (GTK_LABEL(widget),
				   dialogwarning_text);
}





//GtkWidget *menu_image_num_g=NULL;

void show_info(const char *str)
{
  strncpy(dialogwarning_text,str,1000);
  dialogwarning_g= create_dialogwarning();
  gtk_window_set_title(GTK_WINDOW(dialogwarning_g),"info");
  gtk_widget_show(dialogwarning_g);
}

void show_warning(const char *str)
{
  strncpy(dialogwarning_text,str,1000);
  if(settings_get_value("no warnings")==0) {
    dialogwarning_g= create_dialogwarning();
    gtk_window_set_title(GTK_WINDOW(dialogwarning_g),"warning");
    gtk_widget_show(dialogwarning_g);
  }
  else
    gdk_beep();
}

void show_error(const char *str)
{
  strncpy(dialogwarning_text,str,1000);
  dialogwarning_g= create_dialogwarning();
  gtk_window_set_title(GTK_WINDOW(dialogwarning_g),"error");
  gtk_widget_show(dialogwarning_g);
  gdk_beep();
}

void
on_why_the_beep_1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 if(*dialogwarning_text) {
   dialogwarning_g= create_dialogwarning();
   gtk_widget_show(dialogwarning_g);
 }
 *dialogwarning_text=0;
}







/******************* new glade callbacks *********************/

gboolean
on_dialogwarning_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_question_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_yes_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  //GtkWidget *b=lookup_widget(GTK_WIDGET(button),"question");
  //gtk_widget_destroy(b);
}


void
on_no_clicked                          (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *b=lookup_widget(GTK_WIDGET(button),"question");
  gtk_widget_destroy(b);
}


