/*=============================================================================
XMOTO

This file is part of XMOTO.

XMOTO is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

XMOTO is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with XMOTO; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
=============================================================================*/

#include "StateWaitServerInstructions.h"
#include "../net/NetClient.h"
#include "StateManager.h"
#include "StatePreplayingNet.h"
#include "../Game.h"
#include "../GameText.h"
#include "../drawlib/DrawLib.h"

StateWaitServerInstructions::StateWaitServerInstructions(const std::string& i_id):
GameState(true, false, true, true)
{
  m_name = "StateWaitServerInst";
  setId(i_id);

  m_showCursor = false;

  m_renderFps = 30;
  m_updateFps = 30;

  StateManager::instance()->registerAsObserver("CLIENT_DISCONNECTED_BY_ERROR", this);
  StateManager::instance()->registerAsObserver("NET_PREPARE_PLAYING", this);
}

StateWaitServerInstructions::~StateWaitServerInstructions()
{
  StateManager::instance()->unregisterAsObserver("CLIENT_DISCONNECTED_BY_ERROR", this);
  StateManager::instance()->unregisterAsObserver("NET_PREPARE_PLAYING", this);
}

bool StateWaitServerInstructions::render() {
  FontManager* v_fm;
  FontGlyph* v_fg;

  GameState::render();

  v_fm = GameApp::instance()->getDrawLib()->getFontMedium();
  v_fg = v_fm->getGlyph(GAMETEXT_WAIT_XMSERVER);
  v_fm->printString(v_fg,
		    (GameApp::instance()->getDrawLib()->getDispWidth() - v_fg->realWidth())   /2,
		    (GameApp::instance()->getDrawLib()->getDispHeight() - v_fg->realHeight()) /2,
		    MAKE_COLOR(220,255,255,255), -0.5, true);


  return true;
}

void StateWaitServerInstructions::executeOneCommand(std::string cmd, std::string args) {
  if(cmd == "CLIENT_DISCONNECTED_BY_ERROR") {
    m_requestForEnd = true;
  } else if(cmd == "NET_PREPARE_PLAYING") {
    StateManager::instance()->replaceState(new StatePreplayingNet(getId(), args, true),
					   this->getId());
  } else {
    GameState::executeOneCommand(cmd, args);
  }
}

void StateWaitServerInstructions::xmKey(InputEventType i_type, const XMKey& i_xmkey) {
  if(i_type == INPUT_DOWN && i_xmkey == XMKey(SDLK_ESCAPE, KMOD_NONE)) {
    /* quit this state */
    m_requestForEnd = true;
    if(NetClient::instance()->isConnected()) {
      NetClient::instance()->disconnect();
    }
  }

  else {
    GameState::xmKey(i_type, i_xmkey);
  }

}
