// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://www.xmule.org/)
// RSA-1024 Fingerprint: 4145 9DFD 5338 4FCC 1636  86E5 2E5A 42D8 BA13 460B
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <wx/wx.h>
#include <wx/sckaddr.h>

#include <netdb.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "NewSockets.h"
#include "ClientUDPSocket.h"

int new_socketcount=0;
wxUint32 new_ip[10000]; 
wxUint16 new_port[10000]; 

CClientUDPSocket 	*clientudp;

void NewSocket_Start(wxUint8 type,wxUint32 ip,wxUint16 port)
{
	switch(type) {
	case 1:
  	wxIPV4address addr;
	if(!ip) {
	 	addr.AnyAddress();
		addr.Service(port);
	} else {
	 	addr.AnyAddress();
		addr.Service(port);
	}
	clientudp=new CClientUDPSocket(addr);
	break;
	}
}

void NewSocket_Stop(wxUint8 type)
{
	switch(type) {
	case 1:
		clientudp->Destroy();
		break;
	}
}

void NewSocket_SendPacket(wxUint8 type,Packet *packet,wxUint32 ip,wxUint16 port)
{
	switch(type) {
	case 1:
  	clientudp->SendPacket(packet,ip,port);
		break;
	}
}
