/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/coord_xif.cc,v 1.24 2009/01/05 18:31:12 jtc Exp $"

#include "coord_xif.hh"

bool
XrlCoordV0p1Client::send_command(
	const char*	dst_xrl_target_name,
	const string&	command,
	const CommandCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "coord/0.1/command");
        x->args().add(XrlAtom(command));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, command);

    return _sender->send(*x, callback(this, &XrlCoordV0p1Client::unmarshall_command, cb));
}


/* Unmarshall command */
void
XrlCoordV0p1Client::unmarshall_command(
	const XrlError&	e,
	XrlArgs*	a,
	CommandCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlCoordV0p1Client::send_status(
	const char*	dst_xrl_target_name,
	const string&	peer,
	const StatusCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "coord/0.1/status");
        x->args().add(XrlAtom(peer));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, peer);

    return _sender->send(*x, callback(this, &XrlCoordV0p1Client::unmarshall_status, cb));
}


/* Unmarshall status */
void
XrlCoordV0p1Client::unmarshall_status(
	const XrlError&	e,
	XrlArgs*	a,
	StatusCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    string status;
    try {
	a->get("status", status);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &status);
}

bool
XrlCoordV0p1Client::send_pending(
	const char*	dst_xrl_target_name,
	const PendingCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "coord/0.1/pending");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlCoordV0p1Client::unmarshall_pending, cb));
}


/* Unmarshall pending */
void
XrlCoordV0p1Client::unmarshall_pending(
	const XrlError&	e,
	XrlArgs*	a,
	PendingCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool pending;
    try {
	a->get("pending", pending);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &pending);
}
