#!/usr/bin/env python
import os,shutil
#os.environ['PATH'] += ';'+os.path.join('gtk/lib')+';'+os.path.join('gtk/bin') #OLD
#os.environ['PATH'] = os.path.join('gtk/lib')+';'+os.path.join('gtk/bin')+';'+os.path.join('gtk\\lib')+';'+os.path.join('gtk\\bin')+';'+os.environ['PATH']  #NEW


import sys
import shelve
import gtk
import gobject
import pango
import cPickle
import time
import re
import platform
import glob
import gettext
import locale
import webbrowser
import ConfigParser
from urllib import quote as url_quote
from optparse import OptionParser
from email.Utils import parsedate_tz, mktime_tz
from xpn_src.Groups_Pane import Groups_Pane
from xpn_src.Threads_Pane import Threads_Pane
from xpn_src.Article_Pane import Article_Pane
from xpn_src.Groups_Win import Groups_Win
from xpn_src.Config_File import Config_File
from xpn_src.Config_Win import Config_Win
from xpn_src.Edit_Win import Edit_Win
from xpn_src.Edit_Mail_Win import Edit_Mail_Win
from xpn_src.Dialogs import About_Dialog, Dialog_YES_NO, Error_Dialog, MidDialog, Dialog_OK, Dialog_Import_Newsrc
from xpn_src.Article import Article, Article_To_Send
from xpn_src.Show_Logs import Logs_Window
from xpn_src.Newsrc import ImportNewsrc, ExportNewsrc
from xpn_src.Find_Win import Find_Win, Search_Win, GlobalSearch
from xpn_src.Score import Score_Rules, Score_Win
from xpn_src.Charset_List import load_ordered_list
from xpn_src.Connections_Handler import Connection, SMTPConnection, SSLConnection
from xpn_src.UserDir import UserDir, get_wdir
from xpn_src.Outbox_Manager import Outbox_Manager
from xpn_src.KeyBindings import KeyBindings, load_shortcuts
from xpn_src.Server_Win import NNTPServer_Win
from xpn_src.Groups_Vs_ID import Groups_Vs_ID
try:
    set()
except:
    from sets import Set as set

try:
    user_system=" ; "+platform.system()
except:
    user_system=""

NUMBER="1.0.0"
VERSION="XPN/%s (Monkey Business%s)" % (NUMBER,user_system)

gettext.NullTranslations()
gettext.install("xpn")

ui_string="""<ui>
    <menubar name='MainMenuBar'>
        <menu action='File'>
            <menuitem action='groups' />
            <separator/>
            <menuitem action='rules' />
            <separator/>
            <menuitem action='logs' />
            <separator/>
            <menuitem action='exp_newsrc' />
            <menuitem action='imp_newsrc' />
            <separator />
            <menuitem action='accelerator' />
            <separator />
            <menuitem action='conf' />
            <separator />
            <menuitem action='exit' />
        </menu>
        <menu action='Subscribed'>
            <menuitem action='gethdrs' />
            <menuitem action='gethdrssel' />
            <menuitem action='getbodies' />            
            <menuitem action='getbodiessel' />
            <separator />   
            <menuitem action='expand_row' />
            <menuitem action='collapse_row' />
            <menuitem action='expand' />
            <menuitem action='collapse' />
            <separator />
            <menuitem action='group' />
            <separator />
            <menu action='mark_group'>
                <menuitem action='mark' />
                <menuitem action='mark_unread_group' />
                <menuitem action='mark_download_group' />
                <menuitem action='keepall' />
                <separator />
                <menuitem action='markall' />
                <menuitem action='markall_unread' />
            </menu>
            <separator />
            <menu action='view_group_opts'>
                <menuitem action='show_threads' />
                <menuitem action='show_all_read_threads' />
                <menuitem action='show_read_articles' />
                <menuitem action='show_unread_articles' />
                <menuitem action='show_kept_articles' />
                <menuitem action='show_unkept_articles' />
                <menuitem action='show_watched_articles' />
                <menuitem action='show_ignored_articles' />
                <menuitem action='show_unwatchedignored_articles' />
                <menuitem action='show_score_neg_articles' />
                <menuitem action='show_score_zero_articles' />
                <menuitem action='show_score_pos_articles' />
            </menu>
            <separator />
            <menuitem action='find' />
            <menuitem action='global' />
            <separator />
            <menuitem action='apply_score' />
            <separator />
            <menuitem action='groups_vs_id' />
            
        </menu>
        <menu action='Articles'>
            <menuitem action='previous' />
            <menuitem action='next' />
            <menuitem action='next_unread' />
            <menuitem action='parent' />
            <menuitem action='one_key' />
            <menuitem action='move_up' />
            <separator />
            <menuitem action='search' />
            <separator />
            <menu action='view_articles_opts'>
                <menuitem action='raw' />
                <menuitem action='spoiler' />
                <menuitem action='show_quote' />
                <menuitem action='show_sign' />
                <menuitem action='fixed' />
                <menuitem action='show_hide_headers' />
                <menuitem action='rot13' />
            </menu>
            <separator />
            <menu action='flags'>
                <menuitem action='mark_read' />
                <menuitem action='mark_unread' />
                <menuitem action='mark_download' />
                <menuitem action='keep' />
                <separator />
                <menuitem action='mark_read_sub' />
                <menuitem action='mark_unread_sub' />
                <menuitem action='mark_download_sub' />
                <menuitem action='keep_sub' />
                <menuitem action='watch' />
                <menuitem action='ignore' />
                <separator />
                <menuitem action='raise_score' />
                <menuitem action='lower_score' />
                <menuitem action='set_score' />
            </menu>
            <separator />
            <menuitem action='post' />
            <menuitem action='followup' />
            <menuitem action='reply' />
            <menuitem action='outbox_manager' />
            <separator />
            <menuitem action='cancel' />
            <menuitem action='supersede' />
        </menu>
        <menu action='Help'>
            <menuitem action='about' />
        </menu>
    </menubar>
            
    <popup action='mark_group'>
        <menuitem action='mark' />
        <menuitem action='mark_unread_group' />
        <menuitem action='mark_download_group' />
        <menuitem action='keepall' />
        <separator />
        <menuitem action='markall' />
        <menuitem action='markall_unread' />
    </popup>
    
    <popup action='flags'>
        <menuitem action='mark_read' />
        <menuitem action='mark_unread' />
        <menuitem action='mark_download' />
        <menuitem action='keep' />
        <separator />
        <menuitem action='mark_read_sub' />
        <menuitem action='mark_unread_sub' />
        <menuitem action='mark_download_sub' />
        <menuitem action='keep_sub' />
        <menuitem action='watch' />
        <menuitem action='ignore' />
        <separator />
        <menuitem action='raise_score' />
        <menuitem action='lower_score' />
        <menuitem action='set_score' />
    </popup>


    <toolbar name='MainToolBar'>
        <toolitem action='groups' />
        <toolitem action='gethdrs' />
        <toolitem action='getbodies' />
        <toolitem action='mark' />
        <toolitem action='markall' />
        <separator />
        <toolitem action='post' />
        <toolitem action='followup' />
        <toolitem action='reply' />
        <toolitem action='outbox_manager' />
        <separator />
        <toolitem action='previous' />
        <toolitem action='next' />
        <toolitem action='next_unread' />
        <toolitem action='rot13' />
        <separator />
        <toolitem action='expand_row' />
        <toolitem action='collapse_row' />
        <toolitem action='expand' />
        <toolitem action='collapse' />
        <separator />
        <toolitem action='rules' />
        <toolitem action='conf' />
    </toolbar>

</ui>"""

def escape(data):
    """Escape &, <, and > in a string of data.
    """

    # must do ampersand first
    data = data.replace("&", "&amp;")
    data = data.replace(">", "&gt;")
    data = data.replace("<", "&lt;")
    return data

class MainWin:
    def open_logs_win(self,object):
        self.logs_win=Logs_Window(self.window)

    def open_groups_win(self,object):
        self.win2=Groups_Win(self)
        self.win2.show()

    def open_configure_win(self,object):
        self.save_sizes()
        self.win3=Config_Win(self.conf,self)
        self.win3.show()

    def open_rules_win(self,object):
        self.score_win=Score_Win(self.score_rules)
        self.score_win.show()

    def open_groups_vs_id(self,object):
        self.groups_vs_id=Groups_Vs_ID(self.subscribed_groups,self)
        self.groups_vs_id.show()

    def supersede_cancel_message(self,object,mode):
        group_selected=""
        id_name=""
        model,path,iter_selected=self.groups_pane.get_first_selected_row()
        if iter_selected!=None:
            group_selected=model.get_value(iter_selected,0)
            id_name=self.get_id_for_group(group_selected)
        model,iter_selected=self.threads_pane.threads_tree.get_selection().get_selected()
        subj=""
        cp_id=ConfigParser.ConfigParser()
        cp_id.read(os.path.join(get_wdir(),"dats","id.txt"))

        if iter_selected!=None:
            #subj=model.get_value(iter_selected,1).decode("utf-8")
            article=self.threads_pane.get_article(model,iter_selected)
            subj=article.subj
            try:
                article.ngroups
            except AttributeError:
                self.statusbar.push(1,_("First you have to read the article"))
            else:
                nick=cp_id.get(id_name,"nick")
                email=cp_id.get(id_name,"email")
                user=nick+" <"+email+">"
                if article.user_agent.startswith("XPN") and user==article.from_name:
                    if mode=="Supersede":
                        self.win4=Edit_Win(self.configs,article.ngroups,article,None,self.subscribed_groups,"Supersede",server_name=self.current_server,id_name=id_name)
                        #self.win4.show()
                    else:
                        message=Dialog_YES_NO(_("Do you want to CANCEL this article?\n\nSubject: %s ""\nMessage-ID: %s") % (article.subj.encode("utf-8"),escape(article.msgid.encode("utf-8"))))

                        if message.resp:
                            canc_mess=Article_To_Send(article.ngroups,user,"cmsg cancel "+article.msgid,"",VERSION,"us-ascii",load_ordered_list(),["Cancel Message for "+article.msgid],["Control"],["cancel "+article.msgid],cp_id.get(id_name,"gen_mid"),cp_id.get(id_name,"fqdn"))
                            cancel_message=canc_mess.get_article()
                            message,articlePosted=self.connectionsPool[self.current_server].sendArticle(cancel_message)
                            if articlePosted:
                                self.statusbar.push(1,_("Cancel Article Sent: ")+message)
                            else:
                                self.statusbar.push(1,message)
                else:
                    self.statusbar.push(1,_("You can Cancel/Supersede only your articles"))

    def open_outbox_manager(self,obj):
        self.win_outbox=Outbox_Manager(self,VERSION)
        self.win_outbox.show()

            
    def open_edit_win(self,object,is_followup=False):
        group=""
        id_name=""
        model,path,iter_selected=self.groups_pane.get_first_selected_row()
        if iter_selected!=None:
            group=model.get_value(iter_selected,0)
            id_name=self.get_id_for_group(group)
        if is_followup:
            #this is a followup
            model,iter_selected=self.threads_pane.threads_tree.get_selection().get_selected()
            subj=""
            if iter_selected!=None:
                #subj=model.get_value(iter_selected,1).decode("utf-8")
                article=self.threads_pane.get_article(model,iter_selected)
                subj=article.subj
                group=article.original_group
                try:
                    article.ngroups
                except AttributeError:
                    self.statusbar.push(1,_("First you have to read the article"))
                else:
                    self.threads_pane.update_article_icon("fup")

                    bounds=self.article_pane.buffer.get_selection_bounds()
                    selected_text=None
                    if bounds:
                        start=bounds[0]
                        stop=bounds[1]
                        selected_text=self.article_pane.buffer.get_text(start,stop,True).decode("utf-8").split("\n")

                    newsgroups=group
                    if group!=article.ngroups:
                        #this is a crosspost
                        crosspost=True
                        newsgroups=article.ngroups
                    else:
                        crosspost=False
                    if article.fup_to!="":
                        newsgroups=article.fup_to
                        followup_to=True
                    else:
                        followup_to=False

                    if crosspost and not followup_to:
                        message=Dialog_YES_NO(_("This is a crosspost! \n Do you want to send the article only on the original newsgroup (%s) ?") % (group,))
                        if message.resp:
                            newsgroups=group
                    if followup_to:
                        if article.fup_to!="poster":
                            message=Dialog_YES_NO(_("Original Poster set \"Followup_to\" on %s,\n\nDo you want to send your article on the original newsgroup (%s) ?") % (article.fup_to,group))
                            if message.resp:
                                newsgroups=group
                        else:
                            message=Dialog_YES_NO(_("Original Poster set \"Followup_to: poster\",\n\nDo you want to reply by mail ?"))
                            if message.resp:
                                self.open_edit_mail_win(None)
                                return None
                            else:
                                newsgroups=group
                    self.win4=Edit_Win(self.configs,newsgroups,article,selected_text,self.subscribed_groups,server_name=self.current_server,id_name=id_name)
                    #self.win4.show()
        else:
            #this is a new post
            self.win4=Edit_Win(self.configs,group,None,None,self.subscribed_groups,server_name=self.current_server,id_name=id_name)
            #self.win4.show()


    def open_edit_mail_win(self,object):
        to_name=""
        id_name=""
        model,path,iter_selected=self.groups_pane.get_first_selected_row()
        if iter_selected!=None:
            group=model.get_value(iter_selected,0)
            id_name=self.get_id_for_group(group)

        model,iter_selected=self.threads_pane.threads_tree.get_selection().get_selected()
        subj=""
        if iter_selected!=None:
            #subj=model.get_value(iter_selected,1).decode("utf-8")
            article=self.threads_pane.get_article(model,iter_selected)
            subj=article.subj
            try:
                article.reply_to
            except AttributeError:
                self.statusbar.push(1,_("First you have to read the article"))
            else:
                self.threads_pane.update_article_icon("fup")
                if article.reply_to!="":
                    to_name=article.reply_to
                else:
                    to_name=article.from_name
                bounds=self.article_pane.buffer.get_selection_bounds()
                selected_text=None
                if bounds:
                    start=bounds[0]
                    stop=bounds[1]
                    selected_text=self.article_pane.buffer.get_text(start,stop,True).decode("utf-8").split("\n")

                self.win4=Edit_Mail_Win(self.configs,to_name,article,selected_text,id_name=id_name)
                self.win4.show()

    def open_about_dialog(self,object):
        self.about_dialog=About_Dialog(NUMBER)
        self.about_dialog.show()

    def delete_event(self,widget,event,data=None):
        self.mainwin_width,self.mainwin_height=self.window.get_size()
        self.mainwin_pos_x,self.mainwin_pos_y=self.window.get_position()
        return False

    def save_sizes(self):
        try:
            f=open(os.path.join(self.wdir,"dats/sizes.dat"),"rb")
        except IOError:
            sizes={}        
        else:
            sizes=cPickle.load(f)
        sizes["vpaned_pos"]=self.vpaned.get_position()
        sizes["hpaned_pos"]=self.hpaned.get_position()
        sizes["threads_col_status"]=self.threads_pane.column1.get_width()
        sizes["threads_col_subject"]=self.threads_pane.column2.get_width()
        sizes["threads_col_from"]=self.threads_pane.column3.get_width()
        sizes["threads_col_date"]=self.threads_pane.column4.get_width()
        sizes["threads_col_score"]=self.threads_pane.column5.get_width()
        sizes["groups_col1"]=self.groups_pane.column1.get_width()
        if not self.mainwin_width:
            sizes["mainwin_width"],sizes["mainwin_height"]=self.window.get_size()
        else:
            sizes["mainwin_width"]=self.mainwin_width
            sizes["mainwin_height"]=self.mainwin_height
        if not self.mainwin_pos_x:
            sizes["mainwin_pos_x"],sizes["mainwin_pos_y"]=self.window.get_position()
        else:
            sizes["mainwin_pos_x"]=self.mainwin_pos_x
            sizes["mainwin_pos_x"]=self.mainwin_pos_x
        try:
            f=open(os.path.join(self.wdir,"dats/sizes.dat"),"wb")
        except IOError:
            pass
        else:
            cPickle.dump(sizes,f,1)
            f.close()

    def save_chekmenu_options(self):
        self.configs["raw"]=str(bool(self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/raw").get_active()))
        self.configs["fixed"]=str(bool(self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/fixed").get_active()))
        self.configs["show_quote"]=str(bool(self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/show_quote").get_active()))
        self.configs["show_sign"]=str(bool(self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/show_sign").get_active()))
        self.configs["show_spoiler"]=str(bool(self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/spoiler").get_active()))
        self.configs["show_threads"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_threads").get_active()))
        self.configs["show_all_read_threads"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_all_read_threads").get_active()))
        self.configs["show_read_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_read_articles").get_active()))
        self.configs["show_unread_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unread_articles").get_active()))
        self.configs["show_kept_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_kept_articles").get_active()))
        self.configs["show_unkept_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unkept_articles").get_active()))
        self.configs["show_watched_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_watched_articles").get_active()))
        self.configs["show_ignored_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_ignored_articles").get_active()))
        self.configs["show_unwatchedignored_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unwatchedignored_articles").get_active()))
        self.configs["show_score_neg_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_neg_articles").get_active()))
        self.configs["show_score_zero_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_zero_articles").get_active()))
        self.configs["show_score_pos_articles"]=str(bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_pos_articles").get_active()))
        self.conf.write_configs()

    def update_checkmenu_options(self):
        if self.configs["raw"]=="True":
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/raw").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/raw").set_active(False)
        if self.configs["fixed"]=="True":
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/fixed").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/fixed").set_active(False)
        if self.configs["show_quote"]=="True":
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/show_quote").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/show_quote").set_active(False)
        if self.configs["show_sign"]=="True":
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/show_sign").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/show_sign").set_active(False)
        if self.configs["show_spoiler"]=="True":
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/spoiler").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/spoiler").set_active(False)
        if self.configs["show_threads"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_threads").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_threads").set_active(False)
        if self.configs["show_all_read_threads"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_all_read_threads").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_all_read_threads").set_active(False)
        if self.configs["show_read_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_read_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_read_articles").set_active(False)
        if self.configs["show_unread_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unread_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unread_articles").set_active(False)
        if self.configs["show_kept_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_kept_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_kept_articles").set_active(False)
        if self.configs["show_unkept_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unkept_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unkept_articles").set_active(False)
        if self.configs["show_watched_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_watched_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_watched_articles").set_active(False)
        if self.configs["show_ignored_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_ignored_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_ignored_articles").set_active(False)
        if self.configs["show_unwatchedignored_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unwatchedignored_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unwatchedignored_articles").set_active(False)
        if self.configs["show_score_neg_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_neg_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_neg_articles").set_active(False)
        if self.configs["show_score_zero_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_zero_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_zero_articles").set_active(False)
        if self.configs["show_score_pos_articles"]=="True":
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_pos_articles").set_active(True)
        else:
            self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_pos_articles").set_active(False)
      
    def destroy(self,widget):
        for connection in self.connectionsPool.itervalues():
            connection.closeConnection()
        self.save_sorting_type()
        self.save_sizes()
        self.save_chekmenu_options()
        self.purge_groups()
        try: os.remove(os.path.join(self.wdir,"xpn.lock"))
        except: pass
        gtk.main_quit()

    def save_sorting_type(self,obj=None):
        for n in range(1,5):
            col=self.threads_pane.threads_tree.get_column(n)
            if col.get_sort_indicator():
                order=col.get_sort_order()
                col_name=["Subject","From","Date","Score"][n-1]
                if order==gtk.SORT_ASCENDING:
                    ascend_order="True"
                else:
                    ascend_order="False"
                self.configs["ascend_order"]=ascend_order
                self.configs["sort_col"]=col_name
                self.conf.write_configs()
         
                
    
    def show_subscribed(self):
        model,path_list,iter_list=self.groups_pane.get_selected_rows()
        try:
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"rb")
        except IOError:
            self.statusbar.push(1,_("No Subscribed Groups"))
            self.groups_pane.show_list([])
        else:
            try:
                list=cPickle.load(f)
            except:
                f.close()
                self.recover_subscribed()
                self.show_subscribed()
                return
            else:
                f.close()
                new_list=[]
                self.subscribed_groups=[]
                for group in list:
                    try:
                        articles=shelve.open(os.path.join(self.wdir,"groups_info/",group[0],group[0]))
                    except:
                        self.statusbar.push(1,_("Missing %s file") % (group[0],))
                        if not os.path.isdir(os.path.join(self.wdir,"groups_info",group[0])):
                            os.makedirs(os.path.join(self.wdir,"groups_info",group[0]))

                    else:                        
                        unread_number=0
                        total=len(articles.keys())
                        for article in articles.itervalues():
                            if not article.is_read:
                                unread_number=unread_number+1
                        articles.close()
                        new_list.append((group[0],str(unread_number)+" ("+str(total)+")"))
                        self.subscribed_groups.append([group[0],group[2],group[3]]) #group_name,server_name,id_name
                self.groups_pane.show_list(new_list,True)
        self.threads_pane.clear()
        self.article_pane.clear()
        if path_list:
            self.groups_pane.select_row_by_path(path_list[0])

    def show_threads(self,group):
        art_fup=gtk.gdk.pixbuf_new_from_file("pixmaps/art_fup.xpm")
        art_body=gtk.gdk.pixbuf_new_from_file("pixmaps/art_body.xpm")
        art_unread=gtk.gdk.pixbuf_new_from_file("pixmaps/art_unread.xpm")
        art_read=gtk.gdk.pixbuf_new_from_file("pixmaps/art_read.xpm")
        art_mark=gtk.gdk.pixbuf_new_from_file("pixmaps/art_mark.xpm")
        art_keep=gtk.gdk.pixbuf_new_from_file("pixmaps/art_keep.xpm")
        art_unkeep=gtk.gdk.pixbuf_new_from_file("pixmaps/art_unkeep.xpm")
        art_watch=gtk.gdk.pixbuf_new_from_file("pixmaps/art_watch.xpm")
        art_unwatchignore=gtk.gdk.pixbuf_new_from_file("pixmaps/art_unwatchignore.xpm")
        art_ignore=gtk.gdk.pixbuf_new_from_file("pixmaps/art_ignore.xpm")
        if group:
            self.window.set_title( "%s - XPN %s" % ( group, NUMBER ) )
        else:
            self.window.set_title( "XPN %s" % (NUMBER,) )

        if not group: return
        groups=[line[0] for line in self.groups_pane.model]
        if not group in groups: return 
            
        self.threads_pane.clear()
        model=self.threads_pane.new_model()

        articles_shelve=shelve.open(os.path.join(self.wdir,"groups_info/",group,group))
        sorted=[(article.secs,article) for article in articles_shelve.itervalues()]
        sorted.sort()
        articles=sorted

        articles_shelve.close()

        j=0
        #Threading articles
        self.statusbar.push(1,_("Please Wait. Building Threads"))

        show_read_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_read_articles").get_active())
        show_unread_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unread_articles").get_active())
        show_kept_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_kept_articles").get_active())
        show_unkept_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unkept_articles").get_active())
        show_watched_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_watched_articles").get_active())
        show_ignored_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_ignored_articles").get_active())
        show_unwatchedignored_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_unwatchedignored_articles").get_active())
        show_score_neg_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_neg_articles").get_active())
        show_score_zero_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_zero_articles").get_active())
        show_score_pos_articles=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_score_pos_articles").get_active())
        show_threads=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_threads").get_active())
        show_all_read_threads=bool(self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_all_read_threads").get_active())


        article_tree = {}
        for secs, xpn_article in articles:
            number=xpn_article.number
            msgid=xpn_article.msgid
            nick,from_name,ref,subj,date,date_parsed=xpn_article.get_headers()

            if xpn_article.keep:
                icon2=art_keep
                if not show_kept_articles: continue
            else:
                icon2=art_unkeep
                if not show_unkept_articles: continue

            if xpn_article.is_read:
                isUnread=False
                icon=art_read
                if not show_read_articles: continue
            else:
                isUnread=True
                if xpn_article.body!=None:
                    icon=art_body
                elif xpn_article.marked_for_download:
                    icon=art_mark
                else:
                    icon=art_unread
                if not show_unread_articles: continue

            show_score=True           
            if xpn_article.score<0:
                score_foreground="red"
                if not show_score_neg_articles: continue
                    
            elif xpn_article.score>0:
                score_foreground="darkgreen"
                if not show_score_pos_articles: continue
           
            else : #xpn_article.score==0
                score_foreground="darkgreen"
                show_score=False
                if not show_score_zero_articles: continue
           
            if xpn_article.watch:
                icon3=art_watch
                if not show_watched_articles: continue
            elif xpn_article.ignore:
                icon3=art_ignore
                if not show_ignored_articles: continue
            else:
                icon3=art_unwatchignore
                if not show_unwatchedignored_articles: continue
            
            try :
                fg_color=xpn_article.fg_color
            except:
                fg_color_set=False
                fg_color="black"
            else:
                if fg_color:
                    if xpn_article.fg_color.lower()!="default":
                        fg_color_set=True
                        try: gtk.gdk.color_parse(fg_color)
                        except: 
                            fg_color="black"
                            fg_color_set=False
                    else:
                        fg_color_set=False
                        fg_color="black"
                else:
                    fg_color_set=False
                    fg_color="black"


            try :
                bg_color=xpn_article.bg_color
            except:
                bg_color_set=False
                bg_color="white"
            else:
                if bg_color:
                    if xpn_article.bg_color.lower()!="default":
                        bg_color_set=True
                        try: gtk.gdk.color_parse(bg_color)
                        except: 
                            bg_color="white"
                            bg_color_set=False
                    else:
                        bg_color_set=False
                        bg_color="black"                           
                else:
                    bg_color_set=False
                    bg_color="white"
            article_info = [icon,subj,nick,date_parsed,xpn_article,isUnread,xpn_article.secs,xpn_article.score,score_foreground,show_score,icon2,icon3,0,False,fg_color_set,fg_color,bg_color_set,bg_color]
            
            if show_threads:
                try:
                    idx=ref.rindex("<")
                except ValueError:
                    #Root node
                    article_tree[msgid] = (True, [], article_info)
                else:
                    #Child node
                    last_ref=ref[idx:]
                    if last_ref in article_tree:
                        #I found the father
                        article_tree[last_ref][1].append(msgid)
                        article_tree[msgid] = (False, [], article_info)
                    else:
                        #Trying threading by subject
                        for old_article_msgid, (old_article_is_root, old_branchs, old_article_info) in article_tree.iteritems():
                            old_article_subj = old_article_info[1]
                            if (old_article_subj in subj) and old_article_is_root:
                                #Found a root article with similar subject
                                article_tree[old_article_msgid][1].append(msgid)
                                article_tree[msgid] = (False, [], article_info)
                                break
                        else:
                            #In the list there aren't articles with similar subject
                            article_tree[msgid] = (True, [], article_info)
            else:
                # we're populating "article_tree", but always with true because
                # they're all "root nodes" (show_threads is false)
                article_tree[msgid] = (True, [], article_info)


        # here we apply all the "tree wide" filters
        def anyUnread(node):
            '''Recursive function to check if all the branch is read.'''
            (root, branchs, info) = article_tree[node]

            # if the node is unread, the whole branch has any unread
            if info[5]:  
                return True

            # if any of the sons is unread, just pass the flag to the previous call
            for branch in branchs:
                if anyUnread(branch):
                    return True

            # all my sons are read
            return False
            
        if not show_all_read_threads:
            roots = [k for k,v in article_tree.iteritems() if v[0]]
            for article_root in roots:
                if not anyUnread(article_root):
                    del article_tree[article_root]

            
        def walkTree(node, iter_mom):
            '''Recursive function to build the articles tree in the GTK Widget.'''
            # took the info about the article in the node
            (root, branchs, info) = article_tree[node]
            if info[5]:
                unread_in_thread = 1
            else:
                unread_in_thread = 0

            # tell TreeStore to build a branch
            iter_new = self.threads_pane.insert(model, iter_mom, None, info)

            # build all its sons
            for branch in branchs:
                (node_iter, more_unread) = walkTree(branch, iter_new)
                unread_in_thread += more_unread

            return (iter_new, unread_in_thread)

        # with the help of walkTree, we'll build... well... the tree
        roots = [k for k,v in article_tree.items() if v[0]]
        for article_root in roots:
            # start a branch from its root
            (root_iter, unread_in_thread) = walkTree(article_root, None)

            # show how many unread items the branch has
            self.threads_pane.set_unread_in_thread(model, root_iter, unread_in_thread)
            self.threads_pane.set_unread_in_thread_visible(model, root_iter, unread_in_thread!=0)

        message=_("%s selected") % (group,)
        self.statusbar.push(1,message)
        self.threads_pane.set_model(model)
        #adjust sorting
        model=self.threads_pane.threads_tree.get_model()
        sort_col=self.configs["sort_col"].lower()
        sortings={"subject":1,"from":2,"date":6,"score":7}
        sort_col=sortings.get(sort_col,6)
        if self.configs["ascend_order"]=="True":
            sort_order=gtk.SORT_ASCENDING
        else:
            sort_order=gtk.SORT_DESCENDING
        model.set_sort_column_id(sort_col,sort_order)

    def get_server_for_group(self,group_name):
        server_name=""
        for group,server,id in self.subscribed_groups:
            if group==group_name: server_name=server
        return server_name

    def get_id_for_group(self,group_name):
        id_name=""
        for group,server,id in self.subscribed_groups:
            if group==group_name: id_name=id
        return id_name

    def view_group(self,*params):
        clicktype=params[-1]
        if self.configs["oneclick"]=="True" and clicktype=="doubleclick": return
        if self.configs["oneclick"]=="False" and clicktype=="oneclick": return
        if self.groups_lock==False:
            self.groups_lock=True
            model,path_list,iter_list=self.groups_pane.get_selected_rows()
            if iter_list:
                self.group_to_thread=model.get_value(iter_list[0],0)
                self.current_server=self.get_server_for_group(self.group_to_thread)
                self.article_pane.clear()
                self.show_threads(self.group_to_thread)
            self.groups_lock=False

    def mark_for_download(self,article):
        '''mark article for download'''
        msgid=article.msgid
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",self.group_to_thread,self.group_to_thread))
        xpn_article=articles.get(msgid,None)
        if xpn_article!=None:
            article.marked_for_download=not article.marked_for_download
            articles[msgid]=article
        articles.close()


    def mark_subthread_for_download(self,model,root_iter,force_value=None):
        '''mark subthread for download'''
        article=self.threads_pane.get_article(model,root_iter)
        msgid=article.msgid
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",self.group_to_thread,self.group_to_thread))
        xpn_article=articles.get(msgid,None)
        if xpn_article!=None:
            #let's mark the root article
            if force_value==True:
                if xpn_article.body==None:
                    xpn_article.marked_for_download=force_value
            elif force_value==False:
                xpn_article.marked_for_download=force_value
            else:
                status=not xpn_article.marked_for_download
                if status==True:
                    if xpn_article.body==None:
                        xpn_article.marked_for_download=status
                else:
                    xpn_article.marked_for_download=status
            if xpn_article.marked_for_download:
                self.threads_pane.update_article_icon("download",root_iter)
            else:
                if xpn_article.is_read:
                    self.threads_pane.update_article_icon("read",root_iter)
                elif xpn_article.body!=None:
                    self.threads_pane.update_article_icon("body",root_iter)
                else:
                    self.threads_pane.update_article_icon("unread",root_iter)
            articles[msgid]=xpn_article
            self.threads_pane.set_article(model,root_iter,xpn_article)
            
            iter_list=self.threads_pane.get_subthread(root_iter,model,[])
            
            for iter_child in iter_list:
                sub_article=self.threads_pane.get_article(model,iter_child)
                xpn_sub_article=articles.get(sub_article.msgid,None)
                if xpn_sub_article!=None:
                #watching others articles in the subthread
                    if force_value==True:
                        if xpn_sub_article.body==None:
                            xpn_sub_article.marked_for_download=force_value
                    elif force_value==False:
                        xpn_sub_article.marked_for_download=force_value
                    else:
                        status=xpn_article.marked_for_download
                        if status==True:
                            if xpn_sub_article.body==None:
                                xpn_sub_article.marked_for_download=status
                        else:
                            xpn_sub_article.marked_for_download=status
                    
                    if xpn_sub_article.marked_for_download:
                        self.threads_pane.update_article_icon("download",iter_child)
                    else:
                        if xpn_sub_article.is_read:
                            self.threads_pane.update_article_icon("read",iter_child)
                        elif xpn_sub_article.body!=None:
                            self.threads_pane.update_article_icon("body",iter_child)
                        else:
                            self.threads_pane.update_article_icon("unread",iter_child)
                    
                    articles[sub_article.msgid]=xpn_sub_article
                    self.threads_pane.set_article(model,iter_child,xpn_sub_article)

        articles.close()
        

    def mark_group_for_download(self,group):
        '''mark the whole group for download'''
        if group:
            articles=shelve.open(os.path.join(self.wdir,"groups_info/",group,group))
            for article in articles.itervalues():
                if article.body==None:
                    article.marked_for_download=True
                articles[article.msgid]=article
            articles.close()
            self.view_group(None,None)
    
    def keep_subthread(self, model, root_iter):
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",self.group_to_thread,self.group_to_thread))
        root_article=self.threads_pane.get_article(model,root_iter)
        xpn_root_article=articles.get(root_article.msgid,None)
        if xpn_root_article!=None:
            status= xpn_root_article.keep
            xpn_root_article.keep=not status
            if status:
                self.threads_pane.update_article_icon("unkeep",root_iter)
            else:
                self.threads_pane.update_article_icon("keep",root_iter)
            articles[root_article.msgid]=xpn_root_article
            self.threads_pane.set_article(model,root_iter,xpn_root_article)

            iter_list=self.threads_pane.get_subthread(root_iter,model,[])
            for iter_child in iter_list:
                sub_article=self.threads_pane.get_article(model,iter_child)
                xpn_sub_article=articles.get(sub_article.msgid,None)
                if xpn_sub_article!=None:
                    xpn_sub_article.keep=not status
                    if status:
                        self.threads_pane.update_article_icon("unkeep",iter_child)
                    else:
                        self.threads_pane.update_article_icon("keep",iter_child)
                    articles[sub_article.msgid]=xpn_sub_article
                    self.threads_pane.set_article(model,iter_child,xpn_sub_article)
        articles.close()
                    

        
    def mark_subthread_read(self,model,root_iter,read):
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",self.group_to_thread,self.group_to_thread))
        root_article=self.threads_pane.get_article(model,root_iter)
        xpn_root_article=articles.get(root_article.msgid,None)
        if xpn_root_article!=None:
            if read:
                self.remove_from_unreads(root_article)
                self.threads_pane.update_article_icon("read",root_iter)
                self.threads_pane.set_is_unread(model,root_iter,False)
            else:
                self.insert_in_unreads(root_article)
                if xpn_root_article.body==None: self.threads_pane.update_article_icon("unread",root_iter)
                else: self.threads_pane.update_article_icon("body",root_iter)
                self.threads_pane.set_is_unread(model,root_iter,True)
            self.threads_pane.set_article(model,root_iter,xpn_root_article)

            iter_list=self.threads_pane.get_subthread(root_iter,model,[])
            for iter_child in iter_list:
                sub_article=self.threads_pane.get_article(model,iter_child)
                xpn_sub_article=articles.get(sub_article.msgid,None)
                if xpn_sub_article!=None:
                    if read:
                        self.remove_from_unreads(sub_article)
                        self.threads_pane.update_article_icon("read",iter_child)
                        self.threads_pane.set_is_unread(model,iter_child,False)
                    else:
                        self.insert_in_unreads(sub_article)
                        if xpn_sub_article.body==None: self.threads_pane.update_article_icon("unread",iter_child)
                        else: self.threads_pane.update_article_icon("body",iter_child)
                        self.threads_pane.set_is_unread(model,iter_child,True)
                    self.threads_pane.set_article(model,iter_child,xpn_sub_article)
        articles.close()
                    
            
    
    def set_keep(self,article,group):
        '''set keep flag'''
        msgid=article.msgid
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",group,group))
        xpn_article=articles.get(msgid,None)
        if xpn_article!=None:
            article.keep=not article.keep
            articles[msgid]=article
        articles.close()

    def set_watch(self,model,root_iter):
        #set watch flag and mark on subthread
        article=self.threads_pane.get_article(model,root_iter)
        msgid=article.msgid
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",self.group_to_thread,self.group_to_thread))
        xpn_article=articles.get(msgid,None)
        if xpn_article!=None:
            xpn_article.watch=not xpn_article.watch
            watched=self.get_watched()
            ignored=self.get_ignored()
            if xpn_article.watch:
                watched.add(msgid)
                ignored.discard(msgid)
                xpn_article.ignore=False
                self.threads_pane.update_article_icon("watch",root_iter)
            else:
                watched.discard(msgid)
                self.threads_pane.update_article_icon("unwatchignore",root_iter)
            self.threads_pane.set_article(model,root_iter,xpn_article)
            articles[msgid]=xpn_article
            
            iter_list=self.threads_pane.get_subthread(root_iter,model,[])
            
            for iter_child in iter_list:
                #watching others articles in the subthread
                sub_article=self.threads_pane.get_article(model,iter_child)
                xpn_sub_article=articles.get(sub_article.msgid,None)
                if xpn_sub_article!=None:
                    xpn_sub_article.watch=xpn_article.watch
                    if xpn_sub_article.watch:
                        watched.add(sub_article.msgid)
                        self.threads_pane.update_article_icon("watch",iter_child)
                    else:
                        watched.discard(sub_article.msgid)
                        self.threads_pane.update_article_icon("unwatchignore",iter_child)
                    ignored.discard(sub_article.msgid)
                    xpn_sub_article.ignore=False
                    articles[sub_article.msgid]=xpn_sub_article
                    self.threads_pane.set_article(model,iter_child,xpn_sub_article)
            self.dump_watched(watched)
            self.dump_ignored(ignored)
        articles.close()
        self.mark_subthread_for_download(model,root_iter,xpn_article.watch)
    
    def set_ignore(self,model,root_iter):
        #set ignore flag and unmark on subthread
        article=self.threads_pane.get_article(model,root_iter)
        msgid=article.msgid
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",self.group_to_thread,self.group_to_thread))
        xpn_article=articles.get(msgid,None)
        if xpn_article!=None:
            xpn_article.ignore=not xpn_article.ignore
            watched=self.get_watched()
            ignored=self.get_ignored()
            if xpn_article.ignore:
                ignored.add(msgid)
                watched.discard(msgid)
                xpn_article.watch=False
                self.remove_from_unreads(xpn_article)
                self.threads_pane.update_article_icon("ignore",root_iter)
            else:
                ignored.discard(msgid)
                self.insert_in_unreads(xpn_article)
                self.threads_pane.update_article_icon("unwatchignore",root_iter)
            self.threads_pane.set_article(model,root_iter,xpn_article)
            self.threads_pane.set_is_unread(model,root_iter,not xpn_article.is_read)
            articles[msgid]=xpn_article
            
            iter_list=self.threads_pane.get_subthread(root_iter,model,[])
            
            for iter_child in iter_list:
                #watching others articles in the subthread
                sub_article=self.threads_pane.get_article(model,iter_child)
                xpn_sub_article=articles.get(sub_article.msgid,None)
                if xpn_sub_article!=None:
                    xpn_sub_article.ignore=xpn_article.ignore
                    if xpn_sub_article.ignore:
                        ignored.add(sub_article.msgid)
                        self.remove_from_unreads(xpn_sub_article)
                        self.threads_pane.update_article_icon("ignore",iter_child)
                    else:
                        ignored.discard(sub_article.msgid)
                        self.insert_in_unreads(xpn_sub_article)
                        self.threads_pane.update_article_icon("unwatchignore",iter_child)
                    watched.discard(sub_article.msgid)
                    xpn_sub_article.watch=False
                    articles[sub_article.msgid]=xpn_sub_article
                    self.threads_pane.set_article(model,iter_child,xpn_sub_article)
                    self.threads_pane.set_is_unread(model,iter_child,not xpn_sub_article.is_read)


            self.dump_watched(watched)
            self.dump_ignored(ignored)
        articles.close()
        self.mark_subthread_for_download(model,root_iter,xpn_article.watch)

    def insert_in_unreads(self,article):
        #reinsert article in unreads
        msgid=article.msgid
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",self.group_to_thread,self.group_to_thread))
        xpn_article=articles.get(msgid,None)
        if xpn_article!=None:
            if xpn_article.is_read:
                #if the article is read we update the unreads number
                model,path,iter_selected=self.groups_pane.get_first_selected_row()
                unread_vs_total_numbers=model.get_value(iter_selected,1)
                num,tot=unread_vs_total_numbers.split(" ")
                number=int(num)+1
                model.set_value(iter_selected,1,str(number)+" "+tot)
                if number>=1:
                    model.set_value(iter_selected,2,pango.WEIGHT_BOLD)

                #update also unread_in_thread
                if self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_threads").get_active():
                    model,iter_selected=self.threads_pane.threads_tree.get_selection().get_selected()
                    parent_path=tuple([model.get_path(iter_selected)[0],])
                    parent_iter=model.get_iter(parent_path)
                    unread_in_thread=self.threads_pane.get_unread_in_thread(model,parent_iter)
                    unread_in_thread=unread_in_thread+1
                    self.threads_pane.set_unread_in_thread(model,parent_iter,unread_in_thread)
                    self.threads_pane.set_unread_in_thread_visible(model,parent_iter,unread_in_thread!=0)

            article.is_read=False
            articles[msgid]=article
        articles.close()


    def remove_from_unreads(self,article):
        #remove article from unreads
        msgid=article.msgid
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",self.group_to_thread,self.group_to_thread))
        xpn_article=articles.get(msgid,None)
        if xpn_article!=None:
            if not xpn_article.is_read:
                #if the article is unread we update the unreads number
                model,path,iter_selected=self.groups_pane.get_first_selected_row()
                unread_vs_total_numbers=model.get_value(iter_selected,1)
                num,tot=unread_vs_total_numbers.split(" ")
                number=int(num)-1
                model.set_value(iter_selected,1,str(number)+" "+tot)
                if number<1:
                    model.set_value(iter_selected,2,pango.WEIGHT_NORMAL)

                #update also unread_in_thread
                if self.ui.get_widget("/MainMenuBar/Subscribed/view_group_opts/show_threads").get_active():
                    model,iter_selected=self.threads_pane.threads_tree.get_selection().get_selected()
                    parent_path=tuple([model.get_path(iter_selected)[0],])
                    parent_iter=model.get_iter(parent_path)
                    unread_in_thread=self.threads_pane.get_unread_in_thread(model,parent_iter)
                    unread_in_thread=unread_in_thread-1
                    self.threads_pane.set_unread_in_thread(model,parent_iter,unread_in_thread)
                    self.threads_pane.set_unread_in_thread_visible(model,parent_iter,unread_in_thread!=0)

            article.is_read=True
            articles[msgid]=article
        articles.close()

    def show_article(self,article):
        self.article_pane.delete_all()
        vadj=self.article_pane.text_scrolledwin.get_vadjustment()
        vadj.set_value(0)
        is_sign=False
        is_quote=False
        line_number=0
        mute_quote=not bool(self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/show_quote").get_active())
        mute_quote_text_inserted=False
        mute_sign=not bool(self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/show_sign").get_active())
        mute_sign_text_inserted=False

        RE_bold=r"(?:^|.)(\*.+?\*)(?=.|$)"
        RE_underline=r"(?:^|[.,:;\s(])(_.+?_)(?=[.,:;\s)]|$)"
        RE_italic=r"(?:^|[.,:;\s(])(/.+?/)(?=[.,:;\s)]|$)"
        RE_url=r"(https?://[-a-zA-Z0-9_$.+!*(),;:@%&=?~#'/]*[-a-zA-Z0-9_$+!*(@%&=?~#/])"
        RE_mid=r"(?:^|.)(?:<)([-a-zA-Z0-9_$.+!*(),;:%&=?~#'/]+@[-a-zA-Z0-9_$.+!*(),;:%&=?~#'/]+)(?:>)(?=.|$)"
        compiled_bold=re.compile(RE_bold,re.UNICODE|re.DOTALL)
        compiled_underline=re.compile(RE_underline,re.UNICODE)
        compiled_italic=re.compile(RE_italic,re.UNICODE|re.DOTALL)
        compiled_url=re.compile(RE_url)
        compiled_mid=re.compile(RE_mid)

        def quote_depth(line):
            count=0
            for char in line:
                if char==">":
                    count=count+1
                else:
                    break
            if count>3:
                count=3
            if count==0: #this prevent a warning during the mute_quote mode
                count=1
            return str(count)
            
        for line in article:
            line=line.replace("\r","") #this is needed for some strange articles
            insert_newline=True
            if len(line)>0:
                if line[0]==">":
                    is_quote=True
                elif (len(line)==2 and line[0:2]=="--") or (len(line)==3 and line[0:3]=="-- "):
                    is_sign=True
                    is_quote=False
                else:
                    is_quote=False
                tag_prefix=""
                
                if is_quote and not is_sign:
                    if mute_quote:
                        if mute_quote_text_inserted:
                            line=""
                            insert_newline=False
                        else:
                            line=_("> [...Muted Quote...]")
                            mute_quote_text_inserted=True
                    quote_level=quote_depth(line)
                    
                    self.article_pane.insert_with_tags(line,"quote"+quote_level)
                    tag_prefix="quote"+quote_level

                elif is_sign:
                    if mute_sign:
                        if mute_sign_text_inserted:
                            line=""
                            insert_newline=False
                        else:
                            line=_("[...Muted Sign...]")
                            mute_sign_text_inserted=True
                    self.article_pane.insert_with_tags(line,"sign")
                    tag_prefix="sign"
                    mute_quote_text_inserted=False

                else:
                    self.article_pane.insert_with_tags(line,"text")
                    tag_prefix="text"
                    mute_quote_text_inserted=False

                matches_bold=compiled_bold.finditer(line)
                matches_underline=compiled_underline.finditer(line)
                matches_italic=compiled_italic.finditer(line)
                matches_url=compiled_url.finditer(line)
                matches_mid=compiled_mid.finditer(line)
                
                self.apply_styles(matches_bold,tag_prefix,"_bold",line_number,1)
                self.apply_styles(matches_underline,tag_prefix,"_underline",line_number,1)
                self.apply_styles(matches_italic,tag_prefix,"_italic",line_number,1)
                self.apply_styles(matches_url,"","url",line_number,0)
                self.apply_styles(matches_mid,"","mid",line_number,1)
                
            if insert_newline:
                self.article_pane.insert("\n")
                line_number=line_number+1
        if self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/spoiler").get_active()==False:
            self.apply_spoiler()
        if self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/raw").get_active()==True:
            self.highlight_headers()

    def apply_styles(self,style_matched,tagPrefix,tagSuffix,line_number,group_number):
        for match in style_matched:
            iter_start=self.article_pane.buffer.get_start_iter()
            iter_start.set_line(line_number)
            iter_stop=iter_start.copy()
            iter_start.set_line_offset(match.start(group_number))
            iter_stop.set_line_offset(match.end(group_number))
            self.article_pane.buffer.delete(iter_start,iter_stop)
            self.article_pane.insert_with_tags_at_iter(iter_start,match.group(group_number),tagPrefix+tagSuffix)

    def highlight_headers(self):
        bounds=self.article_pane.buffer.get_bounds()
        RE_header="^.+?:"
        if bounds:
            start,stop=bounds
            text=self.article_pane.buffer.get_text(start,stop,True).decode("utf-8")
            text_splitted=text.splitlines()
            if "" in text_splitted:
                index=text_splitted.index("")
            else:
                index=0
            i=0
            headers_block=[]
            for i in range(index):
                headers_block.append(text_splitted[i])
            text='\n'.join(headers_block)
            match_header=re.compile(RE_header,re.UNICODE|re.MULTILINE).finditer(text)
            for match in match_header:
                match_start,match_stop,match_text= match.start(), match.end(), match.group()
                iter_start=self.article_pane.buffer.get_iter_at_offset(match_start)
                iter_stop=self.article_pane.buffer.get_iter_at_offset(match_stop)
                self.article_pane.buffer.delete(iter_start,iter_stop)
                self.article_pane.insert_with_tags_at_iter(iter_start,match_text,"quote1_bold")

    def apply_spoiler(self):
        bounds=self.article_pane.buffer.get_bounds()
        RE_spoiler=chr(12)+".+?"+chr(12)
        if bounds:
            start,stop=bounds
            text=self.article_pane.buffer.get_text(start,stop,True).decode("utf-8")
            matchs_spoiler=re.compile(RE_spoiler,re.UNICODE|re.DOTALL).finditer(text)
            for match in matchs_spoiler:
                match_start,match_stop,match_text= match.start(), match.end(), match.group()

                iter_start=self.article_pane.buffer.get_iter_at_offset(match_start)
                iter_stop=self.article_pane.buffer.get_iter_at_offset(match_stop)
                self.article_pane.buffer.delete(iter_start,iter_stop)
                self.article_pane.insert_with_tags_at_iter(iter_start,match_text,"spoiler")

            if divmod(text.count(chr(12)),2)[1]!=0:
                #the number of spoiler chars is an odd number
                pos=text.rindex(chr(12))
                iter_start=self.article_pane.buffer.get_iter_at_offset(pos)
                iter_stop=self.article_pane.buffer.get_end_iter()
                match_text=self.article_pane.buffer.get_text(iter_start,iter_stop)
                self.article_pane.buffer.delete(iter_start,iter_stop)
                self.article_pane.insert_with_tags_at_iter(iter_start,match_text,"spoiler")

 

    def retrieve_body(self,article_to_read,group,server_name=None):
        if not server_name: 
            if self.current_server:
                server_name=self.current_server
            else:
                server_name=self.get_server_for_group(group)
        body=article_to_read.get_body()
        self.article_pane.textview.grab_focus()
        bodyRetrieved=True
        if not body:
            message,headerList,body,bodyRetrieved=self.connectionsPool[server_name].getBody(article_to_read.number,article_to_read.msgid,group)
            self.statusbar.push(1,message)
            if headerList:
                article_to_read.parse_header_list(headerList)
            if bodyRetrieved:
                article_to_read.set_body(body,'\n'.join(headerList+['']+body))
                body=article_to_read.get_body()
                article_to_read.marked_for_download=False
        return body,bodyRetrieved

    def view_article(self,*params):
        #params=obj,path,column,clicktype
        
        def return_part_number(obj):
            self.part_to_show=0
            i=0
            for button in self.article_pane.multiparts_buttons:
                if obj==button:
                    self.part_to_show=i
                i=i+1
            self.view_article("oneclick")

        def get_and_show_body(article_to_read,body):
            try: article_to_read.body_parts
            except: pass
            else:
                self.article_pane.add_parts_buttons(article_to_read.body_parts)
                for button in self.article_pane.multiparts_buttons: button.connect("released",return_part_number)
                try: 
                    body=article_to_read.body_parts[self.part_to_show][1].splitlines()
                    self.article_pane.multiparts_buttons[self.part_to_show].set_active(True)
                except: body=article_to_read.body_parts[0][1].splitlines()
            if show_raw and bodyRetrieved:
                body=article_to_read.get_raw()
            self.show_article(body)

        
        clicktype=params[-1]
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        show_raw=bool(self.ui.get_widget("/MainMenuBar/Articles/view_articles_opts/raw").get_active())
        if iter_selected!=None:
            article_to_read=self.threads_pane.get_article(model,iter_selected)
            if self.configs["oneclick_article"]=="True" and clicktype=="doubleclick": return
            if self.configs["oneclick_article"]=="False" and clicktype=="oneclick":
                self.article_pane.clear()
                self.article_pane.update_headers_labels(article_to_read)
                body=article_to_read.get_body()
                if (article_to_read.is_read) and (body!=None):
                    bodyRetrieved=True
                    get_and_show_body(article_to_read,body)
                    self.article_pane.update_headers_labels(article_to_read)

                self.article_pane.set_face_x_face(article_to_read.face,article_to_read.x_face)
                return
            
            #self.article_pane.textview.grab_focus()
            body,bodyRetrieved=self.retrieve_body(article_to_read,article_to_read.original_group)

########AGGIUSTARE QUA###################
######QUANDO IL CORPO E' VUOTO BODY E' FALSO E IL PROGRAMMA NON VA AVANTI###########
#####PER IL MOMENTO METTO !=NONE MA E' DA VERIFICARE NEI CASI DI ERRORI###########
            if body!=None:
                self.article_pane.clear()
                if bodyRetrieved:
                    self.threads_pane.set_is_unread(model,iter_selected,False)
                    self.threads_pane.update_article_icon("read")
                    self.remove_from_unreads(article_to_read)
                    self.article_pane.update_headers_labels(article_to_read)

                get_and_show_body(article_to_read,body)
                self.article_pane.set_face_x_face(article_to_read.face,article_to_read.x_face)

            self.threads_pane.threads_tree.grab_focus()


    def view_next_article(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        column=self.threads_pane.threads_tree.get_column(0)

        if iter_selected==None:
            iter_new=model.get_iter_first()
        else:
            path=model.get_path(iter_selected)        
            iter_new=self.threads_pane.find_next_row(model,iter_selected)
        if iter_new!=None:
            path=model.get_path(iter_new)
            self.threads_pane.threads_tree.expand_row(path,False)
            self.threads_pane.threads_tree.scroll_to_cell(path,None,True,0.4,0.0)
            self.threads_pane.threads_tree.set_cursor(path,None,False)
            self.threads_pane.threads_tree.row_activated(path,column)

    def view_next_unread_article(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        column=self.threads_pane.threads_tree.get_column(0)
        if iter_selected==None:
            iter_selected=model.get_iter_first()
        if iter_selected!=None:
            read_status=self.threads_pane.get_is_unread(model,iter_selected)
        else:
            read_status=False
        while (not read_status) and (iter_selected!=None):
            iter_selected=self.threads_pane.find_next_row(model,iter_selected)
            if iter_selected!=None:
                read_status=self.threads_pane.get_is_unread(model,iter_selected)
            else:
                read_status=False
        if read_status:
            path=model.get_path(iter_selected)
            root_path=[]
            root_path.append(path[0])
            root_path=tuple(root_path)
            self.threads_pane.threads_tree.expand_row(root_path,True)
            self.threads_pane.threads_tree.grab_focus()
            self.threads_pane.threads_tree.scroll_to_cell(path,None,True,0.4,0.0)
            self.threads_pane.threads_tree.set_cursor(path,None,False)
            self.threads_pane.threads_tree.row_activated(path,column)




    def view_previous_article(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        column=self.threads_pane.threads_tree.get_column(0)
        if iter_selected==None:
            iter_new=model.get_iter_first()
        else:
            iter_new=self.threads_pane.find_previous_row(model,iter_selected)
        if iter_new!=None:
            path=model.get_path(iter_new)
            self.threads_pane.threads_tree.set_cursor(path,None,False)
            self.threads_pane.threads_tree.row_activated(path,column)

    def view_parent_article(self,obj):
        model,iter_son=self.threads_pane.threads_tree.get_selection().get_selected()
        if iter_son!=None:
            article_son=self.threads_pane.get_article(model,iter_son)
            references=article_son.ref
            if references=="":
                self.statusbar.push(1,_("This is root article"))
            else:
                idx=references.rindex("<")
                last_ref=references[idx:]

                #First search the parent in the threaded articles
                iter_current=model.get_iter_first()
                success=False
                while iter_current!=None and not success:
                    article_mom=self.threads_pane.get_article(model,iter_current)
                    if article_mom.msgid==last_ref:
                        #It is in the threads, let's show the article selecting its row
                        path=model.get_path(iter_current)
                        self.threads_pane.threads_tree.set_cursor(path,None,False)
                        self.threads_pane.threads_tree.row_activated(path,self.threads_pane.column1)
                        self.statusbar.push(1,_("Article Found"))
                        success=True
                    else:
                        iter_current=self.threads_pane.find_next_row(model,iter_current)

                if not success:
                    #Let' search the article on the server
                    message,number=self.connectionsPool[self.current_server].getArticleNumber(article_son.original_group,last_ref)
                    self.statusbar.push(1,message)
                    if number!=-1:
                        message,headers,last=self.connectionsPool[self.current_server].getHeaders(article_son.original_group,number,number)
                        self.statusbar.push(1,message)
                        if headers:
                            number,subj,from_name,date,msgid,ref,bytes,lines,xref=headers[0]
                            #If it is not in the threaded articles, let's insert a node for this article
                            article=Article(number,msgid,from_name,ref,subj,date,self.configs["fallback_charset"],article_son.original_group,xref,bytes,lines)
                            #applying score rules
                            score=self.score_rules.apply_score_rules(article,article.original_group)
                            article.set_score(score)
                            nick,from_name,ref,subj,date,date_parsed=article.get_headers()
                            art_unread=gtk.gdk.pixbuf_new_from_file("pixmaps/art_unread.xpm")
                            art_unkeep=gtk.gdk.pixbuf_new_from_file("pixmaps/art_unkeep.xpm")

                            if score<0:
                                score_foreground="red"
                            else:
                                score_foreground="darkgreen"
                            if score==0:
                                show_score=False
                            else:
                                show_score=True        
                            iter_new=self.threads_pane.insert(model,None,iter_son,[art_unread,subj,nick,date_parsed,article,True,article.secs,article.score,score_foreground,show_score,art_unkeep])
                            path=model.get_path(iter_new)
                            self.threads_pane.threads_tree.set_cursor(path,None,False)
                            self.threads_pane.threads_tree.row_activated(path,self.threads_pane.column1)
                            self.statusbar.push(1,_("Article loaded"))
                        else:
                            self.statusbar.push(1,_("This article is not available on the server"))
                    else:
                        self.statusbar.push(1,_("This article is not available on the server"))

    def show_activity_list(self,activity_list):
        msg=_("There are new articles in watched threads: ")
        report=""
        if activity_list:
            for group,number in activity_list.iteritems():
                report+=group+": "+str(number)+"\n"
            d=Dialog_OK(msg+"\n\n"+report)

    def get_new_headers(self,obj):
        "Download new headers for the subscribed"
        try:
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"rb")
        except IOError:
            self.statusbar.push(1,_("No Subscribed Groups"))
        else:
            subscribed=cPickle.load(f)
            f.close()
            activity_list=dict()
            for group in subscribed:
                s1=len(self.get_watched())
                group[1]=self.download_headers(group[0],group[1],group[2])
                s2=len(self.get_watched())
                if s2>s1: activity_list[group[0]]=s2-s1
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"wb")
            cPickle.dump(subscribed,f,1)
            f.close()
            self.statusbar.push(1,_("Download Completed"))
            model,path,iter_selected=self.groups_pane.get_first_selected_row()
            self.show_subscribed()
            if iter_selected:
                self.groups_pane.groups_list.set_cursor(path,None,False)
                self.groups_pane.groups_list.row_activated(path,self.groups_pane.groups_list.get_column(0))
            self.show_activity_list(activity_list)
    
    def get_new_headers_selected(self,obj):
        "Dowload new headers for selected group"
        try:
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"rb")
        except IOError:
            self.statusbar.push(1,_("No Subscribed Groups"))
        else:
            subscribed=cPickle.load(f)
            f.close()
            model,path_list,iter_list=self.groups_pane.get_selected_rows()
            activity_list=dict()
            for path in path_list:
                iter_selected=model.get_iter(path)
                group_name=model.get_value(iter_selected,0)
                for group in subscribed:
                    if group[0]==group_name:
                        s1=len(self.get_watched())
                        group[1]=self.download_headers(group[0],group[1],group[2])
                        s2=len(self.get_watched())
                        if s2>s1: activity_list[group_name]=s2-s1
                f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"wb")
                cPickle.dump(subscribed,f,1)
                f.close()
            if path_list:
                self.show_subscribed()
                self.groups_pane.groups_list.set_cursor(path_list[0],None,False)
                self.groups_pane.groups_list.row_activated(path_list[0],self.groups_pane.groups_list.get_column(0))
                self.show_activity_list(activity_list)



    def download_headers(self,group,last_number,server_name):
        watched=self.get_watched()
        ignored=self.get_ignored()
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",group,group))
        first=int(last_number)+1
        #Downloading headers
        self.progressbar.set_text(_("Fetching Headers"))
        self.progressbar.set_fraction(1/float(2))
        while gtk.events_pending():
            gtk.main_iteration(False)
        if self.configs["limit_articles"]=="True":
            articles_number=int(self.configs["limit_articles_number"])
            message,total_headers,last=self.connectionsPool[server_name].getHeaders(group,first,count=articles_number)
        else:            
            message,total_headers,last=self.connectionsPool[server_name].getHeaders(group,first)
        if last!=-1:
            last_number=str(last)
        self.statusbar.push(1,message)
        if total_headers:
            self.progressbar.set_text(_("Building Articles"))
        else:
            self.progressbar.set_text(_("No New Headers"))
        self.progressbar.set_fraction(2/float(2))
        while gtk.events_pending():
            gtk.main_iteration(False)
            
        for headers in total_headers:
            number,subject,from_name,date,msgid,references,bytes,lines,xref=headers
            xpn_article=Article(number,msgid,from_name,references,subject,date,self.configs["fallback_charset"],group,xref,bytes,lines)
            try:
                index=references.rindex("<")
            except ValueError:
                last_ref=""
            else:
                last_ref=references[index:]
            #applying score rules
            score=self.score_rules.apply_score_rules(xpn_article,group)
            xpn_article.set_score(score)
            #applying score actions
            xpn_article,actions,watched,ignored=self.score_rules.apply_action_rules(xpn_article,group,watched,ignored)
            if not "kill" in actions:
                if ((self.configs["download_bodies"]=="True" and not "markread" in actions) or ("retrieve" in actions) or (last_ref in watched)) and not (last_ref in ignored):
                    body,bodyRetrieved=self.retrieve_body(xpn_article,group,server_name)
                if last_ref in ignored:
                    xpn_article.is_read=True
                    xpn_article.ignore=True
                    ignored.add(xpn_article.msgid)
                    watched.discard(xpn_article.msgid)
                    xpn_article.watch=False
                if last_ref in watched:
                    xpn_article.watch=True
                    watched.add(xpn_article.msgid)
                    ignored.discard(xpn_article.msgid)
                    xpn_article.ignore=False
                articles[xpn_article.msgid]=xpn_article
        articles.close()
        self.dump_watched(watched)
        self.dump_ignored(ignored)
        self.progressbar.set_fraction(0)
        self.progressbar.set_text("")
        return last_number

    def reapply_score_actions_rules(self,obj):
        watched=self.get_watched()
        ignored=self.get_ignored()
        try:
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"rb")
        except IOError:
            self.statusbar.push(1,_("No Subscribed Groups"))
        else:
            subscribed=cPickle.load(f)
            f.close()
            j=0
            for group in subscribed:
                j=j+1
                self.progressbar.set_fraction(j/float(len(subscribed)))
                self.progressbar.set_text("%s / %s" % (j,len(subscribed)))
                self.statusbar.push(1,_("Refreshing Group %s") % group[0])
                while gtk.events_pending():
                    gtk.main_iteration(False)

                articles=shelve.open(os.path.join(self.wdir,"groups_info/",group[0],group[0]))
                for xpn_article in articles.itervalues():
                    #reset the article
                    xpn_article.reset_article_score_actions()
                    watched.discard(xpn_article.msgid)
                    ignored.discard(xpn_article.msgid)
        try:
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"rb")
        except IOError:
            self.statusbar.push(1,_("No Subscribed Groups"))
        else:
            subscribed=cPickle.load(f)
            f.close()
            j=0
            for group in subscribed:
                j=j+1
                self.progressbar.set_fraction(j/float(len(subscribed)))
                self.progressbar.set_text("%s / %s" % (j,len(subscribed)))
                self.statusbar.push(1,_("Applying Rules to Group %s") % group[0])
                while gtk.events_pending():
                    gtk.main_iteration(False)


                articles=shelve.open(os.path.join(self.wdir,"groups_info/",group[0],group[0]))
                sorted=[(article.secs,article) for article in articles.itervalues()]
                sorted.sort()
                articles.clear()
                for secs,xpn_article in sorted:
                    #reset the article
                    xpn_article.reset_article_score_actions()
                    watched.discard(xpn_article.msgid)
                    ignored.discard(xpn_article.msgid)   

                    score=self.score_rules.apply_score_rules(xpn_article,group[0])
                    xpn_article.set_score(score)
                    xpn_article,actions,watched,ignored=self.score_rules.apply_action_rules(xpn_article,group[0],watched,ignored)
                    if not "kill" in actions:                    
                        try:
                            index=xpn_article.ref.rindex("<")
                        except ValueError:
                            last_ref=""
                        else:
                            last_ref=xpn_article.ref[index:]
                        if ((self.configs["download_bodies"]=="True" and not "markread" in actions) or ("retrieve" in actions) or (last_ref in watched)) and not (last_ref in ignored):
                            body,bodyRetrieved=self.retrieve_body(xpn_article,group[0],group[2])
                        if last_ref in ignored:
                            xpn_article.is_read=True
                            xpn_article.ignore=True
                            ignored.add(xpn_article.msgid)
                            watched.discard(xpn_article.msgid)
                            xpn_article.watch=False
                        if last_ref in watched:
                            xpn_article.watch=True
                            watched.add(xpn_article.msgid)
                            ignored.discard(xpn_article.msgid)
                            xpn_article.ignore=False
                        articles[xpn_article.msgid]=xpn_article
                articles.close()
        self.dump_watched(watched)
        self.dump_ignored(ignored)
        model,path,iter_selected=self.groups_pane.get_first_selected_row()
        if iter_selected:
            self.show_subscribed()
            self.groups_pane.groups_list.set_cursor(path,None,False)
            self.groups_pane.groups_list.row_activated(path,self.groups_pane.groups_list.get_column(0))
        self.progressbar.set_fraction(0)
        self.progressbar.set_text("")
        self.statusbar.push(1,"")

    def get_bodies(self,obj):
        "Download bodies for marked articles"
        try:
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"rb")
        except IOError:
            self.statusbar.push(1,_("No Subscribed Groups"))
        else:
            subscribed=cPickle.load(f)
            f.close()
            for group in subscribed:
                self.download_bodies(group[0],group[2])
            self.threads_pane.clear()
            self.article_pane.clear()
            self.progressbar.set_fraction(0)
            self.progressbar.set_text("")
            self.statusbar.push(1,_("Download Completed"))
            model,path,iter_selected=self.groups_pane.get_first_selected_row()
            if iter_selected:
                self.show_subscribed()
                self.groups_pane.groups_list.set_cursor(path,None,False)
                self.groups_pane.groups_list.row_activated(path,self.groups_pane.groups_list.get_column(0))
    
    def get_bodies_selected(self,obj):
        "Download bodies for marked articles in selected group"
        try:
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"rb")
        except IOError:
            self.statusbar.push(1,_("No Subscribed Groups"))
        else:
            subscribed=cPickle.load(f)
            f.close()
            model,path_list,iter_list=self.groups_pane.get_selected_rows()
            for path in path_list:
                iter_selected=model.get_iter(path)
                group_name=model.get_value(iter_selected,0)
                for group in subscribed:
                    if group[0]==group_name:
                        self.download_bodies(group[0],group[2])
            if path_list:
                self.threads_pane.clear()
                self.article_pane.clear()
                self.progressbar.set_fraction(0)
                self.progressbar.set_text("")
                self.statusbar.push(1,_("Download Completed"))
                self.groups_pane.groups_list.set_cursor(path_list[0],None,False)
                self.groups_pane.groups_list.row_activated(path_list[0],self.groups_pane.groups_list.get_column(0)) 
                        
    def download_bodies(self,group,server_name):
        articles=shelve.open(os.path.join(self.wdir,"groups_info/",group,group))
        self.statusbar.push(1,_("Downloading Bodies for %s") % (group,))
        marked_articles=[article for article in articles.itervalues() if article.marked_for_download==True]
        j=0
        length=len(marked_articles)
        for article in marked_articles:
            j=j+1
            body,bodyRetrieved=self.retrieve_body(article,group,server_name)
            articles[article.msgid]=article
            self.progressbar.set_fraction(j/float(length))
            self.progressbar.set_text(_("Downloading %s of %s") % (j,length))
            while gtk.events_pending():
                gtk.main_iteration(False)
        articles.close()
    
    def one_key_reading(self,obj):
        #increment=80
        vadj=self.article_pane.text_scrolledwin.get_vadjustment()
        increment= vadj.page_increment * int(self.configs["scroll_fraction"]) / 100
        value= vadj.get_value()
        if value+increment+vadj.page_size<vadj.upper:
            vadj.set_value(value+increment)
        else:
            if vadj.upper-vadj.page_size==vadj.get_value():
                self.view_next_unread_article(None)
            else:
                vadj.set_value(vadj.upper-vadj.page_size)

    def one_key_move_up(self,obj):
        vadj=self.article_pane.text_scrolledwin.get_vadjustment()
        decrement= vadj.page_increment * int(self.configs["scroll_fraction"]) / 100
        value= vadj.get_value()
        if value-decrement>vadj.lower:
            vadj.set_value(value-decrement)
        else:
            vadj.set_value(vadj.lower)
        
    def expand_all_threads(self,obj,expand):
        if expand: self.threads_pane.threads_tree.expand_all()
        else: self.threads_pane.threads_tree.collapse_all()
        self.threads_pane.threads_tree.queue_draw()

    
    def expand_selected_row(self,obj,expand):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected:
            path=model.get_path(iter_selected)
            if expand: self.threads_pane.threads_tree.expand_row(path,True)
            else: self.threads_pane.threads_tree.collapse_row(path)
            self.threads_pane.threads_tree.queue_draw()



    def mark_group(self,obj,mark_read):
        "Mark selected groups read or unread"
        model,path_list,iter_list=self.groups_pane.get_selected_rows()
        for path in path_list:
            iter_selected=model.get_iter(path)
            group_to_mark=model.get_value(iter_selected,0)
            try:
                articles=shelve.open(os.path.join(self.wdir,"groups_info/",group_to_mark,group_to_mark))
            except IOError:
                pass
            else:
                for article in articles.itervalues():
                    article.is_read=mark_read
                    articles[article.msgid]=article
                articles.close()
        if path_list:
            self.show_subscribed()

    def mark_all_groups(self,obj,mark_read):
        "Mark all groups read or unread"
        try:
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"rb")
        except IOError:
            pass
        else:
            subscribed=cPickle.load(f)
            f.close()
            for i in range(len(subscribed)):
                try:
                    articles=shelve.open(os.path.join(self.wdir,"groups_info/",subscribed[i][0],subscribed[i][0]))
                except IOError:
                    pass
                else:
                    for article in articles.itervalues():
                        article.is_read=mark_read
                        articles[article.msgid]=article
                    articles.close()
            self.show_subscribed()

    def keep_group(self,obj):
        "Set keep flag on the whole selected groups"
        model,path_list,iter_list=self.groups_pane.get_selected_rows()
        for path in path_list:
            iter_selected=model.get_iter(path)
            group_to_mark=model.get_value(iter_selected,0)
            try:
                articles=shelve.open(os.path.join(self.wdir,"groups_info/",group_to_mark,group_to_mark))
            except IOError:
                pass
            else:
                for article in articles.itervalues():
                    article.keep=not article.keep
                    articles[article.msgid]=article
                articles.close()
            self.show_subscribed()
 
    def rot13(self,text):
        "Rot13 the string passed"
        string_coded = ""
        dic={'a':'n','b':'o','c':'p','d':'q','e':'r','f':'s','g':'t',
             'h':'u','i':'v','j':'w','k':'x','l':'y','m':'z',
             'n':'a','o':'b','p':'c','q':'d','r':'e','s':'f','t':'g',
             'u':'h','v':'i','w':'j','x':'k','y':'l','z':'m',
             'A':'N','B':'O','C':'P','D':'Q','E':'R','F':'S','G':'T',
             'H':'U','I':'V','J':'W','K':'X','L':'Y','M':'Z',
             'N':'A','O':'B','P':'C','Q':'D','R':'E','S':'F','T':'G',
             'U':'H','V':'I','W':'J','X':'K','Y':'L','Z':'M'}
        for c in text:
            char=dic.get(c,c)
            string_coded=string_coded+char
        return string_coded

    def apply_rot13(self,obj):
        bounds=self.article_pane.buffer.get_selection_bounds()
        if bounds:
            #rot selected text
            start=bounds[0]
            stop=bounds[1]
            self.article_pane.buffer.create_mark("start_rot13",start,True)

            text=self.article_pane.buffer.get_text(start,stop,True).decode("utf-8")
            text_rotted=self.rot13(text)
            self.article_pane.buffer.delete_selection(False,False)
            self.article_pane.insert(text_rotted)

            start=self.article_pane.buffer.get_iter_at_mark(self.article_pane.buffer.get_mark("start_rot13"))
            self.article_pane.buffer.move_mark_by_name("insert",start)
        else:
            #rot the article
            bounds=self.article_pane.buffer.get_bounds()
            if bounds:
                start,stop=bounds
                text=self.article_pane.buffer.get_text(start,stop,True).decode("utf-8")
                text_rotted=self.rot13(text)
                self.show_article(text_rotted.split("\n"))


    def set_fixed_pitch(self,obj):
        monospace=pango.FontDescription("Monospace 9")
        user=pango.FontDescription(self.configs["font_name"])
        style=self.article_pane.textview.get_style().copy()
        if style.font_desc.get_family()!=monospace.get_family():
            self.article_pane.textview.modify_font(monospace)
        else:
            self.article_pane.textview.modify_font(user)


    def show_hide_headers(self,obj):
        self.article_pane.expander.set_expanded(not self.article_pane.expander.get_expanded())

    def export_newsrc(self,obj):
        def dispatch_response(dialog,id):
            if id==gtk.RESPONSE_OK:
                self.save_newsrc(None)
            if id==gtk.RESPONSE_CANCEL:
                self.file_dialog.destroy()
        self.file_dialog=gtk.FileChooserDialog(_("Select Newsrc Export Path"),None,gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_SAVE,gtk.RESPONSE_OK))
        self.file_dialog.set_local_only(True)
        #self.file_dialog.set_current_name("newsrc")
        self.file_dialog.connect("response",dispatch_response)
        path=self.file_dialog.get_current_folder()
        self.file_dialog.set_current_folder(path)
        self.file_dialog.show()

    def import_newsrc(self,obj):
        def dispatch_response(dialog,id):
            if id==gtk.RESPONSE_OK:
                self.load_newsrc(None)
            if id==gtk.RESPONSE_CANCEL:
                self.file_dialog.destroy()

        def show_hide_hidden(obj):
            self.file_dialog.set_property("show_hidden",obj.get_active())

        self.file_dialog=gtk.FileChooserDialog(_("Select Newsrc File"),None,gtk.FILE_CHOOSER_ACTION_OPEN,(gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN,gtk.RESPONSE_OK))
        hidden_checkbutton=gtk.CheckButton(_("Show Hidden Files"))
        self.file_dialog.set_extra_widget(hidden_checkbutton)
        hidden_checkbutton.connect("clicked",show_hide_hidden)
        self.file_dialog.set_local_only(True)
        self.file_dialog.connect("response",dispatch_response)
        path=self.file_dialog.get_current_folder()
        self.file_dialog.set_current_folder(path)
        self.file_dialog.show()

    def save_newsrc(self,obj):
        path=self.file_dialog.get_filename()
        newsrc_file=ExportNewsrc()
        newsrc_file.save_newsrc(path)
        self.file_dialog.destroy()
        self.statusbar.push(1,newsrc_file.message)

    def load_newsrc(self,obj):
        path=self.file_dialog.get_filename()
        self.file_dialog.destroy()
        file_name=os.path.split(path)[1] 
        try:
            server_name=file_name[0:file_name.index(".newsrc")]        
        except:
            server_name=""
        
        d=Dialog_Import_Newsrc(_("""To correctly import a newsrc file you have to use the same server you used when you saved the file.\n
By default XPN uses a name like 'server_name.newsrc' so it is possible to know wich server was used\n
When you try to import a newsrc file XPN searches for the server name in the file name.\n\n
<b>Server To Use:</b>"""),server_name)
        if d.resp==gtk.RESPONSE_OK:
            server_name=d.server_name
            try:
                f=open(path,"rb")
            except IOError:
                self.statusbar.push(1,_("File does not exist"))
            else:
                newsrc_file=f.readlines()
                imp_newsrc=ImportNewsrc(newsrc_file,self,self.configs,server_name)
                self.show_subscribed()
                self.progressbar.set_fraction(0.0)
                self.progressbar.set_text("")
                self.statusbar.push(1,_("Newsrc successful imported"))

    def modify_keybord_shortcuts(self,obj):
        self.shortcuts_win=KeyBindings(self)

    def context_mark_read(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            article=self.threads_pane.get_article(model,iter_selected)
            self.remove_from_unreads(article)
            self.threads_pane.update_article_icon("read")
            self.threads_pane.set_is_unread(model,iter_selected,False)
            
            next_iter=self.threads_pane.find_next_row(model,iter_selected)
            if next_iter!=None and self.configs.get("advance_on_mark","False")=="True":
                old_path=model.get_path(iter_selected)
                if not self.threads_pane.threads_tree.row_expanded(old_path):
                    self.threads_pane.threads_tree.set_cursor(old_path,None,False)
                    self.threads_pane.threads_tree.expand_row(old_path,False)
                path=model.get_path(next_iter)
                self.threads_pane.threads_tree.expand_row(path,False)
                self.threads_pane.threads_tree.scroll_to_cell(path,None,True,0.4,0.0)
                self.threads_pane.threads_tree.set_cursor(path,None,False)

    def context_mark_unread(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            article=self.threads_pane.get_article(model,iter_selected)            
            self.insert_in_unreads(article)
            self.threads_pane.set_is_unread(model,iter_selected,True)
            if article.body==None:
                self.threads_pane.update_article_icon("unread")
            else:
                self.threads_pane.update_article_icon("body")
            next_iter=self.threads_pane.find_next_row(model,iter_selected)
            if next_iter!=None and self.configs.get("advance_on_mark","False")=="True":
                old_path=model.get_path(iter_selected)
                if not self.threads_pane.threads_tree.row_expanded(old_path):
                    self.threads_pane.threads_tree.set_cursor(old_path,None,False)
                    self.threads_pane.threads_tree.expand_row(old_path,False)
                path=model.get_path(next_iter)
                self.threads_pane.threads_tree.expand_row(path,False)
                self.threads_pane.threads_tree.scroll_to_cell(path,None,True,0.4,0.0)
                self.threads_pane.threads_tree.set_cursor(path,None,False)

    def context_keep(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            article=self.threads_pane.get_article(model,iter_selected)
            self.set_keep(article,self.group_to_thread)
            if article.keep:
                self.threads_pane.update_article_icon("keep")
            else:
                self.threads_pane.update_article_icon("unkeep")
            next_iter=self.threads_pane.find_next_row(model,iter_selected)
            if next_iter!=None and self.configs.get("advance_on_mark","False")=="True":
                old_path=model.get_path(iter_selected)
                if not self.threads_pane.threads_tree.row_expanded(old_path):
                    self.threads_pane.threads_tree.set_cursor(old_path,None,False)
                    self.threads_pane.threads_tree.expand_row(old_path,False)
                path=model.get_path(next_iter)
                self.threads_pane.threads_tree.expand_row(path,False)
                self.threads_pane.threads_tree.scroll_to_cell(path,None,True,0.4,0.0)
                self.threads_pane.threads_tree.set_cursor(path,None,False)

    def context_keep_sub(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            self.keep_subthread(model,iter_selected)

    def context_watch(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            self.set_watch(model,iter_selected)

    def context_ignore(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            self.set_ignore(model,iter_selected)

    def context_modify_score(self,obj,action):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            article=self.threads_pane.get_article(model,iter_selected)
            newsgroup=self.group_to_thread
            from_name=article.from_name
            self.score_win=Score_Win(self.score_rules)
            self.score_win.header_opt_menu.set_active(0)
            self.score_win.scope_combo.child.set_text("["+newsgroup+"]")
            self.score_win.match_type_opt_menu.set_active(0)
            self.score_win.match_value_entry.set_text(from_name.encode("utf-8"))
            self.score_win.case_checkbutton.set_active(True)
            self.score_win.score_mod_spinbutton.set_value(100)
            self.score_win.score_mod_opt_menu.set_active(action)
            self.score_win.show()
            self.score_win.notebook.set_current_page(1)

    def context_mark_download(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            article=self.threads_pane.get_article(model,iter_selected)
            if article.body==None:
                self.mark_for_download(article)
                if article.marked_for_download:
                    self.threads_pane.update_article_icon("download")
                elif article.body!=None:
                    self.threads_pane.update_article_icon("body")
                else:
                    self.threads_pane.update_article_icon("unread")
                next_iter=self.threads_pane.find_next_row(model,iter_selected)
                if next_iter!=None and self.configs.get("advance_on_mark","False")=="True":
                    old_path=model.get_path(iter_selected)
                    if not self.threads_pane.threads_tree.row_expanded(old_path):
                        self.threads_pane.threads_tree.set_cursor(old_path,None,False)
                        self.threads_pane.threads_tree.expand_row(old_path,False)
                    path=model.get_path(next_iter)
                    self.threads_pane.threads_tree.expand_row(path,False)
                    self.threads_pane.threads_tree.scroll_to_cell(path,None,True,0.4,0.0)
                    self.threads_pane.threads_tree.set_cursor(path,None,False)

    def context_mark_download_sub(self,obj):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            self.mark_subthread_for_download(model,iter_selected)
    
    def context_mark_read_sub(self,obj,read):
        treesel=self.threads_pane.threads_tree.get_selection()
        model,iter_selected=treesel.get_selected()
        if iter_selected!=None:
            self.mark_subthread_read(model,iter_selected,read)

    
    
    def context_mark_download_group(self,obj):
        self.mark_group_for_download(self.group_to_thread)

    def threads_context_menu(self,obj,event):
        if event.button==3:
            menu=self.ui.get_widget("/flags")
            menu.popup(None,None,None,event.button,event.time)
    
    def groups_context_menu(self,obj,event):
        if event.button==3:
            menu=self.ui.get_widget("/mark_group")
            menu.popup(None,None,None,event.button,event.time)

    def find_article(self,obj):
        self.find_win=Find_Win(self)
        self.find_win.show()

    def global_search(self,obj):
        self.GlobalSearch=GlobalSearch(self)
        self.GlobalSearch.show()

    def search_in_the_article(self,obj):
        self.search_win=Search_Win(self)
        self.search_win.show()

    def connect_signals(self):
        #menuitems signals

        #groups_pane signals
        self.groups_pane.groups_list.connect("button_release_event",self.groups_context_menu)
        self.groups_pane.groups_list.connect("row_activated",self.view_group,"doubleclick")
        self.groups_pane.groups_list.get_selection().connect("changed",self.view_group,"oneclick")

        #threads_pane signals
        self.threads_pane.threads_tree.connect("button_release_event",self.threads_context_menu)
        self.threads_pane.threads_tree.connect("row_activated",self.view_article,"doubleclick")
        self.threads_pane.threads_tree.get_selection().connect("changed",self.view_article, "oneclick")
        
        self.threads_pane.column2.connect("clicked",self.save_sorting_type)
        self.threads_pane.column3.connect("clicked",self.save_sorting_type)
        self.threads_pane.column4.connect("clicked",self.save_sorting_type)
        self.threads_pane.column5.connect("clicked",self.save_sorting_type)

        
        #article_pane_signals
        self.article_pane.vbox.connect("mid_clicked",self.mid_clicked)

    def mid_clicked(self,obj,mid):
        dia=MidDialog(mid)
        if dia.resp==gtk.RESPONSE_OK:
            mid=dia.entry.get_text()
            if dia.sel[0]:
                self.find_article(None)
                self.find_win.entry_msgid.set_text(mid)
                self.find_win.checkbutton_start.set_active(True)
            elif dia.sel[1]:
                self.global_search(None)
                self.GlobalSearch.entry_msgid.set_text(mid)
            else:
                if self.article_pane.use_custom_browser:
                    launcher=webbrowser.get("xpn_launcher")
                    launcher.open("http://groups.google.com/groups?selm="+url_quote(mid))
                else:
                    webbrowser.open("http://groups.google.com/groups?selm="+url_quote(mid))
                    
    def build_panes(self):
        self.groups_pane=Groups_Pane(_("Newsgroups"),_("UnRead"),True,self.configs)
        self.threads_pane=Threads_Pane(self.configs)
        if self.configs["show_headers"]=="True":
            show_headers=True
        else:
            show_headers=False
        self.article_pane=Article_Pane(show_headers,self.configs)

    def set_sizes(self):
        try:
            f=open(os.path.join(self.wdir,"dats/sizes.dat"),"rb")
        except IOError:
            vpaned_pos=120
            hpaned_pos=200
            groups_col1_width=145
            threads_col_subject_width=415
            threads_col_from_width=201
            threads_col_date_width=95
            self.window.maximize()
        else:
            sizes=cPickle.load(f)
            f.close()
            vpaned_pos=sizes.get("vpaned_pos",120)
            hpaned_pos=sizes.get("hpaned_pos",200)
            mainwin_width=sizes.get("mainwin_width",640)
            mainwin_height=sizes.get("mainwin_height",480)
            mainwin_pos_x=sizes.get("mainwin_pos_x",0)
            mainwin_pos_y=sizes.get("mainwin_pos_y",0)
            groups_col1_width=int(sizes.get("groups_col1",145))
            threads_col_subject_width=int(sizes.get("threads_col_subject",415))
            threads_col_from_width=int(sizes.get("threads_col_from",201))
            threads_col_date_width=int(sizes.get("threads_col_date",95))
            self.window.resize(int(mainwin_width),int(mainwin_height))
            self.window.move(int(mainwin_pos_x),int(mainwin_pos_y))
        self.hpaned.set_position(int(hpaned_pos))
        self.vpaned.set_position(int(vpaned_pos))
        self.groups_pane.column1.set_fixed_width(groups_col1_width)
        self.threads_pane.column2.set_fixed_width(threads_col_subject_width)
        self.threads_pane.column3.set_fixed_width(threads_col_from_width)
        self.threads_pane.column4.set_fixed_width(threads_col_date_width)

        

    def build_layout_type_1(self,layout_number,swap=False):
        if layout_number==1:
            self.pane_1=self.groups_pane
            self.pane_2=self.threads_pane
            self.pane_3=self.article_pane
        elif layout_number==2:
            self.pane_1=self.threads_pane
            self.pane_2=self.groups_pane
            self.pane_3=self.article_pane
        elif layout_number==3:
            self.pane_1=self.article_pane
            self.pane_2=self.groups_pane
            self.pane_3=self.threads_pane
        elif layout_number==4:
            self.pane_1=self.groups_pane
            self.pane_2=self.article_pane
            self.pane_3=self.threads_pane
        elif layout_number==5:
            self.pane_1=self.threads_pane
            self.pane_2=self.article_pane
            self.pane_3=self.groups_pane
        elif layout_number==6:
            self.pane_1=self.article_pane
            self.pane_2=self.threads_pane
            self.pane_3=self.groups_pane
            
        #Vpaned
        self.vpaned=gtk.VPaned()
        self.vbox1.pack_start(self.vpaned,True,True,0)
        self.vpaned.show()

        #HPaned
        self.hpaned=gtk.HPaned()
        self.hpaned.show()

        pane_1_parent,pane_2_parent,pane_3_parent=self.unlink_panes()
        
        #Groups Pane
        self.hpaned.add(self.pane_1.get_widget())
        self.pane_1.show()

        #Threads Pane
        self.hpaned.add(self.pane_2.get_widget())
        self.pane_2.show()

        #Article Pane
        
        if not swap:
            self.vpaned.add(self.hpaned)
            self.vpaned.add(self.pane_3.get_widget())
        else:
            self.vpaned.add(self.pane_3.get_widget())
            self.vpaned.add(self.hpaned)
            
        self.pane_3.show()

        if pane_3_parent!=None and pane_2_parent!=None and pane_1_parent!=None:
            pane_3_parent.get_parent().remove(pane_3_parent)
            if pane_1_parent!=pane_3_parent:
                pane_1_parent.get_parent().remove(pane_1_parent)
            if pane_2_parent!=pane_3_parent and pane_2_parent!=pane_1_parent:
                pane_2_parent.get_parent().remove(pane_2_parent)


    def build_layout_type_2(self,layout_number,swap=False):
        if layout_number==1:
            self.pane_1=self.groups_pane
            self.pane_2=self.threads_pane
            self.pane_3=self.article_pane
        elif layout_number==2:
            self.pane_1=self.groups_pane
            self.pane_2=self.article_pane
            self.pane_3=self.threads_pane
        elif layout_number==3:
            self.pane_1=self.article_pane
            self.pane_2=self.groups_pane
            self.pane_3=self.threads_pane
        elif layout_number==4:
            self.pane_1=self.article_pane
            self.pane_2=self.threads_pane
            self.pane_3=self.groups_pane
        elif layout_number==5:
            self.pane_1=self.threads_pane
            self.pane_2=self.article_pane
            self.pane_3=self.groups_pane
        elif layout_number==6:
            self.pane_1=self.threads_pane
            self.pane_2=self.groups_pane
            self.pane_3=self.article_pane

        #HPaned
        self.hpaned=gtk.HPaned()
        self.vbox1.pack_start(self.hpaned,True,True,0)
        self.hpaned.show()

        #Vpaned
        self.vpaned=gtk.VPaned()
        self.vpaned.show()

        pane_1_parent,pane_2_parent,pane_3_parent=self.unlink_panes()
        
        #Groups Pane
        self.vpaned.add(self.pane_1.get_widget())
        self.pane_1.show()


        #Threads Pane
        self.vpaned.add(self.pane_2.get_widget())
        self.pane_2.show()

        #Article Pane
        
        if not swap:
            self.hpaned.add(self.vpaned)
            self.hpaned.add(self.pane_3.get_widget())
        else:
            self.hpaned.add(self.pane_3.get_widget())
            self.hpaned.add(self.vpaned)
            
        self.pane_3.show()

        if pane_3_parent!=None and pane_2_parent!=None and pane_1_parent!=None:
            pane_3_parent.get_parent().remove(pane_3_parent)
            if pane_1_parent!=pane_3_parent:
                pane_1_parent.get_parent().remove(pane_1_parent)
            if pane_2_parent!=pane_3_parent and pane_2_parent!=pane_1_parent:
                pane_2_parent.get_parent().remove(pane_2_parent)
    
    def build_layout_type_3(self,layout_number):
        self.build_layout_type_2(layout_number,True)
    
    def build_layout_type_4(self,layout_number):
        self.build_layout_type_1(layout_number,True)


    def purge_groups(self):
        purge_read_limit=int(self.configs["purge_read"])
        purge_read_limit_secs=purge_read_limit*24*60*60
        purge_unread_limit=int(self.configs["purge_unread"])
        purge_unread_limit_secs=purge_unread_limit*24*60*60
        

        time_now=mktime_tz(parsedate_tz(time.ctime()))
        try:
            f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"rb")
        except IOError:
            pass
        else:
            subscribed=cPickle.load(f)
            f.close()
            watched=set()
            ignored=set()
            for group in subscribed:
                try:
                    articles=shelve.open(os.path.join(self.wdir,"groups_info/",group[0],group[0]))
                    articles_dict=dict(articles)
                    articles.close()
                    shutil.rmtree(os.path.join(self.wdir,"groups_info/",group[0]))
                except IOError:
                    pass
                else:
                    to_remove=[]
                    for article in articles_dict.itervalues():
                        if not article.keep:
                            if article.is_read:
                                #this is a read article
                                if time_now-article.secs>purge_read_limit_secs and purge_read_limit_secs>0:
                                    #we have to purge the article
                                    to_remove.append(article)
                            else:
                                #this is an unread article
                                if time_now-article.secs>purge_unread_limit_secs and purge_unread_limit_secs>0:
                                    #we have to purge the article
                                    to_remove.append(article)
                        
                        if article.watch:
                            #refresh the watched/ignored files
                            watched.add(article.msgid)
                        if article.ignore:
                            ignored.add(article.msgid)

                    self.statusbar.push(1,_("Purging Group: %s") % (group[0],))
                    while gtk.events_pending():
                        gtk.main_iteration(False)

                    for article in to_remove:
                        #purging watched/ignored
                        articles_dict.pop(article.msgid)
                        if article.msgid in watched:
                            watched.discard(article.msgid)
                        if article.msgid in ignored:
                            ignored.discard(article.msgid)

                    #rebuild the database
                    os.makedirs(os.path.join(self.wdir,"groups_info",group[0]))
                    articles=shelve.open(os.path.join(self.wdir,"groups_info/",group[0],group[0]))
                    articles.update(articles_dict)

                    articles.close()
            self.dump_watched(watched)
            self.dump_ignored(ignored)


    def rebuild_layout(self):
        layout_methods = {"1":self.build_layout_type_1,
                          "2":self.build_layout_type_2,
                          "3":self.build_layout_type_3,
                          "4":self.build_layout_type_4
                         }
        r,c=divmod(int(self.configs["layout"])-1,6)
        layout_builder = layout_methods.get(str(r+1), None)
        if layout_builder: layout_builder(c+1)
        else: self.build_layout_type_1(1)
        self.set_sizes()

    def unlink_panes(self):
        pane_1_parent=self.pane_1.get_widget().get_parent()
        if pane_1_parent!=None:
            pane_1_parent.remove(self.pane_1.get_widget())
        pane_2_parent=self.pane_2.get_widget().get_parent()
        if pane_2_parent!=None:
            pane_2_parent.remove(self.pane_2.get_widget())
        pane_3_parent=self.pane_3.get_widget().get_parent()
        if pane_3_parent!=None:
            pane_3_parent.remove(self.pane_3.get_widget())
        return pane_1_parent,pane_2_parent,pane_3_parent
        
    def zoom_pane(self,pane,button):
        buttons=[self.zoom_groups_button,self.zoom_threads_button,self.zoom_article_button]
        status=button.get_active() #mantaining status
        buttons.remove(button)
        for other_button in buttons:
            other_button.set_active(False)
        button.set_active(status)

        if button.get_active()==True:
            parent1=pane.get_widget().get_parent()
            parent2=parent1.get_parent()
            parent3=parent2.get_parent()

        pane_1_parent,pane_2_parent,pane_3_parent=self.unlink_panes()
        try:self.vbox1.remove(self.hpaned)
        except:pass
        try:self.vbox1.remove(self.vpaned)
        except:pass
        
        if button.get_active()==True:
            if type(parent1)==type(gtk.VBox()):
                self.vbox1.pack_start(pane.get_widget(),True,True,0)
            if type(parent2)==type(gtk.VBox()):
                parent2.remove(parent1)
                self.vbox1.pack_start(pane.get_widget(),True,True,0)
            if type(parent3)==type(gtk.VBox()):
                parent3.remove(parent2)
                self.vbox1.pack_start(pane.get_widget(),True,True,0)
        else:
            self.rebuild_layout()
    
    def zoom_article(self,obj):
        self.zoom_pane(self.article_pane,obj)

    def zoom_groups(self,obj):
        self.zoom_pane(self.groups_pane,obj)

    def zoom_threads(self,obj):
        self.zoom_pane(self.threads_pane,obj)

    def get_watched(self):
        try:
            f=open(os.path.join(self.wdir,"dats/watch.dat"),"rb")
        except IOError:
            watched=set()
        else:
            watched=cPickle.load(f)
            f.close()
        return watched

    def dump_watched(self,watched):
        f=open(os.path.join(self.wdir,"dats/watch.dat"),"wb")
        cPickle.dump(watched,f,1)
        f.close()

    def get_ignored(self):
        try:
            f=open(os.path.join(self.wdir,"dats/ignore.dat"),"rb")
        except IOError:
            ignored=set()
        else:
            ignored=cPickle.load(f)
            f.close()
        return ignored

    def dump_ignored(self,ignored):
        f=open(os.path.join(self.wdir,"dats/ignore.dat"),"wb")
        cPickle.dump(ignored,f,1)
        f.close()
   
    def recover_subscribed(self):
        '''Try to recover subscribed.dat when it is corrupted'''
        try:
            file_list=os.listdir(os.path.join(self.wdir,"groups_info/")) 
        except:
            pass
        else:
            subscribed=[]
            for file in file_list:
                if file!="groups.dat" and file!="subscribed.dat" and os.path.isdir(os.path.join(self.wdir,"groups_info/",file)):
                    articles=shelve.open(os.path.join(self.wdir,"groups_info/",file,file))
                    max=0
                    for article in articles.values():
                        if article.number>max:
                            max=article.number
                    articles.close()
                    subscribed.append([file,max])
            if subscribed:
                f=open(os.path.join(self.wdir,"groups_info/subscribed.dat"),"w")
                cPickle.dump(subscribed,f,1)
                f.close()
            else:
                os.remove(os.path.join(self.wdir,"groups_info/subscribed.dat"))
    
    def load_languages(self):
        #loading translation
        if self.configs["lang"]=="it":
            it=gettext.translation("xpn","lang",["it"])
            it.install()
            try:
                #trying to force GTK translation
                locale.setlocale(locale.LC_MESSAGES,"it_IT")
            except: pass
        elif self.configs["lang"]=="fr":
            fr=gettext.translation("xpn","lang",["fr"])
            fr.install()
            try:
                #trying to force GTK translation
                locale.setlocale(locale.LC_MESSAGES,"fr_FR")
            except: pass
        elif self.configs["lang"]=="de":
            de=gettext.translation("xpn","lang",["de"])
            de.install()
            try:
                #trying to force GTK translation
                locale.setlocale(locale.LC_MESSAGES,"de_DE")
            except: pass
        else:
            try:
                #trying to force GTK translation
                locale.setlocale(locale.LC_MESSAGES,"en_US")
            except: pass
    
    def create_ui(self):

        #loading icons
        def _iconset (filename):
            return gtk.IconSet (gtk.gdk.pixbuf_new_from_file (os.path.join ("pixmaps", filename)))
        self.icons=gtk.IconFactory()
        for icon_name in os.listdir("pixmaps"):
            if "." in icon_name and not icon_name.endswith(".svg"):
                self.icons.add("xpn_"+icon_name.split(".")[0], _iconset (icon_name))
        self.icons.add_default()

        
        #try:
        #    self.ui.remove_action_group(self.actiongroup) 
        #    self.ui.remove_ui(self.merge_id)
        #    self.window.remove_accel_group(self.accel_group)
        #except:
        #    pass


        self.ui = gtk.UIManager()
        self.accelgroup = self.ui.get_accel_group()
        self.actiongroup= gtk.ActionGroup("MainWindowActions")

        self.window.add_accel_group(self.accelgroup)
        mscuts=load_shortcuts("main")
        self.actions=[("File",None,_("_File")),
                ("groups","xpn_groups",_("_Groups List..."),mscuts["groups"],_("Manage Groups"),self.open_groups_win),
                ("rules","xpn_score",_("_Scoring and Action Rules..."),mscuts["rules"],_("Edit Scoring and Action Rules"),self.open_rules_win),
                ("logs",None,_("Server _Logs..."),mscuts["logs"],None,self.open_logs_win),                       
                ("exp_newsrc",None,_("Export _Newsrc..."),mscuts["exp_newsrc"],None,self.export_newsrc),
                ("imp_newsrc",None,_("_Import Newsrc..."),mscuts["imp_newsrc"],None,self.import_newsrc),
                ("accelerator",None,_("_Modify Keyboard Shortcuts..."),mscuts["accelerator"],None,self.modify_keybord_shortcuts),
                ("conf","xpn_conf",_("_Preferences..."),mscuts["conf"],_("Preferences"),self.open_configure_win),
                ("exit","xpn_exit",_("_Exit"),mscuts["exit"],None,self.destroy),
                ("Subscribed",None,_("Subscribed _Groups")),
                ("gethdrs","xpn_receive_headers",_("_Get New Headers in Subscribed Groups"),mscuts["gethdrs"],_("Get New Headers in Subscribed Groups"),self.get_new_headers),
                ("gethdrssel","xpn_receive_headers_selected",_("_Get New Headers in Selected Groups"),mscuts["gethdrssel"],None,self.get_new_headers_selected),
                ("getbodies","xpn_receive_bodies",_("Get Marked Article _Bodies in Subscribed Groups"),mscuts["getbodies"],_("Get Marked Article Bodies in Subscribed Groups"),self.get_bodies),
                ("getbodiessel","xpn_receive_bodies_selected",_("Get Marked Article _Bodies in Selected Groups"),mscuts["getbodiessel"],None,self.get_bodies_selected),
                ("expand","xpn_expand_all",_("_Expand All Threads"),mscuts["expand"],_("Expand All"),self.expand_all_threads,True),
                ("collapse","xpn_collapse_all",_("_Collapse All Threads"),mscuts["collapse"],_("Collapse All"),self.expand_all_threads,False),
                ("expand_row","xpn_expand",_("_Expand Selected SubThread"),mscuts["expand_row"],_("Expand Selected SubThread"),self.expand_selected_row,True),
                ("collapse_row","xpn_collapse",_("_Collapse Selected SubThread"),mscuts["collapse_row"],_("Collapse Selected SubThread"),self.expand_selected_row,False),
                ("group",None,_("_View Next Group"),mscuts["group"],None,self.groups_pane.view_next_group),
                ("mark_group",None,_("Mark Group ...")),
                ("mark","xpn_mark",_("_Mark Selected Groups as Read"),mscuts["mark"],_("Mark Selected Groups as Read"),self.mark_group,True),
                ("mark_unread_group",None,_("Mark Selected Groups as Unread"),mscuts["mark_unread_group"],None,self.mark_group,False),
                ("mark_download_group","xpn_mark_multiple",_("Mark Group for Retrieving"),mscuts["mark_download_group"],None,self.context_mark_download_group),
                ("keepall","xpn_art_keep",_("Keep Articles in Selected Groups"),mscuts["keepall"],None,self.keep_group),
                ("markall","xpn_mark_all",_("Mark _All Groups as Read"),mscuts["markall"],_("Mark All Groups as Read"),self.mark_all_groups,True),
                ("markall_unread",None,_("Mark All Groups as Unread"),mscuts["markall_unread"],None,self.mark_all_groups,False),
                ("view_group_opts",None,_("View Options")),
                ("find","xpn_find",_("_Find Article..."),mscuts["find"],None,self.find_article),
                ("global","xpn_global_search",_("Global _Search ..."),mscuts["global"],None,self.global_search),
                ("apply_score",None,_("Apply Scoring and Action Rules"),mscuts["apply_score"],None,self.reapply_score_actions_rules),
                ("groups_vs_id",None,_("Assign Identities to Groups"),mscuts["groups_vs_id"],None,self.open_groups_vs_id),
                ("Articles",None,_("_Articles")),
                ("previous","xpn_previous",_("Read Previous Article"),mscuts["previous"],_("Read Previous Article"),self.view_previous_article),
                ("next","xpn_next",_("Read Next Article"),mscuts["next"],_("Read Next Article"),self.view_next_article),
                ("next_unread","xpn_next_unread",_("Read _Next Unread Article"),mscuts["next_unread"],_("Read Next Unread Article"),self.view_next_unread_article),
                ("parent",None,_("Read Parent Article"),mscuts["parent"],None,self.view_parent_article),
                ("one_key",None,_("One-Key Reading"),mscuts["one_key"],None,self.one_key_reading),
                ("move_up",None,_("One-Key Scroll Up"),mscuts["move_up"],None,self.one_key_move_up),
                ("search","xpn_search",_("_Search in the Body..."),mscuts["search"],None,self.search_in_the_article),
                ("view_articles_opts",None,_("View Options")),
                ("show_hide_headers",None,_("Show/Hide _Headers"),mscuts["show_hide_headers"],None,self.show_hide_headers),
                ("rot13","xpn_rot13",_("_ROT13 Selected Text"),mscuts["rot13"],_("ROT13 Selected Text"),self.apply_rot13),
                ("flags",None,_("Flags & Score")),
                ("mark_read","xpn_art_read",_("Mark Article as Read"),mscuts["mark_read"],None,self.context_mark_read),
                ("mark_unread","xpn_art_unread",_("Mark Article as UnRead"),mscuts["mark_unread"],None,self.context_mark_unread),
                ("mark_download","xpn_art_mark",_("Mark Article for Retrieving"),mscuts["mark_download"],None,self.context_mark_download),
                ("keep","xpn_art_keep",_("Keep Article"),mscuts["keep"],None,self.context_keep),
                ("mark_unread_sub",None,_("Mark SubThread as UnRead"),mscuts["mark_unread_sub"],None,self.context_mark_read_sub,False),
                ("mark_read_sub","xpn_art_read",_("Mark SubThread as Read"),mscuts["mark_read_sub"],None,self.context_mark_read_sub,True),
                ("mark_download_sub","xpn_mark_multiple",_("Mark SubThread for Retrieving"),mscuts["mark_download_sub"],None,self.context_mark_download_sub),
                ("keep_sub","xpn_art_keep",_("Keep SubThread"),mscuts["keep_sub"],None,self.context_keep_sub),
                ("watch","xpn_art_watch",_("Watch SubThread"),mscuts["watch"],None,self.context_watch),
                ("ignore","xpn_art_ignore",_("Ignore SubThread"),mscuts["ignore"],None,self.context_ignore),
                ("raise_score","xpn_raise_score",_("Raise Author Score"),mscuts["raise_score"],None,self.context_modify_score,0),
                ("lower_score","xpn_lower_score",_("Lower Author Score"),mscuts["lower_score"],None,self.context_modify_score,1),
                ("set_score","xpn_set_score",_("Set Author Score"),mscuts["set_score"],None,self.context_modify_score,2),
                ("post","xpn_post",_("_Post New Article..."),mscuts["post"],_("Post New Article"),self.open_edit_win),
                ("outbox_manager","xpn_outbox",_("_Open Outbox Manager"),mscuts["outbox_manager"],_("Open Outbox Manager"),self.open_outbox_manager),
                ("followup","xpn_followup",_("_Follow-Up To Newsgroup..."),mscuts["followup"],_("Follow-Up To Newsgroup"),self.open_edit_win,True),
                ("reply","xpn_reply",_("Reply By _Mail..."),mscuts["reply"],_("Reply by Mail"),self.open_edit_mail_win),
                ("supersede","xpn_supersede",_("Supersede Article..."),mscuts["supersede"],None,self.supersede_cancel_message,"Supersede"),
                ("cancel","xpn_cancel",_("Cancel Article..."),mscuts["cancel"],None,self.supersede_cancel_message,"Cancel"),
                ("Help",None,_("Help")),
                ("about","xpn_about",_("_About..."),mscuts["about"],None,self.open_about_dialog)]
                
        for action in self.actions:
            if len(action)<7:
                self.actiongroup.add_actions([action])
            else:
                self.actiongroup.add_actions([action[0:6]],action[-1])

        self.toggle_actions=[
                ("show_threads",None,_("_Show Threads"),mscuts["show_threads"],None,self.view_group,False,None,None),
                ("show_all_read_threads",None,_("_Show All Read Threads"),mscuts["show_all_read_threads"],None,self.view_group,False,None,None),
                ("show_read_articles",None,_("_Show Read Articles"),mscuts["show_read_articles"],None,self.view_group,False,None,None),
                ("show_unread_articles",None,_("_Show UnRead Articles"),mscuts["show_unread_articles"],None,self.view_group,False,None,None),
                ("show_kept_articles",None,_("_Show Kept Articles"),mscuts["show_kept_articles"],None,self.view_group,False,None,None),
                ("show_unkept_articles",None,_("_Show UnKept Articles"),mscuts["show_unkept_articles"],None,self.view_group,False,None,None),
                ("show_watched_articles",None,_("_Show Watched Articles"),mscuts["show_watched_articles"],None,self.view_group,False,None,None),
                ("show_ignored_articles",None,_("_Show Ignored Articles"),mscuts["show_ignored_articles"],None,self.view_group,False,None,None),
                ("show_unwatchedignored_articles",None,_("_Show UnWatched/UnIgnored Articles"),mscuts["show_unwatchedignored_articles"],None,self.view_group,False,None,None),
                ("show_score_neg_articles",None,_("_Show Articles with Score<0"),mscuts["show_score_neg_articles"],None,self.view_group,False,None,None),
                ("show_score_zero_articles",None,_("_Show Articles with Score=0"),mscuts["show_score_zero_articles"],None,self.view_group,False,None,None),
                ("show_score_pos_articles",None,_("_Show Articles with Score>0"),mscuts["show_score_pos_articles"],None,self.view_group,False,None,None),
                ("raw",None,_("_View Raw Article"),mscuts["raw"],None,self.view_article,False),
                ("spoiler",None,_("Show Spoilered Text"),mscuts["spoiler"],None,self.view_article,False),
                ("show_quote",None,_("Show Quoted Text"),mscuts["show_quote"],None,self.view_article,False),
                ("show_sign",None,_("Show Signatures"),mscuts["show_sign"],None,self.view_article,False),
                ("fixed",None,_("Fixed Pitch Font"),mscuts["fixed"],None,self.set_fixed_pitch,False)]


        for action in self.toggle_actions: 
            if len(action)<8:
                self.actiongroup.add_toggle_actions([action])
            else:
                self.actiongroup.add_toggle_actions([action[0:7]],action[7:])

        self.ui.insert_action_group(self.actiongroup,0)
        self.merge_id = self.ui.add_ui_from_string(ui_string)
        self.ui.ensure_update()  
                
 



    def __init__(self,use_home,custom_dir):
        Edit_Win.VERSION=VERSION
        Edit_Mail_Win.VERSION=VERSION
        if use_home:           
            userdir=UserDir(userHome=True)
        elif custom_dir:
            userdir=UserDir(customPath=custom_dir)
        else:
            userdir=UserDir(cwd=True)
        ret=userdir.Create()
        if ret>0 :sys.exit(ret)
        self.wdir=userdir.dir
        
        self.conf=Config_File()
        self.configs=self.conf.get_configs()

        self.load_languages()
        
        try: open(os.path.join(self.wdir,"xpn.lock"),"r")
        except IOError:open(os.path.join(self.wdir,"xpn.lock"),"w")
        else: 
            #raise StandardError, "An istance of XPN is already running, if you think this is an error remove manually the file 'xpn.lock' in your XPN working directory."
            md=Dialog_YES_NO(_("An instance of XPN is already running.\n\nDo you want to open XPN anyway?"))
            if not md.resp:
                sys.exit()
        
        try: os.remove(os.path.join(self.wdir,"server_logs.dat"))
        except: pass

        try: os.remove(os.path.join(self.wdir,"error_logs.dat"))
        except: pass

        try: map(shutil.rmtree,glob.glob(os.path.join(self.wdir,"groups_info/global.search.results.*")))
        except: pass

        try: os.makedirs(os.path.join(self.wdir,"groups_info"))
        except: pass
        
        try: os.makedirs(os.path.join(self.wdir,"dats"))
        except: pass

        try: os.makedirs(os.path.join(self.wdir,"outbox/news"))
        except: pass
        try: os.makedirs(os.path.join(self.wdir,"outbox/mail"))
        except: pass

        try: os.makedirs(os.path.join(self.wdir,"draft/news"))
        except: pass
        try: os.makedirs(os.path.join(self.wdir,"draft/mail"))
        except: pass
        
        try: os.makedirs(os.path.join(self.wdir,"sent/news"))
        except: pass
        try: os.makedirs(os.path.join(self.wdir,"sent/mail"))
        except: pass
        
        self.s=None

        
        self.groups_lock=False
        self.group_to_thread=""
        self.current_server=""
        self.subscribed_groups=[]

        cp=ConfigParser.ConfigParser()
        cp.read(os.path.join(get_wdir(),"dats","servers.txt"))
        self.connectionsPool=dict()
        for server in cp.sections():
            if cp.get(server,"nntp_use_ssl")=="True":
                self.connectionsPool[server]=SSLConnection(cp.get(server,"server"),cp.get(server,"port"),cp.get(server,"auth"),cp.get(server,"username"),cp.get(server,"password"))
            else:
                self.connectionsPool[server]=Connection(cp.get(server,"server"),cp.get(server,"port"),cp.get(server,"auth"),cp.get(server,"username"),cp.get(server,"password"))


        #loading score rules
        self.score_rules=Score_Rules()

        #MainMenuBar
        self.window=gtk.Window (gtk.WINDOW_TOPLEVEL)
        self.window.connect("delete_event",self.delete_event)
        self.window.connect("destroy",self.destroy)
        self.window.set_title("XPN "+NUMBER)
        self.window.set_icon(gtk.gdk.pixbuf_new_from_file("pixmaps/xpn-icon.png"))
        self.window.set_size_request(300,200)

        self.build_panes()        

        #UIManager
        self.create_ui()


        menubar=self.ui.get_widget("/MainMenuBar")
        toolbar=self.ui.get_widget("/MainToolBar")
        #toolbar.set_icon_size(gtk.ICON_SIZE_LARGE_TOOLBAR)
        toolbar.set_orientation(gtk.ORIENTATION_HORIZONTAL)
        toolbar.set_style(gtk.TOOLBAR_ICONS)
        toolbar.set_style(gtk.SHADOW_NONE)

        #main vbox
        self.vbox1 = gtk.VBox(False,0)
        self.window.add(self.vbox1)
        self.vbox1.show()

        self.vbox1.pack_start(menubar,False,True,0)
        menubar.show()        

        #Handlebox
        self.vbox1.pack_start(toolbar,False,False,0)
        toolbar.show()


        layout_methods = {"1":self.build_layout_type_1,
                          "2":self.build_layout_type_2,
                          "3":self.build_layout_type_3,
                          "4":self.build_layout_type_4
                         }
        r,c=divmod(int(self.configs["layout"])-1,6)
        layout_builder = layout_methods.get(str(r+1), None)
        if layout_builder: layout_builder(c+1)
        else: self.build_layout_type_1(1)   # If there is no layout associated to
                                            # self.configs["layout"] then build 1


        #hbox_bottom
        hbox_bottom=gtk.HBox()
        self.vbox1.pack_end(hbox_bottom,False,False,0)
        hbox_bottom.show()

        #progressbar
        self.progressbar=gtk.ProgressBar()
        hbox_bottom.pack_start(self.progressbar,False,False,0)
        self.progressbar.show()

        #Zoom Buttons
        self.zoom_article_button=gtk.ToggleButton("A")
        self.zoom_threads_button=gtk.ToggleButton("H")
        self.zoom_groups_button=gtk.ToggleButton("G")
        self.zoom_article_button.set_relief(gtk.RELIEF_NONE)
        self.zoom_threads_button.set_relief(gtk.RELIEF_NONE)
        self.zoom_groups_button.set_relief(gtk.RELIEF_NONE)
        self.zoom_article_button.connect("clicked",self.zoom_article)
        self.zoom_threads_button.connect("clicked",self.zoom_threads)
        self.zoom_groups_button.connect("clicked",self.zoom_groups)
        zoom_article_tip=gtk.Tooltips()
        zoom_threads_tip=gtk.Tooltips()
        zoom_groups_tip=gtk.Tooltips()
        zoom_article_tip.set_tip(self.zoom_article_button,_("Zoom Article Pane"))
        zoom_threads_tip.set_tip(self.zoom_threads_button,_("Zoom Headers Pane"))
        zoom_groups_tip.set_tip(self.zoom_groups_button,_("Zoom Groups Pane"))
        hbox_bottom.pack_start(self.zoom_article_button,False,False,0)
        hbox_bottom.pack_start(self.zoom_threads_button,False,False,0)
        hbox_bottom.pack_start(self.zoom_groups_button,False,False,0)
        self.zoom_article_button.show()
        self.zoom_threads_button.show()
        self.zoom_groups_button.show()

        separator=gtk.VSeparator()
        separator.show()
        hbox_bottom.pack_start(separator,False,False,0)


        #statusbar
        self.statusbar=gtk.Statusbar()
        hbox_bottom.pack_start(self.statusbar,True,True,0)
        self.statusbar.show()


        

        self.connect_signals()

        self.show_subscribed()

        self.update_checkmenu_options()

        monospace=pango.FontDescription("Monospace 9")
        if self.configs["use_system_fonts"]=="True":
            user=pango.FontDescription("")
        else:
            user=pango.FontDescription(self.configs["font_name"])
        if self.configs["fixed"]=="True":
            self.article_pane.textview.modify_font(monospace)
        else:
            self.article_pane.textview.modify_font(user)
        self.article_pane.textview.set_indent(5)
        self.set_sizes()
        self.mainwin_width=None  #I must use these because if I close the window with the [x]
        self.mainwin_height=None #I loose window sizes
        self.mainwin_pos_x=None
        self.mainwin_pos_y=None
        
        self.window.show()
        
        if not self.conf.found_config_file:
            dia=Dialog_YES_NO(_("Missing Config File.\n\nDo you want to Configure XPN now?"))
            if dia.resp:
                self.open_configure_win(None)

def hook(et,ev,eb):
    import traceback
    ex_list=traceback.format_exception(et,ev,eb)
    list="".join(ex_list)
    if not ("sys.exit()" in list or "systemexit" in list.lower()):
        message="\n"+"".join(ex_list)
        log=message
        try:
            f=open(os.path.join(wdir,"error_logs.dat"),"a")
        except IOError:
            pass
        else:
            f.write(":::: "+time.ctime(time.time())+" :::: \n"+message+"\n\n")
            f.close()
        try:
            f=open(os.path.join(wdir,"error_logs.dat"),"rb")
        except IOError:
            pass
        else:
            log=f.read()
        try:
            error_dialog=Error_Dialog(unicode(message,"us-ascii","replace").encode("utf-8"),unicode(log,"us-ascii","replace").encode("utf-8"))
            error_dialog.run()
        except:
            sys.stderr.write(_('Unexpected error in the excepthook.'))
            sys.stderr.write('\n\n')
            message = message="\n"+"".join(traceback.format_exception(*sys.exc_info()))
            sys.stderr.write(message)
        else:
            error_dialog.destroy() 


parser=OptionParser(usage=_("python %prog [-d] [-cCUSTOM_DIR]\n\nWith command line options you can decide where XPN will save config files and articles.\nIf you don't use any option, the current working directory will be used.\nIf you use the '--home_dir' option, XPN will create a .xpn directory inside your home directory, and will store informations inside that directory.\nIf you use the '--custom_dir' option, XPN will create a .xpn directory inside that custom_directory.\n\nNOTE: If you set the '--home_dir' option, XPN will ignore the '--custom_dir' option (if you used it).\n\nExamples:\npython xpn.py\npython xpn.py -d\npython xpn.py --custom_dir /home/user/custom"))
parser.add_option("-d","--home_dir",action="store_true",dest="use_home",default=False,
                  help=_("use home directory to store config files and articles"))
parser.add_option("-c","--custom_dir",dest="custom_dir",
                  help=_("specify an existing directory where store config files and articles"))
options,args=parser.parse_args()

try: dir=os.path.dirname(sys.argv[0])
except: dir=""
if dir:
    try:os.chdir(dir)
    except: pass

try:
    main=MainWin(options.use_home,options.custom_dir)
    wdir=main.wdir
except:
    def eHook():
        hook(*sys.exc_info())
        gtk.main_quit()
    wdir=''
    gobject.timeout_add(100,eHook)
    gtk.main()

else:
    #reload(sys)
    #sys.setdefaultencoding("ascii")
    sys.excepthook=hook
    gtk.main()
