.\"
.\" Copyright 1991 by David A. Curry
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that copyright
.\" notice and this permission notice appear in supporting documentation.  The
.\" author makes no representations about the suitability of this software for
.\" any purpose.  It is provided "as is" without express or implied warranty.
.\"
.TH XPOSTIT 1 "December 1992" X11R5
.SH NAME
xpostit \- X window system Post-it\(rg notes
.SH SYNOPSIS
.B xpostit
[
.I \-toolkitoptions ...
] [
.I \-options ...
]
.SH DESCRIPTION
.I Xpostit
provides a mechanism for manipulating on-screen Post-it\(rg notes.
All six sizes of Post-it notes may be displayed,
edited,
and saved to disk files.
In addition,
any on-screen note may be resized to any arbitrary size either when it is
created or at a later time.
.PP
When
.I xpostit
is first invoked,
it creates a small window with a plaid background.
This is the control window for
.IR xpostit .
Additionally,
if any notes were stored in the save directory (see below),
these will be placed on the screen at their last locations and in their last
respective states (normal, iconic, or hidden).
Each Post-it note,
when created,
makes another window on the screen.
.I Xpostit
is controlled using the mouse buttons and a menu.
The Post-it notes are controlled using buttons (Command widgets).
.SH OPTIONS
.PP
.I Xpostit
accepts all of the standard X Toolkit command line options along with the
additional options listed below.
.TP 8
.BI \-bs " number"
Specifies the size of the character buffer in which to save each Post-it
note.
A note may not contain more than this number of characters,
including newlines.
The default is 1024.
.TP 8
.BI \-dir " path"
Specifies the path name of the directory in which to store saved Post-it notes.
If
.I path
begins with a `/' it is taken as-is;
if it does not begin with a `/',
the path is taken relative to the home directory.
The named directory must already exist if notes are to be saved in it.
The default is
.IR \&.postitnotes .
.TP 8
.B \-sb
Enables scroll-bars.
If specified,
a scroll bar will be attached to each Post-it note.
.TP 8
.B \-sv
Enables save-on-exit.
When specified,
this option tells
.I xpostit
to save all Post-it notes to disk files when exiting.
If not specified,
notes will only be saved to disk files when saved manually by the user.
.SH "WIDGET USAGE"
.PP
.I Xpostit
uses several widget types to construct the objects it uses.
.PP
The control window is a Plaid widget called ``Plaid''.
.PP
The menu is a pop-up shell called ``Menu'' containing a SimpleMenu widget.
.PP
Each Post-it note is a pop-up shell called ``PostItNote'',
containing a Form widget called ``Note''
which contains a Text widget called ``NoteText'',
and four Command widgets called ``Save'',
``Erase'',
``Destroy'',
and ``Title''.
.PP
The confirmation box is a pop-up shell called ``Confirm'',
containing a Form widget called ``Buttons''
which contains two Command widgets called ``Confirm'' and ``Cancel''.
The title-change box is a pop-up shell called ``Title'',
containing a Dialog widget called ``Dialog''.
.SH "RESOURCES"
.PP
.I Xpostit
understands all of the core X Toolkit resource names and classes as well
as those listed below,
which are all of class
.BR XPostit .
.TP 8
.B \&.bufSize
Specifies the size of the character buffer used to store a Post-it note.
The default is 1024.
.TP 8
.B \&.noteDir
Specifies the path name of the directory in which to store saved notes.
The default is
.IR \&.postitnotes .
.TP 8
.B \&.saveNotes
Controls the state of the save-on-exit option.
The default is
.BR false .
.TP 8
.B \&.scrollBar
Controls placing scroll bars on Post-it notes.
The default is
.BR false .
.SH "ACTIONS"
.PP
It is possible to rebind the mouse buttons in the Plaid widget to perform
different functions by changing the widget's translations.
The
.I raise()
action,
normally bound to the left mouse button,
raises all notes.
The
.I lower()
action,
normally bound to the middle mouse button,
lowers all notes.
The
.I show()
action,
normally bound to the middle mouse button with the \s-1CTRL\s0 key,
maps all unmapped notes.
The
.I hide()
action,
normally bound to the left mouse button with the \s-1CTRL\s0 key,
unmaps all visible, non-iconic notes on the screen.
The
.I tearoff()
action,
normally invoked by dragging the left button off the Plaid widget,
creates a new note.
The
.I tearoff
action has an optional paramter indicating the size of the note to be
created, e.g.,
.I tearoff(3x5)
to create a 3-inch by 5-inch note.
If no paramter is given,
a 1.5-inch by 2-inch note will be created.
The menu raising function,
normally bound to the right mouse button,
is performed by calling the actions
.I "XawPositionSimpleMenu(Menu)"
and
.IR "MenuPopup(Menu)" .
The
.I quit()
action,
bound to the ``q'' and ``Q'' keys,
is equivalent to selecting ``Exit'' from the menu.
.SH "THE CONTROL WINDOW"
.PP
.I Xpostit
allows several operations to be performed from its control window.
Clicking the left mouse button in the control window will cause all Post-it
notes on the screen to be raised to the top.
Clicking the middle mouse button in the control window will cause all Post-it
notes on the screen to be lowered to the bottom.
Clicking the left mouse button in the control window while holding down the
\s-1CTRL\s0 key will cause all currently hidden notes to be mapped (shown).
Clicking the middle mouse button in the control window while holding down the
\s-1CTRL\s0 key will cause all notes on the screen which are not iconified
to be unmapped (hidden).
Pressing the left mouse button in the control window and dragging it outside
the window will create a new note.
Pressing the right mouse button in the control window raises the
.I xpostit
menu.
Pressing the ``q'' or ``Q'' keys in the control window will exit the program.
.SH "THE MENU"
.PP
The
.I xpostit
menu provides the following selections:
.TP 8
.B "Create 1.5x2 Note"
Create a new Post-it note,
1.5 inches tall by 2 inches wide.
The window will normally need to be positioned using the window manager.
.TP 8
.B "Create 2x3 Note"
Create a new Post-it note,
2 inches tall by 3 inches wide.
.TP 8
.B "Create 3x3 Note"
Create a new Post-it note,
3 inches square.
.TP 8
.B "Create 3x4 Note"
Create a new Post-it note,
3 inches tall by 4 inches wide.
.TP 8
.B "Create 3x5 Note"
Create a new Post-it note,
3 inches tall by 5 inches wide.
.TP 8
.B "Create 4x6 Note"
Create a new Post-it note,
4 inches tall by 6 inches wide.
.TP 8
.B "Raise All Notes"
Raise all Post-it notes to the top.
This is equivalent to pressing the left mouse button in the control window.
.TP 8
.B "Lower All Notes"
Lower all Post-it notes to the bottom.
This is equivalent to pressing the middle mouse button in the control window.
.TP 8
.B "Hide All Notes"
Unmap all Post-it notes, making them disappear from the screen.
This is equivalent to pressing the middle mouse button in the control window
while holding down the \s-1CTRL\s0 key.
Note: to hide a single note,
you may use the window manager to send a
.B WM_DELETE_WINDOW
message to the note window.
Under
.I twm ,
this is done with the
.B f.delete
function.
.TP 8
.B "Show All Notes"
Map all Post-it notes, making them reappear if they were hidden.
This is equivalent to pressing the left mouse button in the control window
while holding down the \s-1CTRL\s0 key.
.TP 8
.B "Save All Notes"
Save all Post-it notes to disk files in the save directory.
.TP 8
.B Exit
Exit
.I xpostit .
If the
.B \-sv
command line option was given,
or the
.B saveNotes
resource is
.B true ,
all Post-it notes will be saved to disk first.
.PP
To select an item from the menu,
drag the mouse cursor to that item and release the mouse button.
.SH "THE POST-IT NOTE"
.PP
Each Post-it note is made up of five parts (plus an optional scroll bar):
a text window where the text of the note is stored,
and four buttons labeled ``Save'',
``Erase'',
``Destroy'',
and ``Title''.
.PP
The title of a Post-it note,
which will be displayed by most window managers in both a title bar and the
icon name area,
is by default the string ``PostItNote #'' followed by a small integer,
the number of the note.
The procedure for changing this title to something more meaningful is
described below.
.PP
To enter text into a Post-it note,
simply move the mouse cursor into the text window and start typing.
Since the text window is actually a Text widget,
all the Text widget translations are accepted.
Essentially,
this means you can use most of the \s-1EMACS\s0 control keys in the window.
Additionally,
the various mouse buttons used for manipulating the selections and cut
buffer are understood.
.PP
After entering text in the Post-it note,
you may wish to save the note in a disk file.
This way,
if the machine goes down,
or if you exit
.IR xpostit ,
the Post-it note can be restored when you restart
.IR xpostit .
(Post-it notes are also saved automatically (if
.B saveNotes
is true) if a SIGHUP,
SIGINT,
SIGTERM,
or SIGQUIT signal is received.)
To save the note to a disk file,
move the mouse cursor to the button labeled ``Save'' and press the left
mouse button,
or use the ``Alt-s'' keyboard sequence.
The note will be saved as the file ``note\fIn\fP'' in your save directory,
where
.I n
is some sequence number.
.BR \s-1NOTE\s0 :
it is important to remember that until you have pressed the ``Save'' button,
the data stored in the Post-it note is not saved on disk and can be lost if
the system goes down or
.I xpostit
exits.
.PP
To erase the entire contents of the text window,
you can press the left mouse button in the ``Erase'' button.
This will bring up a confirmation window,
which has two buttons labeled ``Confirm'' and ``Cancel''.
If you press the ``Confirm'' button,
the text will be erased.
If you press the ``Cancel'' button,
the operation is canceled,
and nothing will happen.
.BR \s-1NOTE\s0 :
erasing the text in the window does not affect any contents of the note
you have saved on disk unless you press the ``Save'' button again.
.PP
To destroy a Post-it note,
getting rid of its window on the screen and the disk file it is saved in,
move the mouse cursor to the ``Destroy'' button and press the left mouse
button.
This will bring up a confirmation window as described above.
If you confirm the operation,
the Post-it note will disappear from the screen and the disk file it was
saved in will be deleted.
.PP
To change the title of a Post-it note,
both in any title bar on the window as well as in the icon for the note,
move the mouse cursor to the ``Title'' button and press the left mouse
button,
or enter the ``Alt-t'' keyboard sequence.
This will bring up a dialog box with the current title in it.
Change or modify the title,
and press the ``Okay'' button with the mouse to change the title,
or press the ``Cancel'' button to discard the change.
You can also simply press the ``Return'' key to change the title,
or the ``Escape'' key to cancel the change.
.SH "SEE ALSO"
X(1)
.SH BUGS
.PP
The sizes of the Post-it notes are only as accurate as the display
dimension and resolution returned by the server.
On the Sun server and possibly others,
this means they aren't all that accurate.
.PP
When the title of a Post-it note is changed,
some window managers (notably
.I twm )
will not make the change in the icon name,
since they only look up this data when a window is mapped.
This can be ``fixed'' by unmapping all notes and mapping them again.
.PP
Without a color display for canary yellow notes and red plaid,
the aesthetic value of
.I xpostit
cannot be fully appreciated.
.SH AUTHOR
David A. Curry, Purdue University
.sp
``Post-it'' and the plaid design are registered trademarks of 3M.
