/*** This Programs/Libraries are (C)opyright by Sebastian Krahmer.
 *** You may use it under the terms of the GPL. You should have
 *** already received the file COPYING that shows you your rights.
 *** Please look at COPYING for further license-details.
 ***  
 *** THERE IS ABSOLUTELY NO WARRANTY. SO YOU USE IT AT YOUR OWN RISK.
 *** IT WAS WRITTEN IN THE HOPE THAT IT WILL BE USEFULL. I AM NOT RESPONSIBLE
 *** FOR ANY DAMAGE YOU MAYBE GET DUE TO USING MY PROGRAMS.
 ***/


#ifndef _TCP_H_
#define _TCP_H_

#include "usi-structs.h"
#include "datalink.h"
#include "ip.h"

namespace usipp {

/** \class TCP
 *  All about TCP
 */
class TCP : public IP {
private:
      	struct tcphdr tcph;
      	char tcpOptions[40];
		int opt_offset;
      	struct pseudohdr pseudo;
public:
      	
	/*! Expects hostname or IP-adress.
         */
	TCP(const char*);

	/*! Destructor
	 */
      	virtual ~TCP();
  
	/*! Assign-operator 
	 */
	TCP &operator=(const TCP&);    

	/*! Copy-constructor 
	 */
	TCP(const TCP&);

       /*! Get sourceport of packet, in host-order.
       	*/
      	u_int16_t get_srcport();

       /*! Get destination-port in host-order
       	*/
      	u_int16_t get_dstport();

      	/*! Get sequencenumber of packet.
       	 */
      	u_int32_t  get_seq();

      	/*! Get acknowlegde-number of packet.
       	 */
      	u_int32_t  get_ack();

      	/*! Get TCP-data offset, sometimes called TCP-header-length.
       	*  Should be 20 in most cases.
       	*/
      	u_int8_t get_off();

       /*! Get TCP-flags. Can be either of
       	*  TH_SYN
       	*  TH_ACK
       	*  TH_FIN
       	*  TH_RST
       	*  TH_PUSH
	*  TH_URG
       	* or any combination of these (althought common combinations are SYN|ACK or
       	* similar)
       	*/
	u_int8_t get_flags();      
      
	/*!*/
        u_int16_t get_win();
      
	/*!*/
        u_int16_t get_tcpsum();
      	
	/*!
         */
	u_int16_t get_urg();
      
	/*! Set source-port 
         */
      	int set_srcport(u_int16_t);

	/*! Set destination-port
         */
      	int set_dstport(u_int16_t);

	/*!
	 */
      	int set_seq(u_int32_t);

	/*!*/
      	int set_ack(u_int32_t);

	/*!*/
      	int set_off(u_int8_t);

	/*!*/
      	int set_flags(u_int8_t);

	/*!*/
      	int set_win(u_int16_t);

	/*! Set TCP-checksum.
	 * Doing these will prevent sendpack() from doing this for you.
         * It's not recommented that you do so, coz the sum will almost
         * be weak.
         */
      	int set_tcpsum(u_int16_t);

	/*!*/
      	int set_urg(u_int16_t);
     
	/*! Return complete TCP header.
	 *  Usefull for some kinds of ICMP messages
	 */
	tcphdr get_tcphdr();

	/* The following functions are already defined in IP {}.
	 * We need them too for TCP {}, and TCP{} calls IP::function() then.
         */
 

	/*! Capture a packet from the net.
         */
      	virtual int sniffpack(void *buf, size_t buflen);
      	
	/*! Send a packet.
         */
	virtual int sendpack(void *payload, size_t paylen);

	/*! Send a string.
         */
      	virtual int sendpack(char *pay_string);
      
      	/*! Just sets filter to TCP and calls Datalink::initdevice()
         */
	virtual int init_device(char *, int, size_t);

	/*! Set a TCP-option of kind
 	 */
	int set_tcpopt(char kind, unsigned char len, union tcp_options t);

	/*! Clear header from all options
	 */
	int reset_tcpopt();
      
	/*! Fill buffer with 20 bytes, return the length of option-field.
	 */
	int get_tcpopt(char *);
};


} // namespace usipp

#endif // _TCP_H_

