.\" X-BASED OCTAHEDRON
.\"
.\" xoct.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 2001	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XOCT 6 "01 Sep 2001" "V5.5.4"
.SH NAME
xoct \- Octahedron X widget
.SH SYNOPSIS
.B /usr/games/xoct
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-{border|bd} {color}] [-face{0|1|2|3|4|5|6|7} {color}]
[-{size {int} | sticky}] [-{mode {int} | both}]
[-[no]orient] [-[no]practice] [-username {string}]
.SH DESCRIPTION
.LP
The original puzzle has 9 triangles per face (size = 3) and has period 4
turning (i.e. the face or points turn with 90 degree intervals).  The
puzzle was designed by Uwe Meffert and called the Magic Octahedron (or
Star Puzzler).  The puzzle was not widely distributed but not exactly
rare.  This puzzle has some analogies to the Rubik's Cube and the solving
techniques are the same to that of the Pyraminx.  Christoph's Magic Jewel
is similar except there are no trivial corners to solve.  This has
2^22*12! or 2,009,078,326,886,400 different combinations.
.sp
Uwe Meffert also noticed that there could be an alternate twisting for
the octahedron where it has period 3 turning (i.e. faces turn with 120
degree intervals).
.sp
One is able to simulate a Trajber's Octahedron (period 3 turning and
sticky mode).  Also one is able to simulate one with variant turning
(period 4 turning and sticky mode).
.SH FEATURES
.LP
Press "\fBmouse-left\fP" button to move a piece.  Release
"\fBmouse-left\fP" button on a piece on the same face and in the same row
(but not an adjacent piece or the move is ambiguous).  The pieces will
then turn towards where the mouse button was released.
.LP
Press "\fBmouse-center\fP", or press "\fBP\fP" or "\fBp\fP" keys to toggle
the practice mode (in practice mode the record should say "practice").
One must double click on "\fBmouse-center\fP" if the puzzle is being worked
on.  This is good for learning moves and experimenting.
.LP
Click "\fBmouse-right\fP", or press "\fBR\fP" or "\fBr\fP" keys to randomize
(this must be done first to set a new record).  One must double click on
"\fBmouse-right\fP" if the puzzle is being worked on.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of "octas".
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of "octas".
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  One has to
orient the faces in orient mode, besides getting all the faces to be the
same color.  To do this one has to get the lines to be oriented in the
same direction, this only matters with center "octas", if at all (i.e.
those "octas" not on a corner or edge).  This does add complexity so
there are 2 sets of records.
.LP
Press "\fB3\fP", "\fB4\fP", "\fBB\fP", or "\fBb\fP" keys (not the keypad
3, 4) to change modes to Period 3, Period 4, or Both.
.LP
Press "\fBY\fP" or "\fBy\fP" to toggle sticky mode (increase/decrease is
disabled here if sticky mode is on).
.br
"Sticky" and "Period 3" turning allows only the faces to turn.  It is as
if the middle cut of the three cuts did not exist.
.br
"Sticky" and "Period 4" turning allows only the points to turn, it is as
if the middle cut of the three cuts did not exist.
.br
Beware, the "Sticky" mode is a hack and much could be done to improve its
look.
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (not implemented).
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo move.
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to write or save a puzzle.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad, "R" keys, or arrow keys to move without mouse clicks.
.br
Key pad is defined for Pyraminx as:
.br
  /     Counterclockwise
.sp
7 8 9   Upper Left, Up, Upper Right
.br
  ^
.br
4<5>6   Left, Clockwise, Right
.br
  v
.br
1 2 3   Lower Left, Down, Lower Right
.LP
Use the shift keys to access "Period 4" turns from "Both" mode, otherwise
it assumes "Period 3" turning.  Points turn in "Period 4" and faces turn in
"Period 3".
.LP
Use the control key and the left mouse button, keypad, or arrow keys to
move the whole octahedron.  This is not recorded as a turn.
.LP
The title is in the following format (non-motif version):
.RS
xoct.{3|4|both<turning modes>}: {1|2|3|4|5|6|sticky<number of "octas"
per edge>} @ (<Number of moves>/{<Record number of moves>
<username>|"NEVER noaccess"|"practice"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the octahedron window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to  display on a color screen as if monochrome
(resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the octahedron window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the octahedron window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the octahedron window (resource name
"\fIbackground\fP").
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the octas in the octhahedoron
window (resource name "\fIborderColor\fP").
.TP 8
.B \-face{0|1|2|3|4|5|6|7} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono-mode, color is represented as the first letter
of the color name. The faces are ordered top to bottom and left to right.
If you has two colors that begin with the same letter you should have one
in uppercase and one in lowercase to distinguish them in mono-mode. You can
change the colors of the faces to make a stupid octahedron (i.e. all White
or in mono-mode all "W").  Unfortunately, it will not normally say its
solved when its randomized.  This would be cheating.
.TP 8
.B \-size <\fIint\fP>
This option allows you to change the number of octas on a edge
(resource name "\fIsize\fP").
.TP 8
.B \-sticky
This option allows you to set the sticky mode (resource name
"\fIsticky\fP").
.TP 8
.B \-mode <\fIint\fP>
This option allows you to set the turning mode (resource name
"\fImode\fP").
.TP 8
.B \-both
This option allows you to set the turning mode to both period 3 and
period 4 (resource name "\fImode\fP" set at 5).
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]practice
This option allows you to access the practice mode (resource name
"\fIpractice\fP").
.B \-username \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
Octahedron with default colors, not randomized:
  0       R     Red
.br
3   1   M   B   Magenta, Blue
.br
  2       W     White
.br
  4       O     Orange
.br
7   5   Y   P   Yellow, Pink
.br
  6       G     Green
.sp
.RS
size: 1-6 <number of triangles in the same orientation as the face per
row>
.br
mode: 3-5 <period 3 turning, period 4 turning, or both (5)>
.br
orient: 0-1 <0 false, 1 true; if 1 then lines on "octas" to be oriented>
.br
sticky: 0-1 <0 false, 1 true; if 1 then some "octas" move together>
.br
practice: 0-1 <0 false, 1 true>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <2 dimensional array of face "octa" position, each
face has size * size "octas", if orient mode then orientation number
follows face number numbered clockwise from 0 to 11, where 0 is up>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <face> <position> <direction> <control>
.RE
Each turn is with respect to a face and position.
.br
Position is 0 to size * size - 1.  Position 0 is the triangle furthest
from the center, increasing clockwise.
.br
Direction is represented as 0 up, 1 upper right, 2 right, 3 lower right,
4 down, 5 lower left, 6 left, 7 upper left, 9 clockwise, and 15
counterclockwise.
.br
Control is represented as 0 or 1, 1 if the whole octahedron is moved at
once (here position does not matter), 0 if not.  The xoct record keeper
does not count a control move as a move, but here we do.
.sp
Caution: the program may crash on corrupted input.
.SH REFERENCES
Beyond Rubik's Cube: spheres, pyramids, dodecahedrons and God knows what
else by Douglas R. Hofstadter, Scientific American, July 1982, pp 16-31.
.sp
Magic Cubes 1996 Catalog of Dr. Christoph Bandelow.
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xdino(6), xpyraminx(6), xmball(6),
xmlink(6), xpanex(6), xcubes(6), xtriangles(6), xhexagons(6), xabacus(1)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-2001, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ftp.x.org/contrib/games\fP

