#define ANIMATE 1
/*-
# X-BASED HEXAGONS
#
#  Hexagons.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Hexagons */

#ifndef _XtHexagons_h
#define _XtHexagons_h

/***********************************************************************
 *
 * Hexagons Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNuserName ((char *) "userName")
#define XtNsizeX ((char *) "sizeX")
#define XtNsizeY ((char *) "sizeY")
#define XtNcorners ((char *) "corners")
#define XtNbase ((char *) "base")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNmenu ((char *) "menu")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNtileBorder ((char *) "tileBorder")
#define XtCUserName ((char *) "UserName")
#define XtCSizeX ((char *) "SizeX")
#define XtCSizeY ((char *) "SizeY")
#define XtCCorners ((char *) "Corners")
#define XtCBase ((char *) "Base")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCMenu ((char *) "Menu")

typedef struct _HexagonsClassRec *HexagonsWidgetClass;

extern WidgetClass hexagonsWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} hexagonsCallbackStruct;
#endif

#define HEXAGONS_HIDE (-8)
#define HEXAGONS_RANDOMIZE_QUERY (-7)
#define HEXAGONS_SOLVE_MESSAGE (-6)
#define HEXAGONS_RESTORE (-5)
#define HEXAGONS_RESET (-4)
#define HEXAGONS_BLOCKED (-3)
#define HEXAGONS_SPACE (-2)
#define HEXAGONS_IGNORE (-1)
#define HEXAGONS_MOVED 0
#define HEXAGONS_SOLVED 1
#define HEXAGONS_PRACTICE 2
#define HEXAGONS_RANDOMIZE 3
#define HEXAGONS_DEC_X 4
#define HEXAGONS_INC_X 5
#define HEXAGONS_DEC_Y 6
#define HEXAGONS_INC_Y 7
#define HEXAGONS_CORNERS 8
#define HEXAGONS_COMPUTED 9
#define HEXAGONS_UNDO 10
#define HEXAGONS_SPEED 11

#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#define MINTILES 1
#define DEFAULTTILESX 3
#define DEFAULTTILESY 3
#define MAXORIENT 2
#define NOCORN 0
#define CORNERS 1
#define DEFAULTCORNERS CORNERS
#define DEFAULTDELAY 10
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 10

typedef struct _HexagonsRec *HexagonsWidget;

extern void intCat(char ** string, const char * var1, const int var2);
extern void stringCat(char ** string, const char * var1, const char * var2);

#endif /* _XtHexagons_h */
/* DON'T ADD STUFF AFTER THIS #endif */
