/*-
# X-BASED SKEWB
#
#  Skewb.h
#
###
#
#  Copyright (c) 1994 - 2003	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Skewb */

#ifndef _XtSkewb_h
#define _XtSkewb_h

/***********************************************************************
 *
 * Skewb Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNuserName ((char *) "userName")
#define XtNorient ((char *) "orient")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNdelay ((char *) "delay")
#define XtNface ((char *) "face")
#define XtNpos ((char *) "pos")
#define XtNdirection ((char *) "direction")
#define XtNpractice ((char *) "practice")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNmenu ((char *) "menu")
#define XtNframeColor ((char *) "frameColor")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtCUserName ((char *) "UserName")
#define XtCOrient ((char *) "Orient")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCDelay ((char *) "Delay")
#define XtCPractice ((char *) "Practice")
#define XtCFace ((char *) "Face")
#define XtCPos ((char *) "Pos")
#define XtCDirection ((char *) "Direction")
#define XtCMenu ((char *) "Menu")

typedef struct _SkewbClassRec *SkewbWidgetClass;

extern WidgetClass skewbWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
	int         face, position, direction;
} skewbCallbackStruct;
#endif

#define SKEWB_HIDE (-9)
#define SKEWB_PRACTICE_QUERY (-8)
#define SKEWB_RANDOMIZE_QUERY (-7)
#define SKEWB_SOLVE_MESSAGE (-6)
#define SKEWB_RESTORE (-5)
#define SKEWB_CLEAR (-4)
#define SKEWB_RESET (-3)
#define SKEWB_ILLEGAL (-1)
#define SKEWB_IGNORE (-1)
#define SKEWB_MOVED 0
#define SKEWB_CONTROL 1
#define SKEWB_SOLVED 2
#define SKEWB_PRACTICE 3
#define SKEWB_RANDOMIZE 4
#define SKEWB_DEC 5
#define SKEWB_ORIENT 6
#define SKEWB_INC 7
#define SKEWB_COMPUTED 8
#define SKEWB_UNDO 9
#define SKEWB_DIM 10

#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#define MAXFACES 6
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

typedef struct _SkewbRec *SkewbWidget;

extern void intCat(char ** string, const char * var1, const int var2);
extern void stringCat(char ** string, const char * var1, const char * var2);

#endif /* _XtSkewb_h */
/* DON'T ADD STUFF AFTER THIS #endif */
