/*-
# X-BASED SKEWB
#
#  SkewbP.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Skewb */

#ifndef _SkewbP_h
#define _SkewbP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Skewb.h"

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)		/* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define FULLCIRCLE NUM_DEGREES

#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w->core.hDC,x,y,x+l,y+h)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w->core.hDC,x1,y1,NULL); \
  (void)LineTo(w->core.hDC,x2,y2)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w->core.hDC,x-r+1,y-r+1,x+r,y+r)
#define DRAWRECTANGLE(w,c,x,y,l,h) w->skewb.hPen = CreatePen(PS_SOLID, 1, c); \
  w->skewb.hOldPen = (HPEN) SelectObject(w->core.hDC, w->skewb.hPen); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->skewb.hOldPen); \
  (void) DeleteObject(w->skewb.hPen)
#define FILLRECTANGLE(w,c,x,y,l,h) w->skewb.hPen = CreatePen(PS_SOLID, 1, c); \
  w->skewb.hOldPen = (HPEN) SelectObject(w->core.hDC, w->skewb.hPen); \
  w->skewb.hBrush = CreateSolidBrush(c); \
  w->skewb.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->skewb.hBrush); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->skewb.hOldBrush); \
  (void) DeleteObject(w->skewb.hBrush); \
  (void) SelectObject(w->core.hDC, w->skewb.hOldPen); \
  (void) DeleteObject(w->skewb.hPen)
#define DRAWLINE(w,c,x1,y1,x2,y2) w->skewb.hPen = CreatePen(PS_SOLID, 1, c); \
  w->skewb.hOldPen = (HPEN) SelectObject(w->core.hDC, w->skewb.hPen); \
  LINE(w,x1,y1,((y1==y2)?1:0)+x2,((x1==x2)?1:0)+y2); \
  (void) SelectObject(w->core.hDC, w->skewb.hOldPen); \
  (void) DeleteObject(w->skewb.hPen)
#define DRAWCIRCLE(w,c,d,x,y) w->skewb.hPen = CreatePen(PS_SOLID, 1, c); \
  w->skewb.hOldPen = (HPEN) SelectObject(w->core.hDC, w->skewb.hPen); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->skewb.hOldPen); \
  (void) DeleteObject(w->skewb.hPen)
#define FILLCIRCLE(w,c,d,x,y) w->skewb.hPen = CreatePen(PS_SOLID, 1, c); \
  w->skewb.hOldPen = (HPEN) SelectObject(w->core.hDC, w->skewb.hPen); \
  w->skewb.hBrush = CreateSolidBrush(c); \
  w->skewb.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->skewb.hBrush); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->skewb.hOldBrush); \
  (void) DeleteObject(w->skewb.hBrush); \
  (void) SelectObject(w->core.hDC, w->skewb.hOldPen); \
  (void) DeleteObject(w->skewb.hPen)
#define DRAWTEXT(w,c,x,y,s,l) (void) SetTextColor(w->core.hDC, c); \
  (void) SetBkMode(w->core.hDC, TRANSPARENT); \
  (void) TextOut(w->core.hDC, (x)-3, (y)-11, (LPCSTR) s, l)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "Skewb.h"

#ifndef Point
#define Point XPoint
#endif
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DRAWLINE(w,c,i,j,k,l) XDrawLine(XtDisplay(w),XtWindow(w),\
  c,i,j,k,l)
#define FILLRECTANGLE(w,c,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define DRAWRECTANGLE(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define FILLCIRCLE(w,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWTEXT(w,c,x,y,s,l) (void) XDrawString(XtDisplay(w),XtWindow(w),\
  c,x,y,s,l)
#define POLYGON(w,c,lc,l,n,o) XFillPolygon(XtDisplay(w), XtWindow(w), c, \
  l, n, Convex, (o) ? CoordModeOrigin : CoordModePrevious); \
  XDrawLines(XtDisplay(w), XtWindow(w), lc, \
  l, (n)+1,(o) ? CoordModeOrigin : CoordModePrevious)
#define POLYLINE(w,c,l,n,o) XDrawLines(XtDisplay(w), XtWindow(w), c, \
  l, n,(o) ? CoordModeOrigin : CoordModePrevious)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _SkewbClassPart {
	int         ignore;
} SkewbClassPart;

typedef struct _SkewbClassRec {
	CoreClassPart core_class;
	SkewbClassPart skewb_class;
} SkewbClassRec;

extern SkewbClassRec skewbClassRec;
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TR 0
#define BR 1
#define BL 2
#define TL 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAXORIENT 4
#define MAXROTATE 3
#define MAXCUBES (MAXORIENT+1)
#define MINOR 0
#define MAJOR 1

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand48
#define LRAND lrand48
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _SkewbLoc {
	int         face, rotation;
} SkewbLoc;

typedef struct _SkewbLocPos {
	int         face, position, direction;
} SkewbLocPos;

typedef struct _SkewbPart {
	SkewbLoc    cubeLoc[MAXFACES][MAXCUBES];
	SkewbLoc    faceLoc[MAXCUBES];
	SkewbLoc    rowLoc[MAXORIENT][MAXCUBES];
	SkewbLoc    minorLoc[MAXORIENT], majorLoc[MAXORIENT][MAXORIENT];
	SkewbLoc    skewbLoc[MAXFACES][MAXCUBES];
	int         currentFace, currentPosition, currentDirection;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         degreeTurn;
	int         delay;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        username[81];
	char        faceChar[MAXFACES];
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
#else
	int         menu;
	char       *username, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} SkewbPart;

typedef struct _SkewbRec {
	CorePart    core;
	SkewbPart   skewb;
} SkewbRec;

typedef struct _RowNext {
	int         face, direction, sideFace;
} RowNext;

extern void HideSkewb(
#ifdef WINVER
const SkewbWidget w
#else
SkewbWidget w, XEvent * event, char **args, int nArgs
#endif
);
extern void SelectSkewb(SkewbWidget w
#ifdef WINVER
, const int x, const int y, const int control, const int alt
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void ReleaseSkewb(SkewbWidget w
#ifdef WINVER
, const int x, const int y, const int control, const int alt
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void PracticeSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void PracticeSkewbMaybe(SkewbWidget w
, XEvent * event, char **args, int nArgs
);
extern void PracticeSkewb2(SkewbWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void RandomizeSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void RandomizeSkewbMaybe(SkewbWidget w
, XEvent * event, char **args, int nArgs
);
extern void RandomizeSkewb2(SkewbWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void GetSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void WriteSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void ClearSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void UndoSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void SolveSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void OrientizeSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void EnterSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void LeaveSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);

#ifdef WINVER
extern void POLYGON(SkewbWidget w, GC color, GC lineColor, const POINT * poly,
	int n, Boolean origin);
extern void POLYLINE(SkewbWidget w, GC color, const POINT * poly,
	int n, Boolean origin);
extern void DestroySkewb(HBRUSH brush);
extern void ResizeSkewb(SkewbWidget w);
extern void SizeSkewb(SkewbWidget w);
extern void InitializeSkewb(SkewbWidget w, HBRUSH brush);
extern void ExposeSkewb(const SkewbWidget w);
extern void DimSkewb(SkewbWidget w);
extern int  MoveSkewbDir(SkewbWidget w, const int direction);
extern void SetSkewb(SkewbWidget w, int reason);
extern void SetSkewbMove(SkewbWidget w, int reason, int face, int position,
	int direction);
#else
extern void QuitSkewb(SkewbWidget w, XEvent * event, char **args, int nArgs);
extern void MoveSkewbCw(SkewbWidget w, XEvent * event, char **args, int nArgs);
extern void MoveSkewbCcw(SkewbWidget w, XEvent * event, char **args,
	int nArgs);
#endif

extern void MoveSkewbInput(SkewbWidget w, int x, int y, int direction,
	int control, int alt);
extern void MoveSkewb(SkewbWidget w, int face, int position, int direction,
	int control);
extern void SetAllColors(SkewbWidget w);
#if 0
/* For future auto-solver */
extern void SolvePieces(SkewbWidget w);

#endif
extern void DrawAllPieces(SkewbWidget w);
extern Boolean CheckSolved(SkewbWidget w);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int control);
extern void GetMove(int *face, int *position, int *direction, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(SkewbWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, SkewbWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, SkewbWidget w);
extern void PrintStartPosition(FILE * fp, SkewbWidget w);
extern void SetStartPosition(SkewbWidget w);

#ifdef DEBUG
extern void PrintCube(SkewbWidget w);

#endif

#endif /* _SkewbP_h */
