/*-
# X-BASED PANEX(tm)
#
#  PanexP.h
#
###
#
#  Copyright (c) 1996 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Panex */

#ifndef _PanexP_h
#define _PanexP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "Panex.h"

#ifndef MOVESOUND
#define MOVESOUND "c:/windows/move.wav"
#endif

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)          /* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define Pixmap HBITMAP

#define DC(w,dr) ((dr==0)?w->core.hDC:w->panex.memDC)
#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w,x,y,x+l,y+h)
#define DRAWRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->panex.hOldBitmap = (HBITMAP) SelectObject(w->panex.memDC,dr); \
  w->panex.hPen = CreatePen(PS_SOLID,1,c); \
  w->panex.hOldPen = (HPEN) SelectObject(DC(w,dr),w->panex.hPen); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr),w->panex.hOldPen); \
  (void) DeleteObject(w->panex.hPen); \
  if (dr) (void) SelectObject(w->panex.memDC,w->panex.hOldBitmap)
#define FILLRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->panex.hOldBitmap = (HBITMAP) SelectObject(w->panex.memDC,dr); \
  w->panex.hPen = CreatePen(PS_SOLID,1,c); \
  w->panex.hOldPen = (HPEN) SelectObject(DC(w,dr),w->panex.hPen); \
  w->panex.hBrush = CreateSolidBrush(c); \
  w->panex.hOldBrush = (HBRUSH) SelectObject(DC(w,dr),w->panex.hBrush); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr),w->panex.hOldBrush); \
  (void) DeleteObject(w->panex.hBrush); \
  (void) SelectObject(DC(w,dr),w->panex.hOldPen); \
  (void) DeleteObject(w->panex.hPen); \
  if (dr) (void) SelectObject(w->panex.memDC,w->panex.hOldBitmap)
#define DRAWTEXT(w,dr,c,x,y,s,l) \
  if (dr) w->panex.hOldBitmap = (HBITMAP) SelectObject(w->panex.memDC,dr); \
  (void) SetTextColor(DC(w,dr), c); \
  (void) SetBkMode(DC(w,dr), TRANSPARENT); \
  (void) TextOut(DC(w,dr), (x)-3, (y)-11, (LPCSTR) s, l); \
  if (dr) (void) SelectObject(w->panex.memDC,w->panex.hOldBitmap)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

extern void DestroyPanex(HBRUSH brush);
extern void ResizePanex(PanexWidget w);
extern void SizePanex(PanexWidget w);
extern void InitializePanex(PanexWidget w, HBRUSH brush);
extern void ExposePanex(const PanexWidget w);
extern void HidePanex(const PanexWidget w);
extern void SelectPanex(PanexWidget w, const int x);
extern void MotionPanex(PanexWidget w, const int x);
extern void ReleasePanex(PanexWidget w, const int x);
extern void ClearPanex(PanexWidget w);
extern void GetPanex(PanexWidget w);
extern void WritePanex(PanexWidget w);
extern void UndoPanex(PanexWidget w);
extern void SolvePanex(PanexWidget w);
extern void ModePanex(PanexWidget w);
extern void SpeedPanex(PanexWidget w);
extern void SlowPanex(PanexWidget w);
extern void SoundPanex(PanexWidget w);
extern void DecrementPanex(PanexWidget w);
extern void IncrementPanex(PanexWidget w);
extern void EnterPanex(PanexWidget w);
extern void LeavePanex(PanexWidget w);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <X11/Xos.h>
#include "Panex.h"

#ifdef VMS
#ifndef MOVESOUND
#define MOVESOUND "[.]move.wav"
#endif
#else
#ifndef MOVESOUND
#if 0
#define MOVESOUND "/usr/share/games/xpuzzles/move.au"
#endif
#define MOVESOUND "/usr/local/share/games/xpuzzles/move.au"
#endif
#endif

#ifndef Pos
#define Pos Position
#endif
#ifndef Point
#define Point XPoint
#endif
#define NUM_DEGREES 360
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DR(w,dr) ((dr==0)?XtWindow(w):dr)
#define DRAWRECTANGLE(w,dr,c,i,j,l,h) XDrawRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define FILLRECTANGLE(w,dr,c,i,j,l,h) XFillRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define DRAWTEXT(w,dr,c,x,y,s,l) (void) XDrawString(XtDisplay(w),DR(w,dr),\
  c,x,y,s,l)
#define POLYGON(w,dr,c,lc,l,n,o) XFillPolygon(XtDisplay(w), DR(w,dr), c, \
  l, n, Convex, (o) ? CoordModeOrigin : CoordModePrevious); \
  XDrawLines(XtDisplay(w), DR(w,dr), lc, \
  l, (n)+1,(o) ? CoordModeOrigin : CoordModePrevious)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _PanexClassPart {
	int         ignore;
} PanexClassPart;

typedef struct _PanexClassRec {
	CoreClassPart core_class;
	PanexClassPart panex_class;
} PanexClassRec;

extern PanexClassRec panexClassRec;
#endif

#define SYMBOL ':'

#define MAXSTACKS 3
#define UP 1
#define DOWN 0

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define COORD 4     
        
#define MAXSLICES 10
        
#define NORMAL 1    
#define DOUBLE 2
#define INSTANT 3   

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srandom
#define LRAND lrandom
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand
#define LRAND lrand
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _PanexLoc {
	int         stack, loc;
} PanexLoc;

typedef struct _PanexPart {
	PanexLoc   *tileOfPosition[MAXSTACKS];
	PanexLoc   *positionOfTile[MAXSTACKS];
	int         currentStack, currentPosition, previousStack;
	Boolean     started, cheat, sound;
	Boolean     mono, reverse, focus;
	int         mode, tiles;
	int         delay, numSlices;
	Position    width, height;
	Point       tileSize, pos;
	Point       delta, puzzleOffset, letterOffset;
	GC          pyramidGC[MAXSTACKS - 1];
	GC          frameGC, stackGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
	Pixmap      bufferTiles[2];
#ifdef WINVER
	long        oldTime;
	char        username[81], moveSound[81];
	char        pyramidChar[MAXSTACKS - 1];
	HDC         memDC;
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
	HBITMAP     hOldBitmap;
#else
	struct timeval oldTime;
	int         menu;
	char       *username, *moveSound, *font;
	Colormap    colormap;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	Pixel       pyramidColor[MAXSTACKS - 1];
	String      pyramidName[MAXSTACKS - 1];
	XtCallbackList select;
#endif
} PanexPart;

typedef struct _PanexRec {
	CorePart    core;
	PanexPart   panex;
} PanexRec;

extern PanexLoc *startLoc[MAXSTACKS - 1];
extern void SetPanex(PanexWidget w, int reason);
extern int  MovePanex(PanexWidget w, int fromStack, int fromPosition,
	int toStack);

extern void SolveTilesFromStart(PanexWidget w);
extern void DrawAllTiles(PanexWidget w);
extern int  TopOfStack(PanexWidget w, int stack, int start);
extern Boolean CheckMiddle(PanexWidget w);
extern Boolean CheckSolved(PanexWidget w);
extern void InitMoves(void);
extern void PutMove(int from, int to);
extern void GetMove(int *from, int *to);
extern int  MadeMoves(void);
extern void FlushMoves(PanexWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, PanexWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, PanexWidget w);
extern void PrintStartPosition(FILE * fp, PanexWidget w);
extern void SetStartPosition(PanexWidget w);

#endif /* _PanexP_h */
