.\" X-BASED DINOSAUR CUBE
.\"
.\" xdino.man
.\"
.\" ##
.\"
.\" Copyright (c) 1995 - 2006	David Albert Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XDINO 6 "11 Oct 2006" "V7.2.4"
.SH NAME
xdino \- Dino X widgets
.SH SYNOPSIS
.B /usr/games/xdino
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-face{0|1|2|3|4|5} {color}] [-{border|bd} {color}]
[-{font|fn} {fontname}] [-view {int}]
[-{mode {int} | both}] [-[no]orient] [-[no]practice]
[-userName {string}] [-scoreFile {filename}] [-scores]
[-version]
.SH DESCRIPTION
.LP
The period 2 turning (i.e. the edges turn with 180 degree intervals) was
suggested by Derek Bosch <bosch@sgi.com>.  The physical puzzle has period
3 turning (i.e. the points turn with 120 degree intervals) is called a
Triangle - 4 Cube - Dinosaur with colored dinosaurs on it, (or Triangle -
4 Cube - 6 Colors with solid colors, (a 4 color and a 2 color are also
available with point oriented coloring)) manufactured by The International
Puzzle & Games (Great Animation International Corporation).
.SH FEATURES
.LP
Press "\fBmouse-left\fP" button to move a piece.  Release
"\fBmouse-left\fP" button on a piece on the same face.  The pieces will
then turn towards where the mouse button was released.
.LP
Click "\fBmouse-center\fP", or press "\fBP\fP" or "\fBp\fP" keys to toggle
the practice mode (in practice mode the record should say "practice").
This is good for learning moves and experimenting.
.LP
Click "\fBmouse-right\fP", or press "\fBZ\fP" or "\fBz\fP" keys, to
randomize the puzzle (this must be done first to set a new record).
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to save (write) a puzzle.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBR\fP" or "\fBr\fP" keys to redo a move.
.LP
Press "\fBC\fP" or "\fBc\fP" keys to clear the puzzle.
.LP
"\fBS\fP" or "\fBs\fP" keys reserved for the auto-solver (not implemented).
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  One has to
orient the faces in orient mode, besides getting all the faces to be the
same color.  To do this one has to get the lines to be oriented in the
same direction.  This does add complexity (ever so slightly, there are
only 2 possibilities) so there are 2 sets of records.
.LP
Press "\fB2\fP", "\fB3\fP", "\fBB\fP", or "\fBb\fP" keys (not the keypad
2, 3) to change modes to Period 2, Period 3, or Both.
.LP
Press "\fBV\fP" or "\fBv\fP" keys to change the view of the cube.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad or arrow keys to move without the mouse.
.br
Key pad is defined for the Dino2d as:
.br
7 8 9   Upper Left, Up, Upper Right
.br
  ^
.br
4< >6   Left, Right
.br
  v
.br
1 2 3   Lower Left, Down, Lower Right
.br
Note: Up, Left, Right, and Down only work when the control key is
pressed and there is no analog for Dino3d.
.sp
Key pad for Dino3d, use must use your intuition (is this a cop out or
what?).  The key pad is defined differently depending on which side of the
cube your mouse is pointing at.
.LP
Use the alt key and the left mouse button, keypad, or arrow keys to move
the center of the cube.  The 2 opposite corners do not move.
.LP
Use the shift keys and the left mouse button, keypad, or arrow key to
access "Period 2" turns from "Both" mode, otherwise it assumes "Period 3"
turning.  Edges turn in "Period 2" and corners turn in "Period 3".  The
"Period 2" mode has extra cuts around the faces.
.LP
Use the control key and the left mouse button, keypad, or arrow keys to
move the whole cube.  This is not recorded as a turn.
.LP
The title is in the following format (non-motif version):
.RS
xdino{2|3}d<dimension>.{2|3|both<turning modes>}: (<Number of
moves>/{<Record number of moves>
<user name>|"NEVER noaccess"|"practice"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the dino window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to display the dino window on a color screen as
if it were monochrome (resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the dino window in reverse video
(resource name "\fIreverse\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the dino window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the dino window (resource name
"\fIbackground\fP").
.TP 8
.B \-face{0|1|2|3|4|5} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono-mode, color is represented as the first letter
of the color name. On the 2-D version, the faces are ordered top to bottom
and left to right on the "t" configuration. The "+-" configuration is
physically consistent with the former, so it is ordered "0, 1, 2, 3, 5, 4".
If you has two colors that begin with the same letter you should have one
in uppercase and one in lowercase to distinguish them in mono-mode. You can
change the colors of the faces to make a stupid cube (i.e. all White or in
mono-mode all "W"). Unfortunately, it will not normally say its solved when
its randomized. This would be cheating.
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the cubelets in the dino window
(resource name "\fIborderColor\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-view <\fIint\fP>
This option allows you to change the view of the cube for OpenGL with
choice of 4 views (resource name "\fIint\fP").
.TP 8
.B \-mode <\fIint\fP>
This option allows you to set the turning mode (resource name
"\fImode\fP").
.TP 8
.B \-both
This option allows you to set the turning mode to both period 2 and
period 3 (resource name "\fImode\fP" set at 4).
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]practice
This option allows you to access the practice mode (resource name
"\fIpractice\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xdino you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get.
.SH SAVE FORMAT
The format is not standard.  The reason for this is that this is simple and
I do not know what the standard is.
.sp
.RS
mode: 2-4 <period 2 turning, period 3 turning, or both (4)>
.br
orient: 0-1 <O false, 1 true; if 1 then lines on pieces are to be
oriented>
.br
practice: 0-1 <0 false, 1 true>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <2 dimensional array of face and edge position, each
face 4 edge pieces, if orient mode then orientation number follows face
number: 0 up, 1 right, 2 down, and 3 left>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <face> <edge> <direction> <style> <control>
.RE
Each turn is with respect to a corner on a face.
.br
The edges start at the top and work clockwise.
.br
Direction is represented as 0 upper right, 1 lower right, 2 lower left,
3 upper left, 5 clockwise, 7 counterclockwise, 8 up, 9 right, 10 down,
and 11 left.
.br
Style is represented as 0, 1, or 2, 0 if just a corner is rotated, 1 if
the center of the cube is moved, and 2 if a period 2 twist.
.br
Control is represented as 0 or 1, 1 if the whole cube is moved at once
(here the edge does not matter), 0 if not.  The xdino record keeper does
not count a control move as a move, but here we do.
.SH REFERENCES
International Puzzles & Games Catalog
.SH SEE ALSO
.LP
X(1), xrubik(6), xskewb(6), xpyraminx(6), xoct(6), xmball(6),
xmlink(6), xpanex(6), xcubes(6), xtriangles(6), xhexagons(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1995-2006, David Albert Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David Albert Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIftp://ftp.tux.org/pub/tux/bagleyd/xpuzzles\fP
.br
\fIftp://ibiblio.org/pub/Linux/games/strategy\fP
