/*
# X-BASED DIAL
#
#  xdial.c
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/*
  xdial.c   Test for dial widget
*/

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include "Dial.h"
#include "DialSq.h"

#define TITLELEN 256

static void Initialize(void);
static void CallbackDial(Widget w, caddr_t clientData,
	dialCallbackStruct *callData);
static void PrintState(Widget w, int n);

static Widget dial, dialsq;
static char prog[] = "TAC: ";
static char title[TITLELEN] = "";

int main(int argc, char **argv)
{
	Widget toplevel, shell;

	toplevel = XtInitialize(argv[0], "Dial", NULL, 0, &argc, argv);

	shell = XtCreateApplicationShell(argv[0], topLevelShellWidgetClass,
		NULL, 0);
	dial = XtCreateManagedWidget("dial", dialWidgetClass, toplevel,
		NULL, 0);
	XtAddCallback(dial, XtNselectCallback, (XtCallbackProc) CallbackDial,
		(XtPointer) NULL);
	dialsq = XtCreateManagedWidget("dialsq", squareDialWidgetClass, shell,
		NULL, 0);
	XtAddCallback(dialsq, XtNselectCallback, (XtCallbackProc) CallbackDial,
		(XtPointer) NULL);
	Initialize();
	XtRealizeWidget(toplevel);
	XtRealizeWidget(shell);
	XGrabButton(XtDisplay(dial), (unsigned int) AnyButton, AnyModifier,
		XtWindow(dial), TRUE,
		(unsigned int) (ButtonPressMask | ButtonMotionMask |
		ButtonReleaseMask),
		GrabModeAsync, GrabModeAsync, XtWindow(dial),
		XCreateFontCursor(XtDisplay(dial), XC_crosshair));
	XGrabButton(XtDisplay(dialsq), (unsigned int) AnyButton, AnyModifier,
		XtWindow(dialsq), TRUE,
		(unsigned int) (ButtonPressMask | ButtonMotionMask |
		ButtonReleaseMask),
		GrabModeAsync, GrabModeAsync, XtWindow(dialsq),
	XCreateFontCursor(XtDisplay(dialsq), XC_crosshair));
	XtMainLoop();

#ifdef VMS
	return 1;
#else
	return 0;
#endif
}

static void Initialize(void)
{
	int n;

	XtVaGetValues(dial,
		XtNval, &n,
		NULL);
	PrintState(XtParent(dial), n);
	XtVaGetValues(dialsq,
		XtNval, &n,
		NULL);
	PrintState(XtParent(dialsq), n);
}

static void CallbackDial(Widget w, caddr_t clientData,
		dialCallbackStruct *callData)
{
	Widget otherw;

	if (w == dial)
		otherw = dialsq;
	else /* (w == dialsq) */
		otherw = dial;
	XtVaSetValues(w, XtNval, callData->val, NULL);
	XtVaSetValues(otherw, XtNval, callData->val, NULL);
	PrintState(XtParent(w), callData->val);
	PrintState(XtParent(otherw), callData->val);
}

static void PrintState(Widget w, int n)
{
	(void) sprintf(title, "%s%d", prog, n);
	XtVaSetValues(w, XtNtitle, title, NULL);
}
