.\" X-BASED PYRAMINX(tm)
.\"
.\" xpyraminx.man
.\"
.\" ##
.\"
.\" Copyright (c) 1994 - 2007	David A. Bagley
.\"
.\"                   All Rights Reserved
.\"
.\" Permission to use, copy, modify, and distribute this software and
.\" its documentation for any purpose and without fee is hereby granted,
.\" provided that the above copyright notice appear in all copies and
.\" that both that copyright notice and this permission notice appear in
.\" supporting documentation, and that the name of the author not be
.\" used in advertising or publicity pertaining to distribution of the
.\" software without specific, written prior permission.
.\"
.\" This program is distributed in the hope that it will be "playable",
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
.\"
.TH XPYRAMINX 6 "03 Apr 2007" "V7.3.1"
.SH NAME
xpyraminx \- Pyramid X widget
.SH SYNOPSIS
.B /usr/games/xpyraminx
[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]
[-display [{host}]:[{vs}]] [-[no]mono] [-[no]{reverse|rv}]
[-{foreground|fg} {color}] [-{background|bg} {color}]
[-face{0|1|2|3} {color}] [-{border|bd} {color}]
[-delay msecs] [-[no]sound] [-moveSound {filename}]
[-{font|fn} {fontname}] [-{size {int} | sticky}]
[-{mode {int} | both}] [-[no]orient] [-[no]practice]
[-userName {string}] [-scoreFile {filename}] [-scores]
[-version]
.SH DESCRIPTION
.LP
The original puzzle has 9 triangles per face (size = 3) and has period 3
turning (i.e. the face or points turn in 120 degree intervals).  The
puzzle was designed by Uwe Meffert and called the Pyraminx.  This has
2^5*3^8*6!/2 or 75,582,720 different combinations.
.sp
Another puzzle Senior Pyraminx 3x3x3 exists only on paper, it has period 2
turning (i.e.  edges turn with 180 degree intervals) but the corners would
fall off unless it had some tricky mechanism.  (This may be the same as
the Master Pyraminx which has 446,965,972,992,000 different combinations).
.sp
Another puzzle (which was not widely distributed), the Junior Pyraminx
(and similarly the Junior Pyraminx Star, a octahedron formed by two
tetrahedra, this has 7!*3^6 or 3,674,160 different combinations), has 4
triangles (size = 2) per face.  This puzzle has been recently reissued
by Meffert as Pyramorphix (http://www.mefferts-puzzles.com). At the time
I designed this computer puzzle thought that it had only period 2 turning
(i.e the edges rotate).  It turns out the puzzle has a period 4 turning
(edges turn with 90 degree intervals) which makes it analogous to the
2x2x2 Rubik's cube.  This puzzle makes various non-tetrahedral shapes.
The puzzle contained here has no period 4 turning flexability.
.sp
One is able to simulate Halpern's Tetrahedron or Pyraminx Tetrahedron
(period 3 turning and sticky mode).   Also one is able to simulate one with
variant turning (period 2 turning and sticky mode).
.SH FEATURES
.LP
Press "\fBmouse-left\fP" button to move a piece.  Release
"\fBmouse-left\fP" button on a piece on the same face and in the same row
(but not an adjacent piece or the move is ambiguous).  The pieces will
then turn towards where the mouse button was released.
.LP
Click "\fBmouse-center\fP", or press "\fBP\fP" or "\fBp\fP" keys to toggle
the practice mode (in practice mode the record should say "practice").
This is good for learning moves and experimenting.
.LP
Click "\fBmouse-right\fP", or press "\fBZ\fP" or "\fBz\fP" keys, to
randomize the puzzle (this must be done first to set a new record).
.LP
Press "\fBG\fP" or "\fBg\fP" keys to get a saved puzzle.
.LP
Press "\fBW\fP" or "\fBw\fP" keys to save (write) a puzzle.
.LP
Press "\fBU\fP" or "\fBu\fP" keys to undo a move.
.LP
Press "\fBR\fP" or "\fBr\fP" keys to redo a move.
.LP
Press "\fBC\fP" or "\fBc\fP" keys to clear the puzzle.
.LP
Press "\fBS\fP" or "\fBs\fP" keys to start auto-solver.  Only works on
1x1x1, 2x2x2, and 3x3x3 pyrmaminxs in Period 3 mode.
.LP
Press "\fBO\fP" or "\fBo\fP" keys to toggle the orient mode.  One has to
orient the faces in orient mode, besides getting all the faces to be the
same color.  To do this one has to get the lines to be oriented in the
same direction, this only matters with center pieces, if at all (i.e.
those pieces not on a corner or edge).  This does add complexity so
there are 2 sets of records.
.LP
Press "\fB2\fP", "\fB3\fP", "\fBB\fP", or "\fBb\fP" keys (not the keypad
2, 3) to change modes to Period 2, Period 3, or Both.
.LP
Press "\fBY\fP" or "\fBy\fP" keys to toggle sticky mode (increase/decrease
is disabled here if sticky mode is on).
.br
"Sticky" and "Period 2" turning allows only the edges to turn, and the 2
center rows turn together. It is as if the middle cut of the three cuts
did not exist.
.br
"Sticky" and "Period 3" turning allows only the faces to turn, it is as if
the middle cut of the three cuts did not exist.
.br
Beware, the "Sticky" mode is a hack and much could be done to improve its
look.
.LP
Press "\fBI\fP" or "\fBi\fP" keys to increase the number of pieces.
.LP
Press "\fBD\fP" or "\fBd\fP" keys to decrease the number of pieces.
.LP
Press "\fB>\fP" or "\fB.\fP" keys to speed up the movement of pieces.
.LP
Press "\fB<\fP" or "\fB,\fP" keys to slow down the movement of pieces.
.LP
Press "\fB@\fP" key to toggle the sound.
.LP
Press "\fBEsc\fP" key to hide program.
.LP
Press "\fBQ\fP", "\fBq\fP", or "\fBCTRL-C\fP" keys to kill program.
.LP
Use the key pad or arrow keys to move without the mouse.
.br
Key pad is defined for Pyraminx as:
.br
  /     Counterclockwise
.sp
  8 9   Up, Upper Right
.br
  ^
.br
4<5>6   Left, Clockwise, Right
.br
  v
.br
1 2     Lower Left, Down
.LP
Use the shift keys to access "Period 3" turns from "Both" mode, otherwise
it assumes "Period 2" turning.  Faces and points turn in "Period 3" and
edges (2 points) turn in "Period 2".
.LP
Use the control key and the left mouse button, keypad, or arrow keys to
move the whole tetrahedron.  This is not recorded as a turn.
.LP
The title is in the following format (non-motif version):
.RS
xpyraminx.{2|3|both<turning modes>}: {1|2|3|4|5|6|7|sticky<number of
pieces per edge>} @ (<Number of moves>/{<Record number of moves>
<user name>|"NEVER noaccess"|"practice"}) - <Comment>
.RE
If there is no record of the current puzzle, it displays "NEVER noaccess".
.SH OPTIONS
.TP 8
.B \-geometry {+|\-}\fIX\fP{+|\-}\fIY\fP
This option sets the initial position of the pyraminx window (resource
name "\fIgeometry\fP").
.TP 8
.B \-display \fIhost\fP:\fIdpy\fP
This option specifies the X server to contact.
.TP 8
.B \-[no]mono
This option allows you to display the pyraminx window on a color screen
as if it were monochrome (resource name "\fImono\fP").
.TP 8
.B \-[no]{reverse|rv}
This option allows you to see the pyraminx window in reverse video
(resource name "\fIreverseVideo\fP").
.TP 8
.B \-{foreground|fg} \fIcolor\fP
This option specifies the foreground of the pyraminx window (resource name
"\fIforeground\fP").
.TP 8
.B \-{background|bg} \fIcolor\fP
This option specifies the background of the pyraminx window (resource name
"\fIbackground\fP").
.TP 8
.B \-face{0|1|2|3} <\fIcolor\fP>
This option allows you to change the color of a face (resource name
"\fIfaceColorN\fP"). In mono-mode, color is represented as the first letter
of the color name. The faces are ordered top to bottom and left to right.
If you has two colors that begin with the same letter you should have one
in uppercase and one in lowercase to distinguish them in mono-mode. You can
change the colors of the faces to make a stupid pyraminx (i.e. all White or
in mono-mode all "W").  Unfortunately, it will not normally say its solved
when its randomized.  This would be cheating.
.TP 8
.B \-{border|bd} \fIcolor\fP
This option specifies the border color of the pieces in the pyraminx
window (resource name "\fIborderColor\fP").
.TP 8
.B \-delay \fImsecs\fP
This option specifies the number of milliseconds it takes to move pieces
(1-50) (resource name "\fIdelay\fP").
.TP 8
.B \-[no]sound
This option specifies if sliding pieces should make a sound or not
(resource name "\fIsound\fP").
.TP 8
.B \-moveSound \fIfilename\fP
This option specifies the file for the move sound (resource name
"\fImoveSound\fP").
.TP 8
.B \-{font|fn} \ffontname\fP
This option specifies the font that will be used (resource name
"\fIfont\fP").
.TP 8
.B \-size <\fIint\fP>
This option allows you to change the number of pieces on a edge
(resource name "\fIsize\fP").
.TP 8
.B \-sticky
This option allows you to set the sticky mode (resource name
"\fIsticky\fP").
.TP 8
.B \-mode <\fIint\fP>
This option allows you to set the turning mode (resource name
"\fImode\fP").
.TP 8
.B \-both
This option allows you to set the turning mode to both period 2 and
period 3 (resource name "\fImode\fP" set at 4).
.TP 8
.B \-[no]orient
This option allows you to access the orient mode (resource name
"\fIorient\fP").
.TP 8
.B \-[no]practice
This option allows you to access the practice mode (resource name
"\fIpractice\fP").
.TP 8
.B \-userName \fIstring\fP
This option specifies the user name for any records made or else it will
get your login name (resource name "\fIuserName\fP").
.TP 8
.B \-scoreFile \fIfilename\fP
Specify an alternative score file (resource name "\fIscoreFile\fP").
.TP 8
.B \-scores
This option lists all the recorded scores and then exits.
.TP 8
.B \-version
This option tells you what version of xpyraminx you have.
.SH RECORDS
You must randomize the puzzle before a record is set, otherwise an
assumption of cheating is made if it is solved after a get or an
auto-solve.
.SH SAVE FORMAT
Here is the format for the xpyraminx configuration, starting position, and
the movement of its pieces.  The format is not standard.  The reason for
this is that this is simple to produce and the standard notation is not
easily scalable for variable number of pieces and turning modes.
.sp
Pyraminx with default colors, not randomized:
.br
0     B     Blue
.br
  1     R   Red
.br
2     Y     Yellow
.br
  3     G   Green
.sp
.RS
size: 1-7 <number of triangles in the same orientation as the face per
row>
.br
mode: 2-4 <period 2 turning, period 3 turning, or both (4)>
.br
orient: 0-1 <0 false, 1 true; if 1 then lines on pieces to be oriented>
.br
sticky: 0-1 <0 false, 1 true; if 1 then some pieces move together>
.br
practice: 0-1 <0 false, 1 true>
.br
moves: 0-MAXINT <total number of moves>
.sp
startingPosition: <2 dimensional array of face piece position, each
face has size * size pieces, if orient mode then orientation number
follows face number: 0 up, 1 upper right, 2 right, 3 down, 4 lower left,
and 5 left>
.RE
.sp
This is then followed by the moves, starting from 1.
.RS
move #: <face> <position> <direction> <control>
.RE
Each turn is with respect to a face and position.
.br
Position is 0 to size * size - 1.  Position 0 is the triangle furthest
from the center, increasing clockwise.
.br
Direction is represented 0 up, 1 upper right, 2 right, 3 down, 4 lower
left, 5 left, 9 clockwise, and 15 counterclockwise.
.br
Control is represented as 0 or 1, 1 if the whole tetrahedron is moved at
once (here position does not matter), 0 if not.  The xpyraminx record
keeper does not count a control move as a move, but here we do.
.sp
If you have a Pyraminx you can not solve (2x2x2 or 3x3x3), enter it in
pyraminx.log file.  Have size = 2 or 3, mode = 3, orient = 0,
practice = 0, randomized = 1, and moves = 0 and the number representation
for the color of the pieces (usually 0=B, 1=R, 2=Y, 3=G).  Bring up
xpyraminx, hit 'g' so it will get your configuration and then 's' to solve
your pyraminx and then 'w' to write out the steps.  Then examine your
pyraminx.log file.
.SH REFERENCES
James G Nourse, The Simple Solutions to Cubic Puzzles, Bantam Books,
New York, November 1981, pp 8-15.
.sp
Mastering the Magic Pyramid by Tom Werneck, Evans Brothers Limited, London,
1981. pp 109-111.
.sp
Douglas R. Hofstadter, Beyond Rubik's Cube: spheres, pyramids,
dodecahedrons and God knows what else, Scientific American, July 1982,
pp 16-31.
.sp
John Ewing & Czes Kosniowski, Puzzle it Out: Cubes, Groups and Puzzles,
Cambridge University Press, New York, 1982, pp 60-61.
.sp
Magic Cubes 1996 Catalog of Dr. Christoph Bandelow.
.SH SEE ALSO
.LP
X(1), xcubes(6), xtriangles(6), xhexagons(6), xmlink(6), xbarrel(6), xpanex(6),
xmball(6), xoct(6), xrubik(6), xskewb(6), xdino(6), xabacus(6)
.SH COPYRIGHTS
.LP
\*R Copyright 1994-2007, David A. Bagley
.SH BUG REPORTS AND PROGRAM UPDATES
.LP
Send bugs (or their reports, or fixes) to the author:
.RS
David A. Bagley, <\fIbagleyd@tux.org\fP>
.RE
.sp
The latest version is currently at:
.RS
\fIhttp://www.tux.org/~bagleyd/puzzles.html\fP
.br
\fIftp://ibiblio.org/pub/Linux/games/strategy\fP
