/*-
# X-BASED RUBIK'S CUBE(tm)
#
#  RubikP.h
#
###
#
#  Copyright (c) 1994 - 2007	David A. Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Rubik */

#ifndef _RubikP_h
#define _RubikP_h

#include "xwin.h"
#include "timer.h"
#include "Rubik.h"

#ifdef WINVER
extern void DestroyPuzzle(HBRUSH brush);
extern void ResizePuzzle(RubikWidget w);
extern void SizePuzzle(RubikWidget w);
extern void InitializePuzzle(RubikWidget w, HBRUSH brush);
extern void ExposePuzzle(RubikWidget w);
extern void IncrementAxisPuzzle(RubikWidget w, char axis);
extern void DimPuzzle(RubikWidget w);
extern int  MovePuzzleDir(RubikWidget w, const int direction);
extern void setPuzzleMove(RubikWidget w, int reason, int face, int position,
	int direction, Boolean control, int fast);

#else

/* This gets around C's inability to do inheritance */
typedef struct _RubikClassPart {
	int         ignore;
} RubikClassPart;

typedef struct _RubikClassRec {
	CoreClassPart coreClass;
	RubikClassPart rubikClass;
} RubikClassRec;

extern RubikClassRec rubikClassRec;

extern void QuitPuzzle(RubikWidget w, XEvent *event, char **args, int nArgs);
extern void MovePuzzleCw(RubikWidget w, XEvent *event, char **args, int nArgs);
extern void MovePuzzleCcw(RubikWidget w, XEvent *event, char **args,
	int nArgs);
#endif

#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define MAX_MAX_SIZE (MAX(w->rubik.sizex,MAX(w->rubik.sizey,w->rubik.sizez)))
#define MAX_TURN_INC 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _MoveRecord {
#if 0
	int face, direction, control;
#endif
	unsigned short int packed;  /* This makes assumptions on the data. */
	int position;		    /* Do not make assumptions on this one. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _RubikStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} RubikStack;

typedef struct _RubikLoc {
	char face, rotation;
} RubikLoc;

typedef struct _RubikPart {
	RubikLoc   *cubeLoc[MAX_FACES];
	RubikLoc   *rowLoc[MAX_ORIENT];
	int         currentFace, currentPosition, currentDirection, currentFast;
	Boolean     currentControl;
	Boolean     started, cheat, sound;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         delay;
	int         sizex, sizey, sizez;
	int         degreeTurn, view;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAX_FACES];
#ifdef WINVER
	char        userName[81], scoreFile[81], moveSound[81];
	char        faceChar[MAX_FACES];
#else
	int         menu, pixmapSize;
	char       *userName, *scoreFile, *moveSound, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAX_FACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAX_FACES];
	XtCallbackList select;
#endif
} RubikPart;

typedef struct _RubikRec {
	CorePart    core;
	RubikPart   rubik;
} RubikRec;

typedef struct _RowNext {
	int         face, direction, sideFace;
} RowNext;

extern RubikLoc *startLoc[MAX_FACES];

extern void HidePuzzle(
#ifdef WINVER
const RubikWidget w
#else
RubikWidget w, XEvent *event, char **args, int nArgs
#endif
);
extern void SelectPuzzle(RubikWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent *event, char **args, int nArgs
#endif
);
extern void ReleasePuzzle(RubikWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent *event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void PracticePuzzleMaybe(RubikWidget w
, XEvent *event, char **args, int nArgs
);
extern void PracticePuzzle2(RubikWidget w
, XEvent *event, char **args, int nArgs
);
extern void RandomizePuzzleMaybe(RubikWidget w
, XEvent *event, char **args, int nArgs
);
extern void RandomizePuzzle2(RubikWidget w
, XEvent *event, char **args, int nArgs
);
#endif
extern void GetPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void WritePuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void ClearPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void UndoPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void RedoPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void RandomizePuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void SolvePuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void PracticePuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void IncrementPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void DecrementPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void IncrementXPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void IncrementYPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void IncrementZPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void OrientizePuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void ViewPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void SpeedPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void SlowPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void SoundPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void EnterPuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void LeavePuzzle(RubikWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);

extern void MovePuzzleInput(RubikWidget w,
	int x, int y, int direction, int control);
extern void setPuzzle(RubikWidget w, int reason);
extern void MovePuzzle(RubikWidget w,
	const int face, const int position, const int direction,
	const Boolean control, int fast);
extern void MovePuzzleDelay(RubikWidget w,
	const int face, const int position, const int direction,
	const Boolean control);
#if (!defined(WINVER) || (WINVER <= 0x030a))
extern void Sleep(unsigned int cMilliseconds);
#endif
extern void SetAllColors(RubikWidget w);
extern void ResetPieces(RubikWidget w);
extern void SolveSomePieces(RubikWidget w);
extern void DrawAllPieces(const RubikWidget w);
extern Boolean CheckSolved(const RubikWidget w, Boolean rotation);
extern void newMoves(RubikStack *s);
extern void deleteMoves(RubikStack *s);
extern void setMove(RubikStack *s,
	int face, int position, int direction, int control);
extern void getMove(RubikStack *s,
	int *face, int *position, int *direction, int *control);
extern int madeMoves(RubikStack *s);
extern void flushMoves(RubikWidget w, RubikStack *s, Boolean undo);
extern int numMoves(RubikStack *s);
extern void scanMoves(FILE *fp, RubikWidget w, int moves);
extern void printMoves(FILE *fp, RubikStack *s);
extern void scanStartPosition(FILE *fp, RubikWidget w);
extern void printStartPosition(FILE *fp, RubikWidget w);
extern void setStartPosition(RubikWidget w);
extern void faceSizes(const RubikWidget w, const int face, int *sizeOfRow, int *sizeOfColumn);
extern int sizeFace(const RubikWidget w, const int face);
extern int sizeRow(const RubikWidget w, const int face);

#ifdef DEBUG
extern void PrintCube(const RubikWidget w);
extern void PrintRow(const RubikWidget w, const int orient, const int size);

#endif

#endif /* _RubikP_h */
