/*-
# X-BASED SKEWB
#
#  SkewbGLP.h
#
###
#
#  Copyright (c) 2003 - 2008	David A. Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for SkewbGL */

#ifndef _SkewbGLP_h
#define _SkewbGLP_h

#include "SkewbGL.h"
#include <GL/gl.h>
#ifndef WINVER
#include <GL/glx.h>

/* This gets around C's inability to do inheritance */
typedef struct _SkewbGLClassPart {
	int         ignore;
} SkewbGLClassPart;

typedef struct _SkewbGLClassRec {
	CoreClassPart coreClass;
	SkewbClassPart skewbClass;
	SkewbGLClassPart skewbGLClass;
} SkewbGLClassRec;

extern SkewbGLClassRec skewbGLClassRec;
#endif

#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAX_ROTATE 3
#define MINOR 0
#define MAJOR 1

#define TOP_FACE 0
#define LEFT_FACE 1
#define FRONT_FACE 2
#define RIGHT_FACE 3
#define BOTTOM_FACE 4
#define BACK_FACE 5
#define NO_FACE (IGNORE_DIR)
#define TEST_FACE (MAX_FACES)
#define ERROR_FACE (MAX_FACES+1)
#define NO_ROTATION (2*MAX_ORIENT)

#define CUBE_LENGTH 0.5
#define CUBE_ROUND (CUBE_LENGTH-0.05)
#define STICKER_LONG (CUBE_ROUND-0.05)
#define STICKER_SHORT (STICKER_LONG-0.05)
#define STICKER_DEPTH (CUBE_LENGTH+0.01)
#define FACELEN (2.0*CUBE_LENGTH)
#define FACEROUND (2.0*CUBE_LENGTH-0.03)
#define FSTICKER_LONG (FACEROUND-0.05)
#define FSTICKER_SHORT (FSTICKER_LONG-0.05)
#define FSTICKER_DEPTH (FACELEN+0.01)
#define CUT 0.04
#define CUT_DEPTH (STICKER_DEPTH+0.001)
#define FCUT_DEPTH (FSTICKER_DEPTH+0.001)

#define SCALE (1.1)

typedef struct _SkewbMove {
        int         face, direction;
        int         position;
} SkewbMove;

typedef struct _SkewbSlice {
        int         face, rotation;
        int         depth;
} SkewbSlice;

typedef struct _SkewbGLPart {
	double angleStep;
	double vx, vy;
	double rotateStep;

	Position    faceDiagonal;
	Position    cubeDiagonalx, cubeDiagonaly, cubeDiagonalz;
	/*Point       cubeSizex, cubeSizey, cubeSizez;*/
	Point       faceSize, viewSize;
	Point       viewMiddle;
	SkewbMove   movement;
	int step;
} SkewbGLPart;

typedef struct _SkewbGLRec {
	CorePart    core;
	SkewbPart   skewb;
	SkewbGLPart skewbGL;
} SkewbGLRec;

extern Boolean SelectPiecesGL(SkewbGLWidget w, int x, int y,
	int *face, int *position);
extern void DrawFrameGL(SkewbGLWidget w, Boolean focus);
extern void DrawAllPiecesGL(SkewbGLWidget w);
#ifdef WINVER
extern void ResizePuzzleGL(SkewbGLWidget w);
extern void ExposePuzzleGL(SkewbGLWidget w);
#endif

#endif /* _SkewbGLP_h */
