/*-
# X-BASED PANEX(tm)
#
#  Panex.h
#
###
#
#  Copyright (c) 1996 - 2007	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Panex */

#ifndef _XtPanex_h
#define _XtPanex_h

/***********************************************************************
 *
 * Panex Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNpyramidColor0 ((char *) "pyramidColor0")
#define XtNpyramidColor1 ((char *) "pyramidColor1")
#define XtNtileBorder ((char *) "tileBorder")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNtiles ((char *) "tiles")
#define XtNmode ((char *) "mode")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCTiles ((char *) "Tiles")
#define XtCMode ((char *) "Mode")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")

typedef struct _PanexClassRec *PanexWidgetClass;

extern WidgetClass panexWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} panexCallbackStruct;
#endif

#define PUZZLE_HIDE (-8)
#define PUZZLE_CLEAR_QUERY (-7)
#define PUZZLE_RESTORE (-6)
#define PUZZLE_RESET (-5)
#define PUZZLE_ILLEGAL (-4)
#define PUZZLE_BLOCKED (-3)
#define PUZZLE_SPACE (-2)
#define PUZZLE_IGNORE (-1)
#define PUZZLE_MOVED 0
#define PUZZLE_SOLVED 1
#define PUZZLE_DEC 2
#define PUZZLE_INC 3
#define PUZZLE_MODE 4
#define PUZZLE_COMPUTED 5
#define PUZZLE_UNDO 6
#define PUZZLE_REDO 7
#define PUZZLE_SPEED 8

#define MENU_GET 0
#define MENU_WRITE 1
#define MENU_EXIT 2
#define MENU_UNDO 3
#define MENU_REDO 4
#define MENU_CLEAR 5
#define MENU_SOLVE 6
#define MENU_MODE 7
#define MENU_INCREMENT 8
#define MENU_DECREMENT 9
#define MENU_SPEED 10
#define MENU_SLOW 11
#define MENU_SOUND 12

#define MINTILES 1
#define DEFAULTTILES 10
#define HANOI 0
#define PANEX 1
#define MAXMODES 2
#define DEFAULTMODE PANEX
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define DEFAULTDELAY 10

typedef struct _PanexRec *PanexWidget;

#endif /* _XtPanex_h */
/* DON'T ADD STUFF AFTER THIS #endif */
