/*
 * @(#)DinoP.h
 *
 * Copyright 1995 - 2010  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Dino */

#ifndef _DinoP_h
#define _DinoP_h

#include "xwin.h"
#include "timer.h"
#include "Dino.h"

#ifdef WINVER
extern void destroyPuzzle(HBRUSH brush);
extern void resizePuzzle(DinoWidget w);
extern void sizePuzzle(DinoWidget w);
extern void initializePuzzle(DinoWidget w, HBRUSH brush);
extern void exposePuzzle(DinoWidget w);
extern void periodModePuzzle(DinoWidget w, const int mode);
extern void dimPuzzle(DinoWidget w);
extern int  movePuzzleDir(DinoWidget w, const int direction);
extern void setPuzzle(DinoWidget w, int reason);
extern void setPuzzleMove(DinoWidget w, int reason, int face, int position,
	int direction, int style, int control, int fast);

#else

/* This gets around C's inability to do inheritance */
typedef struct _DinoClassPart {
	int         ignore;
} DinoClassPart;

typedef struct _DinoClassRec {
	CoreClassPart coreClass;
	DinoClassPart dinoClass;
} DinoClassRec;

extern DinoClassRec dinoClassRec;

extern void quitPuzzle(DinoWidget w, XEvent *event, char **args, int nArgs);
#endif

#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define TR 0
#define BR 1
#define BL 2
#define TL 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAX_ORIENT 4
#define MAX_ROTATE 3
#define CORNER 0
#define MIDDLE 1
#define EDGE 2
#define FACE 3

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _DinoCornerLoc {
	int         face, rotation;
} DinoCornerLoc;

typedef struct _moveRecord {
#if 0
	int face, position, direction, style, control;
#endif
	unsigned long int packed;  /* This makes assumptions on the data. */
} moveRecord;

typedef struct _MoveStack {
	moveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _DinoStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} DinoStack;

typedef struct _DinoLoc {
	int face, side, dir;
} DinoLoc;

typedef struct _DinoPart {
	DinoCornerLoc cubeLoc[MAX_FACES][MAX_ORIENT];
	DinoCornerLoc faceLoc[MAX_ORIENT];
	DinoCornerLoc rowLoc[MAX_ORIENT][MAX_ORIENT];
	DinoCornerLoc spindleLoc[MAX_ROTATE][2];
	int         currentFace, currentPosition, currentDirection, currentFast;
	int         currentControl;
	Boolean     started, cheat, sound;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         degreeTurn, view;
	int         delay;
	int         mode, style;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAX_FACES];
#ifdef WINVER
	char        userName[81], scoreFile[81], moveSound[81];
	char        faceChar[MAX_FACES];
#else
	int         menu, pixmapSize;
	char       *userName, *scoreFile, *moveSound, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAX_FACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAX_FACES];
	XtCallbackList select;
#endif
} DinoPart;

typedef struct _DinoRec {
	CorePart    core;
	DinoPart    dino;
} DinoRec;

typedef struct _RowNext {
	int         face, direction, sideFace;
} RowNext;

extern void hidePuzzle(
#ifdef WINVER
const DinoWidget w
#else
DinoWidget w, XEvent *event, char **args, int nArgs
#endif
);
extern void selectPuzzle(DinoWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent *event, char **args, int nArgs
#endif
);
extern void releasePuzzle(DinoWidget w
#ifdef WINVER
, const int x, const int y, const int shift, const int control, const int alt
#else
, XEvent *event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void practicePuzzleWithQuery(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void practicePuzzleWithDoubleClick(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void randomizePuzzleWithQuery(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void randomizePuzzleWithDoubleClick(DinoWidget w
, XEvent *event, char **args, int nArgs
);
#endif
extern void getPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void writePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void undoPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void redoPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void clearPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void randomizePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void solvePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void practicePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void orientizePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void viewPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void speedUpPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void slowDownPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void toggleSoundPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void enterPuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
extern void leavePuzzle(DinoWidget w
#ifndef WINVER
, XEvent *event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void period2ModePuzzle(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void period3ModePuzzle(DinoWidget w
, XEvent *event, char **args, int nArgs
);
extern void bothModePuzzle(DinoWidget w
, XEvent *event, char **args, int nArgs
);
#endif

extern void movePuzzleInput(DinoWidget w, int x, int y, int direction, int shift,
	int control, int alt);
extern void setPuzzle(DinoWidget w, int reason);
extern void movePuzzle(DinoWidget w, int face, int position, int direction,
	int style, int control, int speed);
extern void movePuzzleDelay(DinoWidget w,
	int face, int position, int direction, int style, int control);
extern void setAllColors(DinoWidget w);
extern void solveSomePieces(DinoWidget w);
extern void drawAllPieces(DinoWidget w);
extern Boolean checkSolved(DinoWidget w);
extern void newMoves(DinoStack *s);
extern void deleteMoves(DinoStack *s);
extern void setMove(DinoStack *s,
	int face, int position, int direction, int style, int control);
extern void getMove(DinoStack *s,
	int *face, int *position, int *direction, int *style, int *control);
extern int madeMoves(DinoStack *s);
extern void flushMoves(DinoWidget w, DinoStack *s, Boolean undo);
extern int numMoves(DinoStack *s);
extern void scanMoves(FILE *fp, DinoWidget w, int moves);
extern void printMoves(FILE *fp, DinoStack *s);
extern void scanStartPosition(FILE *fp, DinoWidget w);
extern void printStartPosition(FILE *fp, DinoWidget w);
extern void setStartPosition(DinoWidget w);

#ifdef DEBUG
extern void printCube(DinoWidget w);

#endif

#endif /* _DinoP_h */
